(ns {{namespace}}.routes
    (:require [io.pedestal.http :refer [html-body]]
              [io.pedestal.http.route.definition :refer [defroutes]]
              [datomic.api :as d]
              [{{namespace}}.db :as db]
              [ring.util.response :as r :refer [response]]
              [hiccup.page :refer [html5 include-js]]))

(defn index
  [request]
  (response (html5 [:html
                    [:head
                     [:title "{{name}}"] ]
                    [:body
                     [:h1 "{{name}}: pedestal loaded"]
                     [:div {:id "app"}]
                     (include-js "js/app.js")]])))

(defroutes routes
  [[["/" {:get index}
     ^:interceptors [html-body
                     db/insert-datomic]]]])
