(set-env!
 :source-paths    #{"src/clj" "src/cljs"}
 :resource-paths  #{"resources" "config" "target"}
 :test-paths      #{"test/clj" "test/cljs"}
 :dependencies '[;; Clojure and Clojurescript
                 [org.clojure/clojure "1.7.0" :exclusions [org.clojure/tools.reader]]
                 [org.clojure/clojurescript "1.7.122"]

                 ;; Pedestal
                 [io.pedestal/pedestal.service "0.4.0-SNAPSHOT" :exclusions [org.clojure/tools.reader]]
                 [io.pedestal/pedestal.jetty "0.4.0-SNAPSHOT"]
                 [ns-tracker "0.2.2"]
                 [environ "1.0.1"]
                 [hiccup "1.0.5"]

                 ;; Datomic, if your heart desires it
                 [com.datomic/datomic-free "0.9.5130" :exclusions [joda-time
                                                                   org.slf4j/slf4j-nop
                                                                   org.slf4j/slf4j-log4j12]]
                 [io.rkn/conformity "0.3.4" :exclusions [com.datomic/datomic-free]]

                 ;; Logging
                 [ch.qos.logback/logback-classic "1.1.2"
                  :exclusions [org.slf4j/slf4j-api]]
                 [org.slf4j/jul-to-slf4j "1.7.7"]
                 [org.slf4j/jcl-over-slf4j "1.7.7"]
                 [org.slf4j/log4j-over-slf4j "1.7.7"]

                 ;; Om
                 [adzerk/boot-cljs          "0.0-3308-0" :scope "test"]
                 [adzerk/boot-cljs-repl     "0.1.9"      :scope "test"]
                 [adzerk/boot-reload        "0.3.2"      :scope "test"]
                 [org.omcljs/om "0.9.0"]])

(def version "0.1.0-SNAPSHOT")
(task-options! pom {:project '{{name}}
                    :version (str version "-standalone")
                    :description "FIXME: write description"
                    :license {"License Name" "All Rights Reserved"}})

(require
 '[adzerk.boot-cljs      :refer [cljs]]
 '[adzerk.boot-cljs-repl :refer [cljs-repl start-repl]]
 '[adzerk.boot-reload    :refer [reload]])

;; == Cider Support =======================================

(require 'boot.repl)
(swap! boot.repl/*default-dependencies*
       concat '[[cider/cider-nrepl "0.10.0-snapshot"]])

(swap! boot.repl/*default-middleware*
       conj 'cider.nrepl/cider-middleware)

;; == Datomic =============================================
(load-data-readers!)

(deftask bootstrap
  "Bootstrap the Datomic database"
  []
  (require '[{{namespace}}.db :as db])
    ((resolve 'db/bootstrap!) @(resolve '{{namespace}}.db/uri)))

;; == Server Tasks ========================================

(deftask clj-build
  "Build my project."
  []
  (comp (aot :namespace '#{ {{namespace}} })
        (pom)
        (uber)
        (jar :main '{{namespace}})))

(require '[{{namespace}} :as {{namespace}}])

(deftask server
  "Run a web server"
  []
    ({{namespace}}/start :io.pedestal.http/join? true))

;; == Client Tasks ========================================
(deftask cljs-build []
  (comp (speak)
        (cljs)))

(deftask run []
  (comp (watch)
        (cljs-repl)
        (reload)
        (cljs-build)))

(deftask production []
  (task-options! cljs {:optimizations :advanced})
  identity)

(deftask development []
  (task-options! cljs {:optimizations :none
                       :unified-mode true
                       :source-map true}
                 reload {:on-jsload '{{name}}.app/init})
  identity)

(deftask dev
  "Simple alias to run application in development mode"
  []
  (set-env! :resource-paths #(disj % "target"))
  (comp (development)
        (run)))

(deftask prod
  "Simple alias to package the application for deployment."
  []
  (comp (development)
        (cljs-build)))
