# thruster
![Ion Thruster](https://upload.wikimedia.org/wikipedia/commons/9/9e/Ion_Engine_Test_Firing_-_GPN-2000-000482.jpg)
![Clojars Project](http://clojars.org/thruster/lein-template/latest-version.svg)

A [Pedestal](https://github.com/pedestal/pedestal)/[Om](https://github.com/omcljs/om) Dev-Setup using [Boot](https://github.com/boot-clj/boot). It's a mashup of Ryan Neufeld's [pedestal-micro](https://github.com/rkneufeld/pedestal-micro) and Martin Klepsch's [tenzing](https://github.com/martinklepsch/tenzing).

It stems out of the frustration of trying to make [Chestnut](https://github.com/plexus/chestnut) work with [Pedestal](https://github.com/pedestal/pedestal).

It offers:

1.  Incremental Clojure and Clojurescript compilation
2.  Live reloading of your Javascript, CSS, etc.
3.  Browser-REPL.
4.  [Cider](https://github.com/clojure-emacs/cider) support.

## Usage

### Create A Project

To create a new project we piggieback the existing `lein new` tooling:

    $ lein new thruster your-app

### Running it

1. You'll need to [install Boot](https://github.com/boot-clj/boot#install).

2. Start the om development task:

    `$ boot dev`

3. Wait until the first compilation finishes, otherwise Pedestal won't pickup the "target" classpath.

3. Start the pedestal server at [localhost:8080](http://localhost:8080):

    `$ boot server`

### Cider support

After you started your application with `boot dev` there will be a
line printed like the following:

    nREPL server started on port 63518 on host 0.0.0.0

1. Use M-x cider-connect to connect to the nrepl server.
2. Then it's just a matter of running => `(start-repl)`.

Now you can run things like `(js/alert "test")`, which should
show a pop-up in your browser after you load the page.

### Packaging

The tasks `prod` and `clj-build` should be used in that specific order to produce a viable jar.

## Additional Considerations

Pedestal takes some getting used to, so if you're new to Pedestal or Web Development in general I highly recommend Ryan Neufeld's webcast [Developing Web Applications With Clojure](http://www.oreilly.com/pub/e/3039).

This is a very early release so expect changes and improvements, also pull requests are welcome. 

## License

Copyright © 2015 Ricardo Acuna

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
