# resolve-java-sources-and-javadocs

A Leiningen plugin that automatically downloads all available `.jar`s with Java sources and javadocs for a given project, so that various tooling (typically IDEs) can access it.

It handles all necessary edge cases, and has efficient caching that is shared across projects.

## Installation and usage

Add the following somewhere in your `~/.lein/profiles.clj` (aka your [user-wide profile](https://github.com/technomancy/leiningen/blob/0f456829a8b21335aa86390f3ee3d0dcc68410d6/doc/PROFILES.md#declaring-profiles)):

```clj
:plugins [[threatgrid/resolve-java-sources-and-javadocs "0.1.0"]]
:middleware [leiningen.resolve-java-sources-and-javadocs/add]
```

> If adding this middleware on a per-project basis, make sure it's not turned on by default, simply because other people might not appreciate a slower (first) dependency resolution for a functionality that they might not use. [Profiles](https://github.com/technomancy/leiningen/blob/master/doc/PROFILES.md) help.  

After that, `lein deps` and any other Lein task that resolves dependencies will fetch the same dependencies, but additionally with `"sources"` and `"javadoc"` Maven qualifiers, if they exist (normally these only exist for Java dependencies, not Clojure ones). 

## Task usage

While `:middleware` usage is the primary API, you can also run `lein resolve-java-sources-and-javadocs`.

## Notes on caching

Running this middleware _for the first time_ on a given project will be slow (think: anything between 1-10m). The more dependencies your project has, especially Java ones, the slower this run will be.

Each time a source or javadoc `.jar` is found, the found artifact will be logged, so that you can see that the plugin is in fact doing something.

After a successful run, a cache file is written to `~/.lein-source-and-javadocs-cache`. This file is shared across all projects, and will automatically grow via deep-merge. So the first few runs in a variety of projects will result in a slow dependency resolution, and after that it will stabilize (in those projects, and best-case scenario, also in _other_ projects)

Given a project with 100% cache hits, this plugin's runtime overhead will be essentially zero.

The `~/.lein-source-and-javadocs-cache` file has a stable format. You can version-control it, so that if you setup a new computer you won't have cache misses.

## License

Copyright © Cisco Systems

This program and the accompanying materials are made available under the terms of the [Eclipse Public License 2.0](https://www.eclipse.org/legal/epl-2.0).
