(ns leiningen.lean
  (:require
   [clojure.string :as string]
   [leiningen.core.classpath :as classpath]
   [leiningen.core.main :as main])
  (:import
   (java.io File)
   (org.eclipse.aether.resolution DependencyResolutionException)))

(defn get-classpath-string [project]
  (try
    (->> project
         classpath/get-classpath
         (string/join File/pathSeparatorChar))
    (catch DependencyResolutionException e
      (main/abort (.getMessage e)))))

(defn lean [{:keys [compile-path] :as project}]

  (let [classpath (get-classpath-string project)
        ;; Create a compile path apt for https://clojure.org/guides/dev_startup_time
        ;; by hashing it by the classpath, we avoid stale caches when changing project.clj
        ;; (Users should make sure to set `:target-path "target/%s/"` for extra cleanliness)
        compile-path (str compile-path
                          (-> classpath .hashCode))]

    (-> compile-path java.io.File. .mkdirs)

    (println (str "java -cp "
                  compile-path ;; XXX place it later so that checkouts have priority
                  File/pathSeparatorChar
                  classpath
                  " "
                  (->> project
                       :jvm-opts
                       (map pr-str)
                       (string/join " "))
                  " -Dclojure.compile.path=" compile-path
                  " clojure.main"))))
