(ns leiningen.lean
  (:require
   [clojure.string :as string]
   [leiningen.core.classpath :as classpath]
   [leiningen.core.main :as main])
  (:import
   (java.io File)
   (org.eclipse.aether.resolution DependencyResolutionException)))

(defn get-classpath-string [project]
  (try
    (->> project
         classpath/get-classpath
         (string/join File/pathSeparatorChar))
    (catch DependencyResolutionException e
      (main/abort (.getMessage e)))))

(defn lean [{:keys [compile-path] :as project}]
  (println (str "java -cp "
                (get-classpath-string project)
                " "
                (->> project
                     :jvm-opts
                     (map pr-str)
                     (string/join " "))
                " -Dclojure.compile-path=" compile-path
                " clojure.main")))
