(ns ctim.schemas.bundle
  (:require [ctim.schemas.common :as c]
            [ctim.schemas.actor :refer [ActorRef StoredActor]]
            [ctim.schemas.attack-pattern :refer [AttackPatternRef StoredAttackPattern]]
            [ctim.schemas.campaign :refer [CampaignRef StoredCampaign]]
            [ctim.schemas.coa :refer [COARef StoredCOA]]
            [ctim.schemas.data-table :refer [DataTableRef StoredDataTable]]
            [ctim.schemas.exploit-target
             :refer [ExploitTargetRef StoredExploitTarget]]
            [ctim.schemas.feedback :refer [FeedbackRef StoredFeedback]]
            [ctim.schemas.incident :refer [IncidentRef StoredIncident]]
            [ctim.schemas.indicator :refer [IndicatorRef StoredIndicator]]
            [ctim.schemas.judgement :refer [JudgementRef StoredJudgement]]
            [ctim.schemas.malware :refer [MalwareRef StoredMalware]]
            [ctim.schemas.relationship
             :refer [RelationshipRef StoredRelationship]]
            [ctim.schemas.sighting :refer [SightingRef StoredSighting]]
            [ctim.schemas.tool :refer [ToolRef StoredTool]]
            [ctim.schemas.verdict :refer [StoredVerdict VerdictRef]]
            #?(:clj  [flanders.core :as f :refer [def-entity-type def-map-type def-eq]]
               :cljs [flanders.core :as f :refer-macros [def-entity-type def-map-type def-eq]])))

(def type-identifier "bundle")

(def-eq BundleTypeIdentifier type-identifier)

(defn objects-entries
  ([] (objects-entries ""))
  ([prefix]
   (f/optional-entries
    (f/entry :actors (f/set-of (symbol (str prefix "Actor")))
             :description (str "a list of `" prefix "Actor`"))
    (f/entry :attack-patterns (f/set-of (symbol (str prefix "AttackPattern")))
             :description (str "a list of `" prefix "AttackPattern`"))
    (f/entry :campaigns (f/set-of (symbol (str prefix "Campaign")))
             :description (str "a list of `" prefix "Campaign`"))
    (f/entry :coas (f/set-of (symbol (str prefix "COA")))
             :description (str "a list of `" prefix "COA`"))
    (f/entry :exploit-targets (f/set-of (symbol (str prefix "ExploitTarget")))
             :description (str "a list of `" prefix "ExploitTarget`"))
    (f/entry :feedbacks (f/set-of (symbol (str prefix "Feedback")))
             :description (str "a list of `" prefix "Feedback`"))
    (f/entry :incidents (f/set-of (symbol (str prefix "Incident")))
             :description (str "a list of `" prefix "Incident`"))
    (f/entry :indicators (f/set-of (symbol (str prefix "Indicator")))
             :description (str "a list of `" prefix "Indicator`"))
    (f/entry :judgements (f/set-of (symbol (str prefix "Judgement")))
             :description (str "a list of `" prefix "Judgement`"))
    (f/entry :malwares (f/set-of (symbol (str prefix "Malware")))
             :description (str "a list of `" prefix "Malware`"))
    (f/entry :relationships (f/set-of (symbol (str prefix "Relationship")))
             :description (str "a list of `" prefix "Relationship`"))
    (f/entry :sightings (f/set-of (symbol (str prefix "Sighting")))
             :description (str "a list of `" prefix "Sighting`"))
    (f/entry :tools (f/set-of (symbol (str prefix "Tool")))
             :description (str "a list of `" prefix "Tool`"))
    (f/entry :verdicts (f/set-of Verdict)
             :description (str "a list of `Verdict`"))
    (f/entry :data-tables (f/set-of (symbol (str prefix "DataTable")))
             :description (str "a list of `" prefix "DataTable`")))))

(def references-entries
  (f/optional-entries
   (f/entry :actor_refs (f/set-of ActorRef))
   (f/entry :attack-pattern_refs (f/set-of AttackPatternRef))
   (f/entry :campaign_refs (f/set-of CampaignRef))
   (f/entry :coa_refs (f/set-of COARef))
   (f/entry :exploit-target_refs (f/set-of ExploitTargetRef))
   (f/entry :feedback_refs (f/set-of FeedbackRef))
   (f/entry :incident_refs (f/set-of IncidentRef))
   (f/entry :indicator_refs (f/set-of IndicatorRef))
   (f/entry :judgement_refs (f/set-of JudgementRef))
   (f/entry :malware_refs (f/set-of MalwareRef))
   (f/entry :relationship_refs (f/set-of RelationshipRef))
   (f/entry :sighting_refs (f/set-of SightingRef))
   (f/entry :tool_refs (f/set-of ToolRef))
   (f/entry :verdict_refs (f/set-of VerdictRef))
   (f/entry :data-table_refs (f/set-of DataTableRef))))

(def bundle-entries
  (f/required-entries
   (f/entry :type BundleTypeIdentifier)
   (f/entry :valid_time c/ValidTime)))

(def-entity-type Bundle
  "Bundle of other entities"
  c/base-entity-entries
  c/sourced-object-entries
  c/describable-entity-entries
  (objects-entries)
  references-entries
  bundle-entries)

(def new-bundle-entries
  (apply f/optional-entries
         bundle-entries))

(def-entity-type NewBundle
  "Schema for submitting new Bundles."
  (:entries Bundle)
  c/base-new-entity-entries
  (objects-entries "New")
  new-bundle-entries)

(def-entity-type StoredBundle
  "A bundle as stored in the data store"
  (:entries Bundle)
  c/base-stored-entity-entries
  (objects-entries "Stored"))

(def BundleReference
  (c/ref-for-type type-identifier))
