(ns ctim.schemas.exploit-target
  (:require [ctim.schemas.common :as c]
            [ctim.schemas.relationships :as rel]
            [ctim.schemas.vocabularies :as v]
            #?(:clj  [flanders.core :as f :refer [def-entity-type def-map-type]]
               :cljs [flanders.core :as f :refer-macros [def-entity-type def-map-type]])))

(def TypeIdentifier
  (f/eq "exploit-target"))

(def-map-type Vulnerability
  (concat
   (f/required-entries
    (f/entry :title f/any-str
             :description "title for this vulnerability")
    (f/entry :description f/any-str
             :description "title for this vulnerability"))
   (f/optional-entries
    (f/entry :is_known f/any-bool
             :description (str "whether or not the vulnerability is known (i.e. "
                               "not a 0-day) at the time of characterization."))
    (f/entry :is_public_acknowledged f/any-bool
             :description (str "whether or not the vulnerability is publicly "
                               "acknowledged by the vendor"))
    (f/entry :short_description f/any-str
             :description "short text description of this vulnerability")
    (f/entry :cve_id f/any-str
             :description "CVE identifier")
    (f/entry :osvdb_id f/any-int
             :description "OSVDB identifier")
    (f/entry :source f/any-str
             :description (str "the source of the CVE or OSVDB as a textual "
                               "description or URL"))
    (f/entry :discovered_datetime c/Time
             ;; simplified
             :description (str "date and time that this vulnerability"
                               " was first discovered"))
    (f/entry :published_datetime c/Time
             ;; simplified
             :description (str "date and time that this vulnerability"
                               " was first published"))
    ;; TODO - :affected_software below is greatly simplified, should it be expanded?
    (f/entry :affected_software f/any-str-seq
             :description (str "list of platforms and software that are affected "
                               "by this vulnerability"))
    (f/entry :references [c/URI]
             :description "list of external references describing this vulnerability"))
   ;; Not provided: CVSS_Score ; Should it be?
   )
  :reference "[VulnerabilityType](http://stixproject.github.io/data-model/1.2/et/VulnerabilityType/)")

(def-map-type Weakness
  [(f/entry :description f/any-str
            :description "text description of this Weakness")
   (f/entry :cwe_id f/any-str
            :required? false
            :description "CWE identifier for a particular weakness")]
  :reference "[WeaknessType](http://stixproject.github.io/data-model/1.2/et/WeaknessType/)")

(def-map-type Configuration
  [(f/entry :description f/any-str
            :description "text description of this Configuration")
   (f/entry :short_description f/any-str
            :required? false
            :description "short text description of this Configuration")
   (f/entry :cce_id f/any-str
            :required? false
            :description "CCE identifier for a configuration item")]
  :reference "[ConfigurationType](http://stixproject.github.io/data-model/1.2/et/ConfigurationType/)")

(def-entity-type ExploitTarget
  "[ExploitTargetType](http://stixproject.github.io/data-model/1.2/et/ExploitTargetType/)"
  c/base-entity-entries
  c/sourcable-object-entries
  c/describable-entity-entries
  (f/required-entries
   (f/entry :type TypeIdentifier)
   (f/entry :valid_time c/ValidTime))
  (f/optional-entries
   (f/entry :vulnerability [Vulnerability]
            :description (str "identifies and characterizes a Vulnerability as a "
                              "potential Exploit Target"))
   (f/entry :weakness [Weakness]
            :description (str "identifies and characterizes a Weakness as a "
                              "potential Exploit Target"))
   (f/entry :configuration [Configuration]
            :description (str "identifies and characterizes a Configuration as"
                              " a potential Exploit Target"))
   (f/entry :potential_COAs rel/RelatedCOAs
            :description (str "identifies and characterizes a Configuration as"
                              " a potential Exploit Target"))
   (f/entry :related_exploit_targets rel/RelatedExploitTargets
            :description (str "identifies and characterizes a Configuration as a "
                              "potential Exploit Target")))
  ;; Not provided: related_packages (deprecated)
  ;; Not provided: handling
  )

(def-entity-type NewExploitTarget
  "Schema for submitting ExploitTargets"
  (:entries ExploitTarget)
  c/base-new-entity-entries
  (f/optional-entries
   (f/entry :type TypeIdentifier)
   (f/entry :valid_time c/ValidTime)))

(def-entity-type StoredExploitTarget
  "An exploit-target as stored in the data store"
  (:entries ExploitTarget)
  c/base-stored-entity-entries)
