(ns ctim.generators.schemas.package-generators
  (:require [clj-momo.lib.time :as time]
            [schema.core :as s]
            [schema-tools.core :as st]
            [clojure.test.check.generators :as gen]
            [ctim.schemas.common :as schemas-common]
            [ctim.schemas.package :as p]
            [ctim.generators.common
             :refer [complete leaf-generators maybe]
             :as common]
            [ctim.generators.id :as gen-id]
            [ctim.generators.schemas.actor-generators :refer [gen-actor]]
            [ctim.generators.schemas.campaign-generators :refer [gen-campaign]]
            [ctim.generators.schemas.coa-generators :refer [gen-coa]]
            [ctim.generators.schemas.exploit-target-generators :refer [gen-exploit-target]]
            [ctim.generators.schemas.feedback-generators :refer [gen-feedback]]
            [ctim.generators.schemas.incident-generators :refer [gen-incident]]
            [ctim.generators.schemas.indicator-generators :refer [gen-indicator]]
            [ctim.generators.schemas.judgement-generators :refer [gen-judgement]]
            [ctim.generators.schemas.sighting-generators :refer [gen-sighting]]
            [ctim.generators.schemas.ttp-generators :refer [gen-ttp]]
            [schema-generators.generators :as seg]))

(def object-keys [:actors
                  :campaigns
                  :coas
                  :exploit-targets
                  :feedbacks
                  :incidents
                  :indicators
                  :judgements
                  :sightings
                  :ttps])

(s/defschema BaseNewPackage
  (apply st/dissoc p/NewPackage object-keys))

(s/defschema BaseStoredPackage
  (apply st/dissoc p/StoredPackage object-keys))

(defn merge-entities
  "merge a base package with its entities"
  [[s id actors campaigns coas exploit-targets
    feedbacks incidents indicators judgements
    sightings ttps]]
  (cond-> (dissoc s :id)
    id (assoc :id id)
    actors (assoc :actors actors)
    campaigns (assoc :campaigns campaigns)
    coas (assoc :coas coas)
    exploit-targets (assoc :exploit-targets exploit-targets)
    feedbacks (assoc :feedbacks feedbacks)
    incidents (assoc :incidents incidents)
    indicators (assoc :indicators indicators)
    judgements (assoc :judgements judgements)
    sightings (assoc :sightings sightings)
    ttps (assoc :ttps ttps)))

(def gen-package
  (gen/fmap
   merge-entities
   (gen/tuple (seg/generator BaseStoredPackage leaf-generators)
              (gen-id/gen-short-id-of-type :package)
              (maybe (gen/vector gen-actor))
              (maybe (gen/vector gen-campaign))
              (maybe (gen/vector gen-coa))
              (maybe (gen/vector gen-exploit-target))
              (maybe (gen/vector gen-feedback))
              (maybe (gen/vector gen-incident))
              (maybe (gen/vector gen-indicator))
              (maybe (gen/vector gen-judgement))
              (maybe (gen/vector gen-sighting))
              (maybe (gen/vector gen-ttp)))))

(defn gen-new-package_ [gen-id]
  (gen/fmap
   merge-entities
   (gen/tuple (seg/generator BaseNewPackage leaf-generators)
              gen-id
              (maybe (gen/vector gen-actor))
              (maybe (gen/vector gen-campaign))
              (maybe (gen/vector gen-coa))
              (maybe (gen/vector gen-exploit-target))
              (maybe (gen/vector gen-feedback))
              (maybe (gen/vector gen-incident))
              (maybe (gen/vector gen-indicator))
              (maybe (gen/vector gen-judgement))
              (maybe (gen/vector gen-sighting))
              (maybe (gen/vector gen-ttp)))))

(def gen-new-package
  (gen-new-package_
   (maybe (gen-id/gen-short-id-of-type :package))))

(def gen-new-package-with-id
  (gen-new-package_
   (gen-id/gen-short-id-of-type :package)))
