/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public class CloningDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, DependencyNode> clones;
    private final Stack<DependencyNode> parents = new Stack();
    private DependencyNode root;

    public CloningDependencyVisitor() {
        this.clones = new IdentityHashMap<DependencyNode, DependencyNode>(256);
    }

    public final DependencyNode getRootNode() {
        return this.root;
    }

    protected DependencyNode clone(DependencyNode node) {
        DefaultDependencyNode clone = new DefaultDependencyNode(node);
        return clone;
    }

    @Override
    public final boolean visitEnter(DependencyNode node) {
        boolean recurse = true;
        DependencyNode clone = this.clones.get(node);
        if (clone == null) {
            clone = this.clone(node);
            this.clones.put(node, clone);
        } else {
            recurse = false;
        }
        DependencyNode parent = this.parents.peek();
        if (parent == null) {
            this.root = clone;
        } else {
            parent.getChildren().add(clone);
        }
        this.parents.push(clone);
        return recurse;
    }

    @Override
    public final boolean visitLeave(DependencyNode node) {
        this.parents.pop();
        return true;
    }
}

