/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.util.ConfigUtils;

final class PrioritizedComponents<T> {
    private static final String FACTORY_SUFFIX = "Factory";
    private final Map<?, ?> configProps;
    private final boolean useInsertionOrder;
    private final List<PrioritizedComponent<T>> components;
    private int firstDisabled;

    public PrioritizedComponents(RepositorySystemSession session) {
        this(session.getConfigProperties());
    }

    PrioritizedComponents(Map<?, ?> configurationProperties) {
        this.configProps = configurationProperties;
        this.useInsertionOrder = ConfigUtils.getBoolean(this.configProps, false, "aether.priority.implicit");
        this.components = new ArrayList<PrioritizedComponent<T>>();
        this.firstDisabled = 0;
    }

    public void add(T component, float priority) {
        Class<?> type = PrioritizedComponents.getImplClass(component);
        int index = this.components.size();
        priority = this.useInsertionOrder ? (float)(-index) : ConfigUtils.getFloat(this.configProps, priority, PrioritizedComponents.getConfigKeys(type));
        PrioritizedComponent<T> pc = new PrioritizedComponent<T>(component, type, priority, index);
        if (!this.useInsertionOrder) {
            index = Collections.binarySearch(this.components, pc);
            index = index < 0 ? -index - 1 : ++index;
        }
        this.components.add(index, pc);
        if (index <= this.firstDisabled && !pc.isDisabled()) {
            ++this.firstDisabled;
        }
    }

    private static Class<?> getImplClass(Object component) {
        Class<?> base;
        Class<?> type = component.getClass();
        int idx = type.getName().indexOf("$$");
        if (idx >= 0 && (base = type.getSuperclass()) != null && idx == base.getName().length() && type.getName().startsWith(base.getName())) {
            type = base;
        }
        return type;
    }

    static String[] getConfigKeys(Class<?> type) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("aether.priority." + type.getName());
        String sn = type.getSimpleName();
        keys.add("aether.priority." + sn);
        if (sn.endsWith(FACTORY_SUFFIX)) {
            keys.add("aether.priority." + sn.substring(0, sn.length() - FACTORY_SUFFIX.length()));
        }
        return keys.toArray(new String[keys.size()]);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public List<PrioritizedComponent<T>> getAll() {
        return this.components;
    }

    public List<PrioritizedComponent<T>> getEnabled() {
        return this.components.subList(0, this.firstDisabled);
    }

    public void list(StringBuilder buffer) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            PrioritizedComponent<T> component = this.components.get(i);
            buffer.append(component.getType().getSimpleName());
            if (!component.isDisabled()) continue;
            buffer.append(" (disabled)");
        }
    }

    public String toString() {
        return this.components.toString();
    }
}

