/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.inject.Named;
import org.eclipse.aether.spi.io.FileProcessor;

@Named
public class DefaultFileProcessor
implements FileProcessor {
    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean mkdirs(File directory) {
        File canonDir;
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File target, String data) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            if (data != null) {
                ((OutputStream)fos).write(data.getBytes("UTF-8"));
            }
            ((OutputStream)fos).close();
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(fos);
            throw throwable;
        }
        DefaultFileProcessor.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File target, InputStream source) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            this.copy(fos, source, null);
            ((OutputStream)fos).close();
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(fos);
            throw throwable;
        }
        DefaultFileProcessor.close(fos);
    }

    @Override
    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            this.mkdirs(target.getAbsoluteFile().getParentFile());
            fos = new FileOutputStream(target);
            total = this.copy(fos, fis, listener);
            ((OutputStream)fos).close();
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(fis);
            DefaultFileProcessor.close(fos);
            throw throwable;
        }
        DefaultFileProcessor.close(fis);
        DefaultFileProcessor.close(fos);
        return total;
    }

    private long copy(OutputStream os, InputStream is, FileProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        while ((bytes = is.read(array)) >= 0) {
            os.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {}
        }
        return total;
    }

    @Override
    public void move(File source, File target) throws IOException {
        if (!source.renameTo(target)) {
            this.copy(source, target);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }
}

