/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.sonatype.guice.bean.locators.HiddenBinding;
import org.sonatype.guice.bean.locators.ImplementationVisitor;
import org.sonatype.guice.bean.locators.RankingFunction;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InjectorPublisher
implements BindingPublisher {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Injector injector;
    private final RankingFunction function;

    InjectorPublisher(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
    }

    @Override
    public <T> void subscribe(TypeLiteral<T> type, BindingSubscriber subscriber) {
        this.publishBindings(type, subscriber, null);
        Class<T> clazz = type.getRawType();
        if (clazz != type.getType()) {
            this.publishBindings(TypeLiteral.get(clazz), subscriber, type);
        }
        if (clazz != Object.class) {
            this.publishBindings(OBJECT_TYPE_LITERAL, subscriber, type);
        }
    }

    @Override
    public <T> boolean contains(Binding<T> binding) {
        return binding == this.injector.getBindings().get(binding.getKey());
    }

    @Override
    public <T> void unsubscribe(TypeLiteral<T> type, BindingSubscriber importer) {
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorPublisher) {
            return this.injector.equals(((InjectorPublisher)rhs).injector);
        }
        return false;
    }

    public String toString() {
        return Logs.toString(this.injector);
    }

    static boolean isVisible(Binding<?> binding) {
        return false == binding.getSource() instanceof HiddenBinding;
    }

    private static boolean isAssignableFrom(TypeLiteral<?> superType, Binding<?> binding) {
        Class implementation = (Class)binding.acceptTargetVisitor(ImplementationVisitor.THIS);
        if (null != implementation && superType.getRawType() != implementation) {
            return TypeParameters.isAssignableFrom(superType, TypeLiteral.get(implementation));
        }
        return false;
    }

    private void publishBindings(TypeLiteral<?> searchType, BindingSubscriber subscriber, TypeLiteral<?> superType) {
        List<Binding<?>> bindings = this.injector.findBindingsByType(searchType);
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            Binding<?> binding = bindings.get(i);
            if (!InjectorPublisher.isVisible(binding) || null != superType && !InjectorPublisher.isAssignableFrom(superType, binding)) continue;
            subscriber.add(binding, this.function.rank(binding));
        }
    }
}

