/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Map;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.AbstractArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingArtifact
extends AbstractArtifact {
    private final Artifact delegate;

    protected DelegatingArtifact(Artifact delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate artifact not specified");
        }
        this.delegate = delegate;
    }

    protected abstract DelegatingArtifact newInstance(Artifact var1);

    @Override
    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public Artifact setVersion(String version) {
        Artifact artifact = this.delegate.setVersion(version);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public String getBaseVersion() {
        return this.delegate.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.delegate.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    @Override
    public String getExtension() {
        return this.delegate.getExtension();
    }

    @Override
    public File getFile() {
        return this.delegate.getFile();
    }

    @Override
    public Artifact setFile(File file) {
        Artifact artifact = this.delegate.setFile(file);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        Artifact artifact = this.delegate.setProperties(properties);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DelegatingArtifact) {
            return this.delegate.equals(((DelegatingArtifact)obj).delegate);
        }
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

