/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.shared.http4.AbstractHttpClientWagon;
import org.apache.maven.wagon.shared.http4.HtmlFileListParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpWagon
extends AbstractHttpClientWagon {
    @Override
    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        HttpGet getMethod = new HttpGet(url);
        try {
            HttpResponse response = this.execute(getMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: ");
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
            InputStream is = response.getEntity().getContent();
            List<String> list = HtmlFileListParser.parseFileList(url, is);
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", e);
        }
        catch (HttpException e) {
            throw new TransferFailedException("Could not read response body.", e);
        }
        finally {
            getMethod.abort();
        }
    }
}

