/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.NoLocalRepositoryManagerException;
import org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

@Component(role=LocalRepositoryManagerFactory.class, hint="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;

    public LocalRepositoryManager newInstance(LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir()).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
    }

    public SimpleLocalRepositoryManagerFactory setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public int getPriority() {
        return 0;
    }
}

