(ns think.semantic-ui
  (:refer-clojure :exclude [list comment])
  (:require [goog.object]
            [cljsjs.react]
            [cljsjs.semantic-ui-react]
            [reagent.core :as reagent]
            [camel-snake-kebab.core :refer [->kebab-case]]))


(defn- semantic-el
  [k]
  (goog.object/getValueByKeys js/semanticUIReact k))

(defn- component
  [k]
  (reagent/adapt-react-class (semantic-el k)))

(defn print-component-defs
  "Generate fn defs in the repl for now"
  []
  (doseq [property (.keys js/Object js/semanticUIReact)]
    (println (str "(def " (->kebab-case property) "\n  (component \"" property "\"))\n"))))


;; Eval this to print comp defs to console then past below comment bellow
;; (print-component-defs)


;;;; Generated Vars ;;;;

(def confirm
  (component "Confirm"))

(def portal
  (component "Portal"))

(def radio
  (component "Radio"))

(def select
  (component "Select"))

(def text-area
  (component "TextArea"))

(def visibility
  (component "Visibility"))

(def breadcrumb
  (component "Breadcrumb"))

(def breadcrumb-divider
  (component "BreadcrumbDivider"))

(def breadcrumb-section
  (component "BreadcrumbSection"))

(def form
  (component "Form"))

(def form-button
  (component "FormButton"))

(def form-checkbox
  (component "FormCheckbox"))

(def form-dropdown
  (component "FormDropdown"))

(def form-field
  (component "FormField"))

(def form-group
  (component "FormGroup"))

(def form-input
  (component "FormInput"))

(def form-radio
  (component "FormRadio"))

(def form-select
  (component "FormSelect"))

(def form-text-area
  (component "FormTextArea"))

(def grid
  (component "Grid"))

(def grid-column
  (component "GridColumn"))

(def grid-row
  (component "GridRow"))

(def menu
  (component "Menu"))

(def menu-header
  (component "MenuHeader"))

(def menu-item
  (component "MenuItem"))

(def menu-menu
  (component "MenuMenu"))

(def message
  (component "Message"))

(def message-content
  (component "MessageContent"))

(def message-header
  (component "MessageHeader"))

(def message-item
  (component "MessageItem"))

(def message-list
  (component "MessageList"))

(def table
  (component "Table"))

(def table-body
  (component "TableBody"))

(def table-cell
  (component "TableCell"))

(def table-footer
  (component "TableFooter"))

(def table-header
  (component "TableHeader"))

(def table-header-cell
  (component "TableHeaderCell"))

(def table-row
  (component "TableRow"))

(def button
  (component "Button"))

(def button-content
  (component "ButtonContent"))

(def button-group
  (component "ButtonGroup"))

(def button-or
  (component "ButtonOr"))

(def container
  (component "Container"))

(def divider
  (component "Divider"))

(def flag
  (component "Flag"))

(def header
  (component "Header"))

(def header-content
  (component "HeaderContent"))

(def header-subheader
  (component "HeaderSubheader"))

(def icon
  (component "Icon"))

(def icon-group
  (component "IconGroup"))

(def image
  (component "Image"))

(def image-group
  (component "ImageGroup"))

(def input
  (component "Input"))

(def label
  (component "Label"))

(def label-detail
  (component "LabelDetail"))

(def label-group
  (component "LabelGroup"))

(def list
  (component "List"))

(def list-content
  (component "ListContent"))

(def list-description
  (component "ListDescription"))

(def list-header
  (component "ListHeader"))

(def list-icon
  (component "ListIcon"))

(def list-item
  (component "ListItem"))

(def list-list
  (component "ListList"))

(def loader
  (component "Loader"))

(def rail
  (component "Rail"))

(def reveal
  (component "Reveal"))

(def reveal-content
  (component "RevealContent"))

(def segment
  (component "Segment"))

(def segment-group
  (component "SegmentGroup"))

(def step
  (component "Step"))

(def step-content
  (component "StepContent"))

(def step-description
  (component "StepDescription"))

(def step-group
  (component "StepGroup"))

(def step-title
  (component "StepTitle"))

(def accordion
  (component "Accordion"))

(def accordion-content
  (component "AccordionContent"))

(def accordion-title
  (component "AccordionTitle"))

(def checkbox
  (component "Checkbox"))

(def dimmer
  (component "Dimmer"))

(def dimmer-dimmable
  (component "DimmerDimmable"))

(def dropdown
  (component "Dropdown"))

(def dropdown-divider
  (component "DropdownDivider"))

(def dropdown-header
  (component "DropdownHeader"))

(def dropdown-item
  (component "DropdownItem"))

(def dropdown-menu
  (component "DropdownMenu"))

(def dropdown-search-input
  (component "DropdownSearchInput"))

(def embed
  (component "Embed"))

(def modal
  (component "Modal"))

(def modal-actions
  (component "ModalActions"))

(def modal-content
  (component "ModalContent"))

(def modal-description
  (component "ModalDescription"))

(def modal-header
  (component "ModalHeader"))

(def popup
  (component "Popup"))

(def popup-content
  (component "PopupContent"))

(def popup-header
  (component "PopupHeader"))

(def progress
  (component "Progress"))

(def rating
  (component "Rating"))

(def rating-icon
  (component "RatingIcon"))

(def search
  (component "Search"))

(def search-category
  (component "SearchCategory"))

(def search-result
  (component "SearchResult"))

(def search-results
  (component "SearchResults"))

(def sidebar
  (component "Sidebar"))

(def sidebar-pushable
  (component "SidebarPushable"))

(def sidebar-pusher
  (component "SidebarPusher"))

(def sticky
  (component "Sticky"))

(def tab
  (component "Tab"))

(def tab-pane
  (component "TabPane"))

(def transition
  (component "Transition"))

(def transition-group
  (component "TransitionGroup"))

(def advertisement
  (component "Advertisement"))

(def card
  (component "Card"))

(def card-content
  (component "CardContent"))

(def card-description
  (component "CardDescription"))

(def card-group
  (component "CardGroup"))

(def card-header
  (component "CardHeader"))

(def card-meta
  (component "CardMeta"))

(def comment
  (component "Comment"))

(def comment-action
  (component "CommentAction"))

(def comment-actions
  (component "CommentActions"))

(def comment-author
  (component "CommentAuthor"))

(def comment-avatar
  (component "CommentAvatar"))

(def comment-content
  (component "CommentContent"))

(def comment-group
  (component "CommentGroup"))

(def comment-metadata
  (component "CommentMetadata"))

(def comment-text
  (component "CommentText"))

(def feed
  (component "Feed"))

(def feed-content
  (component "FeedContent"))

(def feed-date
  (component "FeedDate"))

(def feed-event
  (component "FeedEvent"))

(def feed-extra
  (component "FeedExtra"))

(def feed-label
  (component "FeedLabel"))

(def feed-like
  (component "FeedLike"))

(def feed-meta
  (component "FeedMeta"))

(def feed-summary
  (component "FeedSummary"))

(def feed-user
  (component "FeedUser"))

(def item
  (component "Item"))

(def item-content
  (component "ItemContent"))

(def item-description
  (component "ItemDescription"))

(def item-extra
  (component "ItemExtra"))

(def item-group
  (component "ItemGroup"))

(def item-header
  (component "ItemHeader"))

(def item-image
  (component "ItemImage"))

(def item-meta
  (component "ItemMeta"))

(def statistic
  (component "Statistic"))

(def statistic-group
  (component "StatisticGroup"))

(def statistic-label
  (component "StatisticLabel"))

(def statistic-value
  (component "StatisticValue"))
