// Generated by JavaCPP version 1.2.4: DO NOT EDIT THIS FILE


#ifdef _WIN32
    #define _JAVASOFT_JNI_MD_H_

    #define JNIEXPORT __declspec(dllexport)
    #define JNIIMPORT __declspec(dllimport)
    #define JNICALL __stdcall

    typedef int jint;
    typedef long long jlong;
    typedef signed char jbyte;
#elif defined(__GNUC__)
    #define _JAVASOFT_JNI_MD_H_

    #define JNIEXPORT __attribute__((visibility("default")))
    #define JNIIMPORT
    #define JNICALL

    typedef int jint;
    typedef long long jlong;
    typedef signed char jbyte;
#endif

#include <jni.h>

#ifdef __ANDROID__
    #include <android/log.h>
#elif defined(__APPLE__) && defined(__OBJC__)
    #include <TargetConditionals.h>
    #include <Foundation/Foundation.h>
#endif

#ifdef __linux__
    #include <unistd.h>
#elif defined(__APPLE__)
    #include <mach/mach_init.h>
    #include <mach/task.h>
#elif defined(_WIN32)
    #define NOMINMAX
    #include <windows.h>
    #include <psapi.h>
#endif

#if defined(__ANDROID__) || TARGET_OS_IPHONE
    #define NewWeakGlobalRef(obj) NewGlobalRef(obj)
    #define DeleteWeakGlobalRef(obj) DeleteGlobalRef(obj)
#endif

#include <limits.h>
#include <stddef.h>
#ifndef _WIN32
    #include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exception>
#include <memory>
#include <new>

#if defined(NATIVE_ALLOCATOR) && defined(NATIVE_DEALLOCATOR)
    void* operator new(std::size_t size, const std::nothrow_t&) throw() {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new[](std::size_t size, const std::nothrow_t&) throw() {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new(std::size_t size) throw(std::bad_alloc) {
        return NATIVE_ALLOCATOR(size);
    }
    void* operator new[](std::size_t size) throw(std::bad_alloc) {
        return NATIVE_ALLOCATOR(size);
    }
    void operator delete(void* ptr) throw() {
        NATIVE_DEALLOCATOR(ptr);
    }
    void operator delete[](void* ptr) throw() {
        NATIVE_DEALLOCATOR(ptr);
    }
#endif

#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))
#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))

#if defined(_MSC_VER)
    #define JavaCPP_noinline __declspec(noinline)
    #define JavaCPP_hidden /* hidden by default */
#elif defined(__GNUC__)
    #define JavaCPP_noinline __attribute__((noinline))
    #define JavaCPP_hidden   __attribute__((visibility("hidden")))
#else
    #define JavaCPP_noinline
    #define JavaCPP_hidden
#endif

#include <hdf5.hpp>
#include <hdf5_export.hpp>

static JavaVM* JavaCPP_vm = NULL;
static bool JavaCPP_haveAllocObject = false;
static bool JavaCPP_haveNonvirtual = false;
static const char* JavaCPP_classNames[28] = {
        "org/bytedeco/javacpp/Pointer",
        "org/bytedeco/javacpp/BytePointer",
        "org/bytedeco/javacpp/ShortPointer",
        "org/bytedeco/javacpp/IntPointer",
        "org/bytedeco/javacpp/LongPointer",
        "org/bytedeco/javacpp/FloatPointer",
        "org/bytedeco/javacpp/DoublePointer",
        "org/bytedeco/javacpp/CharPointer",
        "org/bytedeco/javacpp/PointerPointer",
        "org/bytedeco/javacpp/BoolPointer",
        "org/bytedeco/javacpp/CLongPointer",
        "org/bytedeco/javacpp/SizeTPointer",
        "java/lang/String",
        "org/bytedeco/javacpp/Pointer$NativeDeallocator",
        "org/bytedeco/javacpp/Loader",
        "java/nio/Buffer",
        "java/lang/Object",
        "java/lang/NullPointerException",
        "think/hdf5/hdf5$library",
        "java/lang/RuntimeException",
        "think/hdf5/hdf5$object",
        "think/hdf5/hdf5$abstract_ds",
        "think/hdf5/hdf5$dataset",
        "think/hdf5/hdf5$object_registry",
        "think/hdf5/hdf5$location",
        "think/hdf5/hdf5$attribute",
        "think/hdf5/hdf5$EObjType",
        "think/hdf5/hdf5$Access" };
static jclass JavaCPP_classes[28] = { NULL };
static jfieldID JavaCPP_addressFID = NULL;
static jfieldID JavaCPP_positionFID = NULL;
static jfieldID JavaCPP_limitFID = NULL;
static jfieldID JavaCPP_capacityFID = NULL;
static jfieldID JavaCPP_deallocatorFID = NULL;
static jfieldID JavaCPP_ownerAddressFID = NULL;
static jmethodID JavaCPP_initMID = NULL;
static jmethodID JavaCPP_arrayMID = NULL;
static jmethodID JavaCPP_stringMID = NULL;
static jmethodID JavaCPP_getBytesMID = NULL;
static jmethodID JavaCPP_toStringMID = NULL;

static inline void JavaCPP_log(const char* fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
#ifdef __ANDROID__
    __android_log_vprint(ANDROID_LOG_ERROR, "javacpp", fmt, ap);
#elif defined(__APPLE__) && defined(__OBJC__)
    NSLogv([NSString stringWithUTF8String:fmt], ap);
#else
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
#endif
    va_end(ap);
}

static inline jlong JavaCPP_physicalBytes() {
    jlong size = 0;
#ifdef __linux__
    FILE *file = fopen("/proc/self/statm", "r");
    if (file != NULL) {
        long long virtual_size = 0, resident_size = 0;
        if (fscanf(file, "%lld %lld", &virtual_size, &resident_size) == 2) {
            size = (jlong)(resident_size * getpagesize());
        }
        fclose(file);
    }
#elif defined(__APPLE__)
    task_basic_info info = {};
    mach_msg_type_number_t count = TASK_BASIC_INFO_COUNT;
    task_info(current_task(), TASK_BASIC_INFO, (task_info_t)&info, &count);
    size = (jlong)info.resident_size;
#elif defined(_WIN32)
    PROCESS_MEMORY_COUNTERS counters;
    if (GetProcessMemoryInfo(GetCurrentProcess(), &counters, sizeof(counters))) {
        size = (jlong)counters.WorkingSetSize;
    }
#endif
    return size;
}

static JavaCPP_noinline jclass JavaCPP_getClass(JNIEnv* env, int i) {
    if (JavaCPP_classes[i] == NULL && env->PushLocalFrame(1) == 0) {
        jclass cls = env->FindClass(JavaCPP_classNames[i]);
        if (cls == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error loading class %s.", JavaCPP_classNames[i]);
            return NULL;
        }
        JavaCPP_classes[i] = (jclass)env->NewWeakGlobalRef(cls);
        if (JavaCPP_classes[i] == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error creating global reference of class %s.", JavaCPP_classNames[i]);
            return NULL;
        }
        env->PopLocalFrame(NULL);
    }
    return JavaCPP_classes[i];
}

static JavaCPP_noinline jfieldID JavaCPP_getFieldID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jfieldID fid = env->GetFieldID(cls, name, sig);
    if (fid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting field ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return fid;
}

static JavaCPP_noinline jmethodID JavaCPP_getMethodID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jmethodID mid = env->GetMethodID(cls, name, sig);
    if (mid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting method ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return mid;
}

static JavaCPP_noinline jmethodID JavaCPP_getStaticMethodID(JNIEnv* env, int i, const char* name, const char* sig) {
    jclass cls = JavaCPP_getClass(env, i);
    if (cls == NULL) {
        return NULL;
    }
    jmethodID mid = env->GetStaticMethodID(cls, name, sig);
    if (mid == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting static method ID of %s/%s", JavaCPP_classNames[i], name);
        return NULL;
    }
    return mid;
}

static JavaCPP_noinline jobject JavaCPP_createPointer(JNIEnv* env, int i, jclass cls = NULL) {
    if (cls == NULL && (cls = JavaCPP_getClass(env, i)) == NULL) {
        return NULL;
    }
    if (JavaCPP_haveAllocObject) {
        return env->AllocObject(cls);
    } else {
        jmethodID mid = env->GetMethodID(cls, "<init>", "(Lorg/bytedeco/javacpp/Pointer;)V");
        if (mid == NULL || env->ExceptionCheck()) {
            JavaCPP_log("Error getting Pointer constructor of %s, while VM does not support AllocObject()", JavaCPP_classNames[i]);
            return NULL;
        }
        return env->NewObject(cls, mid, NULL);
    }
}

static JavaCPP_noinline void JavaCPP_initPointer(JNIEnv* env, jobject obj, const void* ptr, jlong size, void* owner, void (*deallocator)(void*)) {
    if (deallocator != NULL) {
        jvalue args[4];
        args[0].j = ptr_to_jlong(ptr);
        args[1].j = size;
        args[2].j = ptr_to_jlong(owner);
        args[3].j = ptr_to_jlong(deallocator);
        if (JavaCPP_haveNonvirtual) {
            env->CallNonvirtualVoidMethodA(obj, JavaCPP_getClass(env, 0), JavaCPP_initMID, args);
        } else {
            env->CallVoidMethodA(obj, JavaCPP_initMID, args);
        }
    } else {
        env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(ptr));
        env->SetLongField(obj, JavaCPP_limitFID, (jlong)size);
        env->SetLongField(obj, JavaCPP_capacityFID, (jlong)size);
    }
}

static JavaCPP_noinline jstring JavaCPP_createString(JNIEnv* env, const char* ptr) {
    if (ptr == NULL) {
        return NULL;
    }
#ifdef MODIFIED_UTF8_STRING
    return env->NewStringUTF(ptr);
#else
    size_t length = strlen(ptr);
    jbyteArray bytes = env->NewByteArray(length < INT_MAX ? length : INT_MAX);
    env->SetByteArrayRegion(bytes, 0, length < INT_MAX ? length : INT_MAX, (signed char*)ptr);
    return (jstring)env->NewObject(JavaCPP_getClass(env, 12), JavaCPP_stringMID, bytes);
#endif
}

static JavaCPP_noinline const char* JavaCPP_getStringBytes(JNIEnv* env, jstring str) {
    if (str == NULL) {
        return NULL;
    }
#ifdef MODIFIED_UTF8_STRING
    return env->GetStringUTFChars(str, NULL);
#else
    jbyteArray bytes = (jbyteArray)env->CallObjectMethod(str, JavaCPP_getBytesMID);
    if (bytes == NULL || env->ExceptionCheck()) {
        JavaCPP_log("Error getting bytes from string.");
        return NULL;
    }
    jsize length = env->GetArrayLength(bytes);
    signed char* ptr = new (std::nothrow) signed char[length + 1];
    if (ptr != NULL) {
        env->GetByteArrayRegion(bytes, 0, length, ptr);
        ptr[length] = 0;
    }
    return (const char*)ptr;
#endif
}

static JavaCPP_noinline void JavaCPP_releaseStringBytes(JNIEnv* env, jstring str, const char* ptr) {
#ifdef MODIFIED_UTF8_STRING
    if (str != NULL) {
        env->ReleaseStringUTFChars(str, ptr);
    }
#else
    delete[] ptr;
#endif
}

class JavaCPP_hidden JavaCPP_exception : public std::exception {
public:
    JavaCPP_exception(const char* str) throw() {
        if (str == NULL) {
            strcpy(msg, "Unknown exception.");
        } else {
            strncpy(msg, str, sizeof(msg));
            msg[sizeof(msg) - 1] = 0;
        }
    }
    virtual const char* what() const throw() { return msg; }
    char msg[1024];
};

#ifndef GENERIC_EXCEPTION_CLASS
#define GENERIC_EXCEPTION_CLASS std::exception
#endif
static JavaCPP_noinline jthrowable JavaCPP_handleException(JNIEnv* env, int i) {
    jstring str = NULL;
    try {
        throw;
    } catch (GENERIC_EXCEPTION_CLASS& e) {
        str = JavaCPP_createString(env, e.what());
    } catch (...) {
        str = JavaCPP_createString(env, "Unknown exception.");
    }
    jmethodID mid = JavaCPP_getMethodID(env, i, "<init>", "(Ljava/lang/String;)V");
    if (mid == NULL) {
        return NULL;
    }
    return (jthrowable)env->NewObject(JavaCPP_getClass(env, i), mid, str);
}

static JavaCPP_noinline void* JavaCPP_getPointerOwner(JNIEnv* env, jobject obj) {
    if (obj != NULL) {
        jobject deallocator = env->GetObjectField(obj, JavaCPP_deallocatorFID);
        if (deallocator != NULL && env->IsInstanceOf(deallocator, JavaCPP_getClass(env, 13))) {
            return jlong_to_ptr(env->GetLongField(deallocator, JavaCPP_ownerAddressFID));
        }
    }
    return NULL;
}

#include <vector>
template<typename P, typename T = P> class JavaCPP_hidden VectorAdapter {
public:
    VectorAdapter(const P* ptr, typename std::vector<T>::size_type size, void* owner) : ptr((P*)ptr), size(size), owner(owner),
        vec2(ptr ? std::vector<T>((P*)ptr, (P*)ptr + size) : std::vector<T>()), vec(vec2) { }
    VectorAdapter(const std::vector<T>& vec) : ptr(0), size(0), owner(0), vec2(vec), vec(vec2) { }
    VectorAdapter(      std::vector<T>& vec) : ptr(0), size(0), owner(0), vec(vec) { }
    VectorAdapter(const std::vector<T>* vec) : ptr(0), size(0), owner(0), vec(*(std::vector<T>*)vec) { }
    void assign(P* ptr, typename std::vector<T>::size_type size, void* owner) {
        this->ptr = ptr;
        this->size = size;
        this->owner = owner;
        vec.assign(ptr, ptr + size);
    }
    static void deallocate(void* owner) { operator delete(owner); }
    operator P*() {
        if (vec.size() > size) {
            ptr = (P*)(operator new(sizeof(P) * vec.size(), std::nothrow_t()));
        }
        if (ptr) {
            std::copy(vec.begin(), vec.end(), ptr);
        }
        size = vec.size();
        owner = ptr;
        return ptr;
    }
    operator const P*()        { return &vec[0]; }
    operator std::vector<T>&() { return vec; }
    operator std::vector<T>*() { return ptr ? &vec : 0; }
    P* ptr;
    typename std::vector<T>::size_type size;
    void* owner;
    std::vector<T> vec2;
    std::vector<T>& vec;
};

#include <string>
class JavaCPP_hidden StringAdapter {
public:
    StringAdapter(const          char* ptr, size_t size, void* owner) : ptr((char*)ptr), size(size), owner(owner),
        str2(ptr ? (char*)ptr : "", ptr ? (size > 0 ? size : strlen((char*)ptr)) : 0), str(str2) { }
    StringAdapter(const signed   char* ptr, size_t size, void* owner) : ptr((char*)ptr), size(size), owner(owner),
        str2(ptr ? (char*)ptr : "", ptr ? (size > 0 ? size : strlen((char*)ptr)) : 0), str(str2) { }
    StringAdapter(const unsigned char* ptr, size_t size, void* owner) : ptr((char*)ptr), size(size), owner(owner),
        str2(ptr ? (char*)ptr : "", ptr ? (size > 0 ? size : strlen((char*)ptr)) : 0), str(str2) { }
    StringAdapter(const std::string& str) : ptr(0), size(0), owner(0), str2(str), str(str2) { }
    StringAdapter(      std::string& str) : ptr(0), size(0), owner(0), str(str) { }
    StringAdapter(const std::string* str) : ptr(0), size(0), owner(0), str(*(std::string*)str) { }
    void assign(char* ptr, size_t size, void* owner) {
        this->ptr = ptr;
        this->size = size;
        this->owner = owner;
        str.assign(ptr ? ptr : "", ptr ? (size > 0 ? size : strlen((char*)ptr)) : 0);
    }
    void assign(const          char* ptr, size_t size, void* owner) { assign((char*)ptr, size, owner); }
    void assign(const signed   char* ptr, size_t size, void* owner) { assign((char*)ptr, size, owner); }
    void assign(const unsigned char* ptr, size_t size, void* owner) { assign((char*)ptr, size, owner); }
    static void deallocate(void* owner) { delete[] (char*)owner; }
    operator char*() {
        const char* data = str.data();
        if (str.size() > size) {
            ptr = new (std::nothrow) char[str.size()+1];
            if (ptr) memset(ptr, 0, str.size()+1);
        }
        if (ptr && memcmp(ptr, data, str.size()) != 0) {
            memcpy(ptr, data, str.size());
            if (size > str.size()) ptr[str.size()] = 0;
        }
        size = str.size();
        owner = ptr;
        return ptr;
    }
    operator       signed   char*() { return (signed   char*)(operator char*)(); }
    operator       unsigned char*() { return (unsigned char*)(operator char*)(); }
    operator const          char*() { return                 str.c_str(); }
    operator const signed   char*() { return (signed   char*)str.c_str(); }
    operator const unsigned char*() { return (unsigned char*)str.c_str(); }
    operator         std::string&() { return str; }
    operator         std::string*() { return ptr ? &str : 0; }
    char* ptr;
    size_t size;
    void* owner;
    std::string str2;
    std::string& str;
};

#ifdef SHARED_PTR_NAMESPACE
template<class T> class SharedPtrAdapter {
public:
    typedef SHARED_PTR_NAMESPACE::shared_ptr<T> S;
    SharedPtrAdapter(const T* ptr, size_t size, void* owner) : ptr((T*)ptr), size(size), owner(owner),
            sharedPtr2(owner != NULL && owner != ptr ? *(S*)owner : S((T*)ptr)), sharedPtr(sharedPtr2) { }
    SharedPtrAdapter(const S& sharedPtr) : ptr(0), size(0), owner(0), sharedPtr2(sharedPtr), sharedPtr(sharedPtr2) { }
    SharedPtrAdapter(      S& sharedPtr) : ptr(0), size(0), owner(0), sharedPtr(sharedPtr) { }
    SharedPtrAdapter(const S* sharedPtr) : ptr(0), size(0), owner(0), sharedPtr(*(S*)sharedPtr) { }
    void assign(T* ptr, size_t size, S* owner) {
        this->ptr = ptr;
        this->size = size;
        this->owner = owner;
        this->sharedPtr = owner != NULL && owner != ptr ? *(S*)owner : S((T*)ptr);
    }
    static void deallocate(void* owner) { delete (S*)owner; }
    operator T*() {
        ptr = sharedPtr.get();
        if (owner == NULL || owner == ptr) {
            owner = new S(sharedPtr);
        }
        return ptr;
    }
    operator const T*() { return sharedPtr.get(); }
    operator       S&() { return sharedPtr; }
    operator       S*() { return &sharedPtr; }
    T* ptr;
    size_t size;
    void* owner;
    S sharedPtr2;
    S& sharedPtr;
};
#endif

#ifdef UNIQUE_PTR_NAMESPACE
template<class T> class UniquePtrAdapter {
public:
    typedef UNIQUE_PTR_NAMESPACE::unique_ptr<T> U;
    UniquePtrAdapter(const T* ptr, size_t size, void* owner) : ptr((T*)ptr), size(size), owner(owner),
            uniquePtr2(owner != NULL && owner != ptr ? U() : U((T*)ptr)),
            uniquePtr(owner != NULL && owner != ptr ? *(U*)owner : uniquePtr2) { }
    UniquePtrAdapter(const U& uniquePtr) : ptr(0), size(0), owner(0), uniquePtr((U&)uniquePtr) { }
    UniquePtrAdapter(      U& uniquePtr) : ptr(0), size(0), owner(0), uniquePtr(uniquePtr) { }
    UniquePtrAdapter(const U* uniquePtr) : ptr(0), size(0), owner(0), uniquePtr(*(U*)uniquePtr) { }
    void assign(T* ptr, size_t size, U* owner) {
        this->ptr = ptr;
        this->size = size;
        this->owner = owner;
        this->uniquePtr = owner != NULL && owner != ptr ? *(U*)owner : U((T*)ptr);
    }
    static void deallocate(void* owner) { delete (U*)owner; }
    operator T*() {
        ptr = uniquePtr.get();
        if (owner == NULL || owner == ptr) {
            owner = new U(UNIQUE_PTR_NAMESPACE::move(uniquePtr));
        }
        return ptr;
    }
    operator const T*() { return uniquePtr.get(); }
    operator       U&() { return uniquePtr; }
    operator       U*() { return &uniquePtr; }
    T* ptr;
    size_t size;
    void* owner;
    U uniquePtr2;
    U& uniquePtr;
};
#endif




static void JavaCPP_think_hdf5_hdf5_00024library_deallocate(void *p) { delete (::think::hdf5::library*)p; }
static void JavaCPP_think_hdf5_hdf5_00024location_deallocate(void *p) { delete (::think::hdf5::location*)p; }
static void JavaCPP_think_hdf5_hdf5_00024EObjType_deallocate(void *p) { delete (::think::hdf5::EObjType*)p; }
static void JavaCPP_think_hdf5_hdf5_00024Access_deallocate(void *p) { delete (::think::hdf5::Access*)p; }
static void JavaCPP_org_bytedeco_javacpp_BytePointer_deallocateArray(void* p) { delete[] (signed char*)p; }
static void JavaCPP_org_bytedeco_javacpp_ShortPointer_deallocateArray(void* p) { delete[] (short*)p; }
static void JavaCPP_org_bytedeco_javacpp_IntPointer_deallocateArray(void* p) { delete[] (int*)p; }
static void JavaCPP_org_bytedeco_javacpp_LongPointer_deallocateArray(void* p) { delete[] (jlong*)p; }
static void JavaCPP_org_bytedeco_javacpp_FloatPointer_deallocateArray(void* p) { delete[] (float*)p; }
static void JavaCPP_org_bytedeco_javacpp_DoublePointer_deallocateArray(void* p) { delete[] (double*)p; }
static void JavaCPP_org_bytedeco_javacpp_CharPointer_deallocateArray(void* p) { delete[] (unsigned short*)p; }
static void JavaCPP_org_bytedeco_javacpp_PointerPointer_deallocateArray(void* p) { delete[] (void**)p; }
static void JavaCPP_org_bytedeco_javacpp_BoolPointer_deallocateArray(void* p) { delete[] (bool*)p; }
static void JavaCPP_org_bytedeco_javacpp_CLongPointer_deallocateArray(void* p) { delete[] (long*)p; }
static void JavaCPP_org_bytedeco_javacpp_SizeTPointer_deallocateArray(void* p) { delete[] (size_t*)p; }
static void JavaCPP_think_hdf5_hdf5_00024library_deallocateArray(void* p) { delete[] (::think::hdf5::library*)p; }
static void JavaCPP_think_hdf5_hdf5_00024location_deallocateArray(void* p) { delete[] (::think::hdf5::location*)p; }
static void JavaCPP_think_hdf5_hdf5_00024EObjType_deallocateArray(void* p) { delete[] (::think::hdf5::EObjType*)p; }
static void JavaCPP_think_hdf5_hdf5_00024Access_deallocateArray(void* p) { delete[] (::think::hdf5::Access*)p; }

extern "C" {

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved) {
    JNIEnv* env;
    if (vm->GetEnv((void**)&env, JNI_VERSION_1_4) != JNI_OK) {
        JavaCPP_log("Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnLoad().");
        return JNI_ERR;
    }
    if (JavaCPP_vm == vm) {
        return env->GetVersion();
    }
    JavaCPP_vm = vm;
    JavaCPP_haveAllocObject = env->functions->AllocObject != NULL;
    JavaCPP_haveNonvirtual = env->functions->CallNonvirtualVoidMethodA != NULL;
    const char* members[28][1] = {
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { NULL },
            { NULL },
            { NULL },
            { NULL },
            { NULL },
            { NULL },
            { "sizeof" },
            { NULL },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" },
            { "sizeof" } };
    int offsets[28][1] = {
            { sizeof(void*) },
            { sizeof(signed char) },
            { sizeof(short) },
            { sizeof(int) },
            { sizeof(jlong) },
            { sizeof(float) },
            { sizeof(double) },
            { sizeof(unsigned short) },
            { sizeof(void*) },
            { sizeof(bool) },
            { sizeof(long) },
            { sizeof(size_t) },
            { -1 },
            { -1 },
            { -1 },
            { -1 },
            { -1 },
            { -1 },
            { sizeof(::think::hdf5::library) },
            { -1 },
            { sizeof(::think::hdf5::object) },
            { sizeof(::think::hdf5::abstract_ds) },
            { sizeof(::think::hdf5::dataset) },
            { sizeof(::think::hdf5::object_registry) },
            { sizeof(::think::hdf5::location) },
            { sizeof(::think::hdf5::attribute) },
            { sizeof(::think::hdf5::EObjType) },
            { sizeof(::think::hdf5::Access) } };
    int memberOffsetSizes[28] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
    jmethodID putMemberOffsetMID = JavaCPP_getStaticMethodID(env, 14, "putMemberOffset", "(Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/Class;");
    if (putMemberOffsetMID == NULL) {
        return JNI_ERR;
    }
    for (int i = 0; i < 28 && !env->ExceptionCheck(); i++) {
        for (int j = 0; j < memberOffsetSizes[i] && !env->ExceptionCheck(); j++) {
            if (env->PushLocalFrame(3) == 0) {
                jvalue args[3];
                args[0].l = env->NewStringUTF(JavaCPP_classNames[i]);
                args[1].l = members[i][j] == NULL ? NULL : env->NewStringUTF(members[i][j]);
                args[2].i = offsets[i][j];
                jclass cls = (jclass)env->CallStaticObjectMethodA(JavaCPP_getClass(env, 14), putMemberOffsetMID, args);
                if (cls == NULL || env->ExceptionCheck()) {
                    JavaCPP_log("Error putting member offsets for class %s.", JavaCPP_classNames[i]);
                    return JNI_ERR;
                }
                JavaCPP_classes[i] = (jclass)env->NewWeakGlobalRef(cls);
                if (JavaCPP_classes[i] == NULL || env->ExceptionCheck()) {
                    JavaCPP_log("Error creating global reference of class %s.", JavaCPP_classNames[i]);
                    return JNI_ERR;
                }
                env->PopLocalFrame(NULL);
            }
        }
    }
    JavaCPP_addressFID = JavaCPP_getFieldID(env, 0, "address", "J");
    if (JavaCPP_addressFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_positionFID = JavaCPP_getFieldID(env, 0, "position", "J");
    if (JavaCPP_positionFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_limitFID = JavaCPP_getFieldID(env, 0, "limit", "J");
    if (JavaCPP_limitFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_capacityFID = JavaCPP_getFieldID(env, 0, "capacity", "J");
    if (JavaCPP_capacityFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_deallocatorFID = JavaCPP_getFieldID(env, 0, "deallocator", "Lorg/bytedeco/javacpp/Pointer$Deallocator;");
    if (JavaCPP_deallocatorFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_ownerAddressFID = JavaCPP_getFieldID(env, 13, "ownerAddress", "J");
    if (JavaCPP_ownerAddressFID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_initMID = JavaCPP_getMethodID(env, 0, "init", "(JJJJ)V");
    if (JavaCPP_initMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_arrayMID = JavaCPP_getMethodID(env, 15, "array", "()Ljava/lang/Object;");
    if (JavaCPP_arrayMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_stringMID = JavaCPP_getMethodID(env, 12, "<init>", "([B)V");
    if (JavaCPP_stringMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_getBytesMID = JavaCPP_getMethodID(env, 12, "getBytes", "()[B");
    if (JavaCPP_getBytesMID == NULL) {
        return JNI_ERR;
    }
    JavaCPP_toStringMID = JavaCPP_getMethodID(env, 16, "toString", "()Ljava/lang/String;");
    if (JavaCPP_toStringMID == NULL) {
        return JNI_ERR;
    }
    return env->GetVersion();
}


JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* vm, void* reserved) {
    JNIEnv* env;
    if (vm->GetEnv((void**)&env, JNI_VERSION_1_4) != JNI_OK) {
        JavaCPP_log("Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnUnLoad().");
        return;
    }
    for (int i = 0; i < 28; i++) {
        env->DeleteWeakGlobalRef((jweak)JavaCPP_classes[i]);
        JavaCPP_classes[i] = NULL;
    }
    JavaCPP_vm = NULL;
}



JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Pointer_00024NativeDeallocator_deallocate(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    void* allocatedAddress = jlong_to_ptr(arg0);
    void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(arg1);
    if (deallocatorAddress != NULL && allocatedAddress != NULL) {
        (*deallocatorAddress)(allocatedAddress);
    }

}



JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_asDirectBuffer(JNIEnv* env, jobject obj) {
    char* ptr = (char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong size = env->GetLongField(obj, JavaCPP_limitFID);
    size -= position;
    jobject rarg = NULL;
    char* rptr;
    rptr = ptr;
    jlong rcapacity = size;
    if (rptr != NULL) {
        jlong rcapacityptr = rcapacity * sizeof(rptr[0]);
        rarg = env->NewDirectByteBuffer((void*)rptr, rcapacityptr < INT_MAX ? rcapacityptr : INT_MAX);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_Pointer_physicalBytes(JNIEnv* env, jclass cls) {
    jlong rarg = 0;
    jlong rvalue = JavaCPP_physicalBytes();
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    void* rptr;
    rptr = memchr(ptr0, arg1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_Pointer_memcmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rvalue = memcmp(ptr0, ptr1, arg2);
    rarg = (jint)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memcpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    void* rptr;
    rptr = memcpy(ptr0, ptr1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr == ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memmove(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    void* rptr;
    rptr = memmove(ptr0, ptr1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr == ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_Pointer_memset(JNIEnv* env, jclass cls, jobject arg0, jint arg1, jlong arg2) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    void* rptr;
    rptr = memset(ptr0, arg1, arg2);
    if (rptr == ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_Pointer_allocate(JNIEnv* env, jobject obj, jobject arg0) {
    char* ptr0 = arg0 == NULL ? NULL : (char*)env->GetDirectBufferAddress(arg0);
    void* rptr = ptr0;
    jlong rcapacity = 1;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, NULL);
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_BytePointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* rptr = new (std::nothrow) signed char[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_BytePointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strcat(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strcat((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strchr((char*)ptr0, arg1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strcmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rvalue = strcmp((char*)ptr0, (char*)ptr1);
    rarg = (jint)rvalue;
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strcoll(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rvalue = strcoll((char*)ptr0, (char*)ptr1);
    rarg = (jint)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strcpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strcpy((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strcspn(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rvalue = (size_t)strcspn((char*)ptr0, (char*)ptr1);
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strerror(JNIEnv* env, jclass cls, jint arg0) {
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strerror(arg0);
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strlen(JNIEnv* env, jclass cls, jobject arg0) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jlong rarg = 0;
    size_t rvalue = (size_t)strlen((char*)ptr0);
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strncat(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strncat((char*)ptr0, (char*)ptr1, (size_t)arg2);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_BytePointer_strncmp(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jint rarg = 0;
    int rvalue = strncmp((char*)ptr0, (char*)ptr1, (size_t)arg2);
    rarg = (jint)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strncpy(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strncpy((char*)ptr0, (char*)ptr1, (size_t)arg2);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strpbrk(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strpbrk((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strrchr(JNIEnv* env, jclass cls, jobject arg0, jint arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strrchr((char*)ptr0, arg1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strspn(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rvalue = (size_t)strspn((char*)ptr0, (char*)ptr1);
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strstr(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strstr((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_strtok(JNIEnv* env, jclass cls, jobject arg0, jobject arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = NULL;
    char* rptr;
    rptr = (char*)strtok((char*)ptr0, (char*)ptr1);
    if (rptr == (char*)ptr0) {
        rarg = arg0;
    } else if (rptr == (char*)ptr1) {
        rarg = arg1;
    } else if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 1);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_BytePointer_strxfrm(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jlong arg2) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    signed char* ptr1 = arg1 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jlong rarg = 0;
    size_t rvalue = (size_t)strxfrm((char*)ptr0, (char*)ptr1, (size_t)arg2);
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_get___3BII(JNIEnv* env, jobject obj, jbyteArray arg0, jint arg1, jint arg2) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    signed char* ptr0 = arg0 == NULL ? NULL : (jbyte*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jbyte JNICALL Java_org_bytedeco_javacpp_BytePointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jbyte rarg = 0;
    signed char rvalue = ptr[arg0];
    rarg = (jbyte)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_put__JB(JNIEnv* env, jobject obj, jlong arg0, jbyte arg1) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BytePointer_put___3BII(JNIEnv* env, jobject obj, jbyteArray arg0, jint arg1, jint arg2) {
    signed char* ptr = (signed char*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    signed char* ptr0 = arg0 == NULL ? NULL : (jbyte*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_ShortPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    short* rptr = new (std::nothrow) short[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_ShortPointer_deallocateArray);
}
JNIEXPORT jshort JNICALL Java_org_bytedeco_javacpp_ShortPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jshort rarg = 0;
    short rvalue = ptr[arg0];
    rarg = (jshort)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_get___3SII(JNIEnv* env, jobject obj, jshortArray arg0, jint arg1, jint arg2) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    short* ptr0 = arg0 == NULL ? NULL : (jshort*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_put___3SII(JNIEnv* env, jobject obj, jshortArray arg0, jint arg1, jint arg2) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    short* ptr0 = arg0 == NULL ? NULL : (jshort*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_ShortPointer_put__JS(JNIEnv* env, jobject obj, jlong arg0, jshort arg1) {
    short* ptr = (short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_IntPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    int* rptr = new (std::nothrow) int[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_IntPointer_deallocateArray);
}
JNIEXPORT jint JNICALL Java_org_bytedeco_javacpp_IntPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    int rvalue = ptr[arg0];
    rarg = (jint)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_get___3III(JNIEnv* env, jobject obj, jintArray arg0, jint arg1, jint arg2) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    int* ptr0 = arg0 == NULL ? NULL : (jint*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_put___3III(JNIEnv* env, jobject obj, jintArray arg0, jint arg1, jint arg2) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    int* ptr0 = arg0 == NULL ? NULL : (jint*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_IntPointer_put__JI(JNIEnv* env, jobject obj, jlong arg0, jint arg1) {
    int* ptr = (int*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_LongPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jlong* rptr = new (std::nothrow) jlong[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_LongPointer_deallocateArray);
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_LongPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jlong rvalue = ptr[arg0];
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_get___3JII(JNIEnv* env, jobject obj, jlongArray arg0, jint arg1, jint arg2) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong* ptr0 = arg0 == NULL ? NULL : (jlong*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_put___3JII(JNIEnv* env, jobject obj, jlongArray arg0, jint arg1, jint arg2) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong* ptr0 = arg0 == NULL ? NULL : (jlong*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_LongPointer_put__JJ(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    jlong* ptr = (jlong*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_FloatPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    float* rptr = new (std::nothrow) float[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_FloatPointer_deallocateArray);
}
JNIEXPORT jfloat JNICALL Java_org_bytedeco_javacpp_FloatPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jfloat rarg = 0;
    float rvalue = ptr[arg0];
    rarg = (jfloat)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_get___3FII(JNIEnv* env, jobject obj, jfloatArray arg0, jint arg1, jint arg2) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    float* ptr0 = arg0 == NULL ? NULL : (jfloat*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_put___3FII(JNIEnv* env, jobject obj, jfloatArray arg0, jint arg1, jint arg2) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    float* ptr0 = arg0 == NULL ? NULL : (jfloat*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_FloatPointer_put__JF(JNIEnv* env, jobject obj, jlong arg0, jfloat arg1) {
    float* ptr = (float*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_DoublePointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    double* rptr = new (std::nothrow) double[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_DoublePointer_deallocateArray);
}
JNIEXPORT jdouble JNICALL Java_org_bytedeco_javacpp_DoublePointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jdouble rarg = 0;
    double rvalue = ptr[arg0];
    rarg = (jdouble)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_get___3DII(JNIEnv* env, jobject obj, jdoubleArray arg0, jint arg1, jint arg2) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    double* ptr0 = arg0 == NULL ? NULL : (jdouble*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_put___3DII(JNIEnv* env, jobject obj, jdoubleArray arg0, jint arg1, jint arg2) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    double* ptr0 = arg0 == NULL ? NULL : (jdouble*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_DoublePointer_put__JD(JNIEnv* env, jobject obj, jlong arg0, jdouble arg1) {
    double* ptr = (double*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_CharPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned short* rptr = new (std::nothrow) unsigned short[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_CharPointer_deallocateArray);
}
JNIEXPORT jchar JNICALL Java_org_bytedeco_javacpp_CharPointer_get__J(JNIEnv* env, jobject obj, jlong arg0) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jchar rarg = 0;
    unsigned short rvalue = ptr[arg0];
    rarg = (jchar)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_get___3CII(JNIEnv* env, jobject obj, jcharArray arg0, jint arg1, jint arg2) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned short* ptr0 = arg0 == NULL ? NULL : (jchar*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr0 + arg1, ptr, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_put___3CII(JNIEnv* env, jobject obj, jcharArray arg0, jint arg1, jint arg2) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    unsigned short* ptr0 = arg0 == NULL ? NULL : (jchar*)env->GetPrimitiveArrayCritical(arg0, NULL);
    jobject rarg = obj;
    memcpy(ptr, ptr0 + arg1, arg2 * sizeof(*ptr0));
    if (arg0 != NULL) env->ReleasePrimitiveArrayCritical(arg0, ptr0, 0);
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CharPointer_put__JC(JNIEnv* env, jobject obj, jlong arg0, jchar arg1) {
    unsigned short* ptr = (unsigned short*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_PointerPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    void** rptr = new (std::nothrow) void*[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_PointerPointer_deallocateArray);
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_PointerPointer_get(JNIEnv* env, jobject obj, jclass arg0, jlong arg1) {
    void** ptr = (void**)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    void* rptr;
    rptr = ptr[arg1];
    if (rptr != NULL) {
        rarg = JavaCPP_createPointer(env, 0, arg0);
        if (rarg != NULL) {
            env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
        }
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_PointerPointer_put(JNIEnv* env, jobject obj, jlong arg0, jobject arg1) {
    void** ptr = (void**)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr1 = arg1 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    jobject rarg = obj;
    ptr[arg0] = ptr1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_BoolPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    bool* rptr = new (std::nothrow) bool[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_BoolPointer_deallocateArray);
}
JNIEXPORT jboolean JNICALL Java_org_bytedeco_javacpp_BoolPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    bool* ptr = (bool*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    bool rvalue = (bool)ptr[arg0];
    rarg = (jboolean)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_BoolPointer_put(JNIEnv* env, jobject obj, jlong arg0, jboolean arg1) {
    bool* ptr = (bool*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (bool)arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_CLongPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    long* rptr = new (std::nothrow) long[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_CLongPointer_deallocateArray);
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_CLongPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    long* ptr = (long*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    long rvalue = (long)ptr[arg0];
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_CLongPointer_put(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    long* ptr = (long*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (long)arg1;
    return rarg;
}

JNIEXPORT void JNICALL Java_org_bytedeco_javacpp_SizeTPointer_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    size_t* rptr = new (std::nothrow) size_t[arg0];
    jlong rcapacity = arg0;
    JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_org_bytedeco_javacpp_SizeTPointer_deallocateArray);
}
JNIEXPORT jlong JNICALL Java_org_bytedeco_javacpp_SizeTPointer_get(JNIEnv* env, jobject obj, jlong arg0) {
    size_t* ptr = (size_t*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    size_t rvalue = (size_t)ptr[arg0];
    rarg = (jlong)rvalue;
    return rarg;
}
JNIEXPORT jobject JNICALL Java_org_bytedeco_javacpp_SizeTPointer_put(JNIEnv* env, jobject obj, jlong arg0, jlong arg1) {
    size_t* ptr = (size_t*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = obj;
    ptr[arg0] = (size_t)arg1;
    return rarg;
}


JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library* rptr = new ::think::hdf5::library[arg0];
        jlong rcapacity = arg0;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024library_deallocateArray);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_initLibrary(JNIEnv* env, jclass cls) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::initLibrary();
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_termH5cpp(JNIEnv* env, jclass cls) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::termH5cpp();
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_getLibVersion__Ljava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_IntBuffer_2(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jobject arg2) {
    int* ptr0 = arg0 == NULL ? NULL : (int*)env->GetDirectBufferAddress(arg0);
    jintArray arr0 = NULL;
    if (arg0 != NULL && ptr0 == NULL) {
        arr0 = (jintArray)env->CallObjectMethod(arg0, JavaCPP_arrayMID);
        if (env->ExceptionOccurred() != NULL) {
            env->ExceptionClear();
        } else {
            ptr0 = arr0 == NULL ? NULL : env->GetIntArrayElements(arr0, NULL);
        }
    }
    int* ptr1 = arg1 == NULL ? NULL : (int*)env->GetDirectBufferAddress(arg1);
    jintArray arr1 = NULL;
    if (arg1 != NULL && ptr1 == NULL) {
        arr1 = (jintArray)env->CallObjectMethod(arg1, JavaCPP_arrayMID);
        if (env->ExceptionOccurred() != NULL) {
            env->ExceptionClear();
        } else {
            ptr1 = arr1 == NULL ? NULL : env->GetIntArrayElements(arr1, NULL);
        }
    }
    int* ptr2 = arg2 == NULL ? NULL : (int*)env->GetDirectBufferAddress(arg2);
    jintArray arr2 = NULL;
    if (arg2 != NULL && ptr2 == NULL) {
        arr2 = (jintArray)env->CallObjectMethod(arg2, JavaCPP_arrayMID);
        if (env->ExceptionOccurred() != NULL) {
            env->ExceptionClear();
        } else {
            ptr2 = arr2 == NULL ? NULL : env->GetIntArrayElements(arr2, NULL);
        }
    }
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::getLibVersion(*(unsigned*)ptr0, *(unsigned*)ptr1, *(unsigned*)ptr2);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (arr0 != NULL) env->ReleaseIntArrayElements(arr0, (jint*)ptr0, 0);
    if (arr1 != NULL) env->ReleaseIntArrayElements(arr1, (jint*)ptr1, 0);
    if (arr2 != NULL) env->ReleaseIntArrayElements(arr2, (jint*)ptr2, 0);
    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_getLibVersion___3I_3I_3I(JNIEnv* env, jclass cls, jintArray arg0, jintArray arg1, jintArray arg2) {
    int* ptr0 = arg0 == NULL ? NULL : env->GetIntArrayElements(arg0, NULL);
    int* ptr1 = arg1 == NULL ? NULL : env->GetIntArrayElements(arg1, NULL);
    int* ptr2 = arg2 == NULL ? NULL : env->GetIntArrayElements(arg2, NULL);
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::getLibVersion(*(unsigned*)ptr0, *(unsigned*)ptr1, *(unsigned*)ptr2);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (arg0 != NULL) env->ReleaseIntArrayElements(arg0, (jint*)ptr0, 0);
    if (arg1 != NULL) env->ReleaseIntArrayElements(arg1, (jint*)ptr1, 0);
    if (arg2 != NULL) env->ReleaseIntArrayElements(arg2, (jint*)ptr2, 0);
    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_getLibVersion__Lorg_bytedeco_javacpp_IntPointer_2Lorg_bytedeco_javacpp_IntPointer_2Lorg_bytedeco_javacpp_IntPointer_2(JNIEnv* env, jclass cls, jobject arg0, jobject arg1, jobject arg2) {
    int* ptr0 = arg0 == NULL ? NULL : (int*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    if (ptr0 == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "Pointer address of argument 0 is NULL.");
        return;
    }
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    int* ptr1 = arg1 == NULL ? NULL : (int*)jlong_to_ptr(env->GetLongField(arg1, JavaCPP_addressFID));
    if (ptr1 == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "Pointer address of argument 1 is NULL.");
        return;
    }
    jlong position1 = arg1 == NULL ? 0 : env->GetLongField(arg1, JavaCPP_positionFID);
    ptr1 += position1;
    int* ptr2 = arg2 == NULL ? NULL : (int*)jlong_to_ptr(env->GetLongField(arg2, JavaCPP_addressFID));
    if (ptr2 == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "Pointer address of argument 2 is NULL.");
        return;
    }
    jlong position2 = arg2 == NULL ? 0 : env->GetLongField(arg2, JavaCPP_positionFID);
    ptr2 += position2;
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::getLibVersion(*(unsigned*)ptr0, *(unsigned*)ptr1, *(unsigned*)ptr2);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT jint JNICALL Java_think_hdf5_hdf5_00024library_sizeof_1hsize_1t(JNIEnv* env, jclass cls) {
    jint rarg = 0;
    jthrowable exc = NULL;
    try {
        int rvalue = ::think::hdf5::library::sizeof_hsize_t();
        rarg = (jint)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024library_open_1file__Lorg_bytedeco_javacpp_BytePointer_2I(JNIEnv* env, jclass cls, jobject arg0, jint arg1) {
    signed char* ptr0 = arg0 == NULL ? NULL : (signed char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    const ::think::hdf5::object* rptr;
    jthrowable exc = NULL;
    try {
        rptr = (const ::think::hdf5::object*)::think::hdf5::library::open_file((const char*)ptr0, arg1);
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 20);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024library_open_1file__Ljava_lang_String_2I(JNIEnv* env, jclass cls, jstring arg0, jint arg1) {
    const char* ptr0 = JavaCPP_getStringBytes(env, arg0);
    jobject rarg = NULL;
    const ::think::hdf5::object* rptr;
    jthrowable exc = NULL;
    try {
        rptr = (const ::think::hdf5::object*)::think::hdf5::library::open_file(ptr0, arg1);
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 20);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    JavaCPP_releaseStringBytes(env, arg0, ptr0);
    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_close_1file(JNIEnv* env, jclass cls, jobject arg0) {
    ::think::hdf5::object* ptr0 = arg0 == NULL ? NULL : (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library::close_file(ptr0);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024library_allocate(JNIEnv* env, jobject obj) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::library* rptr = new ::think::hdf5::library();
        jlong rcapacity = 1;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024library_deallocate);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}

JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024dataset_asabstract_1ds(JNIEnv* env, jclass cls, jobject arg0) {
    ::think::hdf5::dataset* ptr0 = arg0 == NULL ? NULL : (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jobject rarg = NULL;
    ::think::hdf5::abstract_ds* rptr;
    jthrowable exc = NULL;
    try {
        rptr = static_cast<think::hdf5::abstract_ds*>(ptr0);
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 21);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jboolean JNICALL Java_think_hdf5_hdf5_00024dataset_is_1simple(JNIEnv* env, jobject obj) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    jthrowable exc = NULL;
    try {
        bool rvalue = (bool)ptr->is_simple();
        rarg = (jboolean)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024dataset_ndims(JNIEnv* env, jobject obj) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->ndims();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024dataset_get_1dims(JNIEnv* env, jobject obj, jobject arg0) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->get_dims(ptr0);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT jboolean JNICALL Java_think_hdf5_hdf5_00024dataset_is_1variable_1len_1string(JNIEnv* env, jobject obj) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jboolean rarg = 0;
    jthrowable exc = NULL;
    try {
        bool rvalue = (bool)ptr->is_variable_len_string();
        rarg = (jboolean)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024dataset_string_1column_1size(JNIEnv* env, jobject obj) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->string_column_size();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024dataset_string_1size(JNIEnv* env, jobject obj) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->string_size();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024dataset_read_1variable_1string(JNIEnv* env, jobject obj, jobject arg0, jlong arg1) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->read_variable_string(ptr0, (size_t)arg1);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024dataset_release_1variable_1string(JNIEnv* env, jobject obj, jobject arg0) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->release_variable_string(ptr0);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024dataset_read_1string(JNIEnv* env, jobject obj, jobject arg0) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->read_string(ptr0);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024dataset_read(JNIEnv* env, jobject obj, jobject arg0, jlong arg1) {
    ::think::hdf5::dataset* ptr = (::think::hdf5::dataset*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->read(ptr0, (size_t)arg1);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}

JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024object_child_1count(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->child_count();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024object_get_1child(JNIEnv* env, jobject obj, jlong arg0) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    ::think::hdf5::object* rptr;
    jthrowable exc = NULL;
    try {
        rptr = ptr->get_child((size_t)arg0);
        if (rptr == ptr) {
            rarg = obj;
        } else if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 20);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024object_to_1dataset(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    ::think::hdf5::dataset* rptr;
    jthrowable exc = NULL;
    try {
        rptr = ptr->to_dataset();
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 22);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024object_registry(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    ::think::hdf5::object_registry* rptr;
    jthrowable exc = NULL;
    try {
        rptr = &ptr->registry();
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 23);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_think_hdf5_hdf5_00024object_obj_1id(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    jthrowable exc = NULL;
    try {
        int rvalue = ptr->obj_id();
        rarg = (jint)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024object_name(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    signed char* rptr;
    jthrowable exc = NULL;
    try {
        StringAdapter radapter(ptr->name());
        rptr = radapter;
        jlong rcapacity = (jlong)radapter.size;
        void* rowner = radapter.owner;
        void (*deallocator)(void*) = &StringAdapter::deallocate;
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 1);
            if (rarg != NULL) {
                JavaCPP_initPointer(env, rarg, rptr, rcapacity, rowner, deallocator);
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jint JNICALL Java_think_hdf5_hdf5_00024object_type(JNIEnv* env, jobject obj) {
    ::think::hdf5::object* ptr = (::think::hdf5::object*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    jthrowable exc = NULL;
    try {
        think::hdf5::EObjType::EEnum rvalue = (think::hdf5::EObjType::EEnum)ptr->type();
        rarg = (jint)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}

JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024object_1registry_dereference(JNIEnv* env, jobject obj, jint arg0, jlong arg1) {
    ::think::hdf5::object_registry* ptr = (::think::hdf5::object_registry*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    ::think::hdf5::object* rptr;
    jthrowable exc = NULL;
    try {
        rptr = ptr->dereference(arg0, arg1);
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 20);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}

JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024location_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::location* rptr = new ::think::hdf5::location[arg0];
        jlong rcapacity = arg0;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024location_deallocateArray);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024location_get_1attribute(JNIEnv* env, jobject obj, jlong arg0) {
    ::think::hdf5::location* ptr = (::think::hdf5::location*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    ::think::hdf5::attribute* rptr;
    jthrowable exc = NULL;
    try {
        rptr = ptr->get_attribute((size_t)arg0);
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 25);
            if (rarg != NULL) {
                env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024location_get_1attribute_1count(JNIEnv* env, jobject obj) {
    ::think::hdf5::location* ptr = (::think::hdf5::location*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->get_attribute_count();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024location_allocate(JNIEnv* env, jobject obj) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::location* rptr = new ::think::hdf5::location();
        jlong rcapacity = 1;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024location_deallocate);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}

JNIEXPORT jobject JNICALL Java_think_hdf5_hdf5_00024attribute_name(JNIEnv* env, jobject obj) {
    ::think::hdf5::attribute* ptr = (::think::hdf5::attribute*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jobject rarg = NULL;
    signed char* rptr;
    jthrowable exc = NULL;
    try {
        StringAdapter radapter(ptr->name());
        rptr = radapter;
        jlong rcapacity = (jlong)radapter.size;
        void* rowner = radapter.owner;
        void (*deallocator)(void*) = &StringAdapter::deallocate;
        if (rptr != NULL) {
            rarg = JavaCPP_createPointer(env, 1);
            if (rarg != NULL) {
                JavaCPP_initPointer(env, rarg, rptr, rcapacity, rowner, deallocator);
            }
        }
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024attribute_read(JNIEnv* env, jobject obj, jobject arg0, jlong arg1) {
    ::think::hdf5::attribute* ptr = (::think::hdf5::attribute*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    char* ptr0 = arg0 == NULL ? NULL : (char*)jlong_to_ptr(env->GetLongField(arg0, JavaCPP_addressFID));
    jlong position0 = arg0 == NULL ? 0 : env->GetLongField(arg0, JavaCPP_positionFID);
    ptr0 += position0;
    jthrowable exc = NULL;
    try {
        ptr->read(ptr0, (size_t)arg1);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}

JNIEXPORT jint JNICALL Java_think_hdf5_hdf5_00024abstract_1ds_get_1type_1class(JNIEnv* env, jobject obj) {
    ::think::hdf5::abstract_ds* ptr = (::think::hdf5::abstract_ds*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jint rarg = 0;
    jthrowable exc = NULL;
    try {
        think::hdf5::abstract_ds::EDType rvalue = (think::hdf5::abstract_ds::EDType)ptr->get_type_class();
        rarg = (jint)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}
JNIEXPORT jlong JNICALL Java_think_hdf5_hdf5_00024abstract_1ds_get_1in_1mem_1data_1size(JNIEnv* env, jobject obj) {
    ::think::hdf5::abstract_ds* ptr = (::think::hdf5::abstract_ds*)jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));
    if (ptr == NULL) {
        env->ThrowNew(JavaCPP_getClass(env, 17), "This pointer address is NULL.");
        return 0;
    }
    jlong position = env->GetLongField(obj, JavaCPP_positionFID);
    ptr += position;
    jlong rarg = 0;
    jthrowable exc = NULL;
    try {
        size_t rvalue = (size_t)ptr->get_in_mem_data_size();
        rarg = (jlong)rvalue;
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
    return rarg;
}

JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024EObjType_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::EObjType* rptr = new ::think::hdf5::EObjType[arg0];
        jlong rcapacity = arg0;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024EObjType_deallocateArray);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024EObjType_allocate(JNIEnv* env, jobject obj) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::EObjType* rptr = new ::think::hdf5::EObjType();
        jlong rcapacity = 1;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024EObjType_deallocate);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}

JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024Access_allocateArray(JNIEnv* env, jobject obj, jlong arg0) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::Access* rptr = new ::think::hdf5::Access[arg0];
        jlong rcapacity = arg0;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024Access_deallocateArray);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}
JNIEXPORT void JNICALL Java_think_hdf5_hdf5_00024Access_allocate(JNIEnv* env, jobject obj) {
    jthrowable exc = NULL;
    try {
        ::think::hdf5::Access* rptr = new ::think::hdf5::Access();
        jlong rcapacity = 1;
        JavaCPP_initPointer(env, obj, rptr, rcapacity, rptr, &JavaCPP_think_hdf5_hdf5_00024Access_deallocate);
    } catch (...) {
        exc = JavaCPP_handleException(env, 19);
    }

    if (exc != NULL) {
        env->Throw(exc);
    }
}


}

