# chord-fressian

This is a tiny library that adds
[Fressian](https://github.com/clojure/data.fressian/) support to
[Chord](https://github.com/james-henderson/chord).  Fressian is an efficient,
self-describing binary format that makes it easy to transmit structured binary
data over a socket.

## Dependency

Add to your project.clj:

```clojure
    [thinktopic/chord-fressian "0.1.0"]
```

## Usage

For both the Clojure server and the Clojurescript client you just need to
require chord-fressian.format, and then use the {:format :fressian} option when
setting up the websocket with Chord.

### Clojurescript client

```clojure
(:require [chord.client :refer [ws-ch]]
           chord-fressian.format
           [cljs.core.async :refer [<! >! put! close!]])
 (:require-macros [cljs.core.async.macros :refer [go]])

 (go
   (let [{:keys [ws-channel error]} (<! (ws-ch "ws://localhost:3000/ws"
                                               {:format :fressian}))]
     (if-not error
       (>! ws-channel "Hello server from client!")
       (js/console.log "Error:" (pr-str error)))))
```

### Clojure server

```clojure
  (:require [chord.http-kit :refer [wrap-websocket-handler]]
            chord-fressian.format
            [clojure.core.async :as a])

  (defn your-handler [{:keys [ws-channel] :as req}]
    (go
      (let [{:keys [message]} (<! ws-channel)]
        (println "Message received:" message)
        (>! ws-channel "Hello client from server!")
        (close! ws-channel))))

  (start-server (-> #'your-handler (wrap-websocket-handler {:format :fressian}))
                {:port 3000})
```

## License

Copyright © 2014 Jeff Rose, ThinkTopic Labs

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
