// Compiled by ClojureScript 1.7.228 {}
goog.provide('thinktopic.aljabr.core');
goog.require('cljs.core');
goog.require('clojure.core.matrix');
goog.require('clojure.core.matrix.implementations');
goog.require('thi.ng.typedarrays.core');
cljs.core.enable_console_print_BANG_.call(null);
thinktopic.aljabr.core.array_seq_STAR_ = (function thinktopic$aljabr$core$array_seq_STAR_(ary){
if(cljs.core.truth_(ary)){
return (new cljs.core.IndexedSeq(ary,(0)));
} else {
return null;
}
});

/**
 * @interface
 */
thinktopic.aljabr.core.PNDArray = function(){};

/**
 * Returns value at given position in an ndarray view (without bounds check,
 *  assumes position is safe).
 */
thinktopic.aljabr.core.get_at = (function thinktopic$aljabr$core$get_at(var_args){
var args37075 = [];
var len__19463__auto___37111 = arguments.length;
var i__19464__auto___37112 = (0);
while(true){
if((i__19464__auto___37112 < len__19463__auto___37111)){
args37075.push((arguments[i__19464__auto___37112]));

var G__37113 = (i__19464__auto___37112 + (1));
i__19464__auto___37112 = G__37113;
continue;
} else {
}
break;
}

var G__37077 = args37075.length;
switch (G__37077) {
case 2:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37075.length)].join('')));

}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$lang$maxFixedArity = 5;

/**
 * Returns value at given position in an ndarray view (with bounds
 *  check)
 */
thinktopic.aljabr.core.get_at_safe = (function thinktopic$aljabr$core$get_at_safe(var_args){
var args37078 = [];
var len__19463__auto___37115 = arguments.length;
var i__19464__auto___37116 = (0);
while(true){
if((i__19464__auto___37116 < len__19463__auto___37115)){
args37078.push((arguments[i__19464__auto___37116]));

var G__37117 = (i__19464__auto___37116 + (1));
i__19464__auto___37116 = G__37117;
continue;
} else {
}
break;
}

var G__37080 = args37078.length;
switch (G__37080) {
case 2:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37078.length)].join('')));

}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$lang$maxFixedArity = 5;

/**
 * Returns value at given global index in an ndarray view's backing
 *  array.
 */
thinktopic.aljabr.core.get_at_index = (function thinktopic$aljabr$core$get_at_index(_,i){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2(_,i);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-index",_);
}
}
}
});

/**
 * Sets backing data array at given position in an ndarray view to
 *  new value v (without bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at = (function thinktopic$aljabr$core$set_at(var_args){
var args37081 = [];
var len__19463__auto___37119 = arguments.length;
var i__19464__auto___37120 = (0);
while(true){
if((i__19464__auto___37120 < len__19463__auto___37119)){
args37081.push((arguments[i__19464__auto___37120]));

var G__37121 = (i__19464__auto___37120 + (1));
i__19464__auto___37120 = G__37121;
continue;
} else {
}
break;
}

var G__37083 = args37081.length;
switch (G__37083) {
case 3:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37081.length)].join('')));

}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$3(_,x,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$4(_,x,y,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$5(_,x,y,z,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$6(_,x,y,z,w,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$lang$maxFixedArity = 6;

/**
 * Sets backing array at given position in an ndarray view to
 *  new value v (with bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at_safe = (function thinktopic$aljabr$core$set_at_safe(var_args){
var args37084 = [];
var len__19463__auto___37123 = arguments.length;
var i__19464__auto___37124 = (0);
while(true){
if((i__19464__auto___37124 < len__19463__auto___37123)){
args37084.push((arguments[i__19464__auto___37124]));

var G__37125 = (i__19464__auto___37124 + (1));
i__19464__auto___37124 = G__37125;
continue;
} else {
}
break;
}

var G__37086 = args37084.length;
switch (G__37086) {
case 3:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37084.length)].join('')));

}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3(_,x,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4(_,x,y,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5(_,x,y,z,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$6(_,x,y,z,w,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$lang$maxFixedArity = 6;

/**
 * Sets backing data array at given global index to new value
 *  v (without bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at_index = (function thinktopic$aljabr$core$set_at_index(_,i,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3(_,i,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-index",_);
}
}
}
});

/**
 * Applies function f to given position in an ndarray view and sets
 *  backing array at same position to the return value of f. The
 *  function f itself accepts m args: first the n coordinates of the
 *  position and the value at this position
 */
thinktopic.aljabr.core.update_at = (function thinktopic$aljabr$core$update_at(var_args){
var args37087 = [];
var len__19463__auto___37127 = arguments.length;
var i__19464__auto___37128 = (0);
while(true){
if((i__19464__auto___37128 < len__19463__auto___37127)){
args37087.push((arguments[i__19464__auto___37128]));

var G__37129 = (i__19464__auto___37128 + (1));
i__19464__auto___37128 = G__37129;
continue;
} else {
}
break;
}

var G__37089 = args37087.length;
switch (G__37089) {
case 3:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37087.length)].join('')));

}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$3(_,x,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$4(_,x,y,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$5(_,x,y,z,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$6(_,x,y,z,w,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$lang$maxFixedArity = 6;

/**
 * Same as `update-at` but with bounds check.
 */
thinktopic.aljabr.core.update_at_safe = (function thinktopic$aljabr$core$update_at_safe(var_args){
var args37090 = [];
var len__19463__auto___37131 = arguments.length;
var i__19464__auto___37132 = (0);
while(true){
if((i__19464__auto___37132 < len__19463__auto___37131)){
args37090.push((arguments[i__19464__auto___37132]));

var G__37133 = (i__19464__auto___37132 + (1));
i__19464__auto___37132 = G__37133;
continue;
} else {
}
break;
}

var G__37092 = args37090.length;
switch (G__37092) {
case 3:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37090.length)].join('')));

}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3(_,x,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4(_,x,y,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5(_,x,y,z,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$6(_,x,y,z,w,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$lang$maxFixedArity = 6;

/**
 * Applies function f to given global index in an ndarray's view
 *  backing array and sets it to the return value of f. The
 *  function f itself accepts 2 args: the supplied array index
 *  and the array's value at this index
 */
thinktopic.aljabr.core.update_at_index = (function thinktopic$aljabr$core$update_at_index(_,i,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3(_,i,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-index",_);
}
}
}
});

/**
 * Returns a new ndarray view with stride order/axes swapped as per
 *  given vector. Does not mutate backing array.
 */
thinktopic.aljabr.core.transpose = (function thinktopic$aljabr$core$transpose(var_args){
var args37093 = [];
var len__19463__auto___37135 = arguments.length;
var i__19464__auto___37136 = (0);
while(true){
if((i__19464__auto___37136 < len__19463__auto___37135)){
args37093.push((arguments[i__19464__auto___37136]));

var G__37137 = (i__19464__auto___37136 + (1));
i__19464__auto___37136 = G__37137;
continue;
} else {
}
break;
}

var G__37095 = args37093.length;
switch (G__37095) {
case 2:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37093.length)].join('')));

}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$lang$maxFixedArity = 5;

/**
 * Returns the backing data array.
 */
thinktopic.aljabr.core.data = (function thinktopic$aljabr$core$data(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$data$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$data$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.data[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.data["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.data",_);
}
}
}
});

/**
 * Returns the ndarray's type id (keyword).
 */
thinktopic.aljabr.core.data_type = (function thinktopic$aljabr$core$data_type(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$data_type$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$data_type$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.data_type[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.data_type["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.data-type",_);
}
}
}
});

/**
 * Returns a vector of the ndarray's strides in each dimension.
 */
thinktopic.aljabr.core.stride = (function thinktopic$aljabr$core$stride(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$stride$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$stride$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.stride[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.stride["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.stride",_);
}
}
}
});

/**
 * Returns the ndarray view's start index in the backing data array
 */
thinktopic.aljabr.core.offset = (function thinktopic$aljabr$core$offset(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$offset$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$offset$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.offset[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.offset["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.offset",_);
}
}
}
});

/**
 * Returns the element count of an ndarray view
 */
thinktopic.aljabr.core.size = (function thinktopic$aljabr$core$size(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$size$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$size$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.size[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.size["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.size",_);
}
}
}
});

/**
 * Creates a new backing array of only values in given ndarray view
 *  and returns new ndarray of same shape, but with strides reset to
 *  defaults order.
 */
thinktopic.aljabr.core.extract = (function thinktopic$aljabr$core$extract(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$extract$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$extract$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.extract[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.extract["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.extract",_);
}
}
}
});

/**
 * Returns the global index into the backing array for given
 *  position in an ndarray view.
 */
thinktopic.aljabr.core.index_at = (function thinktopic$aljabr$core$index_at(var_args){
var args37096 = [];
var len__19463__auto___37139 = arguments.length;
var i__19464__auto___37140 = (0);
while(true){
if((i__19464__auto___37140 < len__19463__auto___37139)){
args37096.push((arguments[i__19464__auto___37140]));

var G__37141 = (i__19464__auto___37140 + (1));
i__19464__auto___37140 = G__37141;
continue;
} else {
}
break;
}

var G__37098 = args37096.length;
switch (G__37098) {
case 2:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37096.length)].join('')));

}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$lang$maxFixedArity = 5;

/**
 * Computes relative position in an ndarray view from given absolute
 *  array index.
 */
thinktopic.aljabr.core.index_pos = (function thinktopic$aljabr$core$index_pos(_,i){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_pos$arity$2(_,i);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_pos[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_pos["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-pos",_);
}
}
}
});

/**
 * Returns a lazy seq of all array indices in an ndarray view.
 */
thinktopic.aljabr.core.index_seq = (function thinktopic$aljabr$core$index_seq(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_seq$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_seq[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_seq["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-seq",_);
}
}
}
});

/**
 * Returns a lazy seq of all position vectors in an ndarray view.
 */
thinktopic.aljabr.core.position_seq = (function thinktopic$aljabr$core$position_seq(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$position_seq$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.position_seq[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.position_seq["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.position-seq",_);
}
}
}
});

/**
 * Returns a new ndarray of same type with its shape truncated at
 *  top end. Negative args are considered offsets from current shape.
 *  nil values keep shape in that dimension. Does not mutate backing
 *  array.
 */
thinktopic.aljabr.core.truncate_h = (function thinktopic$aljabr$core$truncate_h(var_args){
var args37099 = [];
var len__19463__auto___37143 = arguments.length;
var i__19464__auto___37144 = (0);
while(true){
if((i__19464__auto___37144 < len__19463__auto___37143)){
args37099.push((arguments[i__19464__auto___37144]));

var G__37145 = (i__19464__auto___37144 + (1));
i__19464__auto___37144 = G__37145;
continue;
} else {
}
break;
}

var G__37101 = args37099.length;
switch (G__37101) {
case 2:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37099.length)].join('')));

}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$lang$maxFixedArity = 5;

/**
 * Returns a new ndarray of same type with its shape truncated at
 *  lower end, effectively shifting its start index/offset towards the
 *  center of the view. Does not mutate backing array.
 */
thinktopic.aljabr.core.truncate_l = (function thinktopic$aljabr$core$truncate_l(var_args){
var args37102 = [];
var len__19463__auto___37147 = arguments.length;
var i__19464__auto___37148 = (0);
while(true){
if((i__19464__auto___37148 < len__19463__auto___37147)){
args37102.push((arguments[i__19464__auto___37148]));

var G__37149 = (i__19464__auto___37148 + (1));
i__19464__auto___37148 = G__37149;
continue;
} else {
}
break;
}

var G__37104 = args37102.length;
switch (G__37104) {
case 2:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37102.length)].join('')));

}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$lang$maxFixedArity = 5;

/**
 * Returns new ndarray view with stride steps/direction changed as
 *  per given vector. Values >1 result in skipping of items in that
 *  dimension, negative value flip direction, `nil` keeps current
 *  stride for that dimension. Does not mutate backing array.
 */
thinktopic.aljabr.core.step = (function thinktopic$aljabr$core$step(var_args){
var args37105 = [];
var len__19463__auto___37151 = arguments.length;
var i__19464__auto___37152 = (0);
while(true){
if((i__19464__auto___37152 < len__19463__auto___37151)){
args37105.push((arguments[i__19464__auto___37152]));

var G__37153 = (i__19464__auto___37152 + (1));
i__19464__auto___37152 = G__37153;
continue;
} else {
}
break;
}

var G__37107 = args37105.length;
switch (G__37107) {
case 2:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37105.length)].join('')));

}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$lang$maxFixedArity = 5;

/**
 * Generalized getter. Accepts n args (e.g. 3 for a 3D ndarray),
 *  each selecting a dimension slice (nil skips a dimension). Returns
 *  new ndarray view of selection, or if selecting in all dimensions,
 *  returns array value at that point. Does not mutate backing array.
 */
thinktopic.aljabr.core.pick = (function thinktopic$aljabr$core$pick(var_args){
var args37108 = [];
var len__19463__auto___37155 = arguments.length;
var i__19464__auto___37156 = (0);
while(true){
if((i__19464__auto___37156 < len__19463__auto___37155)){
args37108.push((arguments[i__19464__auto___37156]));

var G__37157 = (i__19464__auto___37156 + (1));
i__19464__auto___37156 = G__37157;
continue;
} else {
}
break;
}

var G__37110 = args37108.length;
switch (G__37110) {
case 2:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37108.length)].join('')));

}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$lang$maxFixedArity = 5;

thinktopic.aljabr.core.order = (function thinktopic$aljabr$core$order(coll){
return cljs.core.mapv.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.peek,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),coll)));
});
thinktopic.aljabr.core.shape__GT_stride = (function thinktopic$aljabr$core$shape__GT_stride(shape){
return cljs.core.vec.call(null,cljs.core.drop.call(null,(1),cljs.core.reduce.call(null,(function (p1__37159_SHARP_,p2__37160_SHARP_){
return cljs.core.conj.call(null,p1__37159_SHARP_,(p2__37160_SHARP_ * cljs.core.first.call(null,p1__37159_SHARP_)));
}),cljs.core.list((1)),cljs.core.reverse.call(null,shape))));
});
thinktopic.aljabr.core.ctor_registry = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);

/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1generic = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37168(s__37169){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37169__$1 = s__37169;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37169__$1);
if(temp__4657__auto__){
var s__37169__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37169__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37169__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37171 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37170 = (0);
while(true){
if((i__37170 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37170);
cljs.core.chunk_append.call(null,b__37171,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38861 = (i__37170 + (1));
i__37170 = G__38861;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37171),thinktopic$aljabr$core$iter__37168.call(null,cljs.core.chunk_rest.call(null,s__37169__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37171),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37169__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37168.call(null,cljs.core.rest.call(null,s__37169__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37165 = self__._offset;
var vec__37172 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37165 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37165], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37165], null));
var a0 = cljs.core.nth.call(null,vec__37172,(0),null);
var b0 = cljs.core.nth.call(null,vec__37172,(1),null);
var G__37165__$1 = cljs.core.nth.call(null,vec__37172,(2),null);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,G__37165__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37164){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37164__$1 = (G__37164 | (0));
var G__37161 = (G__37164__$1 - self__._offset);
var a0 = ((G__37161 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37163){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37161_38862 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37161_38862] = G__37163.call(null,p0,(self__._data[G__37161_38862])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37161){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37161);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37161 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37162 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,self__._offset,G__37161.call(null,p0__$1),G__37162.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37165 = self__._offset;
var G__37161 = cljs.core.PersistentVector.EMPTY;
var G__37162 = cljs.core.PersistentVector.EMPTY;
var vec__37173 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37161,G__37162,(G__37165 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37161,self__._shape0),cljs.core.conj.call(null,G__37162,self__._stride0),G__37165], null));
var G__37161__$1 = cljs.core.nth.call(null,vec__37173,(0),null);
var G__37162__$1 = cljs.core.nth.call(null,vec__37173,(1),null);
var G__37165__$1 = cljs.core.nth.call(null,vec__37173,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37161__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37165__$1,G__37162__$1,G__37161__$1);
} else {
return (self__._data[(G__37165__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37174 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37174,(0),null);
var b0 = cljs.core.nth.call(null,vec__37174,(1),null);
var G__37165 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,G__37165,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37163){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37161_38863 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37161_38863] = G__37163.call(null,p0,(self__._data[G__37161_38863])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37161){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37161);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37161){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37161);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37161,G__37163){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37161] = G__37163.call(null,G__37161,(self__._data[(G__37161 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37175(s__37176){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37176__$1 = s__37176;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37176__$1);
if(temp__4657__auto__){
var s__37176__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37176__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37176__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37178 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37177 = (0);
while(true){
if((i__37177 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37177);
cljs.core.chunk_append.call(null,b__37178,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38864 = (i__37177 + (1));
i__37177 = G__38864;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37178),thinktopic$aljabr$core$iter__37175.call(null,cljs.core.chunk_rest.call(null,s__37176__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37178),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37176__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37175.call(null,cljs.core.rest.call(null,s__37176__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = cljs.core.to_array.call(null,self__._shape0);
var vec__37179 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37179,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1generic(buf__37021__auto__,(0),a0,self__._shape0));
var G__37161_38865 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37162_38866 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37161_38865)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37162_38866) | (0))] = (self__._data[(cljs.core.first.call(null,G__37161_38865) | (0))]));

var G__38867 = cljs.core.next.call(null,G__37161_38865);
var G__38868 = cljs.core.next.call(null,G__37162_38866);
G__37161_38865 = G__38867;
G__37162_38866 = G__38868;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38869 = length__37027__auto__;
var i__37023__auto___38870 = (0);
while(true){
if((i__37023__auto___38870 < n__19308__auto___38869)){
(r__37028__auto__[i__37023__auto___38870] = 0.0);

var G__38871 = (i__37023__auto___38870 + (1));
i__37023__auto___38870 = G__38871;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38872 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38873 = (0);
while(true){
if((i__37023__auto___38873 < n__19308__auto___38872)){
(r__37028__auto__[i__37023__auto___38873] = 0.0);

var G__38874 = (i__37023__auto___38873 + (1));
i__37023__auto___38873 = G__38874;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37180(s__37181){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37181__$1 = s__37181;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37181__$1);
if(temp__4657__auto__){
var s__37181__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37181__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37181__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37183 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37182 = (0);
while(true){
if((i__37182 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37182);
cljs.core.chunk_append.call(null,b__37183,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38875 = (i__37182 + (1));
i__37182 = G__38875;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37183),thinktopic$aljabr$core$iter__37180.call(null,cljs.core.chunk_rest.call(null,s__37181__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37183),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37181__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37180.call(null,cljs.core.rest.call(null,s__37181__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38876 = length__37027__auto__;
var i__37023__auto___38877 = (0);
while(true){
if((i__37023__auto___38877 < n__19308__auto___38876)){
(cloned_ary__37042__auto__[i__37023__auto___38877] = (self__._data[i__37023__auto___38877]));

var G__38878 = (i__37023__auto___38877 + (1));
i__37023__auto___38877 = G__38878;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1generic";

thinktopic.aljabr.core.NDArray1generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1generic");
});

thinktopic.aljabr.core.__GT_NDArray1generic = (function thinktopic$aljabr$core$__GT_NDArray1generic(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1generic(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_generic = (function thinktopic$aljabr$core$make_raw_ndarray1_generic(data__37025__auto__,o__37045__auto__,p__37184,p__37185){
var vec__37188 = p__37184;
var _stride0 = cljs.core.nth.call(null,vec__37188,(0),null);
var vec__37189 = p__37185;
var _shape0 = cljs.core.nth.call(null,vec__37189,(0),null);
return (new thinktopic.aljabr.core.NDArray1generic(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_generic', thinktopic.aljabr.core.make_raw_ndarray1_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint8 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37197(s__37198){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37198__$1 = s__37198;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37198__$1);
if(temp__4657__auto__){
var s__37198__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37198__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37198__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37200 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37199 = (0);
while(true){
if((i__37199 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37199);
cljs.core.chunk_append.call(null,b__37200,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38879 = (i__37199 + (1));
i__37199 = G__38879;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37200),thinktopic$aljabr$core$iter__37197.call(null,cljs.core.chunk_rest.call(null,s__37198__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37200),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37198__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37197.call(null,cljs.core.rest.call(null,s__37198__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37194 = self__._offset;
var vec__37201 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37194 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37194], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37194], null));
var a0 = cljs.core.nth.call(null,vec__37201,(0),null);
var b0 = cljs.core.nth.call(null,vec__37201,(1),null);
var G__37194__$1 = cljs.core.nth.call(null,vec__37201,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,G__37194__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37193){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37193__$1 = (G__37193 | (0));
var G__37190 = (G__37193__$1 - self__._offset);
var a0 = ((G__37190 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37192){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37190_38880 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37190_38880] = G__37192.call(null,p0,(self__._data[G__37190_38880])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37190){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37190);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37190 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37191 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,self__._offset,G__37190.call(null,p0__$1),G__37191.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37194 = self__._offset;
var G__37190 = cljs.core.PersistentVector.EMPTY;
var G__37191 = cljs.core.PersistentVector.EMPTY;
var vec__37202 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37190,G__37191,(G__37194 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37190,self__._shape0),cljs.core.conj.call(null,G__37191,self__._stride0),G__37194], null));
var G__37190__$1 = cljs.core.nth.call(null,vec__37202,(0),null);
var G__37191__$1 = cljs.core.nth.call(null,vec__37202,(1),null);
var G__37194__$1 = cljs.core.nth.call(null,vec__37202,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37190__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37194__$1,G__37191__$1,G__37190__$1);
} else {
return (self__._data[(G__37194__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37203 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37203,(0),null);
var b0 = cljs.core.nth.call(null,vec__37203,(1),null);
var G__37194 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,G__37194,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37192){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37190_38881 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37190_38881] = G__37192.call(null,p0,(self__._data[G__37190_38881])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37190){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37190);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37190){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37190);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37190,G__37192){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37190] = G__37192.call(null,G__37190,(self__._data[(G__37190 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37204(s__37205){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37205__$1 = s__37205;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37205__$1);
if(temp__4657__auto__){
var s__37205__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37205__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37205__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37207 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37206 = (0);
while(true){
if((i__37206 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37206);
cljs.core.chunk_append.call(null,b__37207,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38882 = (i__37206 + (1));
i__37206 = G__38882;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37207),thinktopic$aljabr$core$iter__37204.call(null,cljs.core.chunk_rest.call(null,s__37205__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37207),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37205__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37204.call(null,cljs.core.rest.call(null,s__37205__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint8.call(null,self__._shape0);
var vec__37208 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37208,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1uint8(buf__37021__auto__,(0),a0,self__._shape0));
var G__37190_38883 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37191_38884 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37190_38883)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37191_38884) | (0))] = (self__._data[(cljs.core.first.call(null,G__37190_38883) | (0))]));

var G__38885 = cljs.core.next.call(null,G__37190_38883);
var G__38886 = cljs.core.next.call(null,G__37191_38884);
G__37190_38883 = G__38885;
G__37191_38884 = G__38886;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38887 = length__37027__auto__;
var i__37023__auto___38888 = (0);
while(true){
if((i__37023__auto___38888 < n__19308__auto___38887)){
(r__37028__auto__[i__37023__auto___38888] = 0.0);

var G__38889 = (i__37023__auto___38888 + (1));
i__37023__auto___38888 = G__38889;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38890 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38891 = (0);
while(true){
if((i__37023__auto___38891 < n__19308__auto___38890)){
(r__37028__auto__[i__37023__auto___38891] = 0.0);

var G__38892 = (i__37023__auto___38891 + (1));
i__37023__auto___38891 = G__38892;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37209(s__37210){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37210__$1 = s__37210;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37210__$1);
if(temp__4657__auto__){
var s__37210__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37210__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37210__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37212 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37211 = (0);
while(true){
if((i__37211 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37211);
cljs.core.chunk_append.call(null,b__37212,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38893 = (i__37211 + (1));
i__37211 = G__38893;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37212),thinktopic$aljabr$core$iter__37209.call(null,cljs.core.chunk_rest.call(null,s__37210__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37212),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37210__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37209.call(null,cljs.core.rest.call(null,s__37210__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38894 = length__37027__auto__;
var i__37023__auto___38895 = (0);
while(true){
if((i__37023__auto___38895 < n__19308__auto___38894)){
(cloned_ary__37042__auto__[i__37023__auto___38895] = (self__._data[i__37023__auto___38895]));

var G__38896 = (i__37023__auto___38895 + (1));
i__37023__auto___38895 = G__38896;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint8";

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint8");
});

thinktopic.aljabr.core.__GT_NDArray1uint8 = (function thinktopic$aljabr$core$__GT_NDArray1uint8(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint8(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint8(data__37025__auto__,o__37045__auto__,p__37213,p__37214){
var vec__37217 = p__37213;
var _stride0 = cljs.core.nth.call(null,vec__37217,(0),null);
var vec__37218 = p__37214;
var _shape0 = cljs.core.nth.call(null,vec__37218,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint8(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint8', thinktopic.aljabr.core.make_raw_ndarray1_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint8_clamped = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37226(s__37227){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37227__$1 = s__37227;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37227__$1);
if(temp__4657__auto__){
var s__37227__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37227__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37227__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37229 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37228 = (0);
while(true){
if((i__37228 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37228);
cljs.core.chunk_append.call(null,b__37229,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38897 = (i__37228 + (1));
i__37228 = G__38897;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37229),thinktopic$aljabr$core$iter__37226.call(null,cljs.core.chunk_rest.call(null,s__37227__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37229),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37227__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37226.call(null,cljs.core.rest.call(null,s__37227__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37223 = self__._offset;
var vec__37230 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37223 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37223], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37223], null));
var a0 = cljs.core.nth.call(null,vec__37230,(0),null);
var b0 = cljs.core.nth.call(null,vec__37230,(1),null);
var G__37223__$1 = cljs.core.nth.call(null,vec__37230,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,G__37223__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37222){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37222__$1 = (G__37222 | (0));
var G__37219 = (G__37222__$1 - self__._offset);
var a0 = ((G__37219 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37221){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37219_38898 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37219_38898] = G__37221.call(null,p0,(self__._data[G__37219_38898])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37219){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37219);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37219 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37220 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,self__._offset,G__37219.call(null,p0__$1),G__37220.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37223 = self__._offset;
var G__37219 = cljs.core.PersistentVector.EMPTY;
var G__37220 = cljs.core.PersistentVector.EMPTY;
var vec__37231 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37219,G__37220,(G__37223 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37219,self__._shape0),cljs.core.conj.call(null,G__37220,self__._stride0),G__37223], null));
var G__37219__$1 = cljs.core.nth.call(null,vec__37231,(0),null);
var G__37220__$1 = cljs.core.nth.call(null,vec__37231,(1),null);
var G__37223__$1 = cljs.core.nth.call(null,vec__37231,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37219__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37223__$1,G__37220__$1,G__37219__$1);
} else {
return (self__._data[(G__37223__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37232 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37232,(0),null);
var b0 = cljs.core.nth.call(null,vec__37232,(1),null);
var G__37223 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,G__37223,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37221){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37219_38899 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37219_38899] = G__37221.call(null,p0,(self__._data[G__37219_38899])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37219){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37219);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37219){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37219);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37219,G__37221){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37219] = G__37221.call(null,G__37219,(self__._data[(G__37219 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37233(s__37234){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37234__$1 = s__37234;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37234__$1);
if(temp__4657__auto__){
var s__37234__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37234__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37234__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37236 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37235 = (0);
while(true){
if((i__37235 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37235);
cljs.core.chunk_append.call(null,b__37236,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38900 = (i__37235 + (1));
i__37235 = G__38900;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37236),thinktopic$aljabr$core$iter__37233.call(null,cljs.core.chunk_rest.call(null,s__37234__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37236),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37234__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37233.call(null,cljs.core.rest.call(null,s__37234__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint8_clamped.call(null,self__._shape0);
var vec__37237 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37237,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1uint8_clamped(buf__37021__auto__,(0),a0,self__._shape0));
var G__37219_38901 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37220_38902 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37219_38901)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37220_38902) | (0))] = (self__._data[(cljs.core.first.call(null,G__37219_38901) | (0))]));

var G__38903 = cljs.core.next.call(null,G__37219_38901);
var G__38904 = cljs.core.next.call(null,G__37220_38902);
G__37219_38901 = G__38903;
G__37220_38902 = G__38904;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38905 = length__37027__auto__;
var i__37023__auto___38906 = (0);
while(true){
if((i__37023__auto___38906 < n__19308__auto___38905)){
(r__37028__auto__[i__37023__auto___38906] = 0.0);

var G__38907 = (i__37023__auto___38906 + (1));
i__37023__auto___38906 = G__38907;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38908 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38909 = (0);
while(true){
if((i__37023__auto___38909 < n__19308__auto___38908)){
(r__37028__auto__[i__37023__auto___38909] = 0.0);

var G__38910 = (i__37023__auto___38909 + (1));
i__37023__auto___38909 = G__38910;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37238(s__37239){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37239__$1 = s__37239;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37239__$1);
if(temp__4657__auto__){
var s__37239__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37239__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37239__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37241 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37240 = (0);
while(true){
if((i__37240 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37240);
cljs.core.chunk_append.call(null,b__37241,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38911 = (i__37240 + (1));
i__37240 = G__38911;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37241),thinktopic$aljabr$core$iter__37238.call(null,cljs.core.chunk_rest.call(null,s__37239__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37241),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37239__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37238.call(null,cljs.core.rest.call(null,s__37239__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38912 = length__37027__auto__;
var i__37023__auto___38913 = (0);
while(true){
if((i__37023__auto___38913 < n__19308__auto___38912)){
(cloned_ary__37042__auto__[i__37023__auto___38913] = (self__._data[i__37023__auto___38913]));

var G__38914 = (i__37023__auto___38913 + (1));
i__37023__auto___38913 = G__38914;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint8-clamped";

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint8-clamped");
});

thinktopic.aljabr.core.__GT_NDArray1uint8_clamped = (function thinktopic$aljabr$core$__GT_NDArray1uint8_clamped(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped = (function thinktopic$aljabr$core$make_raw_ndarray1_uint8_clamped(data__37025__auto__,o__37045__auto__,p__37242,p__37243){
var vec__37246 = p__37242;
var _stride0 = cljs.core.nth.call(null,vec__37246,(0),null);
var vec__37247 = p__37243;
var _shape0 = cljs.core.nth.call(null,vec__37247,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped', thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8_clamped], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint16 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37255(s__37256){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37256__$1 = s__37256;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37256__$1);
if(temp__4657__auto__){
var s__37256__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37256__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37256__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37258 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37257 = (0);
while(true){
if((i__37257 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37257);
cljs.core.chunk_append.call(null,b__37258,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38915 = (i__37257 + (1));
i__37257 = G__38915;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37258),thinktopic$aljabr$core$iter__37255.call(null,cljs.core.chunk_rest.call(null,s__37256__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37258),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37256__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37255.call(null,cljs.core.rest.call(null,s__37256__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37252 = self__._offset;
var vec__37259 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37252 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37252], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37252], null));
var a0 = cljs.core.nth.call(null,vec__37259,(0),null);
var b0 = cljs.core.nth.call(null,vec__37259,(1),null);
var G__37252__$1 = cljs.core.nth.call(null,vec__37259,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,G__37252__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37251){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37251__$1 = (G__37251 | (0));
var G__37248 = (G__37251__$1 - self__._offset);
var a0 = ((G__37248 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37250){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37248_38916 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37248_38916] = G__37250.call(null,p0,(self__._data[G__37248_38916])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37248){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37248);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37248 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37249 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,self__._offset,G__37248.call(null,p0__$1),G__37249.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37252 = self__._offset;
var G__37248 = cljs.core.PersistentVector.EMPTY;
var G__37249 = cljs.core.PersistentVector.EMPTY;
var vec__37260 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37248,G__37249,(G__37252 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37248,self__._shape0),cljs.core.conj.call(null,G__37249,self__._stride0),G__37252], null));
var G__37248__$1 = cljs.core.nth.call(null,vec__37260,(0),null);
var G__37249__$1 = cljs.core.nth.call(null,vec__37260,(1),null);
var G__37252__$1 = cljs.core.nth.call(null,vec__37260,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37248__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37252__$1,G__37249__$1,G__37248__$1);
} else {
return (self__._data[(G__37252__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37261 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37261,(0),null);
var b0 = cljs.core.nth.call(null,vec__37261,(1),null);
var G__37252 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,G__37252,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37250){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37248_38917 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37248_38917] = G__37250.call(null,p0,(self__._data[G__37248_38917])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37248){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37248);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37248){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37248);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37248,G__37250){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37248] = G__37250.call(null,G__37248,(self__._data[(G__37248 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37262(s__37263){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37263__$1 = s__37263;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37263__$1);
if(temp__4657__auto__){
var s__37263__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37263__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37263__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37265 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37264 = (0);
while(true){
if((i__37264 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37264);
cljs.core.chunk_append.call(null,b__37265,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38918 = (i__37264 + (1));
i__37264 = G__38918;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37265),thinktopic$aljabr$core$iter__37262.call(null,cljs.core.chunk_rest.call(null,s__37263__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37265),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37263__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37262.call(null,cljs.core.rest.call(null,s__37263__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint16.call(null,self__._shape0);
var vec__37266 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37266,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1uint16(buf__37021__auto__,(0),a0,self__._shape0));
var G__37248_38919 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37249_38920 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37248_38919)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37249_38920) | (0))] = (self__._data[(cljs.core.first.call(null,G__37248_38919) | (0))]));

var G__38921 = cljs.core.next.call(null,G__37248_38919);
var G__38922 = cljs.core.next.call(null,G__37249_38920);
G__37248_38919 = G__38921;
G__37249_38920 = G__38922;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38923 = length__37027__auto__;
var i__37023__auto___38924 = (0);
while(true){
if((i__37023__auto___38924 < n__19308__auto___38923)){
(r__37028__auto__[i__37023__auto___38924] = 0.0);

var G__38925 = (i__37023__auto___38924 + (1));
i__37023__auto___38924 = G__38925;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38926 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38927 = (0);
while(true){
if((i__37023__auto___38927 < n__19308__auto___38926)){
(r__37028__auto__[i__37023__auto___38927] = 0.0);

var G__38928 = (i__37023__auto___38927 + (1));
i__37023__auto___38927 = G__38928;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37267(s__37268){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37268__$1 = s__37268;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37268__$1);
if(temp__4657__auto__){
var s__37268__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37268__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37268__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37270 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37269 = (0);
while(true){
if((i__37269 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37269);
cljs.core.chunk_append.call(null,b__37270,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38929 = (i__37269 + (1));
i__37269 = G__38929;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37270),thinktopic$aljabr$core$iter__37267.call(null,cljs.core.chunk_rest.call(null,s__37268__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37270),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37268__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37267.call(null,cljs.core.rest.call(null,s__37268__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38930 = length__37027__auto__;
var i__37023__auto___38931 = (0);
while(true){
if((i__37023__auto___38931 < n__19308__auto___38930)){
(cloned_ary__37042__auto__[i__37023__auto___38931] = (self__._data[i__37023__auto___38931]));

var G__38932 = (i__37023__auto___38931 + (1));
i__37023__auto___38931 = G__38932;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint16";

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint16");
});

thinktopic.aljabr.core.__GT_NDArray1uint16 = (function thinktopic$aljabr$core$__GT_NDArray1uint16(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint16(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint16 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint16(data__37025__auto__,o__37045__auto__,p__37271,p__37272){
var vec__37275 = p__37271;
var _stride0 = cljs.core.nth.call(null,vec__37275,(0),null);
var vec__37276 = p__37272;
var _shape0 = cljs.core.nth.call(null,vec__37276,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint16(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint16', thinktopic.aljabr.core.make_raw_ndarray1_uint16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint16","uint16",-588869202)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37284(s__37285){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37285__$1 = s__37285;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37285__$1);
if(temp__4657__auto__){
var s__37285__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37285__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37285__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37287 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37286 = (0);
while(true){
if((i__37286 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37286);
cljs.core.chunk_append.call(null,b__37287,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38933 = (i__37286 + (1));
i__37286 = G__38933;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37287),thinktopic$aljabr$core$iter__37284.call(null,cljs.core.chunk_rest.call(null,s__37285__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37287),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37285__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37284.call(null,cljs.core.rest.call(null,s__37285__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37281 = self__._offset;
var vec__37288 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37281 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37281], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37281], null));
var a0 = cljs.core.nth.call(null,vec__37288,(0),null);
var b0 = cljs.core.nth.call(null,vec__37288,(1),null);
var G__37281__$1 = cljs.core.nth.call(null,vec__37288,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,G__37281__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37280){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37280__$1 = (G__37280 | (0));
var G__37277 = (G__37280__$1 - self__._offset);
var a0 = ((G__37277 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37279){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37277_38934 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37277_38934] = G__37279.call(null,p0,(self__._data[G__37277_38934])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37277){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37277);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37277 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37278 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,self__._offset,G__37277.call(null,p0__$1),G__37278.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37281 = self__._offset;
var G__37277 = cljs.core.PersistentVector.EMPTY;
var G__37278 = cljs.core.PersistentVector.EMPTY;
var vec__37289 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37277,G__37278,(G__37281 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37277,self__._shape0),cljs.core.conj.call(null,G__37278,self__._stride0),G__37281], null));
var G__37277__$1 = cljs.core.nth.call(null,vec__37289,(0),null);
var G__37278__$1 = cljs.core.nth.call(null,vec__37289,(1),null);
var G__37281__$1 = cljs.core.nth.call(null,vec__37289,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37277__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37281__$1,G__37278__$1,G__37277__$1);
} else {
return (self__._data[(G__37281__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37290 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37290,(0),null);
var b0 = cljs.core.nth.call(null,vec__37290,(1),null);
var G__37281 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,G__37281,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37279){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37277_38935 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37277_38935] = G__37279.call(null,p0,(self__._data[G__37277_38935])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37277){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37277);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37277){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37277);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37277,G__37279){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37277] = G__37279.call(null,G__37277,(self__._data[(G__37277 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37291(s__37292){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37292__$1 = s__37292;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37292__$1);
if(temp__4657__auto__){
var s__37292__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37292__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37292__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37294 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37293 = (0);
while(true){
if((i__37293 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37293);
cljs.core.chunk_append.call(null,b__37294,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38936 = (i__37293 + (1));
i__37293 = G__38936;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37294),thinktopic$aljabr$core$iter__37291.call(null,cljs.core.chunk_rest.call(null,s__37292__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37294),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37292__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37291.call(null,cljs.core.rest.call(null,s__37292__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint32.call(null,self__._shape0);
var vec__37295 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37295,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1uint32(buf__37021__auto__,(0),a0,self__._shape0));
var G__37277_38937 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37278_38938 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37277_38937)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37278_38938) | (0))] = (self__._data[(cljs.core.first.call(null,G__37277_38937) | (0))]));

var G__38939 = cljs.core.next.call(null,G__37277_38937);
var G__38940 = cljs.core.next.call(null,G__37278_38938);
G__37277_38937 = G__38939;
G__37278_38938 = G__38940;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38941 = length__37027__auto__;
var i__37023__auto___38942 = (0);
while(true){
if((i__37023__auto___38942 < n__19308__auto___38941)){
(r__37028__auto__[i__37023__auto___38942] = 0.0);

var G__38943 = (i__37023__auto___38942 + (1));
i__37023__auto___38942 = G__38943;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38944 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38945 = (0);
while(true){
if((i__37023__auto___38945 < n__19308__auto___38944)){
(r__37028__auto__[i__37023__auto___38945] = 0.0);

var G__38946 = (i__37023__auto___38945 + (1));
i__37023__auto___38945 = G__38946;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37296(s__37297){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37297__$1 = s__37297;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37297__$1);
if(temp__4657__auto__){
var s__37297__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37297__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37297__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37299 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37298 = (0);
while(true){
if((i__37298 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37298);
cljs.core.chunk_append.call(null,b__37299,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38947 = (i__37298 + (1));
i__37298 = G__38947;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37299),thinktopic$aljabr$core$iter__37296.call(null,cljs.core.chunk_rest.call(null,s__37297__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37299),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37297__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37296.call(null,cljs.core.rest.call(null,s__37297__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38948 = length__37027__auto__;
var i__37023__auto___38949 = (0);
while(true){
if((i__37023__auto___38949 < n__19308__auto___38948)){
(cloned_ary__37042__auto__[i__37023__auto___38949] = (self__._data[i__37023__auto___38949]));

var G__38950 = (i__37023__auto___38949 + (1));
i__37023__auto___38949 = G__38950;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint32";

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint32");
});

thinktopic.aljabr.core.__GT_NDArray1uint32 = (function thinktopic$aljabr$core$__GT_NDArray1uint32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint32 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint32(data__37025__auto__,o__37045__auto__,p__37300,p__37301){
var vec__37304 = p__37300;
var _stride0 = cljs.core.nth.call(null,vec__37304,(0),null);
var vec__37305 = p__37301;
var _shape0 = cljs.core.nth.call(null,vec__37305,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint32(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint32', thinktopic.aljabr.core.make_raw_ndarray1_uint32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint32","uint32",-418789486)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int8 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37313(s__37314){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37314__$1 = s__37314;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37314__$1);
if(temp__4657__auto__){
var s__37314__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37314__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37314__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37316 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37315 = (0);
while(true){
if((i__37315 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37315);
cljs.core.chunk_append.call(null,b__37316,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38951 = (i__37315 + (1));
i__37315 = G__38951;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37316),thinktopic$aljabr$core$iter__37313.call(null,cljs.core.chunk_rest.call(null,s__37314__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37316),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37314__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37313.call(null,cljs.core.rest.call(null,s__37314__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37310 = self__._offset;
var vec__37317 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37310 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37310], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37310], null));
var a0 = cljs.core.nth.call(null,vec__37317,(0),null);
var b0 = cljs.core.nth.call(null,vec__37317,(1),null);
var G__37310__$1 = cljs.core.nth.call(null,vec__37317,(2),null);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,G__37310__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37309){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37309__$1 = (G__37309 | (0));
var G__37306 = (G__37309__$1 - self__._offset);
var a0 = ((G__37306 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37308){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37306_38952 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37306_38952] = G__37308.call(null,p0,(self__._data[G__37306_38952])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37306){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37306);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37306 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37307 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,self__._offset,G__37306.call(null,p0__$1),G__37307.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37310 = self__._offset;
var G__37306 = cljs.core.PersistentVector.EMPTY;
var G__37307 = cljs.core.PersistentVector.EMPTY;
var vec__37318 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37306,G__37307,(G__37310 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37306,self__._shape0),cljs.core.conj.call(null,G__37307,self__._stride0),G__37310], null));
var G__37306__$1 = cljs.core.nth.call(null,vec__37318,(0),null);
var G__37307__$1 = cljs.core.nth.call(null,vec__37318,(1),null);
var G__37310__$1 = cljs.core.nth.call(null,vec__37318,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37306__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37310__$1,G__37307__$1,G__37306__$1);
} else {
return (self__._data[(G__37310__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37319 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37319,(0),null);
var b0 = cljs.core.nth.call(null,vec__37319,(1),null);
var G__37310 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,G__37310,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37308){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37306_38953 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37306_38953] = G__37308.call(null,p0,(self__._data[G__37306_38953])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37306){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37306);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37306){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37306);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37306,G__37308){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37306] = G__37308.call(null,G__37306,(self__._data[(G__37306 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37320(s__37321){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37321__$1 = s__37321;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37321__$1);
if(temp__4657__auto__){
var s__37321__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37321__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37321__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37323 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37322 = (0);
while(true){
if((i__37322 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37322);
cljs.core.chunk_append.call(null,b__37323,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38954 = (i__37322 + (1));
i__37322 = G__38954;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37323),thinktopic$aljabr$core$iter__37320.call(null,cljs.core.chunk_rest.call(null,s__37321__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37323),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37321__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37320.call(null,cljs.core.rest.call(null,s__37321__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int8.call(null,self__._shape0);
var vec__37324 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37324,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1int8(buf__37021__auto__,(0),a0,self__._shape0));
var G__37306_38955 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37307_38956 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37306_38955)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37307_38956) | (0))] = (self__._data[(cljs.core.first.call(null,G__37306_38955) | (0))]));

var G__38957 = cljs.core.next.call(null,G__37306_38955);
var G__38958 = cljs.core.next.call(null,G__37307_38956);
G__37306_38955 = G__38957;
G__37307_38956 = G__38958;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38959 = length__37027__auto__;
var i__37023__auto___38960 = (0);
while(true){
if((i__37023__auto___38960 < n__19308__auto___38959)){
(r__37028__auto__[i__37023__auto___38960] = 0.0);

var G__38961 = (i__37023__auto___38960 + (1));
i__37023__auto___38960 = G__38961;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38962 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38963 = (0);
while(true){
if((i__37023__auto___38963 < n__19308__auto___38962)){
(r__37028__auto__[i__37023__auto___38963] = 0.0);

var G__38964 = (i__37023__auto___38963 + (1));
i__37023__auto___38963 = G__38964;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37325(s__37326){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37326__$1 = s__37326;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37326__$1);
if(temp__4657__auto__){
var s__37326__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37326__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37326__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37328 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37327 = (0);
while(true){
if((i__37327 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37327);
cljs.core.chunk_append.call(null,b__37328,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38965 = (i__37327 + (1));
i__37327 = G__38965;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37328),thinktopic$aljabr$core$iter__37325.call(null,cljs.core.chunk_rest.call(null,s__37326__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37328),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37326__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37325.call(null,cljs.core.rest.call(null,s__37326__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38966 = length__37027__auto__;
var i__37023__auto___38967 = (0);
while(true){
if((i__37023__auto___38967 < n__19308__auto___38966)){
(cloned_ary__37042__auto__[i__37023__auto___38967] = (self__._data[i__37023__auto___38967]));

var G__38968 = (i__37023__auto___38967 + (1));
i__37023__auto___38967 = G__38968;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int8";

thinktopic.aljabr.core.NDArray1int8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int8");
});

thinktopic.aljabr.core.__GT_NDArray1int8 = (function thinktopic$aljabr$core$__GT_NDArray1int8(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int8(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int8 = (function thinktopic$aljabr$core$make_raw_ndarray1_int8(data__37025__auto__,o__37045__auto__,p__37329,p__37330){
var vec__37333 = p__37329;
var _stride0 = cljs.core.nth.call(null,vec__37333,(0),null);
var vec__37334 = p__37330;
var _shape0 = cljs.core.nth.call(null,vec__37334,(0),null);
return (new thinktopic.aljabr.core.NDArray1int8(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int8', thinktopic.aljabr.core.make_raw_ndarray1_int8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int8","int8",-1834023920)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int16 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37342(s__37343){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37343__$1 = s__37343;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37343__$1);
if(temp__4657__auto__){
var s__37343__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37343__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37343__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37345 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37344 = (0);
while(true){
if((i__37344 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37344);
cljs.core.chunk_append.call(null,b__37345,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38969 = (i__37344 + (1));
i__37344 = G__38969;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37345),thinktopic$aljabr$core$iter__37342.call(null,cljs.core.chunk_rest.call(null,s__37343__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37345),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37343__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37342.call(null,cljs.core.rest.call(null,s__37343__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37339 = self__._offset;
var vec__37346 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37339 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37339], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37339], null));
var a0 = cljs.core.nth.call(null,vec__37346,(0),null);
var b0 = cljs.core.nth.call(null,vec__37346,(1),null);
var G__37339__$1 = cljs.core.nth.call(null,vec__37346,(2),null);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,G__37339__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37338){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37338__$1 = (G__37338 | (0));
var G__37335 = (G__37338__$1 - self__._offset);
var a0 = ((G__37335 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37337){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37335_38970 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37335_38970] = G__37337.call(null,p0,(self__._data[G__37335_38970])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37335){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37335);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37335 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37336 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,self__._offset,G__37335.call(null,p0__$1),G__37336.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37339 = self__._offset;
var G__37335 = cljs.core.PersistentVector.EMPTY;
var G__37336 = cljs.core.PersistentVector.EMPTY;
var vec__37347 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37335,G__37336,(G__37339 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37335,self__._shape0),cljs.core.conj.call(null,G__37336,self__._stride0),G__37339], null));
var G__37335__$1 = cljs.core.nth.call(null,vec__37347,(0),null);
var G__37336__$1 = cljs.core.nth.call(null,vec__37347,(1),null);
var G__37339__$1 = cljs.core.nth.call(null,vec__37347,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37335__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37339__$1,G__37336__$1,G__37335__$1);
} else {
return (self__._data[(G__37339__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37348 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37348,(0),null);
var b0 = cljs.core.nth.call(null,vec__37348,(1),null);
var G__37339 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,G__37339,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37337){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37335_38971 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37335_38971] = G__37337.call(null,p0,(self__._data[G__37335_38971])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37335){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37335);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37335){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37335);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37335,G__37337){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37335] = G__37337.call(null,G__37335,(self__._data[(G__37335 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37349(s__37350){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37350__$1 = s__37350;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37350__$1);
if(temp__4657__auto__){
var s__37350__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37350__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37350__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37352 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37351 = (0);
while(true){
if((i__37351 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37351);
cljs.core.chunk_append.call(null,b__37352,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38972 = (i__37351 + (1));
i__37351 = G__38972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37352),thinktopic$aljabr$core$iter__37349.call(null,cljs.core.chunk_rest.call(null,s__37350__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37352),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37350__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37349.call(null,cljs.core.rest.call(null,s__37350__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int16.call(null,self__._shape0);
var vec__37353 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37353,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1int16(buf__37021__auto__,(0),a0,self__._shape0));
var G__37335_38973 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37336_38974 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37335_38973)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37336_38974) | (0))] = (self__._data[(cljs.core.first.call(null,G__37335_38973) | (0))]));

var G__38975 = cljs.core.next.call(null,G__37335_38973);
var G__38976 = cljs.core.next.call(null,G__37336_38974);
G__37335_38973 = G__38975;
G__37336_38974 = G__38976;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38977 = length__37027__auto__;
var i__37023__auto___38978 = (0);
while(true){
if((i__37023__auto___38978 < n__19308__auto___38977)){
(r__37028__auto__[i__37023__auto___38978] = 0.0);

var G__38979 = (i__37023__auto___38978 + (1));
i__37023__auto___38978 = G__38979;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38980 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38981 = (0);
while(true){
if((i__37023__auto___38981 < n__19308__auto___38980)){
(r__37028__auto__[i__37023__auto___38981] = 0.0);

var G__38982 = (i__37023__auto___38981 + (1));
i__37023__auto___38981 = G__38982;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37354(s__37355){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37355__$1 = s__37355;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37355__$1);
if(temp__4657__auto__){
var s__37355__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37355__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37355__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37357 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37356 = (0);
while(true){
if((i__37356 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37356);
cljs.core.chunk_append.call(null,b__37357,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__38983 = (i__37356 + (1));
i__37356 = G__38983;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37357),thinktopic$aljabr$core$iter__37354.call(null,cljs.core.chunk_rest.call(null,s__37355__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37357),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37355__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37354.call(null,cljs.core.rest.call(null,s__37355__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___38984 = length__37027__auto__;
var i__37023__auto___38985 = (0);
while(true){
if((i__37023__auto___38985 < n__19308__auto___38984)){
(cloned_ary__37042__auto__[i__37023__auto___38985] = (self__._data[i__37023__auto___38985]));

var G__38986 = (i__37023__auto___38985 + (1));
i__37023__auto___38985 = G__38986;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int16";

thinktopic.aljabr.core.NDArray1int16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int16");
});

thinktopic.aljabr.core.__GT_NDArray1int16 = (function thinktopic$aljabr$core$__GT_NDArray1int16(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int16(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int16 = (function thinktopic$aljabr$core$make_raw_ndarray1_int16(data__37025__auto__,o__37045__auto__,p__37358,p__37359){
var vec__37362 = p__37358;
var _stride0 = cljs.core.nth.call(null,vec__37362,(0),null);
var vec__37363 = p__37359;
var _shape0 = cljs.core.nth.call(null,vec__37363,(0),null);
return (new thinktopic.aljabr.core.NDArray1int16(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int16', thinktopic.aljabr.core.make_raw_ndarray1_int16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int16","int16",-188764863)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37371(s__37372){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37372__$1 = s__37372;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37372__$1);
if(temp__4657__auto__){
var s__37372__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37372__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37372__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37374 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37373 = (0);
while(true){
if((i__37373 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37373);
cljs.core.chunk_append.call(null,b__37374,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__38987 = (i__37373 + (1));
i__37373 = G__38987;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37374),thinktopic$aljabr$core$iter__37371.call(null,cljs.core.chunk_rest.call(null,s__37372__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37374),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37372__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37371.call(null,cljs.core.rest.call(null,s__37372__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37368 = self__._offset;
var vec__37375 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37368 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37368], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37368], null));
var a0 = cljs.core.nth.call(null,vec__37375,(0),null);
var b0 = cljs.core.nth.call(null,vec__37375,(1),null);
var G__37368__$1 = cljs.core.nth.call(null,vec__37375,(2),null);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,G__37368__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37367){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37367__$1 = (G__37367 | (0));
var G__37364 = (G__37367__$1 - self__._offset);
var a0 = ((G__37364 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37366){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37364_38988 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37364_38988] = G__37366.call(null,p0,(self__._data[G__37364_38988])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37364){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37364);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37364 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37365 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,self__._offset,G__37364.call(null,p0__$1),G__37365.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37368 = self__._offset;
var G__37364 = cljs.core.PersistentVector.EMPTY;
var G__37365 = cljs.core.PersistentVector.EMPTY;
var vec__37376 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37364,G__37365,(G__37368 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37364,self__._shape0),cljs.core.conj.call(null,G__37365,self__._stride0),G__37368], null));
var G__37364__$1 = cljs.core.nth.call(null,vec__37376,(0),null);
var G__37365__$1 = cljs.core.nth.call(null,vec__37376,(1),null);
var G__37368__$1 = cljs.core.nth.call(null,vec__37376,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37364__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37368__$1,G__37365__$1,G__37364__$1);
} else {
return (self__._data[(G__37368__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37377 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37377,(0),null);
var b0 = cljs.core.nth.call(null,vec__37377,(1),null);
var G__37368 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,G__37368,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37366){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37364_38989 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37364_38989] = G__37366.call(null,p0,(self__._data[G__37364_38989])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37364){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37364);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37364){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37364);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37364,G__37366){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37364] = G__37366.call(null,G__37364,(self__._data[(G__37364 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37378(s__37379){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37379__$1 = s__37379;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37379__$1);
if(temp__4657__auto__){
var s__37379__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37379__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37379__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37381 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37380 = (0);
while(true){
if((i__37380 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37380);
cljs.core.chunk_append.call(null,b__37381,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__38990 = (i__37380 + (1));
i__37380 = G__38990;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37381),thinktopic$aljabr$core$iter__37378.call(null,cljs.core.chunk_rest.call(null,s__37379__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37381),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37379__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37378.call(null,cljs.core.rest.call(null,s__37379__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int32.call(null,self__._shape0);
var vec__37382 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37382,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1int32(buf__37021__auto__,(0),a0,self__._shape0));
var G__37364_38991 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37365_38992 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37364_38991)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37365_38992) | (0))] = (self__._data[(cljs.core.first.call(null,G__37364_38991) | (0))]));

var G__38993 = cljs.core.next.call(null,G__37364_38991);
var G__38994 = cljs.core.next.call(null,G__37365_38992);
G__37364_38991 = G__38993;
G__37365_38992 = G__38994;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___38995 = length__37027__auto__;
var i__37023__auto___38996 = (0);
while(true){
if((i__37023__auto___38996 < n__19308__auto___38995)){
(r__37028__auto__[i__37023__auto___38996] = 0.0);

var G__38997 = (i__37023__auto___38996 + (1));
i__37023__auto___38996 = G__38997;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___38998 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___38999 = (0);
while(true){
if((i__37023__auto___38999 < n__19308__auto___38998)){
(r__37028__auto__[i__37023__auto___38999] = 0.0);

var G__39000 = (i__37023__auto___38999 + (1));
i__37023__auto___38999 = G__39000;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37383(s__37384){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37384__$1 = s__37384;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37384__$1);
if(temp__4657__auto__){
var s__37384__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37384__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37384__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37386 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37385 = (0);
while(true){
if((i__37385 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37385);
cljs.core.chunk_append.call(null,b__37386,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__39001 = (i__37385 + (1));
i__37385 = G__39001;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37386),thinktopic$aljabr$core$iter__37383.call(null,cljs.core.chunk_rest.call(null,s__37384__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37386),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37384__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37383.call(null,cljs.core.rest.call(null,s__37384__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39002 = length__37027__auto__;
var i__37023__auto___39003 = (0);
while(true){
if((i__37023__auto___39003 < n__19308__auto___39002)){
(cloned_ary__37042__auto__[i__37023__auto___39003] = (self__._data[i__37023__auto___39003]));

var G__39004 = (i__37023__auto___39003 + (1));
i__37023__auto___39003 = G__39004;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int32";

thinktopic.aljabr.core.NDArray1int32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int32");
});

thinktopic.aljabr.core.__GT_NDArray1int32 = (function thinktopic$aljabr$core$__GT_NDArray1int32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int32 = (function thinktopic$aljabr$core$make_raw_ndarray1_int32(data__37025__auto__,o__37045__auto__,p__37387,p__37388){
var vec__37391 = p__37387;
var _stride0 = cljs.core.nth.call(null,vec__37391,(0),null);
var vec__37392 = p__37388;
var _shape0 = cljs.core.nth.call(null,vec__37392,(0),null);
return (new thinktopic.aljabr.core.NDArray1int32(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int32', thinktopic.aljabr.core.make_raw_ndarray1_int32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int32","int32",1718804896)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1float32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37400(s__37401){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37401__$1 = s__37401;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37401__$1);
if(temp__4657__auto__){
var s__37401__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37401__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37401__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37403 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37402 = (0);
while(true){
if((i__37402 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37402);
cljs.core.chunk_append.call(null,b__37403,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__39005 = (i__37402 + (1));
i__37402 = G__39005;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37403),thinktopic$aljabr$core$iter__37400.call(null,cljs.core.chunk_rest.call(null,s__37401__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37403),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37401__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37400.call(null,cljs.core.rest.call(null,s__37401__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37397 = self__._offset;
var vec__37404 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37397 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37397], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37397], null));
var a0 = cljs.core.nth.call(null,vec__37404,(0),null);
var b0 = cljs.core.nth.call(null,vec__37404,(1),null);
var G__37397__$1 = cljs.core.nth.call(null,vec__37404,(2),null);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,G__37397__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37396){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37396__$1 = (G__37396 | (0));
var G__37393 = (G__37396__$1 - self__._offset);
var a0 = ((G__37393 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37395){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37393_39006 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37393_39006] = G__37395.call(null,p0,(self__._data[G__37393_39006])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37393){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37393);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37393 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37394 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,self__._offset,G__37393.call(null,p0__$1),G__37394.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37397 = self__._offset;
var G__37393 = cljs.core.PersistentVector.EMPTY;
var G__37394 = cljs.core.PersistentVector.EMPTY;
var vec__37405 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37393,G__37394,(G__37397 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37393,self__._shape0),cljs.core.conj.call(null,G__37394,self__._stride0),G__37397], null));
var G__37393__$1 = cljs.core.nth.call(null,vec__37405,(0),null);
var G__37394__$1 = cljs.core.nth.call(null,vec__37405,(1),null);
var G__37397__$1 = cljs.core.nth.call(null,vec__37405,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37393__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37397__$1,G__37394__$1,G__37393__$1);
} else {
return (self__._data[(G__37397__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37406 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37406,(0),null);
var b0 = cljs.core.nth.call(null,vec__37406,(1),null);
var G__37397 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,G__37397,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37395){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37393_39007 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37393_39007] = G__37395.call(null,p0,(self__._data[G__37393_39007])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37393){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37393);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37393){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37393);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37393,G__37395){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37393] = G__37395.call(null,G__37393,(self__._data[(G__37393 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37407(s__37408){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37408__$1 = s__37408;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37408__$1);
if(temp__4657__auto__){
var s__37408__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37408__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37408__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37410 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37409 = (0);
while(true){
if((i__37409 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37409);
cljs.core.chunk_append.call(null,b__37410,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__39008 = (i__37409 + (1));
i__37409 = G__39008;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37410),thinktopic$aljabr$core$iter__37407.call(null,cljs.core.chunk_rest.call(null,s__37408__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37410),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37408__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37407.call(null,cljs.core.rest.call(null,s__37408__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.float32.call(null,self__._shape0);
var vec__37411 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37411,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1float32(buf__37021__auto__,(0),a0,self__._shape0));
var G__37393_39009 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37394_39010 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37393_39009)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37394_39010) | (0))] = (self__._data[(cljs.core.first.call(null,G__37393_39009) | (0))]));

var G__39011 = cljs.core.next.call(null,G__37393_39009);
var G__39012 = cljs.core.next.call(null,G__37394_39010);
G__37393_39009 = G__39011;
G__37394_39010 = G__39012;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39013 = length__37027__auto__;
var i__37023__auto___39014 = (0);
while(true){
if((i__37023__auto___39014 < n__19308__auto___39013)){
(r__37028__auto__[i__37023__auto___39014] = 0.0);

var G__39015 = (i__37023__auto___39014 + (1));
i__37023__auto___39014 = G__39015;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39016 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39017 = (0);
while(true){
if((i__37023__auto___39017 < n__19308__auto___39016)){
(r__37028__auto__[i__37023__auto___39017] = 0.0);

var G__39018 = (i__37023__auto___39017 + (1));
i__37023__auto___39017 = G__39018;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1float32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37412(s__37413){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37413__$1 = s__37413;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37413__$1);
if(temp__4657__auto__){
var s__37413__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37413__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37413__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37415 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37414 = (0);
while(true){
if((i__37414 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37414);
cljs.core.chunk_append.call(null,b__37415,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__39019 = (i__37414 + (1));
i__37414 = G__39019;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37415),thinktopic$aljabr$core$iter__37412.call(null,cljs.core.chunk_rest.call(null,s__37413__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37415),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37413__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37412.call(null,cljs.core.rest.call(null,s__37413__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39020 = length__37027__auto__;
var i__37023__auto___39021 = (0);
while(true){
if((i__37023__auto___39021 < n__19308__auto___39020)){
(cloned_ary__37042__auto__[i__37023__auto___39021] = (self__._data[i__37023__auto___39021]));

var G__39022 = (i__37023__auto___39021 + (1));
i__37023__auto___39021 = G__39022;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1float32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1float32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1float32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1float32";

thinktopic.aljabr.core.NDArray1float32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1float32");
});

thinktopic.aljabr.core.__GT_NDArray1float32 = (function thinktopic$aljabr$core$__GT_NDArray1float32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1float32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_float32 = (function thinktopic$aljabr$core$make_raw_ndarray1_float32(data__37025__auto__,o__37045__auto__,p__37416,p__37417){
var vec__37420 = p__37416;
var _stride0 = cljs.core.nth.call(null,vec__37420,(0),null);
var vec__37421 = p__37417;
var _shape0 = cljs.core.nth.call(null,vec__37421,(0),null);
return (new thinktopic.aljabr.core.NDArray1float32(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_float32', thinktopic.aljabr.core.make_raw_ndarray1_float32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"float32","float32",-2119815775)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_float32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1float64 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37429(s__37430){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37430__$1 = s__37430;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37430__$1);
if(temp__4657__auto__){
var s__37430__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37430__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37430__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37432 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37431 = (0);
while(true){
if((i__37431 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37431);
cljs.core.chunk_append.call(null,b__37432,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__39023 = (i__37431 + (1));
i__37431 = G__39023;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37432),thinktopic$aljabr$core$iter__37429.call(null,cljs.core.chunk_rest.call(null,s__37430__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37432),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37430__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__37429.call(null,cljs.core.rest.call(null,s__37430__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37426 = self__._offset;
var vec__37433 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37426 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37426], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37426], null));
var a0 = cljs.core.nth.call(null,vec__37433,(0),null);
var b0 = cljs.core.nth.call(null,vec__37433,(1),null);
var G__37426__$1 = cljs.core.nth.call(null,vec__37433,(2),null);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,G__37426__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37425){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37425__$1 = (G__37425 | (0));
var G__37422 = (G__37425__$1 - self__._offset);
var a0 = ((G__37422 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___37020__auto__,p0,G__37424){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__37422_39024 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37422_39024] = G__37424.call(null,p0,(self__._data[G__37422_39024])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___37020__auto__,p0,G__37422){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37422);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__37422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__37423 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,self__._offset,G__37422.call(null,p0__$1),G__37423.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37426 = self__._offset;
var G__37422 = cljs.core.PersistentVector.EMPTY;
var G__37423 = cljs.core.PersistentVector.EMPTY;
var vec__37434 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37422,G__37423,(G__37426 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37422,self__._shape0),cljs.core.conj.call(null,G__37423,self__._stride0),G__37426], null));
var G__37422__$1 = cljs.core.nth.call(null,vec__37434,(0),null);
var G__37423__$1 = cljs.core.nth.call(null,vec__37434,(1),null);
var G__37426__$1 = cljs.core.nth.call(null,vec__37434,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37422__$1);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37426__$1,G__37423__$1,G__37422__$1);
} else {
return (self__._data[(G__37426__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37435 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37435,(0),null);
var b0 = cljs.core.nth.call(null,vec__37435,(1),null);
var G__37426 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,G__37426,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___37020__auto__,p0,G__37424){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37422_39025 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__37422_39025] = G__37424.call(null,p0,(self__._data[G__37422_39025])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37422){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37422);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___37020__auto__,p0,G__37422){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__37422);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___37020__auto__,p0){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37422,G__37424){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37422] = G__37424.call(null,G__37422,(self__._data[(G__37422 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37436(s__37437){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37437__$1 = s__37437;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37437__$1);
if(temp__4657__auto__){
var s__37437__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37437__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37437__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37439 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37438 = (0);
while(true){
if((i__37438 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37438);
cljs.core.chunk_append.call(null,b__37439,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__39026 = (i__37438 + (1));
i__37438 = G__39026;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37439),thinktopic$aljabr$core$iter__37436.call(null,cljs.core.chunk_rest.call(null,s__37437__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37439),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37437__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__37436.call(null,cljs.core.rest.call(null,s__37437__$2)));
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.float64.call(null,self__._shape0);
var vec__37440 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__37440,(0),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray1float64(buf__37021__auto__,(0),a0,self__._shape0));
var G__37422_39027 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37423_39028 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37422_39027)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37423_39028) | (0))] = (self__._data[(cljs.core.first.call(null,G__37422_39027) | (0))]));

var G__39029 = cljs.core.next.call(null,G__37422_39027);
var G__39030 = cljs.core.next.call(null,G__37423_39028);
G__37422_39027 = G__39029;
G__37423_39028 = G__39030;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39031 = length__37027__auto__;
var i__37023__auto___39032 = (0);
while(true){
if((i__37023__auto___39032 < n__19308__auto___39031)){
(r__37028__auto__[i__37023__auto___39032] = 0.0);

var G__39033 = (i__37023__auto___39032 + (1));
i__37023__auto___39032 = G__39033;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39034 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39035 = (0);
while(true){
if((i__37023__auto___39035 < n__19308__auto___39034)){
(r__37028__auto__[i__37023__auto___39035] = 0.0);

var G__39036 = (i__37023__auto___39035 + (1));
i__37023__auto___39035 = G__39036;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1float64.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37441(s__37442){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37442__$1 = s__37442;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37442__$1);
if(temp__4657__auto__){
var s__37442__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37442__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37442__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37444 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37443 = (0);
while(true){
if((i__37443 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__37443);
cljs.core.chunk_append.call(null,b__37444,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__39037 = (i__37443 + (1));
i__37443 = G__39037;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37444),thinktopic$aljabr$core$iter__37441.call(null,cljs.core.chunk_rest.call(null,s__37442__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37444),null);
}
} else {
var a0 = cljs.core.first.call(null,s__37442__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37441.call(null,cljs.core.rest.call(null,s__37442__$2)));
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39038 = length__37027__auto__;
var i__37023__auto___39039 = (0);
while(true){
if((i__37023__auto___39039 < n__19308__auto___39038)){
(cloned_ary__37042__auto__[i__37023__auto___39039] = (self__._data[i__37023__auto___39039]));

var G__39040 = (i__37023__auto___39039 + (1));
i__37023__auto___39039 = G__39040;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1float64.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1float64.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1float64.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1float64";

thinktopic.aljabr.core.NDArray1float64.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1float64");
});

thinktopic.aljabr.core.__GT_NDArray1float64 = (function thinktopic$aljabr$core$__GT_NDArray1float64(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1float64(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_float64 = (function thinktopic$aljabr$core$make_raw_ndarray1_float64(data__37025__auto__,o__37045__auto__,p__37445,p__37446){
var vec__37449 = p__37445;
var _stride0 = cljs.core.nth.call(null,vec__37449,(0),null);
var vec__37450 = p__37446;
var _shape0 = cljs.core.nth.call(null,vec__37450,(0),null);
return (new thinktopic.aljabr.core.NDArray1float64(data__37025__auto__,o__37045__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_float64', thinktopic.aljabr.core.make_raw_ndarray1_float64);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"float64","float64",1881838306)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_float64,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float64], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2generic = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37458(s__37459){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37459__$1 = s__37459;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37459__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37459__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37458_$_iter__37460(s__37461){
return (new cljs.core.LazySeq(null,((function (s__37459__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37461__$1 = s__37461;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37461__$1);
if(temp__4657__auto____$1){
var s__37461__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37461__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37461__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37463 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37462 = (0);
while(true){
if((i__37462 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37462);
cljs.core.chunk_append.call(null,b__37463,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39041 = (i__37462 + (1));
i__37462 = G__39041;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37463),thinktopic$aljabr$core$iter__37458_$_iter__37460.call(null,cljs.core.chunk_rest.call(null,s__37461__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37463),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37461__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37458_$_iter__37460.call(null,cljs.core.rest.call(null,s__37461__$2)));
}
} else {
return null;
}
break;
}
});})(s__37459__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37459__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37458.call(null,cljs.core.rest.call(null,s__37459__$1)));
} else {
var G__39042 = cljs.core.rest.call(null,s__37459__$1);
s__37459__$1 = G__39042;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37455 = self__._offset;
var vec__37464 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37455 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37455], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37455], null));
var a0 = cljs.core.nth.call(null,vec__37464,(0),null);
var b0 = cljs.core.nth.call(null,vec__37464,(1),null);
var G__37455__$1 = cljs.core.nth.call(null,vec__37464,(2),null);
var vec__37465 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37455__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37455__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37455__$1], null));
var a1 = cljs.core.nth.call(null,vec__37465,(0),null);
var b1 = cljs.core.nth.call(null,vec__37465,(1),null);
var G__37455__$2 = cljs.core.nth.call(null,vec__37465,(2),null);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,G__37455__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37454){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37454__$1 = (G__37454 | (0));
var G__37451 = (G__37454__$1 - self__._offset);
var a0 = ((G__37451 / self__._stride0) | (0));
var G__37451__$1 = (G__37451 - (a0 * self__._stride0));
var a1 = ((G__37451__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37453){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37451_39043 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37451_39043] = G__37453.call(null,p0,p1,(self__._data[G__37451_39043])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37451){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37451);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37451 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37452 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,self__._offset,G__37451.call(null,p0__$1),G__37451.call(null,p1__$1),G__37452.call(null,p0__$1),G__37452.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37455 = self__._offset;
var G__37451 = cljs.core.PersistentVector.EMPTY;
var G__37452 = cljs.core.PersistentVector.EMPTY;
var vec__37466 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37451,G__37452,(G__37455 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37451,self__._shape0),cljs.core.conj.call(null,G__37452,self__._stride0),G__37455], null));
var G__37451__$1 = cljs.core.nth.call(null,vec__37466,(0),null);
var G__37452__$1 = cljs.core.nth.call(null,vec__37466,(1),null);
var G__37455__$1 = cljs.core.nth.call(null,vec__37466,(2),null);
var vec__37467 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37451__$1,G__37452__$1,(G__37455__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37451__$1,self__._shape1),cljs.core.conj.call(null,G__37452__$1,self__._stride1),G__37455__$1], null));
var G__37451__$2 = cljs.core.nth.call(null,vec__37467,(0),null);
var G__37452__$2 = cljs.core.nth.call(null,vec__37467,(1),null);
var G__37455__$2 = cljs.core.nth.call(null,vec__37467,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37451__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37455__$2,G__37452__$2,G__37451__$2);
} else {
return (self__._data[(G__37455__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37468 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37468,(0),null);
var b0 = cljs.core.nth.call(null,vec__37468,(1),null);
var vec__37469 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37469,(0),null);
var b1 = cljs.core.nth.call(null,vec__37469,(1),null);
var G__37455 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,G__37455,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37453){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37451_39044 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37451_39044] = G__37453.call(null,p0,p1,(self__._data[G__37451_39044])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37451){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37451);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37451){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37451);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37451,G__37453){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37451] = G__37453.call(null,G__37451,(self__._data[(G__37451 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37470(s__37471){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37471__$1 = s__37471;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37471__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37471__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37470_$_iter__37472(s__37473){
return (new cljs.core.LazySeq(null,((function (s__37471__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37473__$1 = s__37473;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37473__$1);
if(temp__4657__auto____$1){
var s__37473__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37473__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37473__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37475 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37474 = (0);
while(true){
if((i__37474 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37474);
cljs.core.chunk_append.call(null,b__37475,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39045 = (i__37474 + (1));
i__37474 = G__39045;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37475),thinktopic$aljabr$core$iter__37470_$_iter__37472.call(null,cljs.core.chunk_rest.call(null,s__37473__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37475),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37473__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37470_$_iter__37472.call(null,cljs.core.rest.call(null,s__37473__$2)));
}
} else {
return null;
}
break;
}
});})(s__37471__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37471__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37470.call(null,cljs.core.rest.call(null,s__37471__$1)));
} else {
var G__39046 = cljs.core.rest.call(null,s__37471__$1);
s__37471__$1 = G__39046;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = cljs.core.to_array.call(null,(self__._shape0 * self__._shape1));
var vec__37476 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37476,(0),null);
var a1 = cljs.core.nth.call(null,vec__37476,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2generic(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37451_39047 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37452_39048 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37451_39047)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37452_39048) | (0))] = (self__._data[(cljs.core.first.call(null,G__37451_39047) | (0))]));

var G__39049 = cljs.core.next.call(null,G__37451_39047);
var G__39050 = cljs.core.next.call(null,G__37452_39048);
G__37451_39047 = G__39049;
G__37452_39048 = G__39050;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39051 = length__37027__auto__;
var i__37023__auto___39052 = (0);
while(true){
if((i__37023__auto___39052 < n__19308__auto___39051)){
(r__37028__auto__[i__37023__auto___39052] = 0.0);

var G__39053 = (i__37023__auto___39052 + (1));
i__37023__auto___39052 = G__39053;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39054 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39055 = (0);
while(true){
if((i__37023__auto___39055 < n__19308__auto___39054)){
(r__37028__auto__[i__37023__auto___39055] = 0.0);

var G__39056 = (i__37023__auto___39055 + (1));
i__37023__auto___39055 = G__39056;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37477(s__37478){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37478__$1 = s__37478;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37478__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37478__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37477_$_iter__37479(s__37480){
return (new cljs.core.LazySeq(null,((function (s__37478__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37480__$1 = s__37480;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37480__$1);
if(temp__4657__auto____$1){
var s__37480__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37480__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37480__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37482 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37481 = (0);
while(true){
if((i__37481 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37481);
cljs.core.chunk_append.call(null,b__37482,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39057 = (i__37481 + (1));
i__37481 = G__39057;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37482),thinktopic$aljabr$core$iter__37477_$_iter__37479.call(null,cljs.core.chunk_rest.call(null,s__37480__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37482),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37480__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37477_$_iter__37479.call(null,cljs.core.rest.call(null,s__37480__$2)));
}
} else {
return null;
}
break;
}
});})(s__37478__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37478__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37477.call(null,cljs.core.rest.call(null,s__37478__$1)));
} else {
var G__39058 = cljs.core.rest.call(null,s__37478__$1);
s__37478__$1 = G__39058;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39059 = length__37027__auto__;
var i__37023__auto___39060 = (0);
while(true){
if((i__37023__auto___39060 < n__19308__auto___39059)){
(cloned_ary__37042__auto__[i__37023__auto___39060] = (self__._data[i__37023__auto___39060]));

var G__39061 = (i__37023__auto___39060 + (1));
i__37023__auto___39060 = G__39061;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2generic";

thinktopic.aljabr.core.NDArray2generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2generic");
});

thinktopic.aljabr.core.__GT_NDArray2generic = (function thinktopic$aljabr$core$__GT_NDArray2generic(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2generic(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_generic = (function thinktopic$aljabr$core$make_raw_ndarray2_generic(data__37025__auto__,o__37045__auto__,p__37483,p__37484){
var vec__37487 = p__37483;
var _stride0 = cljs.core.nth.call(null,vec__37487,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37487,(1),null);
var vec__37488 = p__37484;
var _shape0 = cljs.core.nth.call(null,vec__37488,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37488,(1),null);
return (new thinktopic.aljabr.core.NDArray2generic(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_generic', thinktopic.aljabr.core.make_raw_ndarray2_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint8 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37496(s__37497){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37497__$1 = s__37497;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37497__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37497__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37496_$_iter__37498(s__37499){
return (new cljs.core.LazySeq(null,((function (s__37497__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37499__$1 = s__37499;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37499__$1);
if(temp__4657__auto____$1){
var s__37499__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37499__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37499__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37501 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37500 = (0);
while(true){
if((i__37500 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37500);
cljs.core.chunk_append.call(null,b__37501,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39062 = (i__37500 + (1));
i__37500 = G__39062;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37501),thinktopic$aljabr$core$iter__37496_$_iter__37498.call(null,cljs.core.chunk_rest.call(null,s__37499__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37501),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37499__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37496_$_iter__37498.call(null,cljs.core.rest.call(null,s__37499__$2)));
}
} else {
return null;
}
break;
}
});})(s__37497__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37497__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37496.call(null,cljs.core.rest.call(null,s__37497__$1)));
} else {
var G__39063 = cljs.core.rest.call(null,s__37497__$1);
s__37497__$1 = G__39063;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37493 = self__._offset;
var vec__37502 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37493 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37493], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37493], null));
var a0 = cljs.core.nth.call(null,vec__37502,(0),null);
var b0 = cljs.core.nth.call(null,vec__37502,(1),null);
var G__37493__$1 = cljs.core.nth.call(null,vec__37502,(2),null);
var vec__37503 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37493__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37493__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37493__$1], null));
var a1 = cljs.core.nth.call(null,vec__37503,(0),null);
var b1 = cljs.core.nth.call(null,vec__37503,(1),null);
var G__37493__$2 = cljs.core.nth.call(null,vec__37503,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,G__37493__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37492){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37492__$1 = (G__37492 | (0));
var G__37489 = (G__37492__$1 - self__._offset);
var a0 = ((G__37489 / self__._stride0) | (0));
var G__37489__$1 = (G__37489 - (a0 * self__._stride0));
var a1 = ((G__37489__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37491){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37489_39064 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37489_39064] = G__37491.call(null,p0,p1,(self__._data[G__37489_39064])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37489){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37489);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37489 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37490 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,self__._offset,G__37489.call(null,p0__$1),G__37489.call(null,p1__$1),G__37490.call(null,p0__$1),G__37490.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37493 = self__._offset;
var G__37489 = cljs.core.PersistentVector.EMPTY;
var G__37490 = cljs.core.PersistentVector.EMPTY;
var vec__37504 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37489,G__37490,(G__37493 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37489,self__._shape0),cljs.core.conj.call(null,G__37490,self__._stride0),G__37493], null));
var G__37489__$1 = cljs.core.nth.call(null,vec__37504,(0),null);
var G__37490__$1 = cljs.core.nth.call(null,vec__37504,(1),null);
var G__37493__$1 = cljs.core.nth.call(null,vec__37504,(2),null);
var vec__37505 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37489__$1,G__37490__$1,(G__37493__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37489__$1,self__._shape1),cljs.core.conj.call(null,G__37490__$1,self__._stride1),G__37493__$1], null));
var G__37489__$2 = cljs.core.nth.call(null,vec__37505,(0),null);
var G__37490__$2 = cljs.core.nth.call(null,vec__37505,(1),null);
var G__37493__$2 = cljs.core.nth.call(null,vec__37505,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37489__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37493__$2,G__37490__$2,G__37489__$2);
} else {
return (self__._data[(G__37493__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37506 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37506,(0),null);
var b0 = cljs.core.nth.call(null,vec__37506,(1),null);
var vec__37507 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37507,(0),null);
var b1 = cljs.core.nth.call(null,vec__37507,(1),null);
var G__37493 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,G__37493,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37491){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37489_39065 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37489_39065] = G__37491.call(null,p0,p1,(self__._data[G__37489_39065])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37489){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37489);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37489){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37489);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37489,G__37491){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37489] = G__37491.call(null,G__37489,(self__._data[(G__37489 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37508(s__37509){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37509__$1 = s__37509;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37509__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37509__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37508_$_iter__37510(s__37511){
return (new cljs.core.LazySeq(null,((function (s__37509__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37511__$1 = s__37511;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37511__$1);
if(temp__4657__auto____$1){
var s__37511__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37511__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37511__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37513 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37512 = (0);
while(true){
if((i__37512 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37512);
cljs.core.chunk_append.call(null,b__37513,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39066 = (i__37512 + (1));
i__37512 = G__39066;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37513),thinktopic$aljabr$core$iter__37508_$_iter__37510.call(null,cljs.core.chunk_rest.call(null,s__37511__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37513),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37511__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37508_$_iter__37510.call(null,cljs.core.rest.call(null,s__37511__$2)));
}
} else {
return null;
}
break;
}
});})(s__37509__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37509__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37508.call(null,cljs.core.rest.call(null,s__37509__$1)));
} else {
var G__39067 = cljs.core.rest.call(null,s__37509__$1);
s__37509__$1 = G__39067;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint8.call(null,(self__._shape0 * self__._shape1));
var vec__37514 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37514,(0),null);
var a1 = cljs.core.nth.call(null,vec__37514,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2uint8(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37489_39068 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37490_39069 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37489_39068)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37490_39069) | (0))] = (self__._data[(cljs.core.first.call(null,G__37489_39068) | (0))]));

var G__39070 = cljs.core.next.call(null,G__37489_39068);
var G__39071 = cljs.core.next.call(null,G__37490_39069);
G__37489_39068 = G__39070;
G__37490_39069 = G__39071;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39072 = length__37027__auto__;
var i__37023__auto___39073 = (0);
while(true){
if((i__37023__auto___39073 < n__19308__auto___39072)){
(r__37028__auto__[i__37023__auto___39073] = 0.0);

var G__39074 = (i__37023__auto___39073 + (1));
i__37023__auto___39073 = G__39074;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39075 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39076 = (0);
while(true){
if((i__37023__auto___39076 < n__19308__auto___39075)){
(r__37028__auto__[i__37023__auto___39076] = 0.0);

var G__39077 = (i__37023__auto___39076 + (1));
i__37023__auto___39076 = G__39077;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37515(s__37516){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37516__$1 = s__37516;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37516__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37516__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37515_$_iter__37517(s__37518){
return (new cljs.core.LazySeq(null,((function (s__37516__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37518__$1 = s__37518;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37518__$1);
if(temp__4657__auto____$1){
var s__37518__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37518__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37518__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37520 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37519 = (0);
while(true){
if((i__37519 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37519);
cljs.core.chunk_append.call(null,b__37520,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39078 = (i__37519 + (1));
i__37519 = G__39078;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37520),thinktopic$aljabr$core$iter__37515_$_iter__37517.call(null,cljs.core.chunk_rest.call(null,s__37518__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37520),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37518__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37515_$_iter__37517.call(null,cljs.core.rest.call(null,s__37518__$2)));
}
} else {
return null;
}
break;
}
});})(s__37516__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37516__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37515.call(null,cljs.core.rest.call(null,s__37516__$1)));
} else {
var G__39079 = cljs.core.rest.call(null,s__37516__$1);
s__37516__$1 = G__39079;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39080 = length__37027__auto__;
var i__37023__auto___39081 = (0);
while(true){
if((i__37023__auto___39081 < n__19308__auto___39080)){
(cloned_ary__37042__auto__[i__37023__auto___39081] = (self__._data[i__37023__auto___39081]));

var G__39082 = (i__37023__auto___39081 + (1));
i__37023__auto___39081 = G__39082;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint8";

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint8");
});

thinktopic.aljabr.core.__GT_NDArray2uint8 = (function thinktopic$aljabr$core$__GT_NDArray2uint8(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint8(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint8(data__37025__auto__,o__37045__auto__,p__37521,p__37522){
var vec__37525 = p__37521;
var _stride0 = cljs.core.nth.call(null,vec__37525,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37525,(1),null);
var vec__37526 = p__37522;
var _shape0 = cljs.core.nth.call(null,vec__37526,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37526,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint8(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint8', thinktopic.aljabr.core.make_raw_ndarray2_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint8_clamped = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37534(s__37535){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37535__$1 = s__37535;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37535__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37535__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37534_$_iter__37536(s__37537){
return (new cljs.core.LazySeq(null,((function (s__37535__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37537__$1 = s__37537;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37537__$1);
if(temp__4657__auto____$1){
var s__37537__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37537__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37537__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37539 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37538 = (0);
while(true){
if((i__37538 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37538);
cljs.core.chunk_append.call(null,b__37539,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39083 = (i__37538 + (1));
i__37538 = G__39083;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37539),thinktopic$aljabr$core$iter__37534_$_iter__37536.call(null,cljs.core.chunk_rest.call(null,s__37537__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37539),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37537__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37534_$_iter__37536.call(null,cljs.core.rest.call(null,s__37537__$2)));
}
} else {
return null;
}
break;
}
});})(s__37535__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37535__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37534.call(null,cljs.core.rest.call(null,s__37535__$1)));
} else {
var G__39084 = cljs.core.rest.call(null,s__37535__$1);
s__37535__$1 = G__39084;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37531 = self__._offset;
var vec__37540 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37531 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37531], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37531], null));
var a0 = cljs.core.nth.call(null,vec__37540,(0),null);
var b0 = cljs.core.nth.call(null,vec__37540,(1),null);
var G__37531__$1 = cljs.core.nth.call(null,vec__37540,(2),null);
var vec__37541 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37531__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37531__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37531__$1], null));
var a1 = cljs.core.nth.call(null,vec__37541,(0),null);
var b1 = cljs.core.nth.call(null,vec__37541,(1),null);
var G__37531__$2 = cljs.core.nth.call(null,vec__37541,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,G__37531__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37530){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37530__$1 = (G__37530 | (0));
var G__37527 = (G__37530__$1 - self__._offset);
var a0 = ((G__37527 / self__._stride0) | (0));
var G__37527__$1 = (G__37527 - (a0 * self__._stride0));
var a1 = ((G__37527__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37529){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37527_39085 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37527_39085] = G__37529.call(null,p0,p1,(self__._data[G__37527_39085])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37527){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37527);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37527 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37528 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,self__._offset,G__37527.call(null,p0__$1),G__37527.call(null,p1__$1),G__37528.call(null,p0__$1),G__37528.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37531 = self__._offset;
var G__37527 = cljs.core.PersistentVector.EMPTY;
var G__37528 = cljs.core.PersistentVector.EMPTY;
var vec__37542 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37527,G__37528,(G__37531 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37527,self__._shape0),cljs.core.conj.call(null,G__37528,self__._stride0),G__37531], null));
var G__37527__$1 = cljs.core.nth.call(null,vec__37542,(0),null);
var G__37528__$1 = cljs.core.nth.call(null,vec__37542,(1),null);
var G__37531__$1 = cljs.core.nth.call(null,vec__37542,(2),null);
var vec__37543 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37527__$1,G__37528__$1,(G__37531__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37527__$1,self__._shape1),cljs.core.conj.call(null,G__37528__$1,self__._stride1),G__37531__$1], null));
var G__37527__$2 = cljs.core.nth.call(null,vec__37543,(0),null);
var G__37528__$2 = cljs.core.nth.call(null,vec__37543,(1),null);
var G__37531__$2 = cljs.core.nth.call(null,vec__37543,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37527__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37531__$2,G__37528__$2,G__37527__$2);
} else {
return (self__._data[(G__37531__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37544 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37544,(0),null);
var b0 = cljs.core.nth.call(null,vec__37544,(1),null);
var vec__37545 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37545,(0),null);
var b1 = cljs.core.nth.call(null,vec__37545,(1),null);
var G__37531 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,G__37531,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37529){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37527_39086 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37527_39086] = G__37529.call(null,p0,p1,(self__._data[G__37527_39086])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37527){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37527);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37527){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37527);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37527,G__37529){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37527] = G__37529.call(null,G__37527,(self__._data[(G__37527 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37546(s__37547){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37547__$1 = s__37547;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37547__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37547__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37546_$_iter__37548(s__37549){
return (new cljs.core.LazySeq(null,((function (s__37547__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37549__$1 = s__37549;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37549__$1);
if(temp__4657__auto____$1){
var s__37549__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37549__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37549__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37551 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37550 = (0);
while(true){
if((i__37550 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37550);
cljs.core.chunk_append.call(null,b__37551,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39087 = (i__37550 + (1));
i__37550 = G__39087;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37551),thinktopic$aljabr$core$iter__37546_$_iter__37548.call(null,cljs.core.chunk_rest.call(null,s__37549__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37551),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37549__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37546_$_iter__37548.call(null,cljs.core.rest.call(null,s__37549__$2)));
}
} else {
return null;
}
break;
}
});})(s__37547__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37547__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37546.call(null,cljs.core.rest.call(null,s__37547__$1)));
} else {
var G__39088 = cljs.core.rest.call(null,s__37547__$1);
s__37547__$1 = G__39088;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint8_clamped.call(null,(self__._shape0 * self__._shape1));
var vec__37552 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37552,(0),null);
var a1 = cljs.core.nth.call(null,vec__37552,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2uint8_clamped(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37527_39089 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37528_39090 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37527_39089)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37528_39090) | (0))] = (self__._data[(cljs.core.first.call(null,G__37527_39089) | (0))]));

var G__39091 = cljs.core.next.call(null,G__37527_39089);
var G__39092 = cljs.core.next.call(null,G__37528_39090);
G__37527_39089 = G__39091;
G__37528_39090 = G__39092;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39093 = length__37027__auto__;
var i__37023__auto___39094 = (0);
while(true){
if((i__37023__auto___39094 < n__19308__auto___39093)){
(r__37028__auto__[i__37023__auto___39094] = 0.0);

var G__39095 = (i__37023__auto___39094 + (1));
i__37023__auto___39094 = G__39095;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39096 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39097 = (0);
while(true){
if((i__37023__auto___39097 < n__19308__auto___39096)){
(r__37028__auto__[i__37023__auto___39097] = 0.0);

var G__39098 = (i__37023__auto___39097 + (1));
i__37023__auto___39097 = G__39098;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37553(s__37554){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37554__$1 = s__37554;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37554__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37554__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37553_$_iter__37555(s__37556){
return (new cljs.core.LazySeq(null,((function (s__37554__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37556__$1 = s__37556;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37556__$1);
if(temp__4657__auto____$1){
var s__37556__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37556__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37556__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37558 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37557 = (0);
while(true){
if((i__37557 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37557);
cljs.core.chunk_append.call(null,b__37558,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39099 = (i__37557 + (1));
i__37557 = G__39099;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37558),thinktopic$aljabr$core$iter__37553_$_iter__37555.call(null,cljs.core.chunk_rest.call(null,s__37556__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37558),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37556__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37553_$_iter__37555.call(null,cljs.core.rest.call(null,s__37556__$2)));
}
} else {
return null;
}
break;
}
});})(s__37554__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37554__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37553.call(null,cljs.core.rest.call(null,s__37554__$1)));
} else {
var G__39100 = cljs.core.rest.call(null,s__37554__$1);
s__37554__$1 = G__39100;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39101 = length__37027__auto__;
var i__37023__auto___39102 = (0);
while(true){
if((i__37023__auto___39102 < n__19308__auto___39101)){
(cloned_ary__37042__auto__[i__37023__auto___39102] = (self__._data[i__37023__auto___39102]));

var G__39103 = (i__37023__auto___39102 + (1));
i__37023__auto___39102 = G__39103;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint8-clamped";

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint8-clamped");
});

thinktopic.aljabr.core.__GT_NDArray2uint8_clamped = (function thinktopic$aljabr$core$__GT_NDArray2uint8_clamped(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped = (function thinktopic$aljabr$core$make_raw_ndarray2_uint8_clamped(data__37025__auto__,o__37045__auto__,p__37559,p__37560){
var vec__37563 = p__37559;
var _stride0 = cljs.core.nth.call(null,vec__37563,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37563,(1),null);
var vec__37564 = p__37560;
var _shape0 = cljs.core.nth.call(null,vec__37564,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37564,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped', thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8_clamped], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint16 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37572(s__37573){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37573__$1 = s__37573;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37573__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37573__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37572_$_iter__37574(s__37575){
return (new cljs.core.LazySeq(null,((function (s__37573__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37575__$1 = s__37575;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37575__$1);
if(temp__4657__auto____$1){
var s__37575__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37575__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37575__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37577 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37576 = (0);
while(true){
if((i__37576 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37576);
cljs.core.chunk_append.call(null,b__37577,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39104 = (i__37576 + (1));
i__37576 = G__39104;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37577),thinktopic$aljabr$core$iter__37572_$_iter__37574.call(null,cljs.core.chunk_rest.call(null,s__37575__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37577),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37575__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37572_$_iter__37574.call(null,cljs.core.rest.call(null,s__37575__$2)));
}
} else {
return null;
}
break;
}
});})(s__37573__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37573__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37572.call(null,cljs.core.rest.call(null,s__37573__$1)));
} else {
var G__39105 = cljs.core.rest.call(null,s__37573__$1);
s__37573__$1 = G__39105;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37569 = self__._offset;
var vec__37578 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37569 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37569], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37569], null));
var a0 = cljs.core.nth.call(null,vec__37578,(0),null);
var b0 = cljs.core.nth.call(null,vec__37578,(1),null);
var G__37569__$1 = cljs.core.nth.call(null,vec__37578,(2),null);
var vec__37579 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37569__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37569__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37569__$1], null));
var a1 = cljs.core.nth.call(null,vec__37579,(0),null);
var b1 = cljs.core.nth.call(null,vec__37579,(1),null);
var G__37569__$2 = cljs.core.nth.call(null,vec__37579,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,G__37569__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37568){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37568__$1 = (G__37568 | (0));
var G__37565 = (G__37568__$1 - self__._offset);
var a0 = ((G__37565 / self__._stride0) | (0));
var G__37565__$1 = (G__37565 - (a0 * self__._stride0));
var a1 = ((G__37565__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37567){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37565_39106 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37565_39106] = G__37567.call(null,p0,p1,(self__._data[G__37565_39106])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37565){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37565);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37565 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37566 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,self__._offset,G__37565.call(null,p0__$1),G__37565.call(null,p1__$1),G__37566.call(null,p0__$1),G__37566.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37569 = self__._offset;
var G__37565 = cljs.core.PersistentVector.EMPTY;
var G__37566 = cljs.core.PersistentVector.EMPTY;
var vec__37580 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37565,G__37566,(G__37569 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37565,self__._shape0),cljs.core.conj.call(null,G__37566,self__._stride0),G__37569], null));
var G__37565__$1 = cljs.core.nth.call(null,vec__37580,(0),null);
var G__37566__$1 = cljs.core.nth.call(null,vec__37580,(1),null);
var G__37569__$1 = cljs.core.nth.call(null,vec__37580,(2),null);
var vec__37581 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37565__$1,G__37566__$1,(G__37569__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37565__$1,self__._shape1),cljs.core.conj.call(null,G__37566__$1,self__._stride1),G__37569__$1], null));
var G__37565__$2 = cljs.core.nth.call(null,vec__37581,(0),null);
var G__37566__$2 = cljs.core.nth.call(null,vec__37581,(1),null);
var G__37569__$2 = cljs.core.nth.call(null,vec__37581,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37565__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37569__$2,G__37566__$2,G__37565__$2);
} else {
return (self__._data[(G__37569__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37582 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37582,(0),null);
var b0 = cljs.core.nth.call(null,vec__37582,(1),null);
var vec__37583 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37583,(0),null);
var b1 = cljs.core.nth.call(null,vec__37583,(1),null);
var G__37569 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,G__37569,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37567){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37565_39107 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37565_39107] = G__37567.call(null,p0,p1,(self__._data[G__37565_39107])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37565){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37565);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37565){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37565);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37565,G__37567){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37565] = G__37567.call(null,G__37565,(self__._data[(G__37565 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37584(s__37585){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37585__$1 = s__37585;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37585__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37585__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37584_$_iter__37586(s__37587){
return (new cljs.core.LazySeq(null,((function (s__37585__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37587__$1 = s__37587;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37587__$1);
if(temp__4657__auto____$1){
var s__37587__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37587__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37587__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37589 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37588 = (0);
while(true){
if((i__37588 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37588);
cljs.core.chunk_append.call(null,b__37589,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39108 = (i__37588 + (1));
i__37588 = G__39108;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37589),thinktopic$aljabr$core$iter__37584_$_iter__37586.call(null,cljs.core.chunk_rest.call(null,s__37587__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37589),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37587__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37584_$_iter__37586.call(null,cljs.core.rest.call(null,s__37587__$2)));
}
} else {
return null;
}
break;
}
});})(s__37585__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37585__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37584.call(null,cljs.core.rest.call(null,s__37585__$1)));
} else {
var G__39109 = cljs.core.rest.call(null,s__37585__$1);
s__37585__$1 = G__39109;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint16.call(null,(self__._shape0 * self__._shape1));
var vec__37590 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37590,(0),null);
var a1 = cljs.core.nth.call(null,vec__37590,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2uint16(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37565_39110 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37566_39111 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37565_39110)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37566_39111) | (0))] = (self__._data[(cljs.core.first.call(null,G__37565_39110) | (0))]));

var G__39112 = cljs.core.next.call(null,G__37565_39110);
var G__39113 = cljs.core.next.call(null,G__37566_39111);
G__37565_39110 = G__39112;
G__37566_39111 = G__39113;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39114 = length__37027__auto__;
var i__37023__auto___39115 = (0);
while(true){
if((i__37023__auto___39115 < n__19308__auto___39114)){
(r__37028__auto__[i__37023__auto___39115] = 0.0);

var G__39116 = (i__37023__auto___39115 + (1));
i__37023__auto___39115 = G__39116;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39117 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39118 = (0);
while(true){
if((i__37023__auto___39118 < n__19308__auto___39117)){
(r__37028__auto__[i__37023__auto___39118] = 0.0);

var G__39119 = (i__37023__auto___39118 + (1));
i__37023__auto___39118 = G__39119;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37591(s__37592){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37592__$1 = s__37592;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37592__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37592__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37591_$_iter__37593(s__37594){
return (new cljs.core.LazySeq(null,((function (s__37592__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37594__$1 = s__37594;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37594__$1);
if(temp__4657__auto____$1){
var s__37594__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37594__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37594__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37596 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37595 = (0);
while(true){
if((i__37595 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37595);
cljs.core.chunk_append.call(null,b__37596,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39120 = (i__37595 + (1));
i__37595 = G__39120;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37596),thinktopic$aljabr$core$iter__37591_$_iter__37593.call(null,cljs.core.chunk_rest.call(null,s__37594__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37596),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37594__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37591_$_iter__37593.call(null,cljs.core.rest.call(null,s__37594__$2)));
}
} else {
return null;
}
break;
}
});})(s__37592__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37592__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37591.call(null,cljs.core.rest.call(null,s__37592__$1)));
} else {
var G__39121 = cljs.core.rest.call(null,s__37592__$1);
s__37592__$1 = G__39121;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39122 = length__37027__auto__;
var i__37023__auto___39123 = (0);
while(true){
if((i__37023__auto___39123 < n__19308__auto___39122)){
(cloned_ary__37042__auto__[i__37023__auto___39123] = (self__._data[i__37023__auto___39123]));

var G__39124 = (i__37023__auto___39123 + (1));
i__37023__auto___39123 = G__39124;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint16";

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint16");
});

thinktopic.aljabr.core.__GT_NDArray2uint16 = (function thinktopic$aljabr$core$__GT_NDArray2uint16(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint16(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint16 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint16(data__37025__auto__,o__37045__auto__,p__37597,p__37598){
var vec__37601 = p__37597;
var _stride0 = cljs.core.nth.call(null,vec__37601,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37601,(1),null);
var vec__37602 = p__37598;
var _shape0 = cljs.core.nth.call(null,vec__37602,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37602,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint16(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint16', thinktopic.aljabr.core.make_raw_ndarray2_uint16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint16","uint16",-588869202)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37610(s__37611){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37611__$1 = s__37611;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37611__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37611__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37610_$_iter__37612(s__37613){
return (new cljs.core.LazySeq(null,((function (s__37611__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37613__$1 = s__37613;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37613__$1);
if(temp__4657__auto____$1){
var s__37613__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37613__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37613__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37615 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37614 = (0);
while(true){
if((i__37614 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37614);
cljs.core.chunk_append.call(null,b__37615,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39125 = (i__37614 + (1));
i__37614 = G__39125;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37615),thinktopic$aljabr$core$iter__37610_$_iter__37612.call(null,cljs.core.chunk_rest.call(null,s__37613__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37615),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37613__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37610_$_iter__37612.call(null,cljs.core.rest.call(null,s__37613__$2)));
}
} else {
return null;
}
break;
}
});})(s__37611__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37611__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37610.call(null,cljs.core.rest.call(null,s__37611__$1)));
} else {
var G__39126 = cljs.core.rest.call(null,s__37611__$1);
s__37611__$1 = G__39126;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37607 = self__._offset;
var vec__37616 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37607 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37607], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37607], null));
var a0 = cljs.core.nth.call(null,vec__37616,(0),null);
var b0 = cljs.core.nth.call(null,vec__37616,(1),null);
var G__37607__$1 = cljs.core.nth.call(null,vec__37616,(2),null);
var vec__37617 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37607__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37607__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37607__$1], null));
var a1 = cljs.core.nth.call(null,vec__37617,(0),null);
var b1 = cljs.core.nth.call(null,vec__37617,(1),null);
var G__37607__$2 = cljs.core.nth.call(null,vec__37617,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,G__37607__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37606){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37606__$1 = (G__37606 | (0));
var G__37603 = (G__37606__$1 - self__._offset);
var a0 = ((G__37603 / self__._stride0) | (0));
var G__37603__$1 = (G__37603 - (a0 * self__._stride0));
var a1 = ((G__37603__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37605){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37603_39127 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37603_39127] = G__37605.call(null,p0,p1,(self__._data[G__37603_39127])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37603){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37603);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37603 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37604 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,self__._offset,G__37603.call(null,p0__$1),G__37603.call(null,p1__$1),G__37604.call(null,p0__$1),G__37604.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37607 = self__._offset;
var G__37603 = cljs.core.PersistentVector.EMPTY;
var G__37604 = cljs.core.PersistentVector.EMPTY;
var vec__37618 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37603,G__37604,(G__37607 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37603,self__._shape0),cljs.core.conj.call(null,G__37604,self__._stride0),G__37607], null));
var G__37603__$1 = cljs.core.nth.call(null,vec__37618,(0),null);
var G__37604__$1 = cljs.core.nth.call(null,vec__37618,(1),null);
var G__37607__$1 = cljs.core.nth.call(null,vec__37618,(2),null);
var vec__37619 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37603__$1,G__37604__$1,(G__37607__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37603__$1,self__._shape1),cljs.core.conj.call(null,G__37604__$1,self__._stride1),G__37607__$1], null));
var G__37603__$2 = cljs.core.nth.call(null,vec__37619,(0),null);
var G__37604__$2 = cljs.core.nth.call(null,vec__37619,(1),null);
var G__37607__$2 = cljs.core.nth.call(null,vec__37619,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37603__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37607__$2,G__37604__$2,G__37603__$2);
} else {
return (self__._data[(G__37607__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37620 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37620,(0),null);
var b0 = cljs.core.nth.call(null,vec__37620,(1),null);
var vec__37621 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37621,(0),null);
var b1 = cljs.core.nth.call(null,vec__37621,(1),null);
var G__37607 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,G__37607,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37605){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37603_39128 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37603_39128] = G__37605.call(null,p0,p1,(self__._data[G__37603_39128])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37603){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37603);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37603){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37603);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37603,G__37605){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37603] = G__37605.call(null,G__37603,(self__._data[(G__37603 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37622(s__37623){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37623__$1 = s__37623;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37623__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37623__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37622_$_iter__37624(s__37625){
return (new cljs.core.LazySeq(null,((function (s__37623__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37625__$1 = s__37625;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37625__$1);
if(temp__4657__auto____$1){
var s__37625__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37625__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37625__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37627 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37626 = (0);
while(true){
if((i__37626 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37626);
cljs.core.chunk_append.call(null,b__37627,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39129 = (i__37626 + (1));
i__37626 = G__39129;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37627),thinktopic$aljabr$core$iter__37622_$_iter__37624.call(null,cljs.core.chunk_rest.call(null,s__37625__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37627),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37625__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37622_$_iter__37624.call(null,cljs.core.rest.call(null,s__37625__$2)));
}
} else {
return null;
}
break;
}
});})(s__37623__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37623__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37622.call(null,cljs.core.rest.call(null,s__37623__$1)));
} else {
var G__39130 = cljs.core.rest.call(null,s__37623__$1);
s__37623__$1 = G__39130;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint32.call(null,(self__._shape0 * self__._shape1));
var vec__37628 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37628,(0),null);
var a1 = cljs.core.nth.call(null,vec__37628,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2uint32(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37603_39131 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37604_39132 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37603_39131)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37604_39132) | (0))] = (self__._data[(cljs.core.first.call(null,G__37603_39131) | (0))]));

var G__39133 = cljs.core.next.call(null,G__37603_39131);
var G__39134 = cljs.core.next.call(null,G__37604_39132);
G__37603_39131 = G__39133;
G__37604_39132 = G__39134;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39135 = length__37027__auto__;
var i__37023__auto___39136 = (0);
while(true){
if((i__37023__auto___39136 < n__19308__auto___39135)){
(r__37028__auto__[i__37023__auto___39136] = 0.0);

var G__39137 = (i__37023__auto___39136 + (1));
i__37023__auto___39136 = G__39137;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39138 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39139 = (0);
while(true){
if((i__37023__auto___39139 < n__19308__auto___39138)){
(r__37028__auto__[i__37023__auto___39139] = 0.0);

var G__39140 = (i__37023__auto___39139 + (1));
i__37023__auto___39139 = G__39140;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37629(s__37630){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37630__$1 = s__37630;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37630__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37630__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37629_$_iter__37631(s__37632){
return (new cljs.core.LazySeq(null,((function (s__37630__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37632__$1 = s__37632;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37632__$1);
if(temp__4657__auto____$1){
var s__37632__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37632__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37632__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37634 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37633 = (0);
while(true){
if((i__37633 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37633);
cljs.core.chunk_append.call(null,b__37634,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39141 = (i__37633 + (1));
i__37633 = G__39141;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37634),thinktopic$aljabr$core$iter__37629_$_iter__37631.call(null,cljs.core.chunk_rest.call(null,s__37632__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37634),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37632__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37629_$_iter__37631.call(null,cljs.core.rest.call(null,s__37632__$2)));
}
} else {
return null;
}
break;
}
});})(s__37630__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37630__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37629.call(null,cljs.core.rest.call(null,s__37630__$1)));
} else {
var G__39142 = cljs.core.rest.call(null,s__37630__$1);
s__37630__$1 = G__39142;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39143 = length__37027__auto__;
var i__37023__auto___39144 = (0);
while(true){
if((i__37023__auto___39144 < n__19308__auto___39143)){
(cloned_ary__37042__auto__[i__37023__auto___39144] = (self__._data[i__37023__auto___39144]));

var G__39145 = (i__37023__auto___39144 + (1));
i__37023__auto___39144 = G__39145;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint32";

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint32");
});

thinktopic.aljabr.core.__GT_NDArray2uint32 = (function thinktopic$aljabr$core$__GT_NDArray2uint32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint32 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint32(data__37025__auto__,o__37045__auto__,p__37635,p__37636){
var vec__37639 = p__37635;
var _stride0 = cljs.core.nth.call(null,vec__37639,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37639,(1),null);
var vec__37640 = p__37636;
var _shape0 = cljs.core.nth.call(null,vec__37640,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37640,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint32(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint32', thinktopic.aljabr.core.make_raw_ndarray2_uint32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint32","uint32",-418789486)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int8 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37648(s__37649){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37649__$1 = s__37649;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37649__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37649__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37648_$_iter__37650(s__37651){
return (new cljs.core.LazySeq(null,((function (s__37649__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37651__$1 = s__37651;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37651__$1);
if(temp__4657__auto____$1){
var s__37651__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37651__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37651__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37653 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37652 = (0);
while(true){
if((i__37652 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37652);
cljs.core.chunk_append.call(null,b__37653,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39146 = (i__37652 + (1));
i__37652 = G__39146;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37653),thinktopic$aljabr$core$iter__37648_$_iter__37650.call(null,cljs.core.chunk_rest.call(null,s__37651__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37653),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37651__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37648_$_iter__37650.call(null,cljs.core.rest.call(null,s__37651__$2)));
}
} else {
return null;
}
break;
}
});})(s__37649__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37649__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37648.call(null,cljs.core.rest.call(null,s__37649__$1)));
} else {
var G__39147 = cljs.core.rest.call(null,s__37649__$1);
s__37649__$1 = G__39147;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37645 = self__._offset;
var vec__37654 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37645 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37645], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37645], null));
var a0 = cljs.core.nth.call(null,vec__37654,(0),null);
var b0 = cljs.core.nth.call(null,vec__37654,(1),null);
var G__37645__$1 = cljs.core.nth.call(null,vec__37654,(2),null);
var vec__37655 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37645__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37645__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37645__$1], null));
var a1 = cljs.core.nth.call(null,vec__37655,(0),null);
var b1 = cljs.core.nth.call(null,vec__37655,(1),null);
var G__37645__$2 = cljs.core.nth.call(null,vec__37655,(2),null);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,G__37645__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37644){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37644__$1 = (G__37644 | (0));
var G__37641 = (G__37644__$1 - self__._offset);
var a0 = ((G__37641 / self__._stride0) | (0));
var G__37641__$1 = (G__37641 - (a0 * self__._stride0));
var a1 = ((G__37641__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37643){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37641_39148 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37641_39148] = G__37643.call(null,p0,p1,(self__._data[G__37641_39148])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37641){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37641);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37641 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37642 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,self__._offset,G__37641.call(null,p0__$1),G__37641.call(null,p1__$1),G__37642.call(null,p0__$1),G__37642.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37645 = self__._offset;
var G__37641 = cljs.core.PersistentVector.EMPTY;
var G__37642 = cljs.core.PersistentVector.EMPTY;
var vec__37656 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37641,G__37642,(G__37645 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37641,self__._shape0),cljs.core.conj.call(null,G__37642,self__._stride0),G__37645], null));
var G__37641__$1 = cljs.core.nth.call(null,vec__37656,(0),null);
var G__37642__$1 = cljs.core.nth.call(null,vec__37656,(1),null);
var G__37645__$1 = cljs.core.nth.call(null,vec__37656,(2),null);
var vec__37657 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37641__$1,G__37642__$1,(G__37645__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37641__$1,self__._shape1),cljs.core.conj.call(null,G__37642__$1,self__._stride1),G__37645__$1], null));
var G__37641__$2 = cljs.core.nth.call(null,vec__37657,(0),null);
var G__37642__$2 = cljs.core.nth.call(null,vec__37657,(1),null);
var G__37645__$2 = cljs.core.nth.call(null,vec__37657,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37641__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37645__$2,G__37642__$2,G__37641__$2);
} else {
return (self__._data[(G__37645__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37658 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37658,(0),null);
var b0 = cljs.core.nth.call(null,vec__37658,(1),null);
var vec__37659 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37659,(0),null);
var b1 = cljs.core.nth.call(null,vec__37659,(1),null);
var G__37645 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,G__37645,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37643){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37641_39149 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37641_39149] = G__37643.call(null,p0,p1,(self__._data[G__37641_39149])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37641){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37641);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37641){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37641);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37641,G__37643){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37641] = G__37643.call(null,G__37641,(self__._data[(G__37641 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37660(s__37661){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37661__$1 = s__37661;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37661__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37661__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37660_$_iter__37662(s__37663){
return (new cljs.core.LazySeq(null,((function (s__37661__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37663__$1 = s__37663;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37663__$1);
if(temp__4657__auto____$1){
var s__37663__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37663__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37663__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37665 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37664 = (0);
while(true){
if((i__37664 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37664);
cljs.core.chunk_append.call(null,b__37665,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39150 = (i__37664 + (1));
i__37664 = G__39150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37665),thinktopic$aljabr$core$iter__37660_$_iter__37662.call(null,cljs.core.chunk_rest.call(null,s__37663__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37665),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37663__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37660_$_iter__37662.call(null,cljs.core.rest.call(null,s__37663__$2)));
}
} else {
return null;
}
break;
}
});})(s__37661__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37661__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37660.call(null,cljs.core.rest.call(null,s__37661__$1)));
} else {
var G__39151 = cljs.core.rest.call(null,s__37661__$1);
s__37661__$1 = G__39151;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int8.call(null,(self__._shape0 * self__._shape1));
var vec__37666 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37666,(0),null);
var a1 = cljs.core.nth.call(null,vec__37666,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2int8(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37641_39152 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37642_39153 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37641_39152)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37642_39153) | (0))] = (self__._data[(cljs.core.first.call(null,G__37641_39152) | (0))]));

var G__39154 = cljs.core.next.call(null,G__37641_39152);
var G__39155 = cljs.core.next.call(null,G__37642_39153);
G__37641_39152 = G__39154;
G__37642_39153 = G__39155;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39156 = length__37027__auto__;
var i__37023__auto___39157 = (0);
while(true){
if((i__37023__auto___39157 < n__19308__auto___39156)){
(r__37028__auto__[i__37023__auto___39157] = 0.0);

var G__39158 = (i__37023__auto___39157 + (1));
i__37023__auto___39157 = G__39158;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39159 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39160 = (0);
while(true){
if((i__37023__auto___39160 < n__19308__auto___39159)){
(r__37028__auto__[i__37023__auto___39160] = 0.0);

var G__39161 = (i__37023__auto___39160 + (1));
i__37023__auto___39160 = G__39161;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37667(s__37668){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37668__$1 = s__37668;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37668__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37668__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37667_$_iter__37669(s__37670){
return (new cljs.core.LazySeq(null,((function (s__37668__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37670__$1 = s__37670;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37670__$1);
if(temp__4657__auto____$1){
var s__37670__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37670__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37670__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37672 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37671 = (0);
while(true){
if((i__37671 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37671);
cljs.core.chunk_append.call(null,b__37672,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39162 = (i__37671 + (1));
i__37671 = G__39162;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37672),thinktopic$aljabr$core$iter__37667_$_iter__37669.call(null,cljs.core.chunk_rest.call(null,s__37670__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37672),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37670__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37667_$_iter__37669.call(null,cljs.core.rest.call(null,s__37670__$2)));
}
} else {
return null;
}
break;
}
});})(s__37668__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37668__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37667.call(null,cljs.core.rest.call(null,s__37668__$1)));
} else {
var G__39163 = cljs.core.rest.call(null,s__37668__$1);
s__37668__$1 = G__39163;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39164 = length__37027__auto__;
var i__37023__auto___39165 = (0);
while(true){
if((i__37023__auto___39165 < n__19308__auto___39164)){
(cloned_ary__37042__auto__[i__37023__auto___39165] = (self__._data[i__37023__auto___39165]));

var G__39166 = (i__37023__auto___39165 + (1));
i__37023__auto___39165 = G__39166;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int8";

thinktopic.aljabr.core.NDArray2int8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int8");
});

thinktopic.aljabr.core.__GT_NDArray2int8 = (function thinktopic$aljabr$core$__GT_NDArray2int8(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int8(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int8 = (function thinktopic$aljabr$core$make_raw_ndarray2_int8(data__37025__auto__,o__37045__auto__,p__37673,p__37674){
var vec__37677 = p__37673;
var _stride0 = cljs.core.nth.call(null,vec__37677,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37677,(1),null);
var vec__37678 = p__37674;
var _shape0 = cljs.core.nth.call(null,vec__37678,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37678,(1),null);
return (new thinktopic.aljabr.core.NDArray2int8(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int8', thinktopic.aljabr.core.make_raw_ndarray2_int8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int8","int8",-1834023920)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int16 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37686(s__37687){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37687__$1 = s__37687;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37687__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37687__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37686_$_iter__37688(s__37689){
return (new cljs.core.LazySeq(null,((function (s__37687__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37689__$1 = s__37689;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37689__$1);
if(temp__4657__auto____$1){
var s__37689__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37689__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37689__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37691 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37690 = (0);
while(true){
if((i__37690 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37690);
cljs.core.chunk_append.call(null,b__37691,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39167 = (i__37690 + (1));
i__37690 = G__39167;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37691),thinktopic$aljabr$core$iter__37686_$_iter__37688.call(null,cljs.core.chunk_rest.call(null,s__37689__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37691),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37689__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37686_$_iter__37688.call(null,cljs.core.rest.call(null,s__37689__$2)));
}
} else {
return null;
}
break;
}
});})(s__37687__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37687__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37686.call(null,cljs.core.rest.call(null,s__37687__$1)));
} else {
var G__39168 = cljs.core.rest.call(null,s__37687__$1);
s__37687__$1 = G__39168;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37683 = self__._offset;
var vec__37692 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37683 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37683], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37683], null));
var a0 = cljs.core.nth.call(null,vec__37692,(0),null);
var b0 = cljs.core.nth.call(null,vec__37692,(1),null);
var G__37683__$1 = cljs.core.nth.call(null,vec__37692,(2),null);
var vec__37693 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37683__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37683__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37683__$1], null));
var a1 = cljs.core.nth.call(null,vec__37693,(0),null);
var b1 = cljs.core.nth.call(null,vec__37693,(1),null);
var G__37683__$2 = cljs.core.nth.call(null,vec__37693,(2),null);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,G__37683__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37682){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37682__$1 = (G__37682 | (0));
var G__37679 = (G__37682__$1 - self__._offset);
var a0 = ((G__37679 / self__._stride0) | (0));
var G__37679__$1 = (G__37679 - (a0 * self__._stride0));
var a1 = ((G__37679__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37681){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37679_39169 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37679_39169] = G__37681.call(null,p0,p1,(self__._data[G__37679_39169])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37679){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37679);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37679 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37680 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,self__._offset,G__37679.call(null,p0__$1),G__37679.call(null,p1__$1),G__37680.call(null,p0__$1),G__37680.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37683 = self__._offset;
var G__37679 = cljs.core.PersistentVector.EMPTY;
var G__37680 = cljs.core.PersistentVector.EMPTY;
var vec__37694 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37679,G__37680,(G__37683 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37679,self__._shape0),cljs.core.conj.call(null,G__37680,self__._stride0),G__37683], null));
var G__37679__$1 = cljs.core.nth.call(null,vec__37694,(0),null);
var G__37680__$1 = cljs.core.nth.call(null,vec__37694,(1),null);
var G__37683__$1 = cljs.core.nth.call(null,vec__37694,(2),null);
var vec__37695 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37679__$1,G__37680__$1,(G__37683__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37679__$1,self__._shape1),cljs.core.conj.call(null,G__37680__$1,self__._stride1),G__37683__$1], null));
var G__37679__$2 = cljs.core.nth.call(null,vec__37695,(0),null);
var G__37680__$2 = cljs.core.nth.call(null,vec__37695,(1),null);
var G__37683__$2 = cljs.core.nth.call(null,vec__37695,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37679__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37683__$2,G__37680__$2,G__37679__$2);
} else {
return (self__._data[(G__37683__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37696 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37696,(0),null);
var b0 = cljs.core.nth.call(null,vec__37696,(1),null);
var vec__37697 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37697,(0),null);
var b1 = cljs.core.nth.call(null,vec__37697,(1),null);
var G__37683 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,G__37683,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37681){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37679_39170 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37679_39170] = G__37681.call(null,p0,p1,(self__._data[G__37679_39170])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37679){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37679);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37679){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37679);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37679,G__37681){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37679] = G__37681.call(null,G__37679,(self__._data[(G__37679 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37698(s__37699){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37699__$1 = s__37699;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37699__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37699__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37698_$_iter__37700(s__37701){
return (new cljs.core.LazySeq(null,((function (s__37699__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37701__$1 = s__37701;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37701__$1);
if(temp__4657__auto____$1){
var s__37701__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37701__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37701__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37703 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37702 = (0);
while(true){
if((i__37702 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37702);
cljs.core.chunk_append.call(null,b__37703,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39171 = (i__37702 + (1));
i__37702 = G__39171;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37703),thinktopic$aljabr$core$iter__37698_$_iter__37700.call(null,cljs.core.chunk_rest.call(null,s__37701__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37703),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37701__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37698_$_iter__37700.call(null,cljs.core.rest.call(null,s__37701__$2)));
}
} else {
return null;
}
break;
}
});})(s__37699__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37699__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37698.call(null,cljs.core.rest.call(null,s__37699__$1)));
} else {
var G__39172 = cljs.core.rest.call(null,s__37699__$1);
s__37699__$1 = G__39172;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int16.call(null,(self__._shape0 * self__._shape1));
var vec__37704 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37704,(0),null);
var a1 = cljs.core.nth.call(null,vec__37704,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2int16(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37679_39173 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37680_39174 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37679_39173)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37680_39174) | (0))] = (self__._data[(cljs.core.first.call(null,G__37679_39173) | (0))]));

var G__39175 = cljs.core.next.call(null,G__37679_39173);
var G__39176 = cljs.core.next.call(null,G__37680_39174);
G__37679_39173 = G__39175;
G__37680_39174 = G__39176;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39177 = length__37027__auto__;
var i__37023__auto___39178 = (0);
while(true){
if((i__37023__auto___39178 < n__19308__auto___39177)){
(r__37028__auto__[i__37023__auto___39178] = 0.0);

var G__39179 = (i__37023__auto___39178 + (1));
i__37023__auto___39178 = G__39179;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39180 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39181 = (0);
while(true){
if((i__37023__auto___39181 < n__19308__auto___39180)){
(r__37028__auto__[i__37023__auto___39181] = 0.0);

var G__39182 = (i__37023__auto___39181 + (1));
i__37023__auto___39181 = G__39182;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37705(s__37706){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37706__$1 = s__37706;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37706__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37706__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37705_$_iter__37707(s__37708){
return (new cljs.core.LazySeq(null,((function (s__37706__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37708__$1 = s__37708;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37708__$1);
if(temp__4657__auto____$1){
var s__37708__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37708__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37708__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37710 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37709 = (0);
while(true){
if((i__37709 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37709);
cljs.core.chunk_append.call(null,b__37710,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39183 = (i__37709 + (1));
i__37709 = G__39183;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37710),thinktopic$aljabr$core$iter__37705_$_iter__37707.call(null,cljs.core.chunk_rest.call(null,s__37708__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37710),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37708__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37705_$_iter__37707.call(null,cljs.core.rest.call(null,s__37708__$2)));
}
} else {
return null;
}
break;
}
});})(s__37706__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37706__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37705.call(null,cljs.core.rest.call(null,s__37706__$1)));
} else {
var G__39184 = cljs.core.rest.call(null,s__37706__$1);
s__37706__$1 = G__39184;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39185 = length__37027__auto__;
var i__37023__auto___39186 = (0);
while(true){
if((i__37023__auto___39186 < n__19308__auto___39185)){
(cloned_ary__37042__auto__[i__37023__auto___39186] = (self__._data[i__37023__auto___39186]));

var G__39187 = (i__37023__auto___39186 + (1));
i__37023__auto___39186 = G__39187;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int16";

thinktopic.aljabr.core.NDArray2int16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int16");
});

thinktopic.aljabr.core.__GT_NDArray2int16 = (function thinktopic$aljabr$core$__GT_NDArray2int16(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int16(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int16 = (function thinktopic$aljabr$core$make_raw_ndarray2_int16(data__37025__auto__,o__37045__auto__,p__37711,p__37712){
var vec__37715 = p__37711;
var _stride0 = cljs.core.nth.call(null,vec__37715,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37715,(1),null);
var vec__37716 = p__37712;
var _shape0 = cljs.core.nth.call(null,vec__37716,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37716,(1),null);
return (new thinktopic.aljabr.core.NDArray2int16(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int16', thinktopic.aljabr.core.make_raw_ndarray2_int16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int16","int16",-188764863)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37724(s__37725){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37725__$1 = s__37725;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37725__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37725__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37724_$_iter__37726(s__37727){
return (new cljs.core.LazySeq(null,((function (s__37725__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37727__$1 = s__37727;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37727__$1);
if(temp__4657__auto____$1){
var s__37727__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37727__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37727__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37729 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37728 = (0);
while(true){
if((i__37728 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37728);
cljs.core.chunk_append.call(null,b__37729,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39188 = (i__37728 + (1));
i__37728 = G__39188;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37729),thinktopic$aljabr$core$iter__37724_$_iter__37726.call(null,cljs.core.chunk_rest.call(null,s__37727__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37729),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37727__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37724_$_iter__37726.call(null,cljs.core.rest.call(null,s__37727__$2)));
}
} else {
return null;
}
break;
}
});})(s__37725__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37725__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37724.call(null,cljs.core.rest.call(null,s__37725__$1)));
} else {
var G__39189 = cljs.core.rest.call(null,s__37725__$1);
s__37725__$1 = G__39189;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37721 = self__._offset;
var vec__37730 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37721 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37721], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37721], null));
var a0 = cljs.core.nth.call(null,vec__37730,(0),null);
var b0 = cljs.core.nth.call(null,vec__37730,(1),null);
var G__37721__$1 = cljs.core.nth.call(null,vec__37730,(2),null);
var vec__37731 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37721__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37721__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37721__$1], null));
var a1 = cljs.core.nth.call(null,vec__37731,(0),null);
var b1 = cljs.core.nth.call(null,vec__37731,(1),null);
var G__37721__$2 = cljs.core.nth.call(null,vec__37731,(2),null);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,G__37721__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37720){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37720__$1 = (G__37720 | (0));
var G__37717 = (G__37720__$1 - self__._offset);
var a0 = ((G__37717 / self__._stride0) | (0));
var G__37717__$1 = (G__37717 - (a0 * self__._stride0));
var a1 = ((G__37717__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37719){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37717_39190 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37717_39190] = G__37719.call(null,p0,p1,(self__._data[G__37717_39190])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37717){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37717);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37717 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37718 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,self__._offset,G__37717.call(null,p0__$1),G__37717.call(null,p1__$1),G__37718.call(null,p0__$1),G__37718.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37721 = self__._offset;
var G__37717 = cljs.core.PersistentVector.EMPTY;
var G__37718 = cljs.core.PersistentVector.EMPTY;
var vec__37732 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37717,G__37718,(G__37721 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37717,self__._shape0),cljs.core.conj.call(null,G__37718,self__._stride0),G__37721], null));
var G__37717__$1 = cljs.core.nth.call(null,vec__37732,(0),null);
var G__37718__$1 = cljs.core.nth.call(null,vec__37732,(1),null);
var G__37721__$1 = cljs.core.nth.call(null,vec__37732,(2),null);
var vec__37733 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37717__$1,G__37718__$1,(G__37721__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37717__$1,self__._shape1),cljs.core.conj.call(null,G__37718__$1,self__._stride1),G__37721__$1], null));
var G__37717__$2 = cljs.core.nth.call(null,vec__37733,(0),null);
var G__37718__$2 = cljs.core.nth.call(null,vec__37733,(1),null);
var G__37721__$2 = cljs.core.nth.call(null,vec__37733,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37717__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37721__$2,G__37718__$2,G__37717__$2);
} else {
return (self__._data[(G__37721__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37734 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37734,(0),null);
var b0 = cljs.core.nth.call(null,vec__37734,(1),null);
var vec__37735 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37735,(0),null);
var b1 = cljs.core.nth.call(null,vec__37735,(1),null);
var G__37721 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,G__37721,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37719){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37717_39191 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37717_39191] = G__37719.call(null,p0,p1,(self__._data[G__37717_39191])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37717){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37717);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37717){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37717);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37717,G__37719){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37717] = G__37719.call(null,G__37717,(self__._data[(G__37717 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37736(s__37737){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37737__$1 = s__37737;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37737__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37737__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37736_$_iter__37738(s__37739){
return (new cljs.core.LazySeq(null,((function (s__37737__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37739__$1 = s__37739;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37739__$1);
if(temp__4657__auto____$1){
var s__37739__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37739__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37739__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37741 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37740 = (0);
while(true){
if((i__37740 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37740);
cljs.core.chunk_append.call(null,b__37741,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39192 = (i__37740 + (1));
i__37740 = G__39192;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37741),thinktopic$aljabr$core$iter__37736_$_iter__37738.call(null,cljs.core.chunk_rest.call(null,s__37739__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37741),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37739__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37736_$_iter__37738.call(null,cljs.core.rest.call(null,s__37739__$2)));
}
} else {
return null;
}
break;
}
});})(s__37737__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37737__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37736.call(null,cljs.core.rest.call(null,s__37737__$1)));
} else {
var G__39193 = cljs.core.rest.call(null,s__37737__$1);
s__37737__$1 = G__39193;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.int32.call(null,(self__._shape0 * self__._shape1));
var vec__37742 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37742,(0),null);
var a1 = cljs.core.nth.call(null,vec__37742,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2int32(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37717_39194 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37718_39195 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37717_39194)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37718_39195) | (0))] = (self__._data[(cljs.core.first.call(null,G__37717_39194) | (0))]));

var G__39196 = cljs.core.next.call(null,G__37717_39194);
var G__39197 = cljs.core.next.call(null,G__37718_39195);
G__37717_39194 = G__39196;
G__37718_39195 = G__39197;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39198 = length__37027__auto__;
var i__37023__auto___39199 = (0);
while(true){
if((i__37023__auto___39199 < n__19308__auto___39198)){
(r__37028__auto__[i__37023__auto___39199] = 0.0);

var G__39200 = (i__37023__auto___39199 + (1));
i__37023__auto___39199 = G__39200;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39201 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39202 = (0);
while(true){
if((i__37023__auto___39202 < n__19308__auto___39201)){
(r__37028__auto__[i__37023__auto___39202] = 0.0);

var G__39203 = (i__37023__auto___39202 + (1));
i__37023__auto___39202 = G__39203;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37743(s__37744){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37744__$1 = s__37744;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37744__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37744__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37743_$_iter__37745(s__37746){
return (new cljs.core.LazySeq(null,((function (s__37744__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37746__$1 = s__37746;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37746__$1);
if(temp__4657__auto____$1){
var s__37746__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37746__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37746__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37748 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37747 = (0);
while(true){
if((i__37747 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37747);
cljs.core.chunk_append.call(null,b__37748,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39204 = (i__37747 + (1));
i__37747 = G__39204;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37748),thinktopic$aljabr$core$iter__37743_$_iter__37745.call(null,cljs.core.chunk_rest.call(null,s__37746__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37748),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37746__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37743_$_iter__37745.call(null,cljs.core.rest.call(null,s__37746__$2)));
}
} else {
return null;
}
break;
}
});})(s__37744__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37744__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37743.call(null,cljs.core.rest.call(null,s__37744__$1)));
} else {
var G__39205 = cljs.core.rest.call(null,s__37744__$1);
s__37744__$1 = G__39205;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39206 = length__37027__auto__;
var i__37023__auto___39207 = (0);
while(true){
if((i__37023__auto___39207 < n__19308__auto___39206)){
(cloned_ary__37042__auto__[i__37023__auto___39207] = (self__._data[i__37023__auto___39207]));

var G__39208 = (i__37023__auto___39207 + (1));
i__37023__auto___39207 = G__39208;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int32";

thinktopic.aljabr.core.NDArray2int32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int32");
});

thinktopic.aljabr.core.__GT_NDArray2int32 = (function thinktopic$aljabr$core$__GT_NDArray2int32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int32 = (function thinktopic$aljabr$core$make_raw_ndarray2_int32(data__37025__auto__,o__37045__auto__,p__37749,p__37750){
var vec__37753 = p__37749;
var _stride0 = cljs.core.nth.call(null,vec__37753,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37753,(1),null);
var vec__37754 = p__37750;
var _shape0 = cljs.core.nth.call(null,vec__37754,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37754,(1),null);
return (new thinktopic.aljabr.core.NDArray2int32(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int32', thinktopic.aljabr.core.make_raw_ndarray2_int32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int32","int32",1718804896)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2float32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37762(s__37763){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37763__$1 = s__37763;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37763__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37763__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37762_$_iter__37764(s__37765){
return (new cljs.core.LazySeq(null,((function (s__37763__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37765__$1 = s__37765;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37765__$1);
if(temp__4657__auto____$1){
var s__37765__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37765__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37765__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37767 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37766 = (0);
while(true){
if((i__37766 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37766);
cljs.core.chunk_append.call(null,b__37767,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39209 = (i__37766 + (1));
i__37766 = G__39209;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37767),thinktopic$aljabr$core$iter__37762_$_iter__37764.call(null,cljs.core.chunk_rest.call(null,s__37765__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37767),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37765__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37762_$_iter__37764.call(null,cljs.core.rest.call(null,s__37765__$2)));
}
} else {
return null;
}
break;
}
});})(s__37763__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37763__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37762.call(null,cljs.core.rest.call(null,s__37763__$1)));
} else {
var G__39210 = cljs.core.rest.call(null,s__37763__$1);
s__37763__$1 = G__39210;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37759 = self__._offset;
var vec__37768 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37759 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37759], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37759], null));
var a0 = cljs.core.nth.call(null,vec__37768,(0),null);
var b0 = cljs.core.nth.call(null,vec__37768,(1),null);
var G__37759__$1 = cljs.core.nth.call(null,vec__37768,(2),null);
var vec__37769 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37759__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37759__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37759__$1], null));
var a1 = cljs.core.nth.call(null,vec__37769,(0),null);
var b1 = cljs.core.nth.call(null,vec__37769,(1),null);
var G__37759__$2 = cljs.core.nth.call(null,vec__37769,(2),null);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,G__37759__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37758){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37758__$1 = (G__37758 | (0));
var G__37755 = (G__37758__$1 - self__._offset);
var a0 = ((G__37755 / self__._stride0) | (0));
var G__37755__$1 = (G__37755 - (a0 * self__._stride0));
var a1 = ((G__37755__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37757){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37755_39211 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37755_39211] = G__37757.call(null,p0,p1,(self__._data[G__37755_39211])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37755){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37755);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37755 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37756 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,self__._offset,G__37755.call(null,p0__$1),G__37755.call(null,p1__$1),G__37756.call(null,p0__$1),G__37756.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37759 = self__._offset;
var G__37755 = cljs.core.PersistentVector.EMPTY;
var G__37756 = cljs.core.PersistentVector.EMPTY;
var vec__37770 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37755,G__37756,(G__37759 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37755,self__._shape0),cljs.core.conj.call(null,G__37756,self__._stride0),G__37759], null));
var G__37755__$1 = cljs.core.nth.call(null,vec__37770,(0),null);
var G__37756__$1 = cljs.core.nth.call(null,vec__37770,(1),null);
var G__37759__$1 = cljs.core.nth.call(null,vec__37770,(2),null);
var vec__37771 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37755__$1,G__37756__$1,(G__37759__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37755__$1,self__._shape1),cljs.core.conj.call(null,G__37756__$1,self__._stride1),G__37759__$1], null));
var G__37755__$2 = cljs.core.nth.call(null,vec__37771,(0),null);
var G__37756__$2 = cljs.core.nth.call(null,vec__37771,(1),null);
var G__37759__$2 = cljs.core.nth.call(null,vec__37771,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37755__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37759__$2,G__37756__$2,G__37755__$2);
} else {
return (self__._data[(G__37759__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37772 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37772,(0),null);
var b0 = cljs.core.nth.call(null,vec__37772,(1),null);
var vec__37773 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37773,(0),null);
var b1 = cljs.core.nth.call(null,vec__37773,(1),null);
var G__37759 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,G__37759,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37757){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37755_39212 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37755_39212] = G__37757.call(null,p0,p1,(self__._data[G__37755_39212])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37755){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37755);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37755){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37755);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37755,G__37757){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37755] = G__37757.call(null,G__37755,(self__._data[(G__37755 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37774(s__37775){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37775__$1 = s__37775;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37775__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37775__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37774_$_iter__37776(s__37777){
return (new cljs.core.LazySeq(null,((function (s__37775__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37777__$1 = s__37777;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37777__$1);
if(temp__4657__auto____$1){
var s__37777__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37777__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37777__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37779 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37778 = (0);
while(true){
if((i__37778 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37778);
cljs.core.chunk_append.call(null,b__37779,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39213 = (i__37778 + (1));
i__37778 = G__39213;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37779),thinktopic$aljabr$core$iter__37774_$_iter__37776.call(null,cljs.core.chunk_rest.call(null,s__37777__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37779),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37777__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37774_$_iter__37776.call(null,cljs.core.rest.call(null,s__37777__$2)));
}
} else {
return null;
}
break;
}
});})(s__37775__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37775__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37774.call(null,cljs.core.rest.call(null,s__37775__$1)));
} else {
var G__39214 = cljs.core.rest.call(null,s__37775__$1);
s__37775__$1 = G__39214;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.float32.call(null,(self__._shape0 * self__._shape1));
var vec__37780 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37780,(0),null);
var a1 = cljs.core.nth.call(null,vec__37780,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2float32(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37755_39215 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37756_39216 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37755_39215)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37756_39216) | (0))] = (self__._data[(cljs.core.first.call(null,G__37755_39215) | (0))]));

var G__39217 = cljs.core.next.call(null,G__37755_39215);
var G__39218 = cljs.core.next.call(null,G__37756_39216);
G__37755_39215 = G__39217;
G__37756_39216 = G__39218;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39219 = length__37027__auto__;
var i__37023__auto___39220 = (0);
while(true){
if((i__37023__auto___39220 < n__19308__auto___39219)){
(r__37028__auto__[i__37023__auto___39220] = 0.0);

var G__39221 = (i__37023__auto___39220 + (1));
i__37023__auto___39220 = G__39221;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39222 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39223 = (0);
while(true){
if((i__37023__auto___39223 < n__19308__auto___39222)){
(r__37028__auto__[i__37023__auto___39223] = 0.0);

var G__39224 = (i__37023__auto___39223 + (1));
i__37023__auto___39223 = G__39224;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2float32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37781(s__37782){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37782__$1 = s__37782;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37782__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37782__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37781_$_iter__37783(s__37784){
return (new cljs.core.LazySeq(null,((function (s__37782__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37784__$1 = s__37784;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37784__$1);
if(temp__4657__auto____$1){
var s__37784__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37784__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37784__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37786 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37785 = (0);
while(true){
if((i__37785 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37785);
cljs.core.chunk_append.call(null,b__37786,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39225 = (i__37785 + (1));
i__37785 = G__39225;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37786),thinktopic$aljabr$core$iter__37781_$_iter__37783.call(null,cljs.core.chunk_rest.call(null,s__37784__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37786),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37784__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37781_$_iter__37783.call(null,cljs.core.rest.call(null,s__37784__$2)));
}
} else {
return null;
}
break;
}
});})(s__37782__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37782__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37781.call(null,cljs.core.rest.call(null,s__37782__$1)));
} else {
var G__39226 = cljs.core.rest.call(null,s__37782__$1);
s__37782__$1 = G__39226;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39227 = length__37027__auto__;
var i__37023__auto___39228 = (0);
while(true){
if((i__37023__auto___39228 < n__19308__auto___39227)){
(cloned_ary__37042__auto__[i__37023__auto___39228] = (self__._data[i__37023__auto___39228]));

var G__39229 = (i__37023__auto___39228 + (1));
i__37023__auto___39228 = G__39229;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2float32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2float32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2float32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2float32";

thinktopic.aljabr.core.NDArray2float32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2float32");
});

thinktopic.aljabr.core.__GT_NDArray2float32 = (function thinktopic$aljabr$core$__GT_NDArray2float32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2float32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_float32 = (function thinktopic$aljabr$core$make_raw_ndarray2_float32(data__37025__auto__,o__37045__auto__,p__37787,p__37788){
var vec__37791 = p__37787;
var _stride0 = cljs.core.nth.call(null,vec__37791,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37791,(1),null);
var vec__37792 = p__37788;
var _shape0 = cljs.core.nth.call(null,vec__37792,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37792,(1),null);
return (new thinktopic.aljabr.core.NDArray2float32(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_float32', thinktopic.aljabr.core.make_raw_ndarray2_float32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"float32","float32",-2119815775)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_float32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2float64 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37800(s__37801){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37801__$1 = s__37801;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37801__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37801__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37800_$_iter__37802(s__37803){
return (new cljs.core.LazySeq(null,((function (s__37801__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37803__$1 = s__37803;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37803__$1);
if(temp__4657__auto____$1){
var s__37803__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37803__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37803__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37805 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37804 = (0);
while(true){
if((i__37804 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37804);
cljs.core.chunk_append.call(null,b__37805,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__39230 = (i__37804 + (1));
i__37804 = G__39230;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37805),thinktopic$aljabr$core$iter__37800_$_iter__37802.call(null,cljs.core.chunk_rest.call(null,s__37803__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37805),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37803__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__37800_$_iter__37802.call(null,cljs.core.rest.call(null,s__37803__$2)));
}
} else {
return null;
}
break;
}
});})(s__37801__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37801__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37800.call(null,cljs.core.rest.call(null,s__37801__$1)));
} else {
var G__39231 = cljs.core.rest.call(null,s__37801__$1);
s__37801__$1 = G__39231;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37797 = self__._offset;
var vec__37806 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37797 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37797], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37797], null));
var a0 = cljs.core.nth.call(null,vec__37806,(0),null);
var b0 = cljs.core.nth.call(null,vec__37806,(1),null);
var G__37797__$1 = cljs.core.nth.call(null,vec__37806,(2),null);
var vec__37807 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37797__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37797__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37797__$1], null));
var a1 = cljs.core.nth.call(null,vec__37807,(0),null);
var b1 = cljs.core.nth.call(null,vec__37807,(1),null);
var G__37797__$2 = cljs.core.nth.call(null,vec__37807,(2),null);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,G__37797__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37796){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37796__$1 = (G__37796 | (0));
var G__37793 = (G__37796__$1 - self__._offset);
var a0 = ((G__37793 / self__._stride0) | (0));
var G__37793__$1 = (G__37793 - (a0 * self__._stride0));
var a1 = ((G__37793__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37795){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__37793_39232 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37793_39232] = G__37795.call(null,p0,p1,(self__._data[G__37793_39232])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___37020__auto__,p0,p1,G__37793){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37793);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__37793 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__37794 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,self__._offset,G__37793.call(null,p0__$1),G__37793.call(null,p1__$1),G__37794.call(null,p0__$1),G__37794.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37797 = self__._offset;
var G__37793 = cljs.core.PersistentVector.EMPTY;
var G__37794 = cljs.core.PersistentVector.EMPTY;
var vec__37808 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37793,G__37794,(G__37797 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37793,self__._shape0),cljs.core.conj.call(null,G__37794,self__._stride0),G__37797], null));
var G__37793__$1 = cljs.core.nth.call(null,vec__37808,(0),null);
var G__37794__$1 = cljs.core.nth.call(null,vec__37808,(1),null);
var G__37797__$1 = cljs.core.nth.call(null,vec__37808,(2),null);
var vec__37809 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37793__$1,G__37794__$1,(G__37797__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37793__$1,self__._shape1),cljs.core.conj.call(null,G__37794__$1,self__._stride1),G__37797__$1], null));
var G__37793__$2 = cljs.core.nth.call(null,vec__37809,(0),null);
var G__37794__$2 = cljs.core.nth.call(null,vec__37809,(1),null);
var G__37797__$2 = cljs.core.nth.call(null,vec__37809,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37793__$2);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37797__$2,G__37794__$2,G__37793__$2);
} else {
return (self__._data[(G__37797__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37810 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37810,(0),null);
var b0 = cljs.core.nth.call(null,vec__37810,(1),null);
var vec__37811 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37811,(0),null);
var b1 = cljs.core.nth.call(null,vec__37811,(1),null);
var G__37797 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,G__37797,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___37020__auto__,p0,p1,G__37795){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37793_39233 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__37793_39233] = G__37795.call(null,p0,p1,(self__._data[G__37793_39233])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37793){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37793);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___37020__auto__,p0,p1,G__37793){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__37793);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___37020__auto__,p0,p1){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37793,G__37795){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37793] = G__37795.call(null,G__37793,(self__._data[(G__37793 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37812(s__37813){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37813__$1 = s__37813;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37813__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37813__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37812_$_iter__37814(s__37815){
return (new cljs.core.LazySeq(null,((function (s__37813__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37815__$1 = s__37815;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37815__$1);
if(temp__4657__auto____$1){
var s__37815__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37815__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37815__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37817 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37816 = (0);
while(true){
if((i__37816 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37816);
cljs.core.chunk_append.call(null,b__37817,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__39234 = (i__37816 + (1));
i__37816 = G__39234;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37817),thinktopic$aljabr$core$iter__37812_$_iter__37814.call(null,cljs.core.chunk_rest.call(null,s__37815__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37817),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37815__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__37812_$_iter__37814.call(null,cljs.core.rest.call(null,s__37815__$2)));
}
} else {
return null;
}
break;
}
});})(s__37813__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37813__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37812.call(null,cljs.core.rest.call(null,s__37813__$1)));
} else {
var G__39235 = cljs.core.rest.call(null,s__37813__$1);
s__37813__$1 = G__39235;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.float64.call(null,(self__._shape0 * self__._shape1));
var vec__37818 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__37818,(0),null);
var a1 = cljs.core.nth.call(null,vec__37818,(1),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray2float64(buf__37021__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__37793_39236 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37794_39237 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37793_39236)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37794_39237) | (0))] = (self__._data[(cljs.core.first.call(null,G__37793_39236) | (0))]));

var G__39238 = cljs.core.next.call(null,G__37793_39236);
var G__39239 = cljs.core.next.call(null,G__37794_39237);
G__37793_39236 = G__39238;
G__37794_39237 = G__39239;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39240 = length__37027__auto__;
var i__37023__auto___39241 = (0);
while(true){
if((i__37023__auto___39241 < n__19308__auto___39240)){
(r__37028__auto__[i__37023__auto___39241] = 0.0);

var G__39242 = (i__37023__auto___39241 + (1));
i__37023__auto___39241 = G__39242;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39243 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39244 = (0);
while(true){
if((i__37023__auto___39244 < n__19308__auto___39243)){
(r__37028__auto__[i__37023__auto___39244] = 0.0);

var G__39245 = (i__37023__auto___39244 + (1));
i__37023__auto___39244 = G__39245;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2float64.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37819(s__37820){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37820__$1 = s__37820;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37820__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37820__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37819_$_iter__37821(s__37822){
return (new cljs.core.LazySeq(null,((function (s__37820__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37822__$1 = s__37822;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37822__$1);
if(temp__4657__auto____$1){
var s__37822__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37822__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37822__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37824 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37823 = (0);
while(true){
if((i__37823 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__37823);
cljs.core.chunk_append.call(null,b__37824,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__39246 = (i__37823 + (1));
i__37823 = G__39246;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37824),thinktopic$aljabr$core$iter__37819_$_iter__37821.call(null,cljs.core.chunk_rest.call(null,s__37822__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37824),null);
}
} else {
var a1 = cljs.core.first.call(null,s__37822__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__37819_$_iter__37821.call(null,cljs.core.rest.call(null,s__37822__$2)));
}
} else {
return null;
}
break;
}
});})(s__37820__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37820__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37819.call(null,cljs.core.rest.call(null,s__37820__$1)));
} else {
var G__39247 = cljs.core.rest.call(null,s__37820__$1);
s__37820__$1 = G__39247;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39248 = length__37027__auto__;
var i__37023__auto___39249 = (0);
while(true){
if((i__37023__auto___39249 < n__19308__auto___39248)){
(cloned_ary__37042__auto__[i__37023__auto___39249] = (self__._data[i__37023__auto___39249]));

var G__39250 = (i__37023__auto___39249 + (1));
i__37023__auto___39249 = G__39250;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2float64.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2float64.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2float64.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2float64";

thinktopic.aljabr.core.NDArray2float64.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2float64");
});

thinktopic.aljabr.core.__GT_NDArray2float64 = (function thinktopic$aljabr$core$__GT_NDArray2float64(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2float64(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_float64 = (function thinktopic$aljabr$core$make_raw_ndarray2_float64(data__37025__auto__,o__37045__auto__,p__37825,p__37826){
var vec__37829 = p__37825;
var _stride0 = cljs.core.nth.call(null,vec__37829,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37829,(1),null);
var vec__37830 = p__37826;
var _shape0 = cljs.core.nth.call(null,vec__37830,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37830,(1),null);
return (new thinktopic.aljabr.core.NDArray2float64(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_float64', thinktopic.aljabr.core.make_raw_ndarray2_float64);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"float64","float64",1881838306)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_float64,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float64], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3generic = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37838(s__37839){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37839__$1 = s__37839;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37839__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37839__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37838_$_iter__37840(s__37841){
return (new cljs.core.LazySeq(null,((function (s__37839__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37841__$1 = s__37841;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37841__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37841__$1,s__37839__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37838_$_iter__37840_$_iter__37842(s__37843){
return (new cljs.core.LazySeq(null,((function (s__37841__$1,s__37839__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37843__$1 = s__37843;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37843__$1);
if(temp__4657__auto____$2){
var s__37843__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37843__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37843__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37845 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37844 = (0);
while(true){
if((i__37844 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37844);
cljs.core.chunk_append.call(null,b__37845,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__39251 = (i__37844 + (1));
i__37844 = G__39251;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37845),thinktopic$aljabr$core$iter__37838_$_iter__37840_$_iter__37842.call(null,cljs.core.chunk_rest.call(null,s__37843__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37845),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37843__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__37838_$_iter__37840_$_iter__37842.call(null,cljs.core.rest.call(null,s__37843__$2)));
}
} else {
return null;
}
break;
}
});})(s__37841__$1,s__37839__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37841__$1,s__37839__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37838_$_iter__37840.call(null,cljs.core.rest.call(null,s__37841__$1)));
} else {
var G__39252 = cljs.core.rest.call(null,s__37841__$1);
s__37841__$1 = G__39252;
continue;
}
} else {
return null;
}
break;
}
});})(s__37839__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37839__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37838.call(null,cljs.core.rest.call(null,s__37839__$1)));
} else {
var G__39253 = cljs.core.rest.call(null,s__37839__$1);
s__37839__$1 = G__39253;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37835 = self__._offset;
var vec__37846 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37835 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37835], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37835], null));
var a0 = cljs.core.nth.call(null,vec__37846,(0),null);
var b0 = cljs.core.nth.call(null,vec__37846,(1),null);
var G__37835__$1 = cljs.core.nth.call(null,vec__37846,(2),null);
var vec__37847 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37835__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37835__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37835__$1], null));
var a1 = cljs.core.nth.call(null,vec__37847,(0),null);
var b1 = cljs.core.nth.call(null,vec__37847,(1),null);
var G__37835__$2 = cljs.core.nth.call(null,vec__37847,(2),null);
var vec__37848 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__37835__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__37835__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__37835__$2], null));
var a2 = cljs.core.nth.call(null,vec__37848,(0),null);
var b2 = cljs.core.nth.call(null,vec__37848,(1),null);
var G__37835__$3 = cljs.core.nth.call(null,vec__37848,(2),null);
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,G__37835__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37834){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37834__$1 = (G__37834 | (0));
var G__37831 = (G__37834__$1 - self__._offset);
var a0 = ((G__37831 / self__._stride0) | (0));
var G__37831__$1 = (G__37831 - (a0 * self__._stride0));
var a1 = ((G__37831__$1 / self__._stride1) | (0));
var G__37831__$2 = (G__37831__$1 - (a1 * self__._stride1));
var a2 = ((G__37831__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37833){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__37831_39254 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__37831_39254] = G__37833.call(null,p0,p1,p2,(self__._data[G__37831_39254])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37831){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__37831);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__37831 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__37832 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,self__._offset,G__37831.call(null,p0__$1),G__37831.call(null,p1__$1),G__37831.call(null,p2__$1),G__37832.call(null,p0__$1),G__37832.call(null,p1__$1),G__37832.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37835 = self__._offset;
var G__37831 = cljs.core.PersistentVector.EMPTY;
var G__37832 = cljs.core.PersistentVector.EMPTY;
var vec__37849 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37831,G__37832,(G__37835 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37831,self__._shape0),cljs.core.conj.call(null,G__37832,self__._stride0),G__37835], null));
var G__37831__$1 = cljs.core.nth.call(null,vec__37849,(0),null);
var G__37832__$1 = cljs.core.nth.call(null,vec__37849,(1),null);
var G__37835__$1 = cljs.core.nth.call(null,vec__37849,(2),null);
var vec__37850 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37831__$1,G__37832__$1,(G__37835__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37831__$1,self__._shape1),cljs.core.conj.call(null,G__37832__$1,self__._stride1),G__37835__$1], null));
var G__37831__$2 = cljs.core.nth.call(null,vec__37850,(0),null);
var G__37832__$2 = cljs.core.nth.call(null,vec__37850,(1),null);
var G__37835__$2 = cljs.core.nth.call(null,vec__37850,(2),null);
var vec__37851 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37831__$2,G__37832__$2,(G__37835__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37831__$2,self__._shape2),cljs.core.conj.call(null,G__37832__$2,self__._stride2),G__37835__$2], null));
var G__37831__$3 = cljs.core.nth.call(null,vec__37851,(0),null);
var G__37832__$3 = cljs.core.nth.call(null,vec__37851,(1),null);
var G__37835__$3 = cljs.core.nth.call(null,vec__37851,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37831__$3);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37835__$3,G__37832__$3,G__37831__$3);
} else {
return (self__._data[(G__37835__$3 | (0))]);
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37852 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37852,(0),null);
var b0 = cljs.core.nth.call(null,vec__37852,(1),null);
var vec__37853 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37853,(0),null);
var b1 = cljs.core.nth.call(null,vec__37853,(1),null);
var vec__37854 = (((p2 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape2 - (p2 | (0))),(self__._stride2 * (p2 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,(0)], null));
var a2 = cljs.core.nth.call(null,vec__37854,(0),null);
var b2 = cljs.core.nth.call(null,vec__37854,(1),null);
var G__37835 = ((self__._offset + b0) + (b1 + b2));
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,G__37835,self__._stride0,self__._stride1,self__._stride2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37833){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37831_39255 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__37831_39255] = G__37833.call(null,p0,p1,p2,(self__._data[G__37831_39255])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37831){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37831);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37831){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__37831);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,self__._offset,self__._stride0,self__._stride1,self__._stride2,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1),((typeof p2 === 'number')?(((p2 < (0)))?(self__._shape2 + (p2 | (0))):(p2 | (0))):self__._shape2)));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37831,G__37833){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37831] = G__37833.call(null,G__37831,(self__._data[(G__37831 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._shape0 * self__._shape1) * self__._shape2);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37855(s__37856){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37856__$1 = s__37856;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37856__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37856__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37855_$_iter__37857(s__37858){
return (new cljs.core.LazySeq(null,((function (s__37856__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37858__$1 = s__37858;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37858__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37858__$1,s__37856__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37855_$_iter__37857_$_iter__37859(s__37860){
return (new cljs.core.LazySeq(null,((function (s__37858__$1,s__37856__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37860__$1 = s__37860;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37860__$1);
if(temp__4657__auto____$2){
var s__37860__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37860__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37860__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37862 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37861 = (0);
while(true){
if((i__37861 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37861);
cljs.core.chunk_append.call(null,b__37862,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null));

var G__39256 = (i__37861 + (1));
i__37861 = G__39256;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37862),thinktopic$aljabr$core$iter__37855_$_iter__37857_$_iter__37859.call(null,cljs.core.chunk_rest.call(null,s__37860__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37862),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37860__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null),thinktopic$aljabr$core$iter__37855_$_iter__37857_$_iter__37859.call(null,cljs.core.rest.call(null,s__37860__$2)));
}
} else {
return null;
}
break;
}
});})(s__37858__$1,s__37856__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37858__$1,s__37856__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37855_$_iter__37857.call(null,cljs.core.rest.call(null,s__37858__$1)));
} else {
var G__39257 = cljs.core.rest.call(null,s__37858__$1);
s__37858__$1 = G__39257;
continue;
}
} else {
return null;
}
break;
}
});})(s__37856__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37856__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37855.call(null,cljs.core.rest.call(null,s__37856__$1)));
} else {
var G__39258 = cljs.core.rest.call(null,s__37856__$1);
s__37856__$1 = G__39258;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = cljs.core.to_array.call(null,((self__._shape0 * self__._shape1) * self__._shape2));
var vec__37863 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var a0 = cljs.core.nth.call(null,vec__37863,(0),null);
var a1 = cljs.core.nth.call(null,vec__37863,(1),null);
var a2 = cljs.core.nth.call(null,vec__37863,(2),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray3generic(buf__37021__auto__,(0),a0,a1,a2,self__._shape0,self__._shape1,self__._shape2));
var G__37831_39259 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37832_39260 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37831_39259)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37832_39260) | (0))] = (self__._data[(cljs.core.first.call(null,G__37831_39259) | (0))]));

var G__39261 = cljs.core.next.call(null,G__37831_39259);
var G__39262 = cljs.core.next.call(null,G__37832_39260);
G__37831_39259 = G__39261;
G__37832_39260 = G__39262;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39263 = length__37027__auto__;
var i__37023__auto___39264 = (0);
while(true){
if((i__37023__auto___39264 < n__19308__auto___39263)){
(r__37028__auto__[i__37023__auto___39264] = 0.0);

var G__39265 = (i__37023__auto___39264 + (1));
i__37023__auto___39264 = G__39265;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39266 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39267 = (0);
while(true){
if((i__37023__auto___39267 < n__19308__auto___39266)){
(r__37028__auto__[i__37023__auto___39267] = 0.0);

var G__39268 = (i__37023__auto___39267 + (1));
i__37023__auto___39267 = G__39268;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray3generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(3))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37864(s__37865){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37865__$1 = s__37865;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37865__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37865__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37864_$_iter__37866(s__37867){
return (new cljs.core.LazySeq(null,((function (s__37865__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37867__$1 = s__37867;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37867__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37867__$1,s__37865__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37864_$_iter__37866_$_iter__37868(s__37869){
return (new cljs.core.LazySeq(null,((function (s__37867__$1,s__37865__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37869__$1 = s__37869;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37869__$1);
if(temp__4657__auto____$2){
var s__37869__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37869__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37869__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37871 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37870 = (0);
while(true){
if((i__37870 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37870);
cljs.core.chunk_append.call(null,b__37871,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]));

var G__39269 = (i__37870 + (1));
i__37870 = G__39269;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37871),thinktopic$aljabr$core$iter__37864_$_iter__37866_$_iter__37868.call(null,cljs.core.chunk_rest.call(null,s__37869__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37871),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37869__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]),thinktopic$aljabr$core$iter__37864_$_iter__37866_$_iter__37868.call(null,cljs.core.rest.call(null,s__37869__$2)));
}
} else {
return null;
}
break;
}
});})(s__37867__$1,s__37865__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37867__$1,s__37865__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37864_$_iter__37866.call(null,cljs.core.rest.call(null,s__37867__$1)));
} else {
var G__39270 = cljs.core.rest.call(null,s__37867__$1);
s__37867__$1 = G__39270;
continue;
}
} else {
return null;
}
break;
}
});})(s__37865__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37865__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37864.call(null,cljs.core.rest.call(null,s__37865__$1)));
} else {
var G__39271 = cljs.core.rest.call(null,s__37865__$1);
s__37865__$1 = G__39271;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((3) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39272 = length__37027__auto__;
var i__37023__auto___39273 = (0);
while(true){
if((i__37023__auto___39273 < n__19308__auto___39272)){
(cloned_ary__37042__auto__[i__37023__auto___39273] = (self__._data[i__37023__auto___39273]));

var G__39274 = (i__37023__auto___39273 + (1));
i__37023__auto___39273 = G__39274;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray3generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_stride2","_stride2",-1119345708,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null),new cljs.core.Symbol(null,"_shape2","_shape2",-126153333,null)], null);
});

thinktopic.aljabr.core.NDArray3generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray3generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray3generic";

thinktopic.aljabr.core.NDArray3generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray3generic");
});

thinktopic.aljabr.core.__GT_NDArray3generic = (function thinktopic$aljabr$core$__GT_NDArray3generic(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
return (new thinktopic.aljabr.core.NDArray3generic(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});


thinktopic.aljabr.core.make_raw_ndarray3_generic = (function thinktopic$aljabr$core$make_raw_ndarray3_generic(data__37025__auto__,o__37045__auto__,p__37872,p__37873){
var vec__37876 = p__37872;
var _stride0 = cljs.core.nth.call(null,vec__37876,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37876,(1),null);
var _stride2 = cljs.core.nth.call(null,vec__37876,(2),null);
var vec__37877 = p__37873;
var _shape0 = cljs.core.nth.call(null,vec__37877,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37877,(1),null);
var _shape2 = cljs.core.nth.call(null,vec__37877,(2),null);
return (new thinktopic.aljabr.core.NDArray3generic(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray3_generic', thinktopic.aljabr.core.make_raw_ndarray3_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray3_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3uint8 = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37885(s__37886){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37886__$1 = s__37886;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37886__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37886__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37885_$_iter__37887(s__37888){
return (new cljs.core.LazySeq(null,((function (s__37886__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37888__$1 = s__37888;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37888__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37888__$1,s__37886__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37885_$_iter__37887_$_iter__37889(s__37890){
return (new cljs.core.LazySeq(null,((function (s__37888__$1,s__37886__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37890__$1 = s__37890;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37890__$1);
if(temp__4657__auto____$2){
var s__37890__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37890__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37890__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37892 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37891 = (0);
while(true){
if((i__37891 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37891);
cljs.core.chunk_append.call(null,b__37892,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__39275 = (i__37891 + (1));
i__37891 = G__39275;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37892),thinktopic$aljabr$core$iter__37885_$_iter__37887_$_iter__37889.call(null,cljs.core.chunk_rest.call(null,s__37890__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37892),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37890__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__37885_$_iter__37887_$_iter__37889.call(null,cljs.core.rest.call(null,s__37890__$2)));
}
} else {
return null;
}
break;
}
});})(s__37888__$1,s__37886__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37888__$1,s__37886__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37885_$_iter__37887.call(null,cljs.core.rest.call(null,s__37888__$1)));
} else {
var G__39276 = cljs.core.rest.call(null,s__37888__$1);
s__37888__$1 = G__39276;
continue;
}
} else {
return null;
}
break;
}
});})(s__37886__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37886__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37885.call(null,cljs.core.rest.call(null,s__37886__$1)));
} else {
var G__39277 = cljs.core.rest.call(null,s__37886__$1);
s__37886__$1 = G__39277;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37882 = self__._offset;
var vec__37893 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37882 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37882], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37882], null));
var a0 = cljs.core.nth.call(null,vec__37893,(0),null);
var b0 = cljs.core.nth.call(null,vec__37893,(1),null);
var G__37882__$1 = cljs.core.nth.call(null,vec__37893,(2),null);
var vec__37894 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37882__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37882__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37882__$1], null));
var a1 = cljs.core.nth.call(null,vec__37894,(0),null);
var b1 = cljs.core.nth.call(null,vec__37894,(1),null);
var G__37882__$2 = cljs.core.nth.call(null,vec__37894,(2),null);
var vec__37895 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__37882__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__37882__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__37882__$2], null));
var a2 = cljs.core.nth.call(null,vec__37895,(0),null);
var b2 = cljs.core.nth.call(null,vec__37895,(1),null);
var G__37882__$3 = cljs.core.nth.call(null,vec__37895,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,G__37882__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37881){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37881__$1 = (G__37881 | (0));
var G__37878 = (G__37881__$1 - self__._offset);
var a0 = ((G__37878 / self__._stride0) | (0));
var G__37878__$1 = (G__37878 - (a0 * self__._stride0));
var a1 = ((G__37878__$1 / self__._stride1) | (0));
var G__37878__$2 = (G__37878__$1 - (a1 * self__._stride1));
var a2 = ((G__37878__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37880){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__37878_39278 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__37878_39278] = G__37880.call(null,p0,p1,p2,(self__._data[G__37878_39278])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37878){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__37878);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__37878 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__37879 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,self__._offset,G__37878.call(null,p0__$1),G__37878.call(null,p1__$1),G__37878.call(null,p2__$1),G__37879.call(null,p0__$1),G__37879.call(null,p1__$1),G__37879.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37882 = self__._offset;
var G__37878 = cljs.core.PersistentVector.EMPTY;
var G__37879 = cljs.core.PersistentVector.EMPTY;
var vec__37896 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37878,G__37879,(G__37882 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37878,self__._shape0),cljs.core.conj.call(null,G__37879,self__._stride0),G__37882], null));
var G__37878__$1 = cljs.core.nth.call(null,vec__37896,(0),null);
var G__37879__$1 = cljs.core.nth.call(null,vec__37896,(1),null);
var G__37882__$1 = cljs.core.nth.call(null,vec__37896,(2),null);
var vec__37897 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37878__$1,G__37879__$1,(G__37882__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37878__$1,self__._shape1),cljs.core.conj.call(null,G__37879__$1,self__._stride1),G__37882__$1], null));
var G__37878__$2 = cljs.core.nth.call(null,vec__37897,(0),null);
var G__37879__$2 = cljs.core.nth.call(null,vec__37897,(1),null);
var G__37882__$2 = cljs.core.nth.call(null,vec__37897,(2),null);
var vec__37898 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37878__$2,G__37879__$2,(G__37882__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37878__$2,self__._shape2),cljs.core.conj.call(null,G__37879__$2,self__._stride2),G__37882__$2], null));
var G__37878__$3 = cljs.core.nth.call(null,vec__37898,(0),null);
var G__37879__$3 = cljs.core.nth.call(null,vec__37898,(1),null);
var G__37882__$3 = cljs.core.nth.call(null,vec__37898,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37878__$3);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__37882__$3,G__37879__$3,G__37878__$3);
} else {
return (self__._data[(G__37882__$3 | (0))]);
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var vec__37899 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__37899,(0),null);
var b0 = cljs.core.nth.call(null,vec__37899,(1),null);
var vec__37900 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__37900,(0),null);
var b1 = cljs.core.nth.call(null,vec__37900,(1),null);
var vec__37901 = (((p2 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape2 - (p2 | (0))),(self__._stride2 * (p2 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,(0)], null));
var a2 = cljs.core.nth.call(null,vec__37901,(0),null);
var b2 = cljs.core.nth.call(null,vec__37901,(1),null);
var G__37882 = ((self__._offset + b0) + (b1 + b2));
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,G__37882,self__._stride0,self__._stride1,self__._stride2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37880){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37878_39279 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__37878_39279] = G__37880.call(null,p0,p1,p2,(self__._data[G__37878_39279])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___37020__auto__,i__37023__auto__,G__37878){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(i__37023__auto__ | (0))] = G__37878);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37878){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__37878);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,self__._offset,self__._stride0,self__._stride1,self__._stride2,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1),((typeof p2 === 'number')?(((p2 < (0)))?(self__._shape2 + (p2 | (0))):(p2 | (0))):self__._shape2)));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___37020__auto__,G__37878,G__37880){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[G__37878] = G__37880.call(null,G__37878,(self__._data[(G__37878 | (0))])));

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return ((self__._shape0 * self__._shape1) * self__._shape2);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37902(s__37903){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37903__$1 = s__37903;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37903__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37903__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37902_$_iter__37904(s__37905){
return (new cljs.core.LazySeq(null,((function (s__37903__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37905__$1 = s__37905;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37905__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37905__$1,s__37903__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37902_$_iter__37904_$_iter__37906(s__37907){
return (new cljs.core.LazySeq(null,((function (s__37905__$1,s__37903__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37907__$1 = s__37907;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37907__$1);
if(temp__4657__auto____$2){
var s__37907__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37907__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37907__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37909 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37908 = (0);
while(true){
if((i__37908 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37908);
cljs.core.chunk_append.call(null,b__37909,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null));

var G__39280 = (i__37908 + (1));
i__37908 = G__39280;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37909),thinktopic$aljabr$core$iter__37902_$_iter__37904_$_iter__37906.call(null,cljs.core.chunk_rest.call(null,s__37907__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37909),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37907__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null),thinktopic$aljabr$core$iter__37902_$_iter__37904_$_iter__37906.call(null,cljs.core.rest.call(null,s__37907__$2)));
}
} else {
return null;
}
break;
}
});})(s__37905__$1,s__37903__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37905__$1,s__37903__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37902_$_iter__37904.call(null,cljs.core.rest.call(null,s__37905__$1)));
} else {
var G__39281 = cljs.core.rest.call(null,s__37905__$1);
s__37905__$1 = G__39281;
continue;
}
} else {
return null;
}
break;
}
});})(s__37903__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37903__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37902.call(null,cljs.core.rest.call(null,s__37903__$1)));
} else {
var G__39282 = cljs.core.rest.call(null,s__37903__$1);
s__37903__$1 = G__39282;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var buf__37021__auto__ = thi.ng.typedarrays.core.uint8.call(null,((self__._shape0 * self__._shape1) * self__._shape2));
var vec__37910 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var a0 = cljs.core.nth.call(null,vec__37910,(0),null);
var a1 = cljs.core.nth.call(null,vec__37910,(1),null);
var a2 = cljs.core.nth.call(null,vec__37910,(2),null);
var arr__37022__auto__ = (new thinktopic.aljabr.core.NDArray3uint8(buf__37021__auto__,(0),a0,a1,a2,self__._shape0,self__._shape1,self__._shape2));
var G__37878_39283 = thinktopic.aljabr.core.index_seq.call(null,___37020__auto____$1);
var G__37879_39284 = thinktopic.aljabr.core.index_seq.call(null,arr__37022__auto__);
while(true){
if(cljs.core.truth_(G__37878_39283)){
(buf__37021__auto__[(cljs.core.first.call(null,G__37879_39284) | (0))] = (self__._data[(cljs.core.first.call(null,G__37878_39283) | (0))]));

var G__39285 = cljs.core.next.call(null,G__37878_39283);
var G__39286 = cljs.core.next.call(null,G__37879_39284);
G__37878_39283 = G__39285;
G__37879_39284 = G__39286;
continue;
} else {
}
break;
}

return arr__37022__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___37020__auto__,data__37025__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var dims__37026__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__37025__auto__));
if((dims__37026__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__37025__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__37025__auto__),clojure.core.matrix.shape.call(null,data__37025__auto__));

}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___37020__auto__,length__37027__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__37027__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__37027__auto__], null));
var n__19308__auto___39287 = length__37027__auto__;
var i__37023__auto___39288 = (0);
while(true){
if((i__37023__auto___39288 < n__19308__auto___39287)){
(r__37028__auto__[i__37023__auto___39288] = 0.0);

var G__39289 = (i__37023__auto___39288 + (1));
i__37023__auto___39288 = G__39289;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___37020__auto__,rows__37029__auto__,columns__37030__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var r__37028__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__37029__auto__ * columns__37030__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__37029__auto__,columns__37030__auto__], null));
var n__19308__auto___39290 = (rows__37029__auto__ * columns__37030__auto__);
var i__37023__auto___39291 = (0);
while(true){
if((i__37023__auto___39291 < n__19308__auto___39290)){
(r__37028__auto__[i__37023__auto___39291] = 0.0);

var G__39292 = (i__37023__auto___39291 + (1));
i__37023__auto___39291 = G__39292;
continue;
} else {
}
break;
}

return r__37028__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___37020__auto__,shape__37031__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__37031__auto__);
if(temp__4655__auto__){
var shape__37031__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__37031__auto____$1)),shape__37031__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___37020__auto__,dimensions__37032__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (dimensions__37032__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__37006__auto__){
var self__ = this;
var m__37006__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(3))){
var iter__19177__auto__ = ((function (m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37911(s__37912){
return (new cljs.core.LazySeq(null,((function (m__37006__auto____$1){
return (function (){
var s__37912__$1 = s__37912;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37912__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37912__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37911_$_iter__37913(s__37914){
return (new cljs.core.LazySeq(null,((function (s__37912__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37914__$1 = s__37914;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37914__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37914__$1,s__37912__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function thinktopic$aljabr$core$iter__37911_$_iter__37913_$_iter__37915(s__37916){
return (new cljs.core.LazySeq(null,((function (s__37914__$1,s__37912__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1){
return (function (){
var s__37916__$1 = s__37916;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37916__$1);
if(temp__4657__auto____$2){
var s__37916__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37916__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37916__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37918 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37917 = (0);
while(true){
if((i__37917 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37917);
cljs.core.chunk_append.call(null,b__37918,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]));

var G__39293 = (i__37917 + (1));
i__37917 = G__39293;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37918),thinktopic$aljabr$core$iter__37911_$_iter__37913_$_iter__37915.call(null,cljs.core.chunk_rest.call(null,s__37916__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37918),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37916__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]),thinktopic$aljabr$core$iter__37911_$_iter__37913_$_iter__37915.call(null,cljs.core.rest.call(null,s__37916__$2)));
}
} else {
return null;
}
break;
}
});})(s__37914__$1,s__37912__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37914__$1,s__37912__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37911_$_iter__37913.call(null,cljs.core.rest.call(null,s__37914__$1)));
} else {
var G__39294 = cljs.core.rest.call(null,s__37914__$1);
s__37914__$1 = G__39294;
continue;
}
} else {
return null;
}
break;
}
});})(s__37912__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
,null,null));
});})(s__37912__$1,a0,xs__5205__auto__,temp__4657__auto__,m__37006__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37911.call(null,cljs.core.rest.call(null,s__37912__$1)));
} else {
var G__39295 = cljs.core.rest.call(null,s__37912__$1);
s__37912__$1 = G__39295;
continue;
}
} else {
return null;
}
break;
}
});})(m__37006__auto____$1))
,null,null));
});})(m__37006__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__37007__auto__ = clojure.core.matrix.shape.call(null,m__37006__auto____$1);
return cljs.core.map.call(null,((function (shape__37007__auto__,m__37006__auto____$1){
return (function (p1__37005__37008__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__37006__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37005__37008__auto__], null),cljs.core.repeat.call(null,((3) - (1)),null)));
});})(shape__37007__auto__,m__37006__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__37007__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var length__37027__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var cloned_ary__37042__auto__ = cljs.core.double_array.call(null,length__37027__auto__);
var n__19308__auto___39296 = length__37027__auto__;
var i__37023__auto___39297 = (0);
while(true){
if((i__37023__auto___39297 < n__19308__auto___39296)){
(cloned_ary__37042__auto__[i__37023__auto___39297] = (self__._data[i__37023__auto___39297]));

var G__39298 = (i__37023__auto___39297 + (1));
i__37023__auto___39297 = G__39298;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__37042__auto__,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray3uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_stride2","_stride2",-1119345708,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null),new cljs.core.Symbol(null,"_shape2","_shape2",-126153333,null)], null);
});

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray3uint8";

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray3uint8");
});

thinktopic.aljabr.core.__GT_NDArray3uint8 = (function thinktopic$aljabr$core$__GT_NDArray3uint8(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
return (new thinktopic.aljabr.core.NDArray3uint8(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});


thinktopic.aljabr.core.make_raw_ndarray3_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray3_uint8(data__37025__auto__,o__37045__auto__,p__37919,p__37920){
var vec__37923 = p__37919;
var _stride0 = cljs.core.nth.call(null,vec__37923,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__37923,(1),null);
var _stride2 = cljs.core.nth.call(null,vec__37923,(2),null);
var vec__37924 = p__37920;
var _shape0 = cljs.core.nth.call(null,vec__37924,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__37924,(1),null);
var _shape2 = cljs.core.nth.call(null,vec__37924,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8(data__37025__auto__,o__37045__auto__,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray3_uint8', thinktopic.aljabr.core.make_raw_ndarray3_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray3_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3uint8_clamped = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
if((a__37043__auto____$1 === b__37044__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__37043__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__37043__auto____$1) === (function (){var x__24690__auto__ = b__37044__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___37020__auto__,dimension_number__37033__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__37033__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__37034__auto__,x__37038__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__37034__auto__,x__37038__auto__,y__37041__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__37034__auto____$1,x__37038__auto__,y__37041__auto__,v__37039__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__37034__auto____$1,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return m__37034__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___37020__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___37020__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__37034__auto__,i__37023__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,i__37023__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__37034__auto____$1,row__37035__auto__,column__37036__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__37034__auto__,indexes__37037__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__37034__auto____$1,indexes__37037__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__37034__auto__,i__37023__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),i__37023__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__37034__auto__,row__37035__auto__,column__37036__auto__,x__37038__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__37034__auto____$1),row__37035__auto__,column__37036__auto__,x__37038__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__37034__auto__,indexes__37037__auto__,v__37039__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
var new_m__37040__auto__ = clojure.core.matrix.clone.call(null,m__37034__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__37040__auto__,cljs.core.concat.call(null,indexes__37037__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__37039__auto__], null)));

return new_m__37040__auto__;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__37034__auto__){
var self__ = this;
var m__37034__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__37043__auto__,b__37044__auto__){
var self__ = this;
var a__37043__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__37043__auto____$1,b__37044__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__37043__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__37044__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
var iter__19177__auto__ = ((function (___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37932(s__37933){
return (new cljs.core.LazySeq(null,((function (___37020__auto____$1){
return (function (){
var s__37933__$1 = s__37933;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37933__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__37933__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37932_$_iter__37934(s__37935){
return (new cljs.core.LazySeq(null,((function (s__37933__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37935__$1 = s__37935;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37935__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__37935__$1,s__37933__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function thinktopic$aljabr$core$iter__37932_$_iter__37934_$_iter__37936(s__37937){
return (new cljs.core.LazySeq(null,((function (s__37935__$1,s__37933__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1){
return (function (){
var s__37937__$1 = s__37937;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__37937__$1);
if(temp__4657__auto____$2){
var s__37937__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37937__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__37937__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__37939 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__37938 = (0);
while(true){
if((i__37938 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__37938);
cljs.core.chunk_append.call(null,b__37939,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__39299 = (i__37938 + (1));
i__37938 = G__39299;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37939),thinktopic$aljabr$core$iter__37932_$_iter__37934_$_iter__37936.call(null,cljs.core.chunk_rest.call(null,s__37937__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37939),null);
}
} else {
var a2 = cljs.core.first.call(null,s__37937__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__37932_$_iter__37934_$_iter__37936.call(null,cljs.core.rest.call(null,s__37937__$2)));
}
} else {
return null;
}
break;
}
});})(s__37935__$1,s__37933__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37935__$1,s__37933__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37932_$_iter__37934.call(null,cljs.core.rest.call(null,s__37935__$1)));
} else {
var G__39300 = cljs.core.rest.call(null,s__37935__$1);
s__37935__$1 = G__39300;
continue;
}
} else {
return null;
}
break;
}
});})(s__37933__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
,null,null));
});})(s__37933__$1,a0,xs__5205__auto__,temp__4657__auto__,___37020__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__37932.call(null,cljs.core.rest.call(null,s__37933__$1)));
} else {
var G__39301 = cljs.core.rest.call(null,s__37933__$1);
s__37933__$1 = G__39301;
continue;
}
} else {
return null;
}
break;
}
});})(___37020__auto____$1))
,null,null));
});})(___37020__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37929 = self__._offset;
var vec__37940 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__37929 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__37929], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__37929], null));
var a0 = cljs.core.nth.call(null,vec__37940,(0),null);
var b0 = cljs.core.nth.call(null,vec__37940,(1),null);
var G__37929__$1 = cljs.core.nth.call(null,vec__37940,(2),null);
var vec__37941 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__37929__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__37929__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__37929__$1], null));
var a1 = cljs.core.nth.call(null,vec__37941,(0),null);
var b1 = cljs.core.nth.call(null,vec__37941,(1),null);
var G__37929__$2 = cljs.core.nth.call(null,vec__37941,(2),null);
var vec__37942 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__37929__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__37929__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__37929__$2], null));
var a2 = cljs.core.nth.call(null,vec__37942,(0),null);
var b2 = cljs.core.nth.call(null,vec__37942,(1),null);
var G__37929__$3 = cljs.core.nth.call(null,vec__37942,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8_clamped(self__._data,G__37929__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___37020__auto__,G__37928){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37928__$1 = (G__37928 | (0));
var G__37925 = (G__37928__$1 - self__._offset);
var a0 = ((G__37925 / self__._stride0) | (0));
var G__37925__$1 = (G__37925 - (a0 * self__._stride0));
var a1 = ((G__37925__$1 / self__._stride1) | (0));
var G__37925__$2 = (G__37925__$1 - (a1 * self__._stride1));
var a2 = ((G__37925__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___37020__auto__,i__37023__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return (self__._data[(i__37023__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37927){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__37925_39302 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__37925_39302] = G__37927.call(null,p0,p1,p2,(self__._data[G__37925_39302])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___37020__auto__){
var self__ = this;
var ___37020__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___37020__auto__,p0,p1,p2,G__37925){
var self__ = this;
var ___37020__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__37925);

return ___37020__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__37925 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__37926 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3uint8_clamped(self__._data,self__._offset,G__37925.call(null,p0__$1),G__37925.call(null,p1__$1),G__37925.call(null,p2__$1),G__37926.call(null,p0__$1),G__37926.call(null,p1__$1),G__37926.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___37020__auto__,p0,p1,p2){
var self__ = this;
var ___37020__auto____$1 = this;
var G__37929 = self__._offset;
var G__37925 = cljs.core.PersistentVector.EMPTY;
var G__37926 = cljs.core.PersistentVector.EMPTY;
var vec__37943 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37925,G__37926,(G__37929 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37925,self__._shape0),cljs.core.conj.call(null,G__37926,self__._stride0),G__37929], null));
var G__37925__$1 = cljs.core.nth.call(null,vec__37943,(0),null);
var G__37926__$1 = cljs.core.nth.call(null,vec__37943,(1),null);
var G__37929__$1 = cljs.core.nth.call(null,vec__37943,(2),null);
var vec__37944 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37925__$1,G__37926__$1,(G__37929__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37925__$1,self__._shape1),cljs.core.conj.call(null,G__37926__$1,self__._stride1),G__37929__$1], null));
var G__37925__$2 = cljs.core.nth.call(null,vec__37944,(0),null);
var G__37926__$2 = cljs.core.nth.call(null,vec__37944,(1),null);
var G__37929__$2 = cljs.core.nth.call(null,vec__37944,(2),null);
var vec__37945 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37925__$2,G__37926__$2,(G__37929__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__37925__$2,self__._shape2),cljs.core.conj.call(null,G__37926__$2,self__._stride2),G__37929__$2], null));
var G__37925__$3 = cljs.core.nth.call(null,vec__37945,(0),null);
var G__37926__$3 = cljs.core.nth.call(null,vec__37945,(1),null);
var G__37929__$3 = cljs.core.nth.call(null,vec__37945,(2),null);
var cnt__37024__auto__ = cljs.core.count.call(null,G__37925__$3);
if((cnt__37024__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__37024__auto__,new cljs.core.Keyword(null,"uint8-clamp