// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18405__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18405__auto__){
return or__18405__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18405__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__23501_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__23501_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__23506 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__23507 = null;
var count__23508 = (0);
var i__23509 = (0);
while(true){
if((i__23509 < count__23508)){
var n = cljs.core._nth.call(null,chunk__23507,i__23509);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23510 = seq__23506;
var G__23511 = chunk__23507;
var G__23512 = count__23508;
var G__23513 = (i__23509 + (1));
seq__23506 = G__23510;
chunk__23507 = G__23511;
count__23508 = G__23512;
i__23509 = G__23513;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__23506);
if(temp__4657__auto__){
var seq__23506__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23506__$1)){
var c__19208__auto__ = cljs.core.chunk_first.call(null,seq__23506__$1);
var G__23514 = cljs.core.chunk_rest.call(null,seq__23506__$1);
var G__23515 = c__19208__auto__;
var G__23516 = cljs.core.count.call(null,c__19208__auto__);
var G__23517 = (0);
seq__23506 = G__23514;
chunk__23507 = G__23515;
count__23508 = G__23516;
i__23509 = G__23517;
continue;
} else {
var n = cljs.core.first.call(null,seq__23506__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23518 = cljs.core.next.call(null,seq__23506__$1);
var G__23519 = null;
var G__23520 = (0);
var G__23521 = (0);
seq__23506 = G__23518;
chunk__23507 = G__23519;
count__23508 = G__23520;
i__23509 = G__23521;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__23560_23567 = cljs.core.seq.call(null,deps);
var chunk__23561_23568 = null;
var count__23562_23569 = (0);
var i__23563_23570 = (0);
while(true){
if((i__23563_23570 < count__23562_23569)){
var dep_23571 = cljs.core._nth.call(null,chunk__23561_23568,i__23563_23570);
topo_sort_helper_STAR_.call(null,dep_23571,(depth + (1)),state);

var G__23572 = seq__23560_23567;
var G__23573 = chunk__23561_23568;
var G__23574 = count__23562_23569;
var G__23575 = (i__23563_23570 + (1));
seq__23560_23567 = G__23572;
chunk__23561_23568 = G__23573;
count__23562_23569 = G__23574;
i__23563_23570 = G__23575;
continue;
} else {
var temp__4657__auto___23576 = cljs.core.seq.call(null,seq__23560_23567);
if(temp__4657__auto___23576){
var seq__23560_23577__$1 = temp__4657__auto___23576;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23560_23577__$1)){
var c__19208__auto___23578 = cljs.core.chunk_first.call(null,seq__23560_23577__$1);
var G__23579 = cljs.core.chunk_rest.call(null,seq__23560_23577__$1);
var G__23580 = c__19208__auto___23578;
var G__23581 = cljs.core.count.call(null,c__19208__auto___23578);
var G__23582 = (0);
seq__23560_23567 = G__23579;
chunk__23561_23568 = G__23580;
count__23562_23569 = G__23581;
i__23563_23570 = G__23582;
continue;
} else {
var dep_23583 = cljs.core.first.call(null,seq__23560_23577__$1);
topo_sort_helper_STAR_.call(null,dep_23583,(depth + (1)),state);

var G__23584 = cljs.core.next.call(null,seq__23560_23577__$1);
var G__23585 = null;
var G__23586 = (0);
var G__23587 = (0);
seq__23560_23567 = G__23584;
chunk__23561_23568 = G__23585;
count__23562_23569 = G__23586;
i__23563_23570 = G__23587;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__23564){
var vec__23566 = p__23564;
var x = cljs.core.nth.call(null,vec__23566,(0),null);
var xs = cljs.core.nthnext.call(null,vec__23566,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__23566,x,xs,get_deps__$1){
return (function (p1__23522_SHARP_){
return clojure.set.difference.call(null,p1__23522_SHARP_,x);
});})(vec__23566,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__23600 = cljs.core.seq.call(null,provides);
var chunk__23601 = null;
var count__23602 = (0);
var i__23603 = (0);
while(true){
if((i__23603 < count__23602)){
var prov = cljs.core._nth.call(null,chunk__23601,i__23603);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23604_23612 = cljs.core.seq.call(null,requires);
var chunk__23605_23613 = null;
var count__23606_23614 = (0);
var i__23607_23615 = (0);
while(true){
if((i__23607_23615 < count__23606_23614)){
var req_23616 = cljs.core._nth.call(null,chunk__23605_23613,i__23607_23615);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23616,prov);

var G__23617 = seq__23604_23612;
var G__23618 = chunk__23605_23613;
var G__23619 = count__23606_23614;
var G__23620 = (i__23607_23615 + (1));
seq__23604_23612 = G__23617;
chunk__23605_23613 = G__23618;
count__23606_23614 = G__23619;
i__23607_23615 = G__23620;
continue;
} else {
var temp__4657__auto___23621 = cljs.core.seq.call(null,seq__23604_23612);
if(temp__4657__auto___23621){
var seq__23604_23622__$1 = temp__4657__auto___23621;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23604_23622__$1)){
var c__19208__auto___23623 = cljs.core.chunk_first.call(null,seq__23604_23622__$1);
var G__23624 = cljs.core.chunk_rest.call(null,seq__23604_23622__$1);
var G__23625 = c__19208__auto___23623;
var G__23626 = cljs.core.count.call(null,c__19208__auto___23623);
var G__23627 = (0);
seq__23604_23612 = G__23624;
chunk__23605_23613 = G__23625;
count__23606_23614 = G__23626;
i__23607_23615 = G__23627;
continue;
} else {
var req_23628 = cljs.core.first.call(null,seq__23604_23622__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23628,prov);

var G__23629 = cljs.core.next.call(null,seq__23604_23622__$1);
var G__23630 = null;
var G__23631 = (0);
var G__23632 = (0);
seq__23604_23612 = G__23629;
chunk__23605_23613 = G__23630;
count__23606_23614 = G__23631;
i__23607_23615 = G__23632;
continue;
}
} else {
}
}
break;
}

var G__23633 = seq__23600;
var G__23634 = chunk__23601;
var G__23635 = count__23602;
var G__23636 = (i__23603 + (1));
seq__23600 = G__23633;
chunk__23601 = G__23634;
count__23602 = G__23635;
i__23603 = G__23636;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__23600);
if(temp__4657__auto__){
var seq__23600__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23600__$1)){
var c__19208__auto__ = cljs.core.chunk_first.call(null,seq__23600__$1);
var G__23637 = cljs.core.chunk_rest.call(null,seq__23600__$1);
var G__23638 = c__19208__auto__;
var G__23639 = cljs.core.count.call(null,c__19208__auto__);
var G__23640 = (0);
seq__23600 = G__23637;
chunk__23601 = G__23638;
count__23602 = G__23639;
i__23603 = G__23640;
continue;
} else {
var prov = cljs.core.first.call(null,seq__23600__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23608_23641 = cljs.core.seq.call(null,requires);
var chunk__23609_23642 = null;
var count__23610_23643 = (0);
var i__23611_23644 = (0);
while(true){
if((i__23611_23644 < count__23610_23643)){
var req_23645 = cljs.core._nth.call(null,chunk__23609_23642,i__23611_23644);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23645,prov);

var G__23646 = seq__23608_23641;
var G__23647 = chunk__23609_23642;
var G__23648 = count__23610_23643;
var G__23649 = (i__23611_23644 + (1));
seq__23608_23641 = G__23646;
chunk__23609_23642 = G__23647;
count__23610_23643 = G__23648;
i__23611_23644 = G__23649;
continue;
} else {
var temp__4657__auto___23650__$1 = cljs.core.seq.call(null,seq__23608_23641);
if(temp__4657__auto___23650__$1){
var seq__23608_23651__$1 = temp__4657__auto___23650__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23608_23651__$1)){
var c__19208__auto___23652 = cljs.core.chunk_first.call(null,seq__23608_23651__$1);
var G__23653 = cljs.core.chunk_rest.call(null,seq__23608_23651__$1);
var G__23654 = c__19208__auto___23652;
var G__23655 = cljs.core.count.call(null,c__19208__auto___23652);
var G__23656 = (0);
seq__23608_23641 = G__23653;
chunk__23609_23642 = G__23654;
count__23610_23643 = G__23655;
i__23611_23644 = G__23656;
continue;
} else {
var req_23657 = cljs.core.first.call(null,seq__23608_23651__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23657,prov);

var G__23658 = cljs.core.next.call(null,seq__23608_23651__$1);
var G__23659 = null;
var G__23660 = (0);
var G__23661 = (0);
seq__23608_23641 = G__23658;
chunk__23609_23642 = G__23659;
count__23610_23643 = G__23660;
i__23611_23644 = G__23661;
continue;
}
} else {
}
}
break;
}

var G__23662 = cljs.core.next.call(null,seq__23600__$1);
var G__23663 = null;
var G__23664 = (0);
var G__23665 = (0);
seq__23600 = G__23662;
chunk__23601 = G__23663;
count__23602 = G__23664;
i__23603 = G__23665;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__23670_23674 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__23671_23675 = null;
var count__23672_23676 = (0);
var i__23673_23677 = (0);
while(true){
if((i__23673_23677 < count__23672_23676)){
var ns_23678 = cljs.core._nth.call(null,chunk__23671_23675,i__23673_23677);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23678);

var G__23679 = seq__23670_23674;
var G__23680 = chunk__23671_23675;
var G__23681 = count__23672_23676;
var G__23682 = (i__23673_23677 + (1));
seq__23670_23674 = G__23679;
chunk__23671_23675 = G__23680;
count__23672_23676 = G__23681;
i__23673_23677 = G__23682;
continue;
} else {
var temp__4657__auto___23683 = cljs.core.seq.call(null,seq__23670_23674);
if(temp__4657__auto___23683){
var seq__23670_23684__$1 = temp__4657__auto___23683;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23670_23684__$1)){
var c__19208__auto___23685 = cljs.core.chunk_first.call(null,seq__23670_23684__$1);
var G__23686 = cljs.core.chunk_rest.call(null,seq__23670_23684__$1);
var G__23687 = c__19208__auto___23685;
var G__23688 = cljs.core.count.call(null,c__19208__auto___23685);
var G__23689 = (0);
seq__23670_23674 = G__23686;
chunk__23671_23675 = G__23687;
count__23672_23676 = G__23688;
i__23673_23677 = G__23689;
continue;
} else {
var ns_23690 = cljs.core.first.call(null,seq__23670_23684__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23690);

var G__23691 = cljs.core.next.call(null,seq__23670_23684__$1);
var G__23692 = null;
var G__23693 = (0);
var G__23694 = (0);
seq__23670_23674 = G__23691;
chunk__23671_23675 = G__23692;
count__23672_23676 = G__23693;
i__23673_23677 = G__23694;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18405__auto__ = goog.require__;
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__23695__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__23695 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23696__i = 0, G__23696__a = new Array(arguments.length -  0);
while (G__23696__i < G__23696__a.length) {G__23696__a[G__23696__i] = arguments[G__23696__i + 0]; ++G__23696__i;}
  args = new cljs.core.IndexedSeq(G__23696__a,0);
} 
return G__23695__delegate.call(this,args);};
G__23695.cljs$lang$maxFixedArity = 0;
G__23695.cljs$lang$applyTo = (function (arglist__23697){
var args = cljs.core.seq(arglist__23697);
return G__23695__delegate(args);
});
G__23695.cljs$core$IFn$_invoke$arity$variadic = G__23695__delegate;
return G__23695;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__23699 = cljs.core._EQ_;
var expr__23700 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__23699.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__23700))){
var path_parts = ((function (pred__23699,expr__23700){
return (function (p1__23698_SHARP_){
return clojure.string.split.call(null,p1__23698_SHARP_,/[\/\\]/);
});})(pred__23699,expr__23700))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__23699,expr__23700){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e23702){if((e23702 instanceof Error)){
var e = e23702;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e23702;

}
}})());
});
;})(path_parts,sep,root,pred__23699,expr__23700))
} else {
if(cljs.core.truth_(pred__23699.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__23700))){
return ((function (pred__23699,expr__23700){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__23699,expr__23700){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__23699,expr__23700))
);

return deferred.addErrback(((function (deferred,pred__23699,expr__23700){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__23699,expr__23700))
);
});
;})(pred__23699,expr__23700))
} else {
return ((function (pred__23699,expr__23700){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__23699,expr__23700))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__23703,callback){
var map__23706 = p__23703;
var map__23706__$1 = ((((!((map__23706 == null)))?((((map__23706.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23706.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23706):map__23706);
var file_msg = map__23706__$1;
var request_url = cljs.core.get.call(null,map__23706__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__23706,map__23706__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__23706,map__23706__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_23730){
var state_val_23731 = (state_23730[(1)]);
if((state_val_23731 === (7))){
var inst_23726 = (state_23730[(2)]);
var state_23730__$1 = state_23730;
var statearr_23732_23752 = state_23730__$1;
(statearr_23732_23752[(2)] = inst_23726);

(statearr_23732_23752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (1))){
var state_23730__$1 = state_23730;
var statearr_23733_23753 = state_23730__$1;
(statearr_23733_23753[(2)] = null);

(statearr_23733_23753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (4))){
var inst_23710 = (state_23730[(7)]);
var inst_23710__$1 = (state_23730[(2)]);
var state_23730__$1 = (function (){var statearr_23734 = state_23730;
(statearr_23734[(7)] = inst_23710__$1);

return statearr_23734;
})();
if(cljs.core.truth_(inst_23710__$1)){
var statearr_23735_23754 = state_23730__$1;
(statearr_23735_23754[(1)] = (5));

} else {
var statearr_23736_23755 = state_23730__$1;
(statearr_23736_23755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (6))){
var state_23730__$1 = state_23730;
var statearr_23737_23756 = state_23730__$1;
(statearr_23737_23756[(2)] = null);

(statearr_23737_23756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (3))){
var inst_23728 = (state_23730[(2)]);
var state_23730__$1 = state_23730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23730__$1,inst_23728);
} else {
if((state_val_23731 === (2))){
var state_23730__$1 = state_23730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23730__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_23731 === (11))){
var inst_23722 = (state_23730[(2)]);
var state_23730__$1 = (function (){var statearr_23738 = state_23730;
(statearr_23738[(8)] = inst_23722);

return statearr_23738;
})();
var statearr_23739_23757 = state_23730__$1;
(statearr_23739_23757[(2)] = null);

(statearr_23739_23757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (9))){
var inst_23716 = (state_23730[(9)]);
var inst_23714 = (state_23730[(10)]);
var inst_23718 = inst_23716.call(null,inst_23714);
var state_23730__$1 = state_23730;
var statearr_23740_23758 = state_23730__$1;
(statearr_23740_23758[(2)] = inst_23718);

(statearr_23740_23758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (5))){
var inst_23710 = (state_23730[(7)]);
var inst_23712 = figwheel.client.file_reloading.blocking_load.call(null,inst_23710);
var state_23730__$1 = state_23730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23730__$1,(8),inst_23712);
} else {
if((state_val_23731 === (10))){
var inst_23714 = (state_23730[(10)]);
var inst_23720 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_23714);
var state_23730__$1 = state_23730;
var statearr_23741_23759 = state_23730__$1;
(statearr_23741_23759[(2)] = inst_23720);

(statearr_23741_23759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23731 === (8))){
var inst_23716 = (state_23730[(9)]);
var inst_23710 = (state_23730[(7)]);
var inst_23714 = (state_23730[(2)]);
var inst_23715 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_23716__$1 = cljs.core.get.call(null,inst_23715,inst_23710);
var state_23730__$1 = (function (){var statearr_23742 = state_23730;
(statearr_23742[(9)] = inst_23716__$1);

(statearr_23742[(10)] = inst_23714);

return statearr_23742;
})();
if(cljs.core.truth_(inst_23716__$1)){
var statearr_23743_23760 = state_23730__$1;
(statearr_23743_23760[(1)] = (9));

} else {
var statearr_23744_23761 = state_23730__$1;
(statearr_23744_23761[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20447__auto__ = null;
var figwheel$client$file_reloading$state_machine__20447__auto____0 = (function (){
var statearr_23748 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23748[(0)] = figwheel$client$file_reloading$state_machine__20447__auto__);

(statearr_23748[(1)] = (1));

return statearr_23748;
});
var figwheel$client$file_reloading$state_machine__20447__auto____1 = (function (state_23730){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_23730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23749){if((e23749 instanceof Object)){
var ex__20450__auto__ = e23749;
var statearr_23750_23762 = state_23730;
(statearr_23750_23762[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23749;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23763 = state_23730;
state_23730 = G__23763;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20447__auto__ = function(state_23730){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20447__auto____1.call(this,state_23730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20447__auto____0;
figwheel$client$file_reloading$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20447__auto____1;
return figwheel$client$file_reloading$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_23751 = f__20559__auto__.call(null);
(statearr_23751[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_23751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__23764,callback){
var map__23767 = p__23764;
var map__23767__$1 = ((((!((map__23767 == null)))?((((map__23767.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23767.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23767):map__23767);
var file_msg = map__23767__$1;
var namespace = cljs.core.get.call(null,map__23767__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__23767,map__23767__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__23767,map__23767__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__23769){
var map__23772 = p__23769;
var map__23772__$1 = ((((!((map__23772 == null)))?((((map__23772.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23772.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23772):map__23772);
var file_msg = map__23772__$1;
var namespace = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18393__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18393__auto__){
var or__18405__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
var or__18405__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18405__auto____$1)){
return or__18405__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18393__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__23774,callback){
var map__23777 = p__23774;
var map__23777__$1 = ((((!((map__23777 == null)))?((((map__23777.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23777.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23777):map__23777);
var file_msg = map__23777__$1;
var request_url = cljs.core.get.call(null,map__23777__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__23777__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20558__auto___23865 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___23865,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___23865,out){
return (function (state_23847){
var state_val_23848 = (state_23847[(1)]);
if((state_val_23848 === (1))){
var inst_23825 = cljs.core.nth.call(null,files,(0),null);
var inst_23826 = cljs.core.nthnext.call(null,files,(1));
var inst_23827 = files;
var state_23847__$1 = (function (){var statearr_23849 = state_23847;
(statearr_23849[(7)] = inst_23827);

(statearr_23849[(8)] = inst_23825);

(statearr_23849[(9)] = inst_23826);

return statearr_23849;
})();
var statearr_23850_23866 = state_23847__$1;
(statearr_23850_23866[(2)] = null);

(statearr_23850_23866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23848 === (2))){
var inst_23827 = (state_23847[(7)]);
var inst_23830 = (state_23847[(10)]);
var inst_23830__$1 = cljs.core.nth.call(null,inst_23827,(0),null);
var inst_23831 = cljs.core.nthnext.call(null,inst_23827,(1));
var inst_23832 = (inst_23830__$1 == null);
var inst_23833 = cljs.core.not.call(null,inst_23832);
var state_23847__$1 = (function (){var statearr_23851 = state_23847;
(statearr_23851[(10)] = inst_23830__$1);

(statearr_23851[(11)] = inst_23831);

return statearr_23851;
})();
if(inst_23833){
var statearr_23852_23867 = state_23847__$1;
(statearr_23852_23867[(1)] = (4));

} else {
var statearr_23853_23868 = state_23847__$1;
(statearr_23853_23868[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23848 === (3))){
var inst_23845 = (state_23847[(2)]);
var state_23847__$1 = state_23847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23847__$1,inst_23845);
} else {
if((state_val_23848 === (4))){
var inst_23830 = (state_23847[(10)]);
var inst_23835 = figwheel.client.file_reloading.reload_js_file.call(null,inst_23830);
var state_23847__$1 = state_23847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23847__$1,(7),inst_23835);
} else {
if((state_val_23848 === (5))){
var inst_23841 = cljs.core.async.close_BANG_.call(null,out);
var state_23847__$1 = state_23847;
var statearr_23854_23869 = state_23847__$1;
(statearr_23854_23869[(2)] = inst_23841);

(statearr_23854_23869[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23848 === (6))){
var inst_23843 = (state_23847[(2)]);
var state_23847__$1 = state_23847;
var statearr_23855_23870 = state_23847__$1;
(statearr_23855_23870[(2)] = inst_23843);

(statearr_23855_23870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23848 === (7))){
var inst_23831 = (state_23847[(11)]);
var inst_23837 = (state_23847[(2)]);
var inst_23838 = cljs.core.async.put_BANG_.call(null,out,inst_23837);
var inst_23827 = inst_23831;
var state_23847__$1 = (function (){var statearr_23856 = state_23847;
(statearr_23856[(7)] = inst_23827);

(statearr_23856[(12)] = inst_23838);

return statearr_23856;
})();
var statearr_23857_23871 = state_23847__$1;
(statearr_23857_23871[(2)] = null);

(statearr_23857_23871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20558__auto___23865,out))
;
return ((function (switch__20446__auto__,c__20558__auto___23865,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____0 = (function (){
var statearr_23861 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23861[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__);

(statearr_23861[(1)] = (1));

return statearr_23861;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____1 = (function (state_23847){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_23847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23862){if((e23862 instanceof Object)){
var ex__20450__auto__ = e23862;
var statearr_23863_23872 = state_23847;
(statearr_23863_23872[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23873 = state_23847;
state_23847 = G__23873;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__ = function(state_23847){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____1.call(this,state_23847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___23865,out))
})();
var state__20560__auto__ = (function (){var statearr_23864 = f__20559__auto__.call(null);
(statearr_23864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___23865);

return statearr_23864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___23865,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__23874,opts){
var map__23878 = p__23874;
var map__23878__$1 = ((((!((map__23878 == null)))?((((map__23878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23878):map__23878);
var eval_body__$1 = cljs.core.get.call(null,map__23878__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__23878__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18393__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18393__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18393__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e23880){var e = e23880;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__23881_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23881_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__23886){
var vec__23887 = p__23886;
var k = cljs.core.nth.call(null,vec__23887,(0),null);
var v = cljs.core.nth.call(null,vec__23887,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__23888){
var vec__23889 = p__23888;
var k = cljs.core.nth.call(null,vec__23889,(0),null);
var v = cljs.core.nth.call(null,vec__23889,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__23893,p__23894){
var map__24141 = p__23893;
var map__24141__$1 = ((((!((map__24141 == null)))?((((map__24141.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24141.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24141):map__24141);
var opts = map__24141__$1;
var before_jsload = cljs.core.get.call(null,map__24141__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__24141__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__24141__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__24142 = p__23894;
var map__24142__$1 = ((((!((map__24142 == null)))?((((map__24142.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24142.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24142):map__24142);
var msg = map__24142__$1;
var files = cljs.core.get.call(null,map__24142__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__24142__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__24142__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_24295){
var state_val_24296 = (state_24295[(1)]);
if((state_val_24296 === (7))){
var inst_24159 = (state_24295[(7)]);
var inst_24156 = (state_24295[(8)]);
var inst_24157 = (state_24295[(9)]);
var inst_24158 = (state_24295[(10)]);
var inst_24164 = cljs.core._nth.call(null,inst_24157,inst_24159);
var inst_24165 = figwheel.client.file_reloading.eval_body.call(null,inst_24164,opts);
var inst_24166 = (inst_24159 + (1));
var tmp24297 = inst_24156;
var tmp24298 = inst_24157;
var tmp24299 = inst_24158;
var inst_24156__$1 = tmp24297;
var inst_24157__$1 = tmp24298;
var inst_24158__$1 = tmp24299;
var inst_24159__$1 = inst_24166;
var state_24295__$1 = (function (){var statearr_24300 = state_24295;
(statearr_24300[(11)] = inst_24165);

(statearr_24300[(7)] = inst_24159__$1);

(statearr_24300[(8)] = inst_24156__$1);

(statearr_24300[(9)] = inst_24157__$1);

(statearr_24300[(10)] = inst_24158__$1);

return statearr_24300;
})();
var statearr_24301_24387 = state_24295__$1;
(statearr_24301_24387[(2)] = null);

(statearr_24301_24387[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (20))){
var inst_24199 = (state_24295[(12)]);
var inst_24207 = figwheel.client.file_reloading.sort_files.call(null,inst_24199);
var state_24295__$1 = state_24295;
var statearr_24302_24388 = state_24295__$1;
(statearr_24302_24388[(2)] = inst_24207);

(statearr_24302_24388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (27))){
var state_24295__$1 = state_24295;
var statearr_24303_24389 = state_24295__$1;
(statearr_24303_24389[(2)] = null);

(statearr_24303_24389[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (1))){
var inst_24148 = (state_24295[(13)]);
var inst_24145 = before_jsload.call(null,files);
var inst_24146 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_24147 = (function (){return ((function (inst_24148,inst_24145,inst_24146,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23890_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23890_SHARP_);
});
;})(inst_24148,inst_24145,inst_24146,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24148__$1 = cljs.core.filter.call(null,inst_24147,files);
var inst_24149 = cljs.core.not_empty.call(null,inst_24148__$1);
var state_24295__$1 = (function (){var statearr_24304 = state_24295;
(statearr_24304[(14)] = inst_24145);

(statearr_24304[(15)] = inst_24146);

(statearr_24304[(13)] = inst_24148__$1);

return statearr_24304;
})();
if(cljs.core.truth_(inst_24149)){
var statearr_24305_24390 = state_24295__$1;
(statearr_24305_24390[(1)] = (2));

} else {
var statearr_24306_24391 = state_24295__$1;
(statearr_24306_24391[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (24))){
var state_24295__$1 = state_24295;
var statearr_24307_24392 = state_24295__$1;
(statearr_24307_24392[(2)] = null);

(statearr_24307_24392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (39))){
var inst_24249 = (state_24295[(16)]);
var state_24295__$1 = state_24295;
var statearr_24308_24393 = state_24295__$1;
(statearr_24308_24393[(2)] = inst_24249);

(statearr_24308_24393[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (46))){
var inst_24290 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24309_24394 = state_24295__$1;
(statearr_24309_24394[(2)] = inst_24290);

(statearr_24309_24394[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (4))){
var inst_24193 = (state_24295[(2)]);
var inst_24194 = cljs.core.List.EMPTY;
var inst_24195 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_24194);
var inst_24196 = (function (){return ((function (inst_24193,inst_24194,inst_24195,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23891_SHARP_){
var and__18393__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23891_SHARP_);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23891_SHARP_));
} else {
return and__18393__auto__;
}
});
;})(inst_24193,inst_24194,inst_24195,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24197 = cljs.core.filter.call(null,inst_24196,files);
var inst_24198 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_24199 = cljs.core.concat.call(null,inst_24197,inst_24198);
var state_24295__$1 = (function (){var statearr_24310 = state_24295;
(statearr_24310[(17)] = inst_24195);

(statearr_24310[(12)] = inst_24199);

(statearr_24310[(18)] = inst_24193);

return statearr_24310;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_24311_24395 = state_24295__$1;
(statearr_24311_24395[(1)] = (16));

} else {
var statearr_24312_24396 = state_24295__$1;
(statearr_24312_24396[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (15))){
var inst_24183 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24313_24397 = state_24295__$1;
(statearr_24313_24397[(2)] = inst_24183);

(statearr_24313_24397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (21))){
var inst_24209 = (state_24295[(19)]);
var inst_24209__$1 = (state_24295[(2)]);
var inst_24210 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_24209__$1);
var state_24295__$1 = (function (){var statearr_24314 = state_24295;
(statearr_24314[(19)] = inst_24209__$1);

return statearr_24314;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24295__$1,(22),inst_24210);
} else {
if((state_val_24296 === (31))){
var inst_24293 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24295__$1,inst_24293);
} else {
if((state_val_24296 === (32))){
var inst_24249 = (state_24295[(16)]);
var inst_24254 = inst_24249.cljs$lang$protocol_mask$partition0$;
var inst_24255 = (inst_24254 & (64));
var inst_24256 = inst_24249.cljs$core$ISeq$;
var inst_24257 = (inst_24255) || (inst_24256);
var state_24295__$1 = state_24295;
if(cljs.core.truth_(inst_24257)){
var statearr_24315_24398 = state_24295__$1;
(statearr_24315_24398[(1)] = (35));

} else {
var statearr_24316_24399 = state_24295__$1;
(statearr_24316_24399[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (40))){
var inst_24270 = (state_24295[(20)]);
var inst_24269 = (state_24295[(2)]);
var inst_24270__$1 = cljs.core.get.call(null,inst_24269,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_24271 = cljs.core.get.call(null,inst_24269,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_24272 = cljs.core.not_empty.call(null,inst_24270__$1);
var state_24295__$1 = (function (){var statearr_24317 = state_24295;
(statearr_24317[(21)] = inst_24271);

(statearr_24317[(20)] = inst_24270__$1);

return statearr_24317;
})();
if(cljs.core.truth_(inst_24272)){
var statearr_24318_24400 = state_24295__$1;
(statearr_24318_24400[(1)] = (41));

} else {
var statearr_24319_24401 = state_24295__$1;
(statearr_24319_24401[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (33))){
var state_24295__$1 = state_24295;
var statearr_24320_24402 = state_24295__$1;
(statearr_24320_24402[(2)] = false);

(statearr_24320_24402[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (13))){
var inst_24169 = (state_24295[(22)]);
var inst_24173 = cljs.core.chunk_first.call(null,inst_24169);
var inst_24174 = cljs.core.chunk_rest.call(null,inst_24169);
var inst_24175 = cljs.core.count.call(null,inst_24173);
var inst_24156 = inst_24174;
var inst_24157 = inst_24173;
var inst_24158 = inst_24175;
var inst_24159 = (0);
var state_24295__$1 = (function (){var statearr_24321 = state_24295;
(statearr_24321[(7)] = inst_24159);

(statearr_24321[(8)] = inst_24156);

(statearr_24321[(9)] = inst_24157);

(statearr_24321[(10)] = inst_24158);

return statearr_24321;
})();
var statearr_24322_24403 = state_24295__$1;
(statearr_24322_24403[(2)] = null);

(statearr_24322_24403[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (22))){
var inst_24212 = (state_24295[(23)]);
var inst_24209 = (state_24295[(19)]);
var inst_24217 = (state_24295[(24)]);
var inst_24213 = (state_24295[(25)]);
var inst_24212__$1 = (state_24295[(2)]);
var inst_24213__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24212__$1);
var inst_24214 = (function (){var all_files = inst_24209;
var res_SINGLEQUOTE_ = inst_24212__$1;
var res = inst_24213__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_24212,inst_24209,inst_24217,inst_24213,inst_24212__$1,inst_24213__$1,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23892_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__23892_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_24212,inst_24209,inst_24217,inst_24213,inst_24212__$1,inst_24213__$1,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24215 = cljs.core.filter.call(null,inst_24214,inst_24212__$1);
var inst_24216 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_24217__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24216);
var inst_24218 = cljs.core.not_empty.call(null,inst_24217__$1);
var state_24295__$1 = (function (){var statearr_24323 = state_24295;
(statearr_24323[(23)] = inst_24212__$1);

(statearr_24323[(26)] = inst_24215);

(statearr_24323[(24)] = inst_24217__$1);

(statearr_24323[(25)] = inst_24213__$1);

return statearr_24323;
})();
if(cljs.core.truth_(inst_24218)){
var statearr_24324_24404 = state_24295__$1;
(statearr_24324_24404[(1)] = (23));

} else {
var statearr_24325_24405 = state_24295__$1;
(statearr_24325_24405[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (36))){
var state_24295__$1 = state_24295;
var statearr_24326_24406 = state_24295__$1;
(statearr_24326_24406[(2)] = false);

(statearr_24326_24406[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (41))){
var inst_24270 = (state_24295[(20)]);
var inst_24274 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_24275 = cljs.core.map.call(null,inst_24274,inst_24270);
var inst_24276 = cljs.core.pr_str.call(null,inst_24275);
var inst_24277 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_24276)].join('');
var inst_24278 = figwheel.client.utils.log.call(null,inst_24277);
var state_24295__$1 = state_24295;
var statearr_24327_24407 = state_24295__$1;
(statearr_24327_24407[(2)] = inst_24278);

(statearr_24327_24407[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (43))){
var inst_24271 = (state_24295[(21)]);
var inst_24281 = (state_24295[(2)]);
var inst_24282 = cljs.core.not_empty.call(null,inst_24271);
var state_24295__$1 = (function (){var statearr_24328 = state_24295;
(statearr_24328[(27)] = inst_24281);

return statearr_24328;
})();
if(cljs.core.truth_(inst_24282)){
var statearr_24329_24408 = state_24295__$1;
(statearr_24329_24408[(1)] = (44));

} else {
var statearr_24330_24409 = state_24295__$1;
(statearr_24330_24409[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (29))){
var inst_24212 = (state_24295[(23)]);
var inst_24209 = (state_24295[(19)]);
var inst_24215 = (state_24295[(26)]);
var inst_24217 = (state_24295[(24)]);
var inst_24249 = (state_24295[(16)]);
var inst_24213 = (state_24295[(25)]);
var inst_24245 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_24248 = (function (){var all_files = inst_24209;
var res_SINGLEQUOTE_ = inst_24212;
var res = inst_24213;
var files_not_loaded = inst_24215;
var dependencies_that_loaded = inst_24217;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24249,inst_24213,inst_24245,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24247){
var map__24331 = p__24247;
var map__24331__$1 = ((((!((map__24331 == null)))?((((map__24331.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24331.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24331):map__24331);
var namespace = cljs.core.get.call(null,map__24331__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24249,inst_24213,inst_24245,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24249__$1 = cljs.core.group_by.call(null,inst_24248,inst_24215);
var inst_24251 = (inst_24249__$1 == null);
var inst_24252 = cljs.core.not.call(null,inst_24251);
var state_24295__$1 = (function (){var statearr_24333 = state_24295;
(statearr_24333[(28)] = inst_24245);

(statearr_24333[(16)] = inst_24249__$1);

return statearr_24333;
})();
if(inst_24252){
var statearr_24334_24410 = state_24295__$1;
(statearr_24334_24410[(1)] = (32));

} else {
var statearr_24335_24411 = state_24295__$1;
(statearr_24335_24411[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (44))){
var inst_24271 = (state_24295[(21)]);
var inst_24284 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24271);
var inst_24285 = cljs.core.pr_str.call(null,inst_24284);
var inst_24286 = [cljs.core.str("not required: "),cljs.core.str(inst_24285)].join('');
var inst_24287 = figwheel.client.utils.log.call(null,inst_24286);
var state_24295__$1 = state_24295;
var statearr_24336_24412 = state_24295__$1;
(statearr_24336_24412[(2)] = inst_24287);

(statearr_24336_24412[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (6))){
var inst_24190 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24337_24413 = state_24295__$1;
(statearr_24337_24413[(2)] = inst_24190);

(statearr_24337_24413[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (28))){
var inst_24215 = (state_24295[(26)]);
var inst_24242 = (state_24295[(2)]);
var inst_24243 = cljs.core.not_empty.call(null,inst_24215);
var state_24295__$1 = (function (){var statearr_24338 = state_24295;
(statearr_24338[(29)] = inst_24242);

return statearr_24338;
})();
if(cljs.core.truth_(inst_24243)){
var statearr_24339_24414 = state_24295__$1;
(statearr_24339_24414[(1)] = (29));

} else {
var statearr_24340_24415 = state_24295__$1;
(statearr_24340_24415[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (25))){
var inst_24213 = (state_24295[(25)]);
var inst_24229 = (state_24295[(2)]);
var inst_24230 = cljs.core.not_empty.call(null,inst_24213);
var state_24295__$1 = (function (){var statearr_24341 = state_24295;
(statearr_24341[(30)] = inst_24229);

return statearr_24341;
})();
if(cljs.core.truth_(inst_24230)){
var statearr_24342_24416 = state_24295__$1;
(statearr_24342_24416[(1)] = (26));

} else {
var statearr_24343_24417 = state_24295__$1;
(statearr_24343_24417[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (34))){
var inst_24264 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
if(cljs.core.truth_(inst_24264)){
var statearr_24344_24418 = state_24295__$1;
(statearr_24344_24418[(1)] = (38));

} else {
var statearr_24345_24419 = state_24295__$1;
(statearr_24345_24419[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (17))){
var state_24295__$1 = state_24295;
var statearr_24346_24420 = state_24295__$1;
(statearr_24346_24420[(2)] = recompile_dependents);

(statearr_24346_24420[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (3))){
var state_24295__$1 = state_24295;
var statearr_24347_24421 = state_24295__$1;
(statearr_24347_24421[(2)] = null);

(statearr_24347_24421[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (12))){
var inst_24186 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24348_24422 = state_24295__$1;
(statearr_24348_24422[(2)] = inst_24186);

(statearr_24348_24422[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (2))){
var inst_24148 = (state_24295[(13)]);
var inst_24155 = cljs.core.seq.call(null,inst_24148);
var inst_24156 = inst_24155;
var inst_24157 = null;
var inst_24158 = (0);
var inst_24159 = (0);
var state_24295__$1 = (function (){var statearr_24349 = state_24295;
(statearr_24349[(7)] = inst_24159);

(statearr_24349[(8)] = inst_24156);

(statearr_24349[(9)] = inst_24157);

(statearr_24349[(10)] = inst_24158);

return statearr_24349;
})();
var statearr_24350_24423 = state_24295__$1;
(statearr_24350_24423[(2)] = null);

(statearr_24350_24423[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (23))){
var inst_24212 = (state_24295[(23)]);
var inst_24209 = (state_24295[(19)]);
var inst_24215 = (state_24295[(26)]);
var inst_24217 = (state_24295[(24)]);
var inst_24213 = (state_24295[(25)]);
var inst_24220 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_24222 = (function (){var all_files = inst_24209;
var res_SINGLEQUOTE_ = inst_24212;
var res = inst_24213;
var files_not_loaded = inst_24215;
var dependencies_that_loaded = inst_24217;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24220,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24221){
var map__24351 = p__24221;
var map__24351__$1 = ((((!((map__24351 == null)))?((((map__24351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24351):map__24351);
var request_url = cljs.core.get.call(null,map__24351__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24220,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24223 = cljs.core.reverse.call(null,inst_24217);
var inst_24224 = cljs.core.map.call(null,inst_24222,inst_24223);
var inst_24225 = cljs.core.pr_str.call(null,inst_24224);
var inst_24226 = figwheel.client.utils.log.call(null,inst_24225);
var state_24295__$1 = (function (){var statearr_24353 = state_24295;
(statearr_24353[(31)] = inst_24220);

return statearr_24353;
})();
var statearr_24354_24424 = state_24295__$1;
(statearr_24354_24424[(2)] = inst_24226);

(statearr_24354_24424[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (35))){
var state_24295__$1 = state_24295;
var statearr_24355_24425 = state_24295__$1;
(statearr_24355_24425[(2)] = true);

(statearr_24355_24425[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (19))){
var inst_24199 = (state_24295[(12)]);
var inst_24205 = figwheel.client.file_reloading.expand_files.call(null,inst_24199);
var state_24295__$1 = state_24295;
var statearr_24356_24426 = state_24295__$1;
(statearr_24356_24426[(2)] = inst_24205);

(statearr_24356_24426[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (11))){
var state_24295__$1 = state_24295;
var statearr_24357_24427 = state_24295__$1;
(statearr_24357_24427[(2)] = null);

(statearr_24357_24427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (9))){
var inst_24188 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24358_24428 = state_24295__$1;
(statearr_24358_24428[(2)] = inst_24188);

(statearr_24358_24428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (5))){
var inst_24159 = (state_24295[(7)]);
var inst_24158 = (state_24295[(10)]);
var inst_24161 = (inst_24159 < inst_24158);
var inst_24162 = inst_24161;
var state_24295__$1 = state_24295;
if(cljs.core.truth_(inst_24162)){
var statearr_24359_24429 = state_24295__$1;
(statearr_24359_24429[(1)] = (7));

} else {
var statearr_24360_24430 = state_24295__$1;
(statearr_24360_24430[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (14))){
var inst_24169 = (state_24295[(22)]);
var inst_24178 = cljs.core.first.call(null,inst_24169);
var inst_24179 = figwheel.client.file_reloading.eval_body.call(null,inst_24178,opts);
var inst_24180 = cljs.core.next.call(null,inst_24169);
var inst_24156 = inst_24180;
var inst_24157 = null;
var inst_24158 = (0);
var inst_24159 = (0);
var state_24295__$1 = (function (){var statearr_24361 = state_24295;
(statearr_24361[(7)] = inst_24159);

(statearr_24361[(32)] = inst_24179);

(statearr_24361[(8)] = inst_24156);

(statearr_24361[(9)] = inst_24157);

(statearr_24361[(10)] = inst_24158);

return statearr_24361;
})();
var statearr_24362_24431 = state_24295__$1;
(statearr_24362_24431[(2)] = null);

(statearr_24362_24431[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (45))){
var state_24295__$1 = state_24295;
var statearr_24363_24432 = state_24295__$1;
(statearr_24363_24432[(2)] = null);

(statearr_24363_24432[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (26))){
var inst_24212 = (state_24295[(23)]);
var inst_24209 = (state_24295[(19)]);
var inst_24215 = (state_24295[(26)]);
var inst_24217 = (state_24295[(24)]);
var inst_24213 = (state_24295[(25)]);
var inst_24232 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_24234 = (function (){var all_files = inst_24209;
var res_SINGLEQUOTE_ = inst_24212;
var res = inst_24213;
var files_not_loaded = inst_24215;
var dependencies_that_loaded = inst_24217;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24232,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24233){
var map__24364 = p__24233;
var map__24364__$1 = ((((!((map__24364 == null)))?((((map__24364.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24364.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24364):map__24364);
var namespace = cljs.core.get.call(null,map__24364__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__24364__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24232,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24235 = cljs.core.map.call(null,inst_24234,inst_24213);
var inst_24236 = cljs.core.pr_str.call(null,inst_24235);
var inst_24237 = figwheel.client.utils.log.call(null,inst_24236);
var inst_24238 = (function (){var all_files = inst_24209;
var res_SINGLEQUOTE_ = inst_24212;
var res = inst_24213;
var files_not_loaded = inst_24215;
var dependencies_that_loaded = inst_24217;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24232,inst_24234,inst_24235,inst_24236,inst_24237,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24212,inst_24209,inst_24215,inst_24217,inst_24213,inst_24232,inst_24234,inst_24235,inst_24236,inst_24237,state_val_24296,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24239 = setTimeout(inst_24238,(10));
var state_24295__$1 = (function (){var statearr_24366 = state_24295;
(statearr_24366[(33)] = inst_24232);

(statearr_24366[(34)] = inst_24237);

return statearr_24366;
})();
var statearr_24367_24433 = state_24295__$1;
(statearr_24367_24433[(2)] = inst_24239);

(statearr_24367_24433[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (16))){
var state_24295__$1 = state_24295;
var statearr_24368_24434 = state_24295__$1;
(statearr_24368_24434[(2)] = reload_dependents);

(statearr_24368_24434[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (38))){
var inst_24249 = (state_24295[(16)]);
var inst_24266 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24249);
var state_24295__$1 = state_24295;
var statearr_24369_24435 = state_24295__$1;
(statearr_24369_24435[(2)] = inst_24266);

(statearr_24369_24435[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (30))){
var state_24295__$1 = state_24295;
var statearr_24370_24436 = state_24295__$1;
(statearr_24370_24436[(2)] = null);

(statearr_24370_24436[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (10))){
var inst_24169 = (state_24295[(22)]);
var inst_24171 = cljs.core.chunked_seq_QMARK_.call(null,inst_24169);
var state_24295__$1 = state_24295;
if(inst_24171){
var statearr_24371_24437 = state_24295__$1;
(statearr_24371_24437[(1)] = (13));

} else {
var statearr_24372_24438 = state_24295__$1;
(statearr_24372_24438[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (18))){
var inst_24203 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
if(cljs.core.truth_(inst_24203)){
var statearr_24373_24439 = state_24295__$1;
(statearr_24373_24439[(1)] = (19));

} else {
var statearr_24374_24440 = state_24295__$1;
(statearr_24374_24440[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (42))){
var state_24295__$1 = state_24295;
var statearr_24375_24441 = state_24295__$1;
(statearr_24375_24441[(2)] = null);

(statearr_24375_24441[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (37))){
var inst_24261 = (state_24295[(2)]);
var state_24295__$1 = state_24295;
var statearr_24376_24442 = state_24295__$1;
(statearr_24376_24442[(2)] = inst_24261);

(statearr_24376_24442[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24296 === (8))){
var inst_24156 = (state_24295[(8)]);
var inst_24169 = (state_24295[(22)]);
var inst_24169__$1 = cljs.core.seq.call(null,inst_24156);
var state_24295__$1 = (function (){var statearr_24377 = state_24295;
(statearr_24377[(22)] = inst_24169__$1);

return statearr_24377;
})();
if(inst_24169__$1){
var statearr_24378_24443 = state_24295__$1;
(statearr_24378_24443[(1)] = (10));

} else {
var statearr_24379_24444 = state_24295__$1;
(statearr_24379_24444[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20446__auto__,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____0 = (function (){
var statearr_24383 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24383[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__);

(statearr_24383[(1)] = (1));

return statearr_24383;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____1 = (function (state_24295){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_24295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e24384){if((e24384 instanceof Object)){
var ex__20450__auto__ = e24384;
var statearr_24385_24445 = state_24295;
(statearr_24385_24445[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24295);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24446 = state_24295;
state_24295 = G__24446;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__ = function(state_24295){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____1.call(this,state_24295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20560__auto__ = (function (){var statearr_24386 = f__20559__auto__.call(null);
(statearr_24386[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_24386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__,map__24141,map__24141__$1,opts,before_jsload,on_jsload,reload_dependents,map__24142,map__24142__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20558__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__24449,link){
var map__24452 = p__24449;
var map__24452__$1 = ((((!((map__24452 == null)))?((((map__24452.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24452.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24452):map__24452);
var file = cljs.core.get.call(null,map__24452__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__24452,map__24452__$1,file){
return (function (p1__24447_SHARP_,p2__24448_SHARP_){
if(cljs.core._EQ_.call(null,p1__24447_SHARP_,p2__24448_SHARP_)){
return p1__24447_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__24452,map__24452__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__24458){
var map__24459 = p__24458;
var map__24459__$1 = ((((!((map__24459 == null)))?((((map__24459.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24459.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24459):map__24459);
var match_length = cljs.core.get.call(null,map__24459__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__24459__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__24454_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__24454_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args24461 = [];
var len__19463__auto___24464 = arguments.length;
var i__19464__auto___24465 = (0);
while(true){
if((i__19464__auto___24465 < len__19463__auto___24464)){
args24461.push((arguments[i__19464__auto___24465]));

var G__24466 = (i__19464__auto___24465 + (1));
i__19464__auto___24465 = G__24466;
continue;
} else {
}
break;
}

var G__24463 = args24461.length;
switch (G__24463) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24461.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__24468_SHARP_,p2__24469_SHARP_){
return cljs.core.assoc.call(null,p1__24468_SHARP_,cljs.core.get.call(null,p2__24469_SHARP_,key),p2__24469_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__24470){
var map__24473 = p__24470;
var map__24473__$1 = ((((!((map__24473 == null)))?((((map__24473.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24473.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24473):map__24473);
var f_data = map__24473__$1;
var file = cljs.core.get.call(null,map__24473__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__24475,files_msg){
var map__24482 = p__24475;
var map__24482__$1 = ((((!((map__24482 == null)))?((((map__24482.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24482.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24482):map__24482);
var opts = map__24482__$1;
var on_cssload = cljs.core.get.call(null,map__24482__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__24484_24488 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__24485_24489 = null;
var count__24486_24490 = (0);
var i__24487_24491 = (0);
while(true){
if((i__24487_24491 < count__24486_24490)){
var f_24492 = cljs.core._nth.call(null,chunk__24485_24489,i__24487_24491);
figwheel.client.file_reloading.reload_css_file.call(null,f_24492);

var G__24493 = seq__24484_24488;
var G__24494 = chunk__24485_24489;
var G__24495 = count__24486_24490;
var G__24496 = (i__24487_24491 + (1));
seq__24484_24488 = G__24493;
chunk__24485_24489 = G__24494;
count__24486_24490 = G__24495;
i__24487_24491 = G__24496;
continue;
} else {
var temp__4657__auto___24497 = cljs.core.seq.call(null,seq__24484_24488);
if(temp__4657__auto___24497){
var seq__24484_24498__$1 = temp__4657__auto___24497;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24484_24498__$1)){
var c__19208__auto___24499 = cljs.core.chunk_first.call(null,seq__24484_24498__$1);
var G__24500 = cljs.core.chunk_rest.call(null,seq__24484_24498__$1);
var G__24501 = c__19208__auto___24499;
var G__24502 = cljs.core.count.call(null,c__19208__auto___24499);
var G__24503 = (0);
seq__24484_24488 = G__24500;
chunk__24485_24489 = G__24501;
count__24486_24490 = G__24502;
i__24487_24491 = G__24503;
continue;
} else {
var f_24504 = cljs.core.first.call(null,seq__24484_24498__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_24504);

var G__24505 = cljs.core.next.call(null,seq__24484_24498__$1);
var G__24506 = null;
var G__24507 = (0);
var G__24508 = (0);
seq__24484_24488 = G__24505;
chunk__24485_24489 = G__24506;
count__24486_24490 = G__24507;
i__24487_24491 = G__24508;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__24482,map__24482__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__24482,map__24482__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map