// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__41710 = cljs.core._EQ_;
var expr__41711 = (function (){var or__18405__auto__ = (function (){try{return localStorage.getItem("figwheel_autoload");
}catch (e41714){if((e41714 instanceof Error)){
var e = e41714;
return false;
} else {
throw e41714;

}
}})();
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__41710.call(null,"true",expr__41711))){
return true;
} else {
if(cljs.core.truth_(pred__41710.call(null,"false",expr__41711))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__41711)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
try{localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
}catch (e41716){if((e41716 instanceof Error)){
var e = e41716;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Unable to access localStorage")].join(''));
} else {
throw e41716;

}
}} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.repl_print_fn = (function figwheel$client$repl_print_fn(var_args){
var args__19470__auto__ = [];
var len__19463__auto___41718 = arguments.length;
var i__19464__auto___41719 = (0);
while(true){
if((i__19464__auto___41719 < len__19463__auto___41718)){
args__19470__auto__.push((arguments[i__19464__auto___41719]));

var G__41720 = (i__19464__auto___41719 + (1));
i__19464__auto___41719 = G__41720;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((0) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((0)),(0))):null);
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__19471__auto__);
});

figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));

return null;
});

figwheel.client.repl_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_print_fn.cljs$lang$applyTo = (function (seq41717){
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41717));
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__41721){
var map__41724 = p__41721;
var map__41724__$1 = ((((!((map__41724 == null)))?((((map__41724.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41724.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41724):map__41724);
var message = cljs.core.get.call(null,map__41724__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__41724__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__18405__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__18393__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__18393__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__18393__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__20558__auto___41886 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___41886,ch){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___41886,ch){
return (function (state_41855){
var state_val_41856 = (state_41855[(1)]);
if((state_val_41856 === (7))){
var inst_41851 = (state_41855[(2)]);
var state_41855__$1 = state_41855;
var statearr_41857_41887 = state_41855__$1;
(statearr_41857_41887[(2)] = inst_41851);

(statearr_41857_41887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (1))){
var state_41855__$1 = state_41855;
var statearr_41858_41888 = state_41855__$1;
(statearr_41858_41888[(2)] = null);

(statearr_41858_41888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (4))){
var inst_41808 = (state_41855[(7)]);
var inst_41808__$1 = (state_41855[(2)]);
var state_41855__$1 = (function (){var statearr_41859 = state_41855;
(statearr_41859[(7)] = inst_41808__$1);

return statearr_41859;
})();
if(cljs.core.truth_(inst_41808__$1)){
var statearr_41860_41889 = state_41855__$1;
(statearr_41860_41889[(1)] = (5));

} else {
var statearr_41861_41890 = state_41855__$1;
(statearr_41861_41890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (15))){
var inst_41815 = (state_41855[(8)]);
var inst_41830 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_41815);
var inst_41831 = cljs.core.first.call(null,inst_41830);
var inst_41832 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_41831);
var inst_41833 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_41832)].join('');
var inst_41834 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_41833);
var state_41855__$1 = state_41855;
var statearr_41862_41891 = state_41855__$1;
(statearr_41862_41891[(2)] = inst_41834);

(statearr_41862_41891[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (13))){
var inst_41839 = (state_41855[(2)]);
var state_41855__$1 = state_41855;
var statearr_41863_41892 = state_41855__$1;
(statearr_41863_41892[(2)] = inst_41839);

(statearr_41863_41892[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (6))){
var state_41855__$1 = state_41855;
var statearr_41864_41893 = state_41855__$1;
(statearr_41864_41893[(2)] = null);

(statearr_41864_41893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (17))){
var inst_41837 = (state_41855[(2)]);
var state_41855__$1 = state_41855;
var statearr_41865_41894 = state_41855__$1;
(statearr_41865_41894[(2)] = inst_41837);

(statearr_41865_41894[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (3))){
var inst_41853 = (state_41855[(2)]);
var state_41855__$1 = state_41855;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41855__$1,inst_41853);
} else {
if((state_val_41856 === (12))){
var inst_41814 = (state_41855[(9)]);
var inst_41828 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_41814,opts);
var state_41855__$1 = state_41855;
if(cljs.core.truth_(inst_41828)){
var statearr_41866_41895 = state_41855__$1;
(statearr_41866_41895[(1)] = (15));

} else {
var statearr_41867_41896 = state_41855__$1;
(statearr_41867_41896[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (2))){
var state_41855__$1 = state_41855;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41855__$1,(4),ch);
} else {
if((state_val_41856 === (11))){
var inst_41815 = (state_41855[(8)]);
var inst_41820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41821 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_41815);
var inst_41822 = cljs.core.async.timeout.call(null,(1000));
var inst_41823 = [inst_41821,inst_41822];
var inst_41824 = (new cljs.core.PersistentVector(null,2,(5),inst_41820,inst_41823,null));
var state_41855__$1 = state_41855;
return cljs.core.async.ioc_alts_BANG_.call(null,state_41855__$1,(14),inst_41824);
} else {
if((state_val_41856 === (9))){
var inst_41815 = (state_41855[(8)]);
var inst_41841 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_41842 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_41815);
var inst_41843 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_41842);
var inst_41844 = [cljs.core.str("Not loading: "),cljs.core.str(inst_41843)].join('');
var inst_41845 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_41844);
var state_41855__$1 = (function (){var statearr_41868 = state_41855;
(statearr_41868[(10)] = inst_41841);

return statearr_41868;
})();
var statearr_41869_41897 = state_41855__$1;
(statearr_41869_41897[(2)] = inst_41845);

(statearr_41869_41897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (5))){
var inst_41808 = (state_41855[(7)]);
var inst_41810 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_41811 = (new cljs.core.PersistentArrayMap(null,2,inst_41810,null));
var inst_41812 = (new cljs.core.PersistentHashSet(null,inst_41811,null));
var inst_41813 = figwheel.client.focus_msgs.call(null,inst_41812,inst_41808);
var inst_41814 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_41813);
var inst_41815 = cljs.core.first.call(null,inst_41813);
var inst_41816 = figwheel.client.autoload_QMARK_.call(null);
var state_41855__$1 = (function (){var statearr_41870 = state_41855;
(statearr_41870[(9)] = inst_41814);

(statearr_41870[(8)] = inst_41815);

return statearr_41870;
})();
if(cljs.core.truth_(inst_41816)){
var statearr_41871_41898 = state_41855__$1;
(statearr_41871_41898[(1)] = (8));

} else {
var statearr_41872_41899 = state_41855__$1;
(statearr_41872_41899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (14))){
var inst_41826 = (state_41855[(2)]);
var state_41855__$1 = state_41855;
var statearr_41873_41900 = state_41855__$1;
(statearr_41873_41900[(2)] = inst_41826);

(statearr_41873_41900[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (16))){
var state_41855__$1 = state_41855;
var statearr_41874_41901 = state_41855__$1;
(statearr_41874_41901[(2)] = null);

(statearr_41874_41901[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (10))){
var inst_41847 = (state_41855[(2)]);
var state_41855__$1 = (function (){var statearr_41875 = state_41855;
(statearr_41875[(11)] = inst_41847);

return statearr_41875;
})();
var statearr_41876_41902 = state_41855__$1;
(statearr_41876_41902[(2)] = null);

(statearr_41876_41902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41856 === (8))){
var inst_41814 = (state_41855[(9)]);
var inst_41818 = figwheel.client.reload_file_state_QMARK_.call(null,inst_41814,opts);
var state_41855__$1 = state_41855;
if(cljs.core.truth_(inst_41818)){
var statearr_41877_41903 = state_41855__$1;
(statearr_41877_41903[(1)] = (11));

} else {
var statearr_41878_41904 = state_41855__$1;
(statearr_41878_41904[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___41886,ch))
;
return ((function (switch__20446__auto__,c__20558__auto___41886,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_41882 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41882[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__);

(statearr_41882[(1)] = (1));

return statearr_41882;
});
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1 = (function (state_41855){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_41855);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e41883){if((e41883 instanceof Object)){
var ex__20450__auto__ = e41883;
var statearr_41884_41905 = state_41855;
(statearr_41884_41905[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41855);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41906 = state_41855;
state_41855 = G__41906;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__ = function(state_41855){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1.call(this,state_41855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___41886,ch))
})();
var state__20560__auto__ = (function (){var statearr_41885 = f__20559__auto__.call(null);
(statearr_41885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___41886);

return statearr_41885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___41886,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__41907_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__41907_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_41914 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_41914){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_41912 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_41913 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),figwheel.client.utils.eval_helper.call(null,code,opts)], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_41913;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_41912;
}}catch (e41911){if((e41911 instanceof Error)){
var e = e41911;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_41914], null));
} else {
var e = e41911;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_41914))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__41915){
var map__41922 = p__41915;
var map__41922__$1 = ((((!((map__41922 == null)))?((((map__41922.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41922.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41922):map__41922);
var opts = map__41922__$1;
var build_id = cljs.core.get.call(null,map__41922__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__41922,map__41922__$1,opts,build_id){
return (function (p__41924){
var vec__41925 = p__41924;
var map__41926 = cljs.core.nth.call(null,vec__41925,(0),null);
var map__41926__$1 = ((((!((map__41926 == null)))?((((map__41926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41926):map__41926);
var msg = map__41926__$1;
var msg_name = cljs.core.get.call(null,map__41926__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41925,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__41925,map__41926,map__41926__$1,msg,msg_name,_,map__41922,map__41922__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__41925,map__41926,map__41926__$1,msg,msg_name,_,map__41922,map__41922__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__41922,map__41922__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__41932){
var vec__41933 = p__41932;
var map__41934 = cljs.core.nth.call(null,vec__41933,(0),null);
var map__41934__$1 = ((((!((map__41934 == null)))?((((map__41934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41934):map__41934);
var msg = map__41934__$1;
var msg_name = cljs.core.get.call(null,map__41934__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41933,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__41936){
var map__41946 = p__41936;
var map__41946__$1 = ((((!((map__41946 == null)))?((((map__41946.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41946.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41946):map__41946);
var on_compile_warning = cljs.core.get.call(null,map__41946__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__41946__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__41946,map__41946__$1,on_compile_warning,on_compile_fail){
return (function (p__41948){
var vec__41949 = p__41948;
var map__41950 = cljs.core.nth.call(null,vec__41949,(0),null);
var map__41950__$1 = ((((!((map__41950 == null)))?((((map__41950.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41950.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41950):map__41950);
var msg = map__41950__$1;
var msg_name = cljs.core.get.call(null,map__41950__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41949,(1));
var pred__41952 = cljs.core._EQ_;
var expr__41953 = msg_name;
if(cljs.core.truth_(pred__41952.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__41953))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__41952.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__41953))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__41946,map__41946__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__,msg_hist,msg_names,msg){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__,msg_hist,msg_names,msg){
return (function (state_42169){
var state_val_42170 = (state_42169[(1)]);
if((state_val_42170 === (7))){
var inst_42093 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42093)){
var statearr_42171_42217 = state_42169__$1;
(statearr_42171_42217[(1)] = (8));

} else {
var statearr_42172_42218 = state_42169__$1;
(statearr_42172_42218[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (20))){
var inst_42163 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42173_42219 = state_42169__$1;
(statearr_42173_42219[(2)] = inst_42163);

(statearr_42173_42219[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (27))){
var inst_42159 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42174_42220 = state_42169__$1;
(statearr_42174_42220[(2)] = inst_42159);

(statearr_42174_42220[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (1))){
var inst_42086 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42086)){
var statearr_42175_42221 = state_42169__$1;
(statearr_42175_42221[(1)] = (2));

} else {
var statearr_42176_42222 = state_42169__$1;
(statearr_42176_42222[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (24))){
var inst_42161 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42177_42223 = state_42169__$1;
(statearr_42177_42223[(2)] = inst_42161);

(statearr_42177_42223[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (4))){
var inst_42167 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42169__$1,inst_42167);
} else {
if((state_val_42170 === (15))){
var inst_42165 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42178_42224 = state_42169__$1;
(statearr_42178_42224[(2)] = inst_42165);

(statearr_42178_42224[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (21))){
var inst_42124 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42179_42225 = state_42169__$1;
(statearr_42179_42225[(2)] = inst_42124);

(statearr_42179_42225[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (31))){
var inst_42148 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42148)){
var statearr_42180_42226 = state_42169__$1;
(statearr_42180_42226[(1)] = (34));

} else {
var statearr_42181_42227 = state_42169__$1;
(statearr_42181_42227[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (32))){
var inst_42157 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42182_42228 = state_42169__$1;
(statearr_42182_42228[(2)] = inst_42157);

(statearr_42182_42228[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (33))){
var inst_42146 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42183_42229 = state_42169__$1;
(statearr_42183_42229[(2)] = inst_42146);

(statearr_42183_42229[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (13))){
var inst_42107 = figwheel.client.heads_up.clear.call(null);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(16),inst_42107);
} else {
if((state_val_42170 === (22))){
var inst_42128 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42129 = figwheel.client.heads_up.append_message.call(null,inst_42128);
var state_42169__$1 = state_42169;
var statearr_42184_42230 = state_42169__$1;
(statearr_42184_42230[(2)] = inst_42129);

(statearr_42184_42230[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (36))){
var inst_42155 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42185_42231 = state_42169__$1;
(statearr_42185_42231[(2)] = inst_42155);

(statearr_42185_42231[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (29))){
var inst_42139 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42186_42232 = state_42169__$1;
(statearr_42186_42232[(2)] = inst_42139);

(statearr_42186_42232[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (6))){
var inst_42088 = (state_42169[(7)]);
var state_42169__$1 = state_42169;
var statearr_42187_42233 = state_42169__$1;
(statearr_42187_42233[(2)] = inst_42088);

(statearr_42187_42233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (28))){
var inst_42135 = (state_42169[(2)]);
var inst_42136 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42137 = figwheel.client.heads_up.display_warning.call(null,inst_42136);
var state_42169__$1 = (function (){var statearr_42188 = state_42169;
(statearr_42188[(8)] = inst_42135);

return statearr_42188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(29),inst_42137);
} else {
if((state_val_42170 === (25))){
var inst_42133 = figwheel.client.heads_up.clear.call(null);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(28),inst_42133);
} else {
if((state_val_42170 === (34))){
var inst_42150 = figwheel.client.heads_up.flash_loaded.call(null);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(37),inst_42150);
} else {
if((state_val_42170 === (17))){
var inst_42115 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42189_42234 = state_42169__$1;
(statearr_42189_42234[(2)] = inst_42115);

(statearr_42189_42234[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (3))){
var inst_42105 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42105)){
var statearr_42190_42235 = state_42169__$1;
(statearr_42190_42235[(1)] = (13));

} else {
var statearr_42191_42236 = state_42169__$1;
(statearr_42191_42236[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (12))){
var inst_42101 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42192_42237 = state_42169__$1;
(statearr_42192_42237[(2)] = inst_42101);

(statearr_42192_42237[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (2))){
var inst_42088 = (state_42169[(7)]);
var inst_42088__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_42169__$1 = (function (){var statearr_42193 = state_42169;
(statearr_42193[(7)] = inst_42088__$1);

return statearr_42193;
})();
if(cljs.core.truth_(inst_42088__$1)){
var statearr_42194_42238 = state_42169__$1;
(statearr_42194_42238[(1)] = (5));

} else {
var statearr_42195_42239 = state_42169__$1;
(statearr_42195_42239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (23))){
var inst_42131 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42131)){
var statearr_42196_42240 = state_42169__$1;
(statearr_42196_42240[(1)] = (25));

} else {
var statearr_42197_42241 = state_42169__$1;
(statearr_42197_42241[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (35))){
var state_42169__$1 = state_42169;
var statearr_42198_42242 = state_42169__$1;
(statearr_42198_42242[(2)] = null);

(statearr_42198_42242[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (19))){
var inst_42126 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42126)){
var statearr_42199_42243 = state_42169__$1;
(statearr_42199_42243[(1)] = (22));

} else {
var statearr_42200_42244 = state_42169__$1;
(statearr_42200_42244[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (11))){
var inst_42097 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42201_42245 = state_42169__$1;
(statearr_42201_42245[(2)] = inst_42097);

(statearr_42201_42245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (9))){
var inst_42099 = figwheel.client.heads_up.clear.call(null);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(12),inst_42099);
} else {
if((state_val_42170 === (5))){
var inst_42090 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_42169__$1 = state_42169;
var statearr_42202_42246 = state_42169__$1;
(statearr_42202_42246[(2)] = inst_42090);

(statearr_42202_42246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (14))){
var inst_42117 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42117)){
var statearr_42203_42247 = state_42169__$1;
(statearr_42203_42247[(1)] = (18));

} else {
var statearr_42204_42248 = state_42169__$1;
(statearr_42204_42248[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (26))){
var inst_42141 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_42169__$1 = state_42169;
if(cljs.core.truth_(inst_42141)){
var statearr_42205_42249 = state_42169__$1;
(statearr_42205_42249[(1)] = (30));

} else {
var statearr_42206_42250 = state_42169__$1;
(statearr_42206_42250[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (16))){
var inst_42109 = (state_42169[(2)]);
var inst_42110 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42111 = figwheel.client.format_messages.call(null,inst_42110);
var inst_42112 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42113 = figwheel.client.heads_up.display_error.call(null,inst_42111,inst_42112);
var state_42169__$1 = (function (){var statearr_42207 = state_42169;
(statearr_42207[(9)] = inst_42109);

return statearr_42207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(17),inst_42113);
} else {
if((state_val_42170 === (30))){
var inst_42143 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42144 = figwheel.client.heads_up.display_warning.call(null,inst_42143);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(33),inst_42144);
} else {
if((state_val_42170 === (10))){
var inst_42103 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42208_42251 = state_42169__$1;
(statearr_42208_42251[(2)] = inst_42103);

(statearr_42208_42251[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (18))){
var inst_42119 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42120 = figwheel.client.format_messages.call(null,inst_42119);
var inst_42121 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_42122 = figwheel.client.heads_up.display_error.call(null,inst_42120,inst_42121);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(21),inst_42122);
} else {
if((state_val_42170 === (37))){
var inst_42152 = (state_42169[(2)]);
var state_42169__$1 = state_42169;
var statearr_42209_42252 = state_42169__$1;
(statearr_42209_42252[(2)] = inst_42152);

(statearr_42209_42252[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42170 === (8))){
var inst_42095 = figwheel.client.heads_up.flash_loaded.call(null);
var state_42169__$1 = state_42169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42169__$1,(11),inst_42095);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__20446__auto__,c__20558__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0 = (function (){
var statearr_42213 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42213[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__);

(statearr_42213[(1)] = (1));

return statearr_42213;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1 = (function (state_42169){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_42169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e42214){if((e42214 instanceof Object)){
var ex__20450__auto__ = e42214;
var statearr_42215_42253 = state_42169;
(statearr_42215_42253[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42214;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42254 = state_42169;
state_42169 = G__42254;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__ = function(state_42169){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1.call(this,state_42169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__,msg_hist,msg_names,msg))
})();
var state__20560__auto__ = (function (){var statearr_42216 = f__20559__auto__.call(null);
(statearr_42216[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_42216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__,msg_hist,msg_names,msg))
);

return c__20558__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__20558__auto___42317 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___42317,ch){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___42317,ch){
return (function (state_42300){
var state_val_42301 = (state_42300[(1)]);
if((state_val_42301 === (1))){
var state_42300__$1 = state_42300;
var statearr_42302_42318 = state_42300__$1;
(statearr_42302_42318[(2)] = null);

(statearr_42302_42318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42301 === (2))){
var state_42300__$1 = state_42300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42300__$1,(4),ch);
} else {
if((state_val_42301 === (3))){
var inst_42298 = (state_42300[(2)]);
var state_42300__$1 = state_42300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42300__$1,inst_42298);
} else {
if((state_val_42301 === (4))){
var inst_42288 = (state_42300[(7)]);
var inst_42288__$1 = (state_42300[(2)]);
var state_42300__$1 = (function (){var statearr_42303 = state_42300;
(statearr_42303[(7)] = inst_42288__$1);

return statearr_42303;
})();
if(cljs.core.truth_(inst_42288__$1)){
var statearr_42304_42319 = state_42300__$1;
(statearr_42304_42319[(1)] = (5));

} else {
var statearr_42305_42320 = state_42300__$1;
(statearr_42305_42320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42301 === (5))){
var inst_42288 = (state_42300[(7)]);
var inst_42290 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_42288);
var state_42300__$1 = state_42300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42300__$1,(8),inst_42290);
} else {
if((state_val_42301 === (6))){
var state_42300__$1 = state_42300;
var statearr_42306_42321 = state_42300__$1;
(statearr_42306_42321[(2)] = null);

(statearr_42306_42321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42301 === (7))){
var inst_42296 = (state_42300[(2)]);
var state_42300__$1 = state_42300;
var statearr_42307_42322 = state_42300__$1;
(statearr_42307_42322[(2)] = inst_42296);

(statearr_42307_42322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42301 === (8))){
var inst_42292 = (state_42300[(2)]);
var state_42300__$1 = (function (){var statearr_42308 = state_42300;
(statearr_42308[(8)] = inst_42292);

return statearr_42308;
})();
var statearr_42309_42323 = state_42300__$1;
(statearr_42309_42323[(2)] = null);

(statearr_42309_42323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__20558__auto___42317,ch))
;
return ((function (switch__20446__auto__,c__20558__auto___42317,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_42313 = [null,null,null,null,null,null,null,null,null];
(statearr_42313[(0)] = figwheel$client$heads_up_plugin_$_state_machine__20447__auto__);

(statearr_42313[(1)] = (1));

return statearr_42313;
});
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1 = (function (state_42300){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_42300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e42314){if((e42314 instanceof Object)){
var ex__20450__auto__ = e42314;
var statearr_42315_42324 = state_42300;
(statearr_42315_42324[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42300);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42314;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42325 = state_42300;
state_42300 = G__42325;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__ = function(state_42300){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1.call(this,state_42300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___42317,ch))
})();
var state__20560__auto__ = (function (){var statearr_42316 = f__20559__auto__.call(null);
(statearr_42316[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___42317);

return statearr_42316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___42317,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_42346){
var state_val_42347 = (state_42346[(1)]);
if((state_val_42347 === (1))){
var inst_42341 = cljs.core.async.timeout.call(null,(3000));
var state_42346__$1 = state_42346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42346__$1,(2),inst_42341);
} else {
if((state_val_42347 === (2))){
var inst_42343 = (state_42346[(2)]);
var inst_42344 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_42346__$1 = (function (){var statearr_42348 = state_42346;
(statearr_42348[(7)] = inst_42343);

return statearr_42348;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42346__$1,inst_42344);
} else {
return null;
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_42352 = [null,null,null,null,null,null,null,null];
(statearr_42352[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__);

(statearr_42352[(1)] = (1));

return statearr_42352;
});
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1 = (function (state_42346){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_42346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e42353){if((e42353 instanceof Object)){
var ex__20450__auto__ = e42353;
var statearr_42354_42356 = state_42346;
(statearr_42354_42356[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42346);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42357 = state_42346;
state_42346 = G__42357;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__ = function(state_42346){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1.call(this,state_42346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_42355 = f__20559__auto__.call(null);
(statearr_42355[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_42355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__42358){
var map__42365 = p__42358;
var map__42365__$1 = ((((!((map__42365 == null)))?((((map__42365.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42365.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42365):map__42365);
var ed = map__42365__$1;
var formatted_exception = cljs.core.get.call(null,map__42365__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__42365__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__42365__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__42367_42371 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__42368_42372 = null;
var count__42369_42373 = (0);
var i__42370_42374 = (0);
while(true){
if((i__42370_42374 < count__42369_42373)){
var msg_42375 = cljs.core._nth.call(null,chunk__42368_42372,i__42370_42374);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_42375);

var G__42376 = seq__42367_42371;
var G__42377 = chunk__42368_42372;
var G__42378 = count__42369_42373;
var G__42379 = (i__42370_42374 + (1));
seq__42367_42371 = G__42376;
chunk__42368_42372 = G__42377;
count__42369_42373 = G__42378;
i__42370_42374 = G__42379;
continue;
} else {
var temp__4657__auto___42380 = cljs.core.seq.call(null,seq__42367_42371);
if(temp__4657__auto___42380){
var seq__42367_42381__$1 = temp__4657__auto___42380;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42367_42381__$1)){
var c__19208__auto___42382 = cljs.core.chunk_first.call(null,seq__42367_42381__$1);
var G__42383 = cljs.core.chunk_rest.call(null,seq__42367_42381__$1);
var G__42384 = c__19208__auto___42382;
var G__42385 = cljs.core.count.call(null,c__19208__auto___42382);
var G__42386 = (0);
seq__42367_42371 = G__42383;
chunk__42368_42372 = G__42384;
count__42369_42373 = G__42385;
i__42370_42374 = G__42386;
continue;
} else {
var msg_42387 = cljs.core.first.call(null,seq__42367_42381__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_42387);

var G__42388 = cljs.core.next.call(null,seq__42367_42381__$1);
var G__42389 = null;
var G__42390 = (0);
var G__42391 = (0);
seq__42367_42371 = G__42388;
chunk__42368_42372 = G__42389;
count__42369_42373 = G__42390;
i__42370_42374 = G__42391;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__42392){
var map__42395 = p__42392;
var map__42395__$1 = ((((!((map__42395 == null)))?((((map__42395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42395):map__42395);
var w = map__42395__$1;
var message = cljs.core.get.call(null,map__42395__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__18393__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__18393__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__18393__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__42403 = cljs.core.seq.call(null,plugins);
var chunk__42404 = null;
var count__42405 = (0);
var i__42406 = (0);
while(true){
if((i__42406 < count__42405)){
var vec__42407 = cljs.core._nth.call(null,chunk__42404,i__42406);
var k = cljs.core.nth.call(null,vec__42407,(0),null);
var plugin = cljs.core.nth.call(null,vec__42407,(1),null);
if(cljs.core.truth_(plugin)){
var pl_42409 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__42403,chunk__42404,count__42405,i__42406,pl_42409,vec__42407,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_42409.call(null,msg_hist);
});})(seq__42403,chunk__42404,count__42405,i__42406,pl_42409,vec__42407,k,plugin))
);
} else {
}

var G__42410 = seq__42403;
var G__42411 = chunk__42404;
var G__42412 = count__42405;
var G__42413 = (i__42406 + (1));
seq__42403 = G__42410;
chunk__42404 = G__42411;
count__42405 = G__42412;
i__42406 = G__42413;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__42403);
if(temp__4657__auto__){
var seq__42403__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42403__$1)){
var c__19208__auto__ = cljs.core.chunk_first.call(null,seq__42403__$1);
var G__42414 = cljs.core.chunk_rest.call(null,seq__42403__$1);
var G__42415 = c__19208__auto__;
var G__42416 = cljs.core.count.call(null,c__19208__auto__);
var G__42417 = (0);
seq__42403 = G__42414;
chunk__42404 = G__42415;
count__42405 = G__42416;
i__42406 = G__42417;
continue;
} else {
var vec__42408 = cljs.core.first.call(null,seq__42403__$1);
var k = cljs.core.nth.call(null,vec__42408,(0),null);
var plugin = cljs.core.nth.call(null,vec__42408,(1),null);
if(cljs.core.truth_(plugin)){
var pl_42418 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__42403,chunk__42404,count__42405,i__42406,pl_42418,vec__42408,k,plugin,seq__42403__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_42418.call(null,msg_hist);
});})(seq__42403,chunk__42404,count__42405,i__42406,pl_42418,vec__42408,k,plugin,seq__42403__$1,temp__4657__auto__))
);
} else {
}

var G__42419 = cljs.core.next.call(null,seq__42403__$1);
var G__42420 = null;
var G__42421 = (0);
var G__42422 = (0);
seq__42403 = G__42419;
chunk__42404 = G__42420;
count__42405 = G__42421;
i__42406 = G__42422;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args42423 = [];
var len__19463__auto___42426 = arguments.length;
var i__19464__auto___42427 = (0);
while(true){
if((i__19464__auto___42427 < len__19463__auto___42426)){
args42423.push((arguments[i__19464__auto___42427]));

var G__42428 = (i__19464__auto___42427 + (1));
i__19464__auto___42427 = G__42428;
continue;
} else {
}
break;
}

var G__42425 = args42423.length;
switch (G__42425) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42423.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__19470__auto__ = [];
var len__19463__auto___42434 = arguments.length;
var i__19464__auto___42435 = (0);
while(true){
if((i__19464__auto___42435 < len__19463__auto___42434)){
args__19470__auto__.push((arguments[i__19464__auto___42435]));

var G__42436 = (i__19464__auto___42435 + (1));
i__19464__auto___42435 = G__42436;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((0) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__19471__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__42431){
var map__42432 = p__42431;
var map__42432__$1 = ((((!((map__42432 == null)))?((((map__42432.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42432.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42432):map__42432);
var opts = map__42432__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq42430){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq42430));
});

//# sourceMappingURL=client.js.map