// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20603 = [];
var len__19463__auto___20609 = arguments.length;
var i__19464__auto___20610 = (0);
while(true){
if((i__19464__auto___20610 < len__19463__auto___20609)){
args20603.push((arguments[i__19464__auto___20610]));

var G__20611 = (i__19464__auto___20610 + (1));
i__19464__auto___20610 = G__20611;
continue;
} else {
}
break;
}

var G__20605 = args20603.length;
switch (G__20605) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20603.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20606 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20606 = (function (f,blockable,meta20607){
this.f = f;
this.blockable = blockable;
this.meta20607 = meta20607;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20608,meta20607__$1){
var self__ = this;
var _20608__$1 = this;
return (new cljs.core.async.t_cljs$core$async20606(self__.f,self__.blockable,meta20607__$1));
});

cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20608){
var self__ = this;
var _20608__$1 = this;
return self__.meta20607;
});

cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20606.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20606.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20607","meta20607",-1101610868,null)], null);
});

cljs.core.async.t_cljs$core$async20606.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20606.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20606";

cljs.core.async.t_cljs$core$async20606.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async20606");
});

cljs.core.async.__GT_t_cljs$core$async20606 = (function cljs$core$async$__GT_t_cljs$core$async20606(f__$1,blockable__$1,meta20607){
return (new cljs.core.async.t_cljs$core$async20606(f__$1,blockable__$1,meta20607));
});

}

return (new cljs.core.async.t_cljs$core$async20606(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20615 = [];
var len__19463__auto___20618 = arguments.length;
var i__19464__auto___20619 = (0);
while(true){
if((i__19464__auto___20619 < len__19463__auto___20618)){
args20615.push((arguments[i__19464__auto___20619]));

var G__20620 = (i__19464__auto___20619 + (1));
i__19464__auto___20619 = G__20620;
continue;
} else {
}
break;
}

var G__20617 = args20615.length;
switch (G__20617) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20615.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20622 = [];
var len__19463__auto___20625 = arguments.length;
var i__19464__auto___20626 = (0);
while(true){
if((i__19464__auto___20626 < len__19463__auto___20625)){
args20622.push((arguments[i__19464__auto___20626]));

var G__20627 = (i__19464__auto___20626 + (1));
i__19464__auto___20626 = G__20627;
continue;
} else {
}
break;
}

var G__20624 = args20622.length;
switch (G__20624) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20622.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20629 = [];
var len__19463__auto___20632 = arguments.length;
var i__19464__auto___20633 = (0);
while(true){
if((i__19464__auto___20633 < len__19463__auto___20632)){
args20629.push((arguments[i__19464__auto___20633]));

var G__20634 = (i__19464__auto___20633 + (1));
i__19464__auto___20633 = G__20634;
continue;
} else {
}
break;
}

var G__20631 = args20629.length;
switch (G__20631) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20629.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20636 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20636);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20636,ret){
return (function (){
return fn1.call(null,val_20636);
});})(val_20636,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20637 = [];
var len__19463__auto___20640 = arguments.length;
var i__19464__auto___20641 = (0);
while(true){
if((i__19464__auto___20641 < len__19463__auto___20640)){
args20637.push((arguments[i__19464__auto___20641]));

var G__20642 = (i__19464__auto___20641 + (1));
i__19464__auto___20641 = G__20642;
continue;
} else {
}
break;
}

var G__20639 = args20637.length;
switch (G__20639) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20637.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19308__auto___20644 = n;
var x_20645 = (0);
while(true){
if((x_20645 < n__19308__auto___20644)){
(a[x_20645] = (0));

var G__20646 = (x_20645 + (1));
x_20645 = G__20646;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20647 = (i + (1));
i = G__20647;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20651 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20651 = (function (alt_flag,flag,meta20652){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20652 = meta20652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20653,meta20652__$1){
var self__ = this;
var _20653__$1 = this;
return (new cljs.core.async.t_cljs$core$async20651(self__.alt_flag,self__.flag,meta20652__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20653){
var self__ = this;
var _20653__$1 = this;
return self__.meta20652;
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20652","meta20652",2143482320,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20651.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20651";

cljs.core.async.t_cljs$core$async20651.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async20651");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20651 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20651(alt_flag__$1,flag__$1,meta20652){
return (new cljs.core.async.t_cljs$core$async20651(alt_flag__$1,flag__$1,meta20652));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20651(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20657 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20657 = (function (alt_handler,flag,cb,meta20658){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20658 = meta20658;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20659,meta20658__$1){
var self__ = this;
var _20659__$1 = this;
return (new cljs.core.async.t_cljs$core$async20657(self__.alt_handler,self__.flag,self__.cb,meta20658__$1));
});

cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20659){
var self__ = this;
var _20659__$1 = this;
return self__.meta20658;
});

cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20657.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20658","meta20658",-1864962380,null)], null);
});

cljs.core.async.t_cljs$core$async20657.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20657.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20657";

cljs.core.async.t_cljs$core$async20657.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async20657");
});

cljs.core.async.__GT_t_cljs$core$async20657 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20657(alt_handler__$1,flag__$1,cb__$1,meta20658){
return (new cljs.core.async.t_cljs$core$async20657(alt_handler__$1,flag__$1,cb__$1,meta20658));
});

}

return (new cljs.core.async.t_cljs$core$async20657(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20660_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20660_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20661_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20661_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18405__auto__ = wport;
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20662 = (i + (1));
i = G__20662;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18405__auto__ = ret;
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__18393__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18393__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__19470__auto__ = [];
var len__19463__auto___20668 = arguments.length;
var i__19464__auto___20669 = (0);
while(true){
if((i__19464__auto___20669 < len__19463__auto___20668)){
args__19470__auto__.push((arguments[i__19464__auto___20669]));

var G__20670 = (i__19464__auto___20669 + (1));
i__19464__auto___20669 = G__20670;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((1) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19471__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20665){
var map__20666 = p__20665;
var map__20666__$1 = ((((!((map__20666 == null)))?((((map__20666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20666):map__20666);
var opts = map__20666__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20663){
var G__20664 = cljs.core.first.call(null,seq20663);
var seq20663__$1 = cljs.core.next.call(null,seq20663);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20664,seq20663__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20671 = [];
var len__19463__auto___20721 = arguments.length;
var i__19464__auto___20722 = (0);
while(true){
if((i__19464__auto___20722 < len__19463__auto___20721)){
args20671.push((arguments[i__19464__auto___20722]));

var G__20723 = (i__19464__auto___20722 + (1));
i__19464__auto___20722 = G__20723;
continue;
} else {
}
break;
}

var G__20673 = args20671.length;
switch (G__20673) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20671.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20558__auto___20725 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___20725){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___20725){
return (function (state_20697){
var state_val_20698 = (state_20697[(1)]);
if((state_val_20698 === (7))){
var inst_20693 = (state_20697[(2)]);
var state_20697__$1 = state_20697;
var statearr_20699_20726 = state_20697__$1;
(statearr_20699_20726[(2)] = inst_20693);

(statearr_20699_20726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (1))){
var state_20697__$1 = state_20697;
var statearr_20700_20727 = state_20697__$1;
(statearr_20700_20727[(2)] = null);

(statearr_20700_20727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (4))){
var inst_20676 = (state_20697[(7)]);
var inst_20676__$1 = (state_20697[(2)]);
var inst_20677 = (inst_20676__$1 == null);
var state_20697__$1 = (function (){var statearr_20701 = state_20697;
(statearr_20701[(7)] = inst_20676__$1);

return statearr_20701;
})();
if(cljs.core.truth_(inst_20677)){
var statearr_20702_20728 = state_20697__$1;
(statearr_20702_20728[(1)] = (5));

} else {
var statearr_20703_20729 = state_20697__$1;
(statearr_20703_20729[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (13))){
var state_20697__$1 = state_20697;
var statearr_20704_20730 = state_20697__$1;
(statearr_20704_20730[(2)] = null);

(statearr_20704_20730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (6))){
var inst_20676 = (state_20697[(7)]);
var state_20697__$1 = state_20697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20697__$1,(11),to,inst_20676);
} else {
if((state_val_20698 === (3))){
var inst_20695 = (state_20697[(2)]);
var state_20697__$1 = state_20697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20697__$1,inst_20695);
} else {
if((state_val_20698 === (12))){
var state_20697__$1 = state_20697;
var statearr_20705_20731 = state_20697__$1;
(statearr_20705_20731[(2)] = null);

(statearr_20705_20731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (2))){
var state_20697__$1 = state_20697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20697__$1,(4),from);
} else {
if((state_val_20698 === (11))){
var inst_20686 = (state_20697[(2)]);
var state_20697__$1 = state_20697;
if(cljs.core.truth_(inst_20686)){
var statearr_20706_20732 = state_20697__$1;
(statearr_20706_20732[(1)] = (12));

} else {
var statearr_20707_20733 = state_20697__$1;
(statearr_20707_20733[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (9))){
var state_20697__$1 = state_20697;
var statearr_20708_20734 = state_20697__$1;
(statearr_20708_20734[(2)] = null);

(statearr_20708_20734[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (5))){
var state_20697__$1 = state_20697;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20709_20735 = state_20697__$1;
(statearr_20709_20735[(1)] = (8));

} else {
var statearr_20710_20736 = state_20697__$1;
(statearr_20710_20736[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (14))){
var inst_20691 = (state_20697[(2)]);
var state_20697__$1 = state_20697;
var statearr_20711_20737 = state_20697__$1;
(statearr_20711_20737[(2)] = inst_20691);

(statearr_20711_20737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (10))){
var inst_20683 = (state_20697[(2)]);
var state_20697__$1 = state_20697;
var statearr_20712_20738 = state_20697__$1;
(statearr_20712_20738[(2)] = inst_20683);

(statearr_20712_20738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20698 === (8))){
var inst_20680 = cljs.core.async.close_BANG_.call(null,to);
var state_20697__$1 = state_20697;
var statearr_20713_20739 = state_20697__$1;
(statearr_20713_20739[(2)] = inst_20680);

(statearr_20713_20739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___20725))
;
return ((function (switch__20446__auto__,c__20558__auto___20725){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_20717 = [null,null,null,null,null,null,null,null];
(statearr_20717[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_20717[(1)] = (1));

return statearr_20717;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_20697){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_20697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e20718){if((e20718 instanceof Object)){
var ex__20450__auto__ = e20718;
var statearr_20719_20740 = state_20697;
(statearr_20719_20740[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20741 = state_20697;
state_20697 = G__20741;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_20697){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_20697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___20725))
})();
var state__20560__auto__ = (function (){var statearr_20720 = f__20559__auto__.call(null);
(statearr_20720[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___20725);

return statearr_20720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___20725))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20925){
var vec__20926 = p__20925;
var v = cljs.core.nth.call(null,vec__20926,(0),null);
var p = cljs.core.nth.call(null,vec__20926,(1),null);
var job = vec__20926;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20558__auto___21108 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results){
return (function (state_20931){
var state_val_20932 = (state_20931[(1)]);
if((state_val_20932 === (1))){
var state_20931__$1 = state_20931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20931__$1,(2),res,v);
} else {
if((state_val_20932 === (2))){
var inst_20928 = (state_20931[(2)]);
var inst_20929 = cljs.core.async.close_BANG_.call(null,res);
var state_20931__$1 = (function (){var statearr_20933 = state_20931;
(statearr_20933[(7)] = inst_20928);

return statearr_20933;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20931__$1,inst_20929);
} else {
return null;
}
}
});})(c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results))
;
return ((function (switch__20446__auto__,c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_20937 = [null,null,null,null,null,null,null,null];
(statearr_20937[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__);

(statearr_20937[(1)] = (1));

return statearr_20937;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1 = (function (state_20931){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_20931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e20938){if((e20938 instanceof Object)){
var ex__20450__auto__ = e20938;
var statearr_20939_21109 = state_20931;
(statearr_20939_21109[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21110 = state_20931;
state_20931 = G__21110;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = function(state_20931){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1.call(this,state_20931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results))
})();
var state__20560__auto__ = (function (){var statearr_20940 = f__20559__auto__.call(null);
(statearr_20940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21108);

return statearr_20940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___21108,res,vec__20926,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20941){
var vec__20942 = p__20941;
var v = cljs.core.nth.call(null,vec__20942,(0),null);
var p = cljs.core.nth.call(null,vec__20942,(1),null);
var job = vec__20942;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19308__auto___21111 = n;
var __21112 = (0);
while(true){
if((__21112 < n__19308__auto___21111)){
var G__20943_21113 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20943_21113) {
case "compute":
var c__20558__auto___21115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21112,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (__21112,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function (state_20956){
var state_val_20957 = (state_20956[(1)]);
if((state_val_20957 === (1))){
var state_20956__$1 = state_20956;
var statearr_20958_21116 = state_20956__$1;
(statearr_20958_21116[(2)] = null);

(statearr_20958_21116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (2))){
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20956__$1,(4),jobs);
} else {
if((state_val_20957 === (3))){
var inst_20954 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20956__$1,inst_20954);
} else {
if((state_val_20957 === (4))){
var inst_20946 = (state_20956[(2)]);
var inst_20947 = process.call(null,inst_20946);
var state_20956__$1 = state_20956;
if(cljs.core.truth_(inst_20947)){
var statearr_20959_21117 = state_20956__$1;
(statearr_20959_21117[(1)] = (5));

} else {
var statearr_20960_21118 = state_20956__$1;
(statearr_20960_21118[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (5))){
var state_20956__$1 = state_20956;
var statearr_20961_21119 = state_20956__$1;
(statearr_20961_21119[(2)] = null);

(statearr_20961_21119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (6))){
var state_20956__$1 = state_20956;
var statearr_20962_21120 = state_20956__$1;
(statearr_20962_21120[(2)] = null);

(statearr_20962_21120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (7))){
var inst_20952 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20963_21121 = state_20956__$1;
(statearr_20963_21121[(2)] = inst_20952);

(statearr_20963_21121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21112,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
;
return ((function (__21112,switch__20446__auto__,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_20967 = [null,null,null,null,null,null,null];
(statearr_20967[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__);

(statearr_20967[(1)] = (1));

return statearr_20967;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1 = (function (state_20956){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_20956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e20968){if((e20968 instanceof Object)){
var ex__20450__auto__ = e20968;
var statearr_20969_21122 = state_20956;
(statearr_20969_21122[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20968;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21123 = state_20956;
state_20956 = G__21123;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = function(state_20956){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1.call(this,state_20956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__;
})()
;})(__21112,switch__20446__auto__,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
})();
var state__20560__auto__ = (function (){var statearr_20970 = f__20559__auto__.call(null);
(statearr_20970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21115);

return statearr_20970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(__21112,c__20558__auto___21115,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
);


break;
case "async":
var c__20558__auto___21124 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21112,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (__21112,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function (state_20983){
var state_val_20984 = (state_20983[(1)]);
if((state_val_20984 === (1))){
var state_20983__$1 = state_20983;
var statearr_20985_21125 = state_20983__$1;
(statearr_20985_21125[(2)] = null);

(statearr_20985_21125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (2))){
var state_20983__$1 = state_20983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20983__$1,(4),jobs);
} else {
if((state_val_20984 === (3))){
var inst_20981 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20983__$1,inst_20981);
} else {
if((state_val_20984 === (4))){
var inst_20973 = (state_20983[(2)]);
var inst_20974 = async.call(null,inst_20973);
var state_20983__$1 = state_20983;
if(cljs.core.truth_(inst_20974)){
var statearr_20986_21126 = state_20983__$1;
(statearr_20986_21126[(1)] = (5));

} else {
var statearr_20987_21127 = state_20983__$1;
(statearr_20987_21127[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (5))){
var state_20983__$1 = state_20983;
var statearr_20988_21128 = state_20983__$1;
(statearr_20988_21128[(2)] = null);

(statearr_20988_21128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (6))){
var state_20983__$1 = state_20983;
var statearr_20989_21129 = state_20983__$1;
(statearr_20989_21129[(2)] = null);

(statearr_20989_21129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (7))){
var inst_20979 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
var statearr_20990_21130 = state_20983__$1;
(statearr_20990_21130[(2)] = inst_20979);

(statearr_20990_21130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21112,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
;
return ((function (__21112,switch__20446__auto__,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_20994 = [null,null,null,null,null,null,null];
(statearr_20994[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__);

(statearr_20994[(1)] = (1));

return statearr_20994;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1 = (function (state_20983){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_20983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e20995){if((e20995 instanceof Object)){
var ex__20450__auto__ = e20995;
var statearr_20996_21131 = state_20983;
(statearr_20996_21131[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20995;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21132 = state_20983;
state_20983 = G__21132;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = function(state_20983){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1.call(this,state_20983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__;
})()
;})(__21112,switch__20446__auto__,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
})();
var state__20560__auto__ = (function (){var statearr_20997 = f__20559__auto__.call(null);
(statearr_20997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21124);

return statearr_20997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(__21112,c__20558__auto___21124,G__20943_21113,n__19308__auto___21111,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__21133 = (__21112 + (1));
__21112 = G__21133;
continue;
} else {
}
break;
}

var c__20558__auto___21134 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___21134,jobs,results,process,async){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___21134,jobs,results,process,async){
return (function (state_21019){
var state_val_21020 = (state_21019[(1)]);
if((state_val_21020 === (1))){
var state_21019__$1 = state_21019;
var statearr_21021_21135 = state_21019__$1;
(statearr_21021_21135[(2)] = null);

(statearr_21021_21135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (2))){
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21019__$1,(4),from);
} else {
if((state_val_21020 === (3))){
var inst_21017 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21019__$1,inst_21017);
} else {
if((state_val_21020 === (4))){
var inst_21000 = (state_21019[(7)]);
var inst_21000__$1 = (state_21019[(2)]);
var inst_21001 = (inst_21000__$1 == null);
var state_21019__$1 = (function (){var statearr_21022 = state_21019;
(statearr_21022[(7)] = inst_21000__$1);

return statearr_21022;
})();
if(cljs.core.truth_(inst_21001)){
var statearr_21023_21136 = state_21019__$1;
(statearr_21023_21136[(1)] = (5));

} else {
var statearr_21024_21137 = state_21019__$1;
(statearr_21024_21137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (5))){
var inst_21003 = cljs.core.async.close_BANG_.call(null,jobs);
var state_21019__$1 = state_21019;
var statearr_21025_21138 = state_21019__$1;
(statearr_21025_21138[(2)] = inst_21003);

(statearr_21025_21138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (6))){
var inst_21005 = (state_21019[(8)]);
var inst_21000 = (state_21019[(7)]);
var inst_21005__$1 = cljs.core.async.chan.call(null,(1));
var inst_21006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21007 = [inst_21000,inst_21005__$1];
var inst_21008 = (new cljs.core.PersistentVector(null,2,(5),inst_21006,inst_21007,null));
var state_21019__$1 = (function (){var statearr_21026 = state_21019;
(statearr_21026[(8)] = inst_21005__$1);

return statearr_21026;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21019__$1,(8),jobs,inst_21008);
} else {
if((state_val_21020 === (7))){
var inst_21015 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21027_21139 = state_21019__$1;
(statearr_21027_21139[(2)] = inst_21015);

(statearr_21027_21139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (8))){
var inst_21005 = (state_21019[(8)]);
var inst_21010 = (state_21019[(2)]);
var state_21019__$1 = (function (){var statearr_21028 = state_21019;
(statearr_21028[(9)] = inst_21010);

return statearr_21028;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21019__$1,(9),results,inst_21005);
} else {
if((state_val_21020 === (9))){
var inst_21012 = (state_21019[(2)]);
var state_21019__$1 = (function (){var statearr_21029 = state_21019;
(statearr_21029[(10)] = inst_21012);

return statearr_21029;
})();
var statearr_21030_21140 = state_21019__$1;
(statearr_21030_21140[(2)] = null);

(statearr_21030_21140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___21134,jobs,results,process,async))
;
return ((function (switch__20446__auto__,c__20558__auto___21134,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_21034 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21034[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__);

(statearr_21034[(1)] = (1));

return statearr_21034;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1 = (function (state_21019){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21035){if((e21035 instanceof Object)){
var ex__20450__auto__ = e21035;
var statearr_21036_21141 = state_21019;
(statearr_21036_21141[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21142 = state_21019;
state_21019 = G__21142;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = function(state_21019){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1.call(this,state_21019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___21134,jobs,results,process,async))
})();
var state__20560__auto__ = (function (){var statearr_21037 = f__20559__auto__.call(null);
(statearr_21037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21134);

return statearr_21037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___21134,jobs,results,process,async))
);


var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__,jobs,results,process,async){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__,jobs,results,process,async){
return (function (state_21075){
var state_val_21076 = (state_21075[(1)]);
if((state_val_21076 === (7))){
var inst_21071 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21077_21143 = state_21075__$1;
(statearr_21077_21143[(2)] = inst_21071);

(statearr_21077_21143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (20))){
var state_21075__$1 = state_21075;
var statearr_21078_21144 = state_21075__$1;
(statearr_21078_21144[(2)] = null);

(statearr_21078_21144[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (1))){
var state_21075__$1 = state_21075;
var statearr_21079_21145 = state_21075__$1;
(statearr_21079_21145[(2)] = null);

(statearr_21079_21145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (4))){
var inst_21040 = (state_21075[(7)]);
var inst_21040__$1 = (state_21075[(2)]);
var inst_21041 = (inst_21040__$1 == null);
var state_21075__$1 = (function (){var statearr_21080 = state_21075;
(statearr_21080[(7)] = inst_21040__$1);

return statearr_21080;
})();
if(cljs.core.truth_(inst_21041)){
var statearr_21081_21146 = state_21075__$1;
(statearr_21081_21146[(1)] = (5));

} else {
var statearr_21082_21147 = state_21075__$1;
(statearr_21082_21147[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (15))){
var inst_21053 = (state_21075[(8)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21075__$1,(18),to,inst_21053);
} else {
if((state_val_21076 === (21))){
var inst_21066 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21083_21148 = state_21075__$1;
(statearr_21083_21148[(2)] = inst_21066);

(statearr_21083_21148[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (13))){
var inst_21068 = (state_21075[(2)]);
var state_21075__$1 = (function (){var statearr_21084 = state_21075;
(statearr_21084[(9)] = inst_21068);

return statearr_21084;
})();
var statearr_21085_21149 = state_21075__$1;
(statearr_21085_21149[(2)] = null);

(statearr_21085_21149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (6))){
var inst_21040 = (state_21075[(7)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21075__$1,(11),inst_21040);
} else {
if((state_val_21076 === (17))){
var inst_21061 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21061)){
var statearr_21086_21150 = state_21075__$1;
(statearr_21086_21150[(1)] = (19));

} else {
var statearr_21087_21151 = state_21075__$1;
(statearr_21087_21151[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (3))){
var inst_21073 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21075__$1,inst_21073);
} else {
if((state_val_21076 === (12))){
var inst_21050 = (state_21075[(10)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21075__$1,(14),inst_21050);
} else {
if((state_val_21076 === (2))){
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21075__$1,(4),results);
} else {
if((state_val_21076 === (19))){
var state_21075__$1 = state_21075;
var statearr_21088_21152 = state_21075__$1;
(statearr_21088_21152[(2)] = null);

(statearr_21088_21152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (11))){
var inst_21050 = (state_21075[(2)]);
var state_21075__$1 = (function (){var statearr_21089 = state_21075;
(statearr_21089[(10)] = inst_21050);

return statearr_21089;
})();
var statearr_21090_21153 = state_21075__$1;
(statearr_21090_21153[(2)] = null);

(statearr_21090_21153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (9))){
var state_21075__$1 = state_21075;
var statearr_21091_21154 = state_21075__$1;
(statearr_21091_21154[(2)] = null);

(statearr_21091_21154[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (5))){
var state_21075__$1 = state_21075;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21092_21155 = state_21075__$1;
(statearr_21092_21155[(1)] = (8));

} else {
var statearr_21093_21156 = state_21075__$1;
(statearr_21093_21156[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (14))){
var inst_21055 = (state_21075[(11)]);
var inst_21053 = (state_21075[(8)]);
var inst_21053__$1 = (state_21075[(2)]);
var inst_21054 = (inst_21053__$1 == null);
var inst_21055__$1 = cljs.core.not.call(null,inst_21054);
var state_21075__$1 = (function (){var statearr_21094 = state_21075;
(statearr_21094[(11)] = inst_21055__$1);

(statearr_21094[(8)] = inst_21053__$1);

return statearr_21094;
})();
if(inst_21055__$1){
var statearr_21095_21157 = state_21075__$1;
(statearr_21095_21157[(1)] = (15));

} else {
var statearr_21096_21158 = state_21075__$1;
(statearr_21096_21158[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (16))){
var inst_21055 = (state_21075[(11)]);
var state_21075__$1 = state_21075;
var statearr_21097_21159 = state_21075__$1;
(statearr_21097_21159[(2)] = inst_21055);

(statearr_21097_21159[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (10))){
var inst_21047 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21098_21160 = state_21075__$1;
(statearr_21098_21160[(2)] = inst_21047);

(statearr_21098_21160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (18))){
var inst_21058 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21099_21161 = state_21075__$1;
(statearr_21099_21161[(2)] = inst_21058);

(statearr_21099_21161[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (8))){
var inst_21044 = cljs.core.async.close_BANG_.call(null,to);
var state_21075__$1 = state_21075;
var statearr_21100_21162 = state_21075__$1;
(statearr_21100_21162[(2)] = inst_21044);

(statearr_21100_21162[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__,jobs,results,process,async))
;
return ((function (switch__20446__auto__,c__20558__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_21104 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21104[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__);

(statearr_21104[(1)] = (1));

return statearr_21104;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1 = (function (state_21075){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21105){if((e21105 instanceof Object)){
var ex__20450__auto__ = e21105;
var statearr_21106_21163 = state_21075;
(statearr_21106_21163[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21164 = state_21075;
state_21075 = G__21164;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__ = function(state_21075){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1.call(this,state_21075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__,jobs,results,process,async))
})();
var state__20560__auto__ = (function (){var statearr_21107 = f__20559__auto__.call(null);
(statearr_21107[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_21107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__,jobs,results,process,async))
);

return c__20558__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args21165 = [];
var len__19463__auto___21168 = arguments.length;
var i__19464__auto___21169 = (0);
while(true){
if((i__19464__auto___21169 < len__19463__auto___21168)){
args21165.push((arguments[i__19464__auto___21169]));

var G__21170 = (i__19464__auto___21169 + (1));
i__19464__auto___21169 = G__21170;
continue;
} else {
}
break;
}

var G__21167 = args21165.length;
switch (G__21167) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21165.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args21172 = [];
var len__19463__auto___21175 = arguments.length;
var i__19464__auto___21176 = (0);
while(true){
if((i__19464__auto___21176 < len__19463__auto___21175)){
args21172.push((arguments[i__19464__auto___21176]));

var G__21177 = (i__19464__auto___21176 + (1));
i__19464__auto___21176 = G__21177;
continue;
} else {
}
break;
}

var G__21174 = args21172.length;
switch (G__21174) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21172.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args21179 = [];
var len__19463__auto___21232 = arguments.length;
var i__19464__auto___21233 = (0);
while(true){
if((i__19464__auto___21233 < len__19463__auto___21232)){
args21179.push((arguments[i__19464__auto___21233]));

var G__21234 = (i__19464__auto___21233 + (1));
i__19464__auto___21233 = G__21234;
continue;
} else {
}
break;
}

var G__21181 = args21179.length;
switch (G__21181) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21179.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20558__auto___21236 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___21236,tc,fc){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___21236,tc,fc){
return (function (state_21207){
var state_val_21208 = (state_21207[(1)]);
if((state_val_21208 === (7))){
var inst_21203 = (state_21207[(2)]);
var state_21207__$1 = state_21207;
var statearr_21209_21237 = state_21207__$1;
(statearr_21209_21237[(2)] = inst_21203);

(statearr_21209_21237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (1))){
var state_21207__$1 = state_21207;
var statearr_21210_21238 = state_21207__$1;
(statearr_21210_21238[(2)] = null);

(statearr_21210_21238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (4))){
var inst_21184 = (state_21207[(7)]);
var inst_21184__$1 = (state_21207[(2)]);
var inst_21185 = (inst_21184__$1 == null);
var state_21207__$1 = (function (){var statearr_21211 = state_21207;
(statearr_21211[(7)] = inst_21184__$1);

return statearr_21211;
})();
if(cljs.core.truth_(inst_21185)){
var statearr_21212_21239 = state_21207__$1;
(statearr_21212_21239[(1)] = (5));

} else {
var statearr_21213_21240 = state_21207__$1;
(statearr_21213_21240[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (13))){
var state_21207__$1 = state_21207;
var statearr_21214_21241 = state_21207__$1;
(statearr_21214_21241[(2)] = null);

(statearr_21214_21241[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (6))){
var inst_21184 = (state_21207[(7)]);
var inst_21190 = p.call(null,inst_21184);
var state_21207__$1 = state_21207;
if(cljs.core.truth_(inst_21190)){
var statearr_21215_21242 = state_21207__$1;
(statearr_21215_21242[(1)] = (9));

} else {
var statearr_21216_21243 = state_21207__$1;
(statearr_21216_21243[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (3))){
var inst_21205 = (state_21207[(2)]);
var state_21207__$1 = state_21207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21207__$1,inst_21205);
} else {
if((state_val_21208 === (12))){
var state_21207__$1 = state_21207;
var statearr_21217_21244 = state_21207__$1;
(statearr_21217_21244[(2)] = null);

(statearr_21217_21244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (2))){
var state_21207__$1 = state_21207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21207__$1,(4),ch);
} else {
if((state_val_21208 === (11))){
var inst_21184 = (state_21207[(7)]);
var inst_21194 = (state_21207[(2)]);
var state_21207__$1 = state_21207;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21207__$1,(8),inst_21194,inst_21184);
} else {
if((state_val_21208 === (9))){
var state_21207__$1 = state_21207;
var statearr_21218_21245 = state_21207__$1;
(statearr_21218_21245[(2)] = tc);

(statearr_21218_21245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (5))){
var inst_21187 = cljs.core.async.close_BANG_.call(null,tc);
var inst_21188 = cljs.core.async.close_BANG_.call(null,fc);
var state_21207__$1 = (function (){var statearr_21219 = state_21207;
(statearr_21219[(8)] = inst_21187);

return statearr_21219;
})();
var statearr_21220_21246 = state_21207__$1;
(statearr_21220_21246[(2)] = inst_21188);

(statearr_21220_21246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (14))){
var inst_21201 = (state_21207[(2)]);
var state_21207__$1 = state_21207;
var statearr_21221_21247 = state_21207__$1;
(statearr_21221_21247[(2)] = inst_21201);

(statearr_21221_21247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (10))){
var state_21207__$1 = state_21207;
var statearr_21222_21248 = state_21207__$1;
(statearr_21222_21248[(2)] = fc);

(statearr_21222_21248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21208 === (8))){
var inst_21196 = (state_21207[(2)]);
var state_21207__$1 = state_21207;
if(cljs.core.truth_(inst_21196)){
var statearr_21223_21249 = state_21207__$1;
(statearr_21223_21249[(1)] = (12));

} else {
var statearr_21224_21250 = state_21207__$1;
(statearr_21224_21250[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___21236,tc,fc))
;
return ((function (switch__20446__auto__,c__20558__auto___21236,tc,fc){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_21228 = [null,null,null,null,null,null,null,null,null];
(statearr_21228[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_21228[(1)] = (1));

return statearr_21228;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_21207){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21229){if((e21229 instanceof Object)){
var ex__20450__auto__ = e21229;
var statearr_21230_21251 = state_21207;
(statearr_21230_21251[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21207);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21252 = state_21207;
state_21207 = G__21252;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_21207){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_21207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___21236,tc,fc))
})();
var state__20560__auto__ = (function (){var statearr_21231 = f__20559__auto__.call(null);
(statearr_21231[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21236);

return statearr_21231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___21236,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_21316){
var state_val_21317 = (state_21316[(1)]);
if((state_val_21317 === (7))){
var inst_21312 = (state_21316[(2)]);
var state_21316__$1 = state_21316;
var statearr_21318_21339 = state_21316__$1;
(statearr_21318_21339[(2)] = inst_21312);

(statearr_21318_21339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (1))){
var inst_21296 = init;
var state_21316__$1 = (function (){var statearr_21319 = state_21316;
(statearr_21319[(7)] = inst_21296);

return statearr_21319;
})();
var statearr_21320_21340 = state_21316__$1;
(statearr_21320_21340[(2)] = null);

(statearr_21320_21340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (4))){
var inst_21299 = (state_21316[(8)]);
var inst_21299__$1 = (state_21316[(2)]);
var inst_21300 = (inst_21299__$1 == null);
var state_21316__$1 = (function (){var statearr_21321 = state_21316;
(statearr_21321[(8)] = inst_21299__$1);

return statearr_21321;
})();
if(cljs.core.truth_(inst_21300)){
var statearr_21322_21341 = state_21316__$1;
(statearr_21322_21341[(1)] = (5));

} else {
var statearr_21323_21342 = state_21316__$1;
(statearr_21323_21342[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (6))){
var inst_21303 = (state_21316[(9)]);
var inst_21296 = (state_21316[(7)]);
var inst_21299 = (state_21316[(8)]);
var inst_21303__$1 = f.call(null,inst_21296,inst_21299);
var inst_21304 = cljs.core.reduced_QMARK_.call(null,inst_21303__$1);
var state_21316__$1 = (function (){var statearr_21324 = state_21316;
(statearr_21324[(9)] = inst_21303__$1);

return statearr_21324;
})();
if(inst_21304){
var statearr_21325_21343 = state_21316__$1;
(statearr_21325_21343[(1)] = (8));

} else {
var statearr_21326_21344 = state_21316__$1;
(statearr_21326_21344[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (3))){
var inst_21314 = (state_21316[(2)]);
var state_21316__$1 = state_21316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21316__$1,inst_21314);
} else {
if((state_val_21317 === (2))){
var state_21316__$1 = state_21316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21316__$1,(4),ch);
} else {
if((state_val_21317 === (9))){
var inst_21303 = (state_21316[(9)]);
var inst_21296 = inst_21303;
var state_21316__$1 = (function (){var statearr_21327 = state_21316;
(statearr_21327[(7)] = inst_21296);

return statearr_21327;
})();
var statearr_21328_21345 = state_21316__$1;
(statearr_21328_21345[(2)] = null);

(statearr_21328_21345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (5))){
var inst_21296 = (state_21316[(7)]);
var state_21316__$1 = state_21316;
var statearr_21329_21346 = state_21316__$1;
(statearr_21329_21346[(2)] = inst_21296);

(statearr_21329_21346[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (10))){
var inst_21310 = (state_21316[(2)]);
var state_21316__$1 = state_21316;
var statearr_21330_21347 = state_21316__$1;
(statearr_21330_21347[(2)] = inst_21310);

(statearr_21330_21347[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21317 === (8))){
var inst_21303 = (state_21316[(9)]);
var inst_21306 = cljs.core.deref.call(null,inst_21303);
var state_21316__$1 = state_21316;
var statearr_21331_21348 = state_21316__$1;
(statearr_21331_21348[(2)] = inst_21306);

(statearr_21331_21348[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20447__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20447__auto____0 = (function (){
var statearr_21335 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21335[(0)] = cljs$core$async$reduce_$_state_machine__20447__auto__);

(statearr_21335[(1)] = (1));

return statearr_21335;
});
var cljs$core$async$reduce_$_state_machine__20447__auto____1 = (function (state_21316){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21336){if((e21336 instanceof Object)){
var ex__20450__auto__ = e21336;
var statearr_21337_21349 = state_21316;
(statearr_21337_21349[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21316);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21350 = state_21316;
state_21316 = G__21350;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20447__auto__ = function(state_21316){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20447__auto____1.call(this,state_21316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20447__auto____0;
cljs$core$async$reduce_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20447__auto____1;
return cljs$core$async$reduce_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_21338 = f__20559__auto__.call(null);
(statearr_21338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_21338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21351 = [];
var len__19463__auto___21403 = arguments.length;
var i__19464__auto___21404 = (0);
while(true){
if((i__19464__auto___21404 < len__19463__auto___21403)){
args21351.push((arguments[i__19464__auto___21404]));

var G__21405 = (i__19464__auto___21404 + (1));
i__19464__auto___21404 = G__21405;
continue;
} else {
}
break;
}

var G__21353 = args21351.length;
switch (G__21353) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21351.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_21378){
var state_val_21379 = (state_21378[(1)]);
if((state_val_21379 === (7))){
var inst_21360 = (state_21378[(2)]);
var state_21378__$1 = state_21378;
var statearr_21380_21407 = state_21378__$1;
(statearr_21380_21407[(2)] = inst_21360);

(statearr_21380_21407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (1))){
var inst_21354 = cljs.core.seq.call(null,coll);
var inst_21355 = inst_21354;
var state_21378__$1 = (function (){var statearr_21381 = state_21378;
(statearr_21381[(7)] = inst_21355);

return statearr_21381;
})();
var statearr_21382_21408 = state_21378__$1;
(statearr_21382_21408[(2)] = null);

(statearr_21382_21408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (4))){
var inst_21355 = (state_21378[(7)]);
var inst_21358 = cljs.core.first.call(null,inst_21355);
var state_21378__$1 = state_21378;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21378__$1,(7),ch,inst_21358);
} else {
if((state_val_21379 === (13))){
var inst_21372 = (state_21378[(2)]);
var state_21378__$1 = state_21378;
var statearr_21383_21409 = state_21378__$1;
(statearr_21383_21409[(2)] = inst_21372);

(statearr_21383_21409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (6))){
var inst_21363 = (state_21378[(2)]);
var state_21378__$1 = state_21378;
if(cljs.core.truth_(inst_21363)){
var statearr_21384_21410 = state_21378__$1;
(statearr_21384_21410[(1)] = (8));

} else {
var statearr_21385_21411 = state_21378__$1;
(statearr_21385_21411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (3))){
var inst_21376 = (state_21378[(2)]);
var state_21378__$1 = state_21378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21378__$1,inst_21376);
} else {
if((state_val_21379 === (12))){
var state_21378__$1 = state_21378;
var statearr_21386_21412 = state_21378__$1;
(statearr_21386_21412[(2)] = null);

(statearr_21386_21412[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (2))){
var inst_21355 = (state_21378[(7)]);
var state_21378__$1 = state_21378;
if(cljs.core.truth_(inst_21355)){
var statearr_21387_21413 = state_21378__$1;
(statearr_21387_21413[(1)] = (4));

} else {
var statearr_21388_21414 = state_21378__$1;
(statearr_21388_21414[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (11))){
var inst_21369 = cljs.core.async.close_BANG_.call(null,ch);
var state_21378__$1 = state_21378;
var statearr_21389_21415 = state_21378__$1;
(statearr_21389_21415[(2)] = inst_21369);

(statearr_21389_21415[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (9))){
var state_21378__$1 = state_21378;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21390_21416 = state_21378__$1;
(statearr_21390_21416[(1)] = (11));

} else {
var statearr_21391_21417 = state_21378__$1;
(statearr_21391_21417[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (5))){
var inst_21355 = (state_21378[(7)]);
var state_21378__$1 = state_21378;
var statearr_21392_21418 = state_21378__$1;
(statearr_21392_21418[(2)] = inst_21355);

(statearr_21392_21418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (10))){
var inst_21374 = (state_21378[(2)]);
var state_21378__$1 = state_21378;
var statearr_21393_21419 = state_21378__$1;
(statearr_21393_21419[(2)] = inst_21374);

(statearr_21393_21419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21379 === (8))){
var inst_21355 = (state_21378[(7)]);
var inst_21365 = cljs.core.next.call(null,inst_21355);
var inst_21355__$1 = inst_21365;
var state_21378__$1 = (function (){var statearr_21394 = state_21378;
(statearr_21394[(7)] = inst_21355__$1);

return statearr_21394;
})();
var statearr_21395_21420 = state_21378__$1;
(statearr_21395_21420[(2)] = null);

(statearr_21395_21420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_21399 = [null,null,null,null,null,null,null,null];
(statearr_21399[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_21399[(1)] = (1));

return statearr_21399;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_21378){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21400){if((e21400 instanceof Object)){
var ex__20450__auto__ = e21400;
var statearr_21401_21421 = state_21378;
(statearr_21401_21421[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21378);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21422 = state_21378;
state_21378 = G__21422;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_21378){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_21378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_21402 = f__20559__auto__.call(null);
(statearr_21402[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_21402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19061__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,ch);
} else {
var m__19061__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m);
} else {
var m__19061__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21644 = (function (mult,ch,cs,meta21645){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21645 = meta21645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21646,meta21645__$1){
var self__ = this;
var _21646__$1 = this;
return (new cljs.core.async.t_cljs$core$async21644(self__.mult,self__.ch,self__.cs,meta21645__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21646){
var self__ = this;
var _21646__$1 = this;
return self__.meta21645;
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21645","meta21645",1363129853,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21644.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21644";

cljs.core.async.t_cljs$core$async21644.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async21644");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21644 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21644(mult__$1,ch__$1,cs__$1,meta21645){
return (new cljs.core.async.t_cljs$core$async21644(mult__$1,ch__$1,cs__$1,meta21645));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21644(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20558__auto___21865 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___21865,cs,m,dchan,dctr,done){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___21865,cs,m,dchan,dctr,done){
return (function (state_21777){
var state_val_21778 = (state_21777[(1)]);
if((state_val_21778 === (7))){
var inst_21773 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21779_21866 = state_21777__$1;
(statearr_21779_21866[(2)] = inst_21773);

(statearr_21779_21866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (20))){
var inst_21678 = (state_21777[(7)]);
var inst_21688 = cljs.core.first.call(null,inst_21678);
var inst_21689 = cljs.core.nth.call(null,inst_21688,(0),null);
var inst_21690 = cljs.core.nth.call(null,inst_21688,(1),null);
var state_21777__$1 = (function (){var statearr_21780 = state_21777;
(statearr_21780[(8)] = inst_21689);

return statearr_21780;
})();
if(cljs.core.truth_(inst_21690)){
var statearr_21781_21867 = state_21777__$1;
(statearr_21781_21867[(1)] = (22));

} else {
var statearr_21782_21868 = state_21777__$1;
(statearr_21782_21868[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (27))){
var inst_21718 = (state_21777[(9)]);
var inst_21649 = (state_21777[(10)]);
var inst_21720 = (state_21777[(11)]);
var inst_21725 = (state_21777[(12)]);
var inst_21725__$1 = cljs.core._nth.call(null,inst_21718,inst_21720);
var inst_21726 = cljs.core.async.put_BANG_.call(null,inst_21725__$1,inst_21649,done);
var state_21777__$1 = (function (){var statearr_21783 = state_21777;
(statearr_21783[(12)] = inst_21725__$1);

return statearr_21783;
})();
if(cljs.core.truth_(inst_21726)){
var statearr_21784_21869 = state_21777__$1;
(statearr_21784_21869[(1)] = (30));

} else {
var statearr_21785_21870 = state_21777__$1;
(statearr_21785_21870[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (1))){
var state_21777__$1 = state_21777;
var statearr_21786_21871 = state_21777__$1;
(statearr_21786_21871[(2)] = null);

(statearr_21786_21871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (24))){
var inst_21678 = (state_21777[(7)]);
var inst_21695 = (state_21777[(2)]);
var inst_21696 = cljs.core.next.call(null,inst_21678);
var inst_21658 = inst_21696;
var inst_21659 = null;
var inst_21660 = (0);
var inst_21661 = (0);
var state_21777__$1 = (function (){var statearr_21787 = state_21777;
(statearr_21787[(13)] = inst_21659);

(statearr_21787[(14)] = inst_21695);

(statearr_21787[(15)] = inst_21658);

(statearr_21787[(16)] = inst_21660);

(statearr_21787[(17)] = inst_21661);

return statearr_21787;
})();
var statearr_21788_21872 = state_21777__$1;
(statearr_21788_21872[(2)] = null);

(statearr_21788_21872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (39))){
var state_21777__$1 = state_21777;
var statearr_21792_21873 = state_21777__$1;
(statearr_21792_21873[(2)] = null);

(statearr_21792_21873[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (4))){
var inst_21649 = (state_21777[(10)]);
var inst_21649__$1 = (state_21777[(2)]);
var inst_21650 = (inst_21649__$1 == null);
var state_21777__$1 = (function (){var statearr_21793 = state_21777;
(statearr_21793[(10)] = inst_21649__$1);

return statearr_21793;
})();
if(cljs.core.truth_(inst_21650)){
var statearr_21794_21874 = state_21777__$1;
(statearr_21794_21874[(1)] = (5));

} else {
var statearr_21795_21875 = state_21777__$1;
(statearr_21795_21875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (15))){
var inst_21659 = (state_21777[(13)]);
var inst_21658 = (state_21777[(15)]);
var inst_21660 = (state_21777[(16)]);
var inst_21661 = (state_21777[(17)]);
var inst_21674 = (state_21777[(2)]);
var inst_21675 = (inst_21661 + (1));
var tmp21789 = inst_21659;
var tmp21790 = inst_21658;
var tmp21791 = inst_21660;
var inst_21658__$1 = tmp21790;
var inst_21659__$1 = tmp21789;
var inst_21660__$1 = tmp21791;
var inst_21661__$1 = inst_21675;
var state_21777__$1 = (function (){var statearr_21796 = state_21777;
(statearr_21796[(13)] = inst_21659__$1);

(statearr_21796[(15)] = inst_21658__$1);

(statearr_21796[(16)] = inst_21660__$1);

(statearr_21796[(18)] = inst_21674);

(statearr_21796[(17)] = inst_21661__$1);

return statearr_21796;
})();
var statearr_21797_21876 = state_21777__$1;
(statearr_21797_21876[(2)] = null);

(statearr_21797_21876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (21))){
var inst_21699 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21801_21877 = state_21777__$1;
(statearr_21801_21877[(2)] = inst_21699);

(statearr_21801_21877[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (31))){
var inst_21725 = (state_21777[(12)]);
var inst_21729 = done.call(null,null);
var inst_21730 = cljs.core.async.untap_STAR_.call(null,m,inst_21725);
var state_21777__$1 = (function (){var statearr_21802 = state_21777;
(statearr_21802[(19)] = inst_21729);

return statearr_21802;
})();
var statearr_21803_21878 = state_21777__$1;
(statearr_21803_21878[(2)] = inst_21730);

(statearr_21803_21878[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (32))){
var inst_21717 = (state_21777[(20)]);
var inst_21719 = (state_21777[(21)]);
var inst_21718 = (state_21777[(9)]);
var inst_21720 = (state_21777[(11)]);
var inst_21732 = (state_21777[(2)]);
var inst_21733 = (inst_21720 + (1));
var tmp21798 = inst_21717;
var tmp21799 = inst_21719;
var tmp21800 = inst_21718;
var inst_21717__$1 = tmp21798;
var inst_21718__$1 = tmp21800;
var inst_21719__$1 = tmp21799;
var inst_21720__$1 = inst_21733;
var state_21777__$1 = (function (){var statearr_21804 = state_21777;
(statearr_21804[(20)] = inst_21717__$1);

(statearr_21804[(21)] = inst_21719__$1);

(statearr_21804[(9)] = inst_21718__$1);

(statearr_21804[(11)] = inst_21720__$1);

(statearr_21804[(22)] = inst_21732);

return statearr_21804;
})();
var statearr_21805_21879 = state_21777__$1;
(statearr_21805_21879[(2)] = null);

(statearr_21805_21879[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (40))){
var inst_21745 = (state_21777[(23)]);
var inst_21749 = done.call(null,null);
var inst_21750 = cljs.core.async.untap_STAR_.call(null,m,inst_21745);
var state_21777__$1 = (function (){var statearr_21806 = state_21777;
(statearr_21806[(24)] = inst_21749);

return statearr_21806;
})();
var statearr_21807_21880 = state_21777__$1;
(statearr_21807_21880[(2)] = inst_21750);

(statearr_21807_21880[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (33))){
var inst_21736 = (state_21777[(25)]);
var inst_21738 = cljs.core.chunked_seq_QMARK_.call(null,inst_21736);
var state_21777__$1 = state_21777;
if(inst_21738){
var statearr_21808_21881 = state_21777__$1;
(statearr_21808_21881[(1)] = (36));

} else {
var statearr_21809_21882 = state_21777__$1;
(statearr_21809_21882[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (13))){
var inst_21668 = (state_21777[(26)]);
var inst_21671 = cljs.core.async.close_BANG_.call(null,inst_21668);
var state_21777__$1 = state_21777;
var statearr_21810_21883 = state_21777__$1;
(statearr_21810_21883[(2)] = inst_21671);

(statearr_21810_21883[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (22))){
var inst_21689 = (state_21777[(8)]);
var inst_21692 = cljs.core.async.close_BANG_.call(null,inst_21689);
var state_21777__$1 = state_21777;
var statearr_21811_21884 = state_21777__$1;
(statearr_21811_21884[(2)] = inst_21692);

(statearr_21811_21884[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (36))){
var inst_21736 = (state_21777[(25)]);
var inst_21740 = cljs.core.chunk_first.call(null,inst_21736);
var inst_21741 = cljs.core.chunk_rest.call(null,inst_21736);
var inst_21742 = cljs.core.count.call(null,inst_21740);
var inst_21717 = inst_21741;
var inst_21718 = inst_21740;
var inst_21719 = inst_21742;
var inst_21720 = (0);
var state_21777__$1 = (function (){var statearr_21812 = state_21777;
(statearr_21812[(20)] = inst_21717);

(statearr_21812[(21)] = inst_21719);

(statearr_21812[(9)] = inst_21718);

(statearr_21812[(11)] = inst_21720);

return statearr_21812;
})();
var statearr_21813_21885 = state_21777__$1;
(statearr_21813_21885[(2)] = null);

(statearr_21813_21885[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (41))){
var inst_21736 = (state_21777[(25)]);
var inst_21752 = (state_21777[(2)]);
var inst_21753 = cljs.core.next.call(null,inst_21736);
var inst_21717 = inst_21753;
var inst_21718 = null;
var inst_21719 = (0);
var inst_21720 = (0);
var state_21777__$1 = (function (){var statearr_21814 = state_21777;
(statearr_21814[(20)] = inst_21717);

(statearr_21814[(27)] = inst_21752);

(statearr_21814[(21)] = inst_21719);

(statearr_21814[(9)] = inst_21718);

(statearr_21814[(11)] = inst_21720);

return statearr_21814;
})();
var statearr_21815_21886 = state_21777__$1;
(statearr_21815_21886[(2)] = null);

(statearr_21815_21886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (43))){
var state_21777__$1 = state_21777;
var statearr_21816_21887 = state_21777__$1;
(statearr_21816_21887[(2)] = null);

(statearr_21816_21887[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (29))){
var inst_21761 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21817_21888 = state_21777__$1;
(statearr_21817_21888[(2)] = inst_21761);

(statearr_21817_21888[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (44))){
var inst_21770 = (state_21777[(2)]);
var state_21777__$1 = (function (){var statearr_21818 = state_21777;
(statearr_21818[(28)] = inst_21770);

return statearr_21818;
})();
var statearr_21819_21889 = state_21777__$1;
(statearr_21819_21889[(2)] = null);

(statearr_21819_21889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (6))){
var inst_21709 = (state_21777[(29)]);
var inst_21708 = cljs.core.deref.call(null,cs);
var inst_21709__$1 = cljs.core.keys.call(null,inst_21708);
var inst_21710 = cljs.core.count.call(null,inst_21709__$1);
var inst_21711 = cljs.core.reset_BANG_.call(null,dctr,inst_21710);
var inst_21716 = cljs.core.seq.call(null,inst_21709__$1);
var inst_21717 = inst_21716;
var inst_21718 = null;
var inst_21719 = (0);
var inst_21720 = (0);
var state_21777__$1 = (function (){var statearr_21820 = state_21777;
(statearr_21820[(20)] = inst_21717);

(statearr_21820[(21)] = inst_21719);

(statearr_21820[(9)] = inst_21718);

(statearr_21820[(11)] = inst_21720);

(statearr_21820[(30)] = inst_21711);

(statearr_21820[(29)] = inst_21709__$1);

return statearr_21820;
})();
var statearr_21821_21890 = state_21777__$1;
(statearr_21821_21890[(2)] = null);

(statearr_21821_21890[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (28))){
var inst_21717 = (state_21777[(20)]);
var inst_21736 = (state_21777[(25)]);
var inst_21736__$1 = cljs.core.seq.call(null,inst_21717);
var state_21777__$1 = (function (){var statearr_21822 = state_21777;
(statearr_21822[(25)] = inst_21736__$1);

return statearr_21822;
})();
if(inst_21736__$1){
var statearr_21823_21891 = state_21777__$1;
(statearr_21823_21891[(1)] = (33));

} else {
var statearr_21824_21892 = state_21777__$1;
(statearr_21824_21892[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (25))){
var inst_21719 = (state_21777[(21)]);
var inst_21720 = (state_21777[(11)]);
var inst_21722 = (inst_21720 < inst_21719);
var inst_21723 = inst_21722;
var state_21777__$1 = state_21777;
if(cljs.core.truth_(inst_21723)){
var statearr_21825_21893 = state_21777__$1;
(statearr_21825_21893[(1)] = (27));

} else {
var statearr_21826_21894 = state_21777__$1;
(statearr_21826_21894[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (34))){
var state_21777__$1 = state_21777;
var statearr_21827_21895 = state_21777__$1;
(statearr_21827_21895[(2)] = null);

(statearr_21827_21895[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (17))){
var state_21777__$1 = state_21777;
var statearr_21828_21896 = state_21777__$1;
(statearr_21828_21896[(2)] = null);

(statearr_21828_21896[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (3))){
var inst_21775 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21777__$1,inst_21775);
} else {
if((state_val_21778 === (12))){
var inst_21704 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21829_21897 = state_21777__$1;
(statearr_21829_21897[(2)] = inst_21704);

(statearr_21829_21897[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (2))){
var state_21777__$1 = state_21777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21777__$1,(4),ch);
} else {
if((state_val_21778 === (23))){
var state_21777__$1 = state_21777;
var statearr_21830_21898 = state_21777__$1;
(statearr_21830_21898[(2)] = null);

(statearr_21830_21898[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (35))){
var inst_21759 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21831_21899 = state_21777__$1;
(statearr_21831_21899[(2)] = inst_21759);

(statearr_21831_21899[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (19))){
var inst_21678 = (state_21777[(7)]);
var inst_21682 = cljs.core.chunk_first.call(null,inst_21678);
var inst_21683 = cljs.core.chunk_rest.call(null,inst_21678);
var inst_21684 = cljs.core.count.call(null,inst_21682);
var inst_21658 = inst_21683;
var inst_21659 = inst_21682;
var inst_21660 = inst_21684;
var inst_21661 = (0);
var state_21777__$1 = (function (){var statearr_21832 = state_21777;
(statearr_21832[(13)] = inst_21659);

(statearr_21832[(15)] = inst_21658);

(statearr_21832[(16)] = inst_21660);

(statearr_21832[(17)] = inst_21661);

return statearr_21832;
})();
var statearr_21833_21900 = state_21777__$1;
(statearr_21833_21900[(2)] = null);

(statearr_21833_21900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (11))){
var inst_21678 = (state_21777[(7)]);
var inst_21658 = (state_21777[(15)]);
var inst_21678__$1 = cljs.core.seq.call(null,inst_21658);
var state_21777__$1 = (function (){var statearr_21834 = state_21777;
(statearr_21834[(7)] = inst_21678__$1);

return statearr_21834;
})();
if(inst_21678__$1){
var statearr_21835_21901 = state_21777__$1;
(statearr_21835_21901[(1)] = (16));

} else {
var statearr_21836_21902 = state_21777__$1;
(statearr_21836_21902[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (9))){
var inst_21706 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21837_21903 = state_21777__$1;
(statearr_21837_21903[(2)] = inst_21706);

(statearr_21837_21903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (5))){
var inst_21656 = cljs.core.deref.call(null,cs);
var inst_21657 = cljs.core.seq.call(null,inst_21656);
var inst_21658 = inst_21657;
var inst_21659 = null;
var inst_21660 = (0);
var inst_21661 = (0);
var state_21777__$1 = (function (){var statearr_21838 = state_21777;
(statearr_21838[(13)] = inst_21659);

(statearr_21838[(15)] = inst_21658);

(statearr_21838[(16)] = inst_21660);

(statearr_21838[(17)] = inst_21661);

return statearr_21838;
})();
var statearr_21839_21904 = state_21777__$1;
(statearr_21839_21904[(2)] = null);

(statearr_21839_21904[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (14))){
var state_21777__$1 = state_21777;
var statearr_21840_21905 = state_21777__$1;
(statearr_21840_21905[(2)] = null);

(statearr_21840_21905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (45))){
var inst_21767 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21841_21906 = state_21777__$1;
(statearr_21841_21906[(2)] = inst_21767);

(statearr_21841_21906[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (26))){
var inst_21709 = (state_21777[(29)]);
var inst_21763 = (state_21777[(2)]);
var inst_21764 = cljs.core.seq.call(null,inst_21709);
var state_21777__$1 = (function (){var statearr_21842 = state_21777;
(statearr_21842[(31)] = inst_21763);

return statearr_21842;
})();
if(inst_21764){
var statearr_21843_21907 = state_21777__$1;
(statearr_21843_21907[(1)] = (42));

} else {
var statearr_21844_21908 = state_21777__$1;
(statearr_21844_21908[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (16))){
var inst_21678 = (state_21777[(7)]);
var inst_21680 = cljs.core.chunked_seq_QMARK_.call(null,inst_21678);
var state_21777__$1 = state_21777;
if(inst_21680){
var statearr_21845_21909 = state_21777__$1;
(statearr_21845_21909[(1)] = (19));

} else {
var statearr_21846_21910 = state_21777__$1;
(statearr_21846_21910[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (38))){
var inst_21756 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21847_21911 = state_21777__$1;
(statearr_21847_21911[(2)] = inst_21756);

(statearr_21847_21911[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (30))){
var state_21777__$1 = state_21777;
var statearr_21848_21912 = state_21777__$1;
(statearr_21848_21912[(2)] = null);

(statearr_21848_21912[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (10))){
var inst_21659 = (state_21777[(13)]);
var inst_21661 = (state_21777[(17)]);
var inst_21667 = cljs.core._nth.call(null,inst_21659,inst_21661);
var inst_21668 = cljs.core.nth.call(null,inst_21667,(0),null);
var inst_21669 = cljs.core.nth.call(null,inst_21667,(1),null);
var state_21777__$1 = (function (){var statearr_21849 = state_21777;
(statearr_21849[(26)] = inst_21668);

return statearr_21849;
})();
if(cljs.core.truth_(inst_21669)){
var statearr_21850_21913 = state_21777__$1;
(statearr_21850_21913[(1)] = (13));

} else {
var statearr_21851_21914 = state_21777__$1;
(statearr_21851_21914[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (18))){
var inst_21702 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21852_21915 = state_21777__$1;
(statearr_21852_21915[(2)] = inst_21702);

(statearr_21852_21915[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (42))){
var state_21777__$1 = state_21777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21777__$1,(45),dchan);
} else {
if((state_val_21778 === (37))){
var inst_21736 = (state_21777[(25)]);
var inst_21649 = (state_21777[(10)]);
var inst_21745 = (state_21777[(23)]);
var inst_21745__$1 = cljs.core.first.call(null,inst_21736);
var inst_21746 = cljs.core.async.put_BANG_.call(null,inst_21745__$1,inst_21649,done);
var state_21777__$1 = (function (){var statearr_21853 = state_21777;
(statearr_21853[(23)] = inst_21745__$1);

return statearr_21853;
})();
if(cljs.core.truth_(inst_21746)){
var statearr_21854_21916 = state_21777__$1;
(statearr_21854_21916[(1)] = (39));

} else {
var statearr_21855_21917 = state_21777__$1;
(statearr_21855_21917[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (8))){
var inst_21660 = (state_21777[(16)]);
var inst_21661 = (state_21777[(17)]);
var inst_21663 = (inst_21661 < inst_21660);
var inst_21664 = inst_21663;
var state_21777__$1 = state_21777;
if(cljs.core.truth_(inst_21664)){
var statearr_21856_21918 = state_21777__$1;
(statearr_21856_21918[(1)] = (10));

} else {
var statearr_21857_21919 = state_21777__$1;
(statearr_21857_21919[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___21865,cs,m,dchan,dctr,done))
;
return ((function (switch__20446__auto__,c__20558__auto___21865,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20447__auto__ = null;
var cljs$core$async$mult_$_state_machine__20447__auto____0 = (function (){
var statearr_21861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21861[(0)] = cljs$core$async$mult_$_state_machine__20447__auto__);

(statearr_21861[(1)] = (1));

return statearr_21861;
});
var cljs$core$async$mult_$_state_machine__20447__auto____1 = (function (state_21777){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_21777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e21862){if((e21862 instanceof Object)){
var ex__20450__auto__ = e21862;
var statearr_21863_21920 = state_21777;
(statearr_21863_21920[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21777);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21921 = state_21777;
state_21777 = G__21921;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20447__auto__ = function(state_21777){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20447__auto____1.call(this,state_21777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20447__auto____0;
cljs$core$async$mult_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20447__auto____1;
return cljs$core$async$mult_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___21865,cs,m,dchan,dctr,done))
})();
var state__20560__auto__ = (function (){var statearr_21864 = f__20559__auto__.call(null);
(statearr_21864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___21865);

return statearr_21864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___21865,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21922 = [];
var len__19463__auto___21925 = arguments.length;
var i__19464__auto___21926 = (0);
while(true){
if((i__19464__auto___21926 < len__19463__auto___21925)){
args21922.push((arguments[i__19464__auto___21926]));

var G__21927 = (i__19464__auto___21926 + (1));
i__19464__auto___21926 = G__21927;
continue;
} else {
}
break;
}

var G__21924 = args21922.length;
switch (G__21924) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21922.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,ch);
} else {
var m__19061__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,ch);
} else {
var m__19061__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m);
} else {
var m__19061__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,state_map);
} else {
var m__19061__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19060__auto__ = (((m == null))?null:m);
var m__19061__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,m,mode);
} else {
var m__19061__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__19470__auto__ = [];
var len__19463__auto___21939 = arguments.length;
var i__19464__auto___21940 = (0);
while(true){
if((i__19464__auto___21940 < len__19463__auto___21939)){
args__19470__auto__.push((arguments[i__19464__auto___21940]));

var G__21941 = (i__19464__auto___21940 + (1));
i__19464__auto___21940 = G__21941;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((3) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19471__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21933){
var map__21934 = p__21933;
var map__21934__$1 = ((((!((map__21934 == null)))?((((map__21934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21934):map__21934);
var opts = map__21934__$1;
var statearr_21936_21942 = state;
(statearr_21936_21942[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__21934,map__21934__$1,opts){
return (function (val){
var statearr_21937_21943 = state;
(statearr_21937_21943[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21934,map__21934__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_21938_21944 = state;
(statearr_21938_21944[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21929){
var G__21930 = cljs.core.first.call(null,seq21929);
var seq21929__$1 = cljs.core.next.call(null,seq21929);
var G__21931 = cljs.core.first.call(null,seq21929__$1);
var seq21929__$2 = cljs.core.next.call(null,seq21929__$1);
var G__21932 = cljs.core.first.call(null,seq21929__$2);
var seq21929__$3 = cljs.core.next.call(null,seq21929__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21930,G__21931,G__21932,seq21929__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async22108 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22108 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta22109){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta22109 = meta22109;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22110,meta22109__$1){
var self__ = this;
var _22110__$1 = this;
return (new cljs.core.async.t_cljs$core$async22108(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta22109__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22110){
var self__ = this;
var _22110__$1 = this;
return self__.meta22109;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta22109","meta22109",-1175765384,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22108.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22108.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22108";

cljs.core.async.t_cljs$core$async22108.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22108");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async22108 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async22108(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22109){
return (new cljs.core.async.t_cljs$core$async22108(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22109));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async22108(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20558__auto___22271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_22208){
var state_val_22209 = (state_22208[(1)]);
if((state_val_22209 === (7))){
var inst_22126 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
var statearr_22210_22272 = state_22208__$1;
(statearr_22210_22272[(2)] = inst_22126);

(statearr_22210_22272[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (20))){
var inst_22138 = (state_22208[(7)]);
var state_22208__$1 = state_22208;
var statearr_22211_22273 = state_22208__$1;
(statearr_22211_22273[(2)] = inst_22138);

(statearr_22211_22273[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (27))){
var state_22208__$1 = state_22208;
var statearr_22212_22274 = state_22208__$1;
(statearr_22212_22274[(2)] = null);

(statearr_22212_22274[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (1))){
var inst_22114 = (state_22208[(8)]);
var inst_22114__$1 = calc_state.call(null);
var inst_22116 = (inst_22114__$1 == null);
var inst_22117 = cljs.core.not.call(null,inst_22116);
var state_22208__$1 = (function (){var statearr_22213 = state_22208;
(statearr_22213[(8)] = inst_22114__$1);

return statearr_22213;
})();
if(inst_22117){
var statearr_22214_22275 = state_22208__$1;
(statearr_22214_22275[(1)] = (2));

} else {
var statearr_22215_22276 = state_22208__$1;
(statearr_22215_22276[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (24))){
var inst_22168 = (state_22208[(9)]);
var inst_22161 = (state_22208[(10)]);
var inst_22182 = (state_22208[(11)]);
var inst_22182__$1 = inst_22161.call(null,inst_22168);
var state_22208__$1 = (function (){var statearr_22216 = state_22208;
(statearr_22216[(11)] = inst_22182__$1);

return statearr_22216;
})();
if(cljs.core.truth_(inst_22182__$1)){
var statearr_22217_22277 = state_22208__$1;
(statearr_22217_22277[(1)] = (29));

} else {
var statearr_22218_22278 = state_22208__$1;
(statearr_22218_22278[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (4))){
var inst_22129 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22129)){
var statearr_22219_22279 = state_22208__$1;
(statearr_22219_22279[(1)] = (8));

} else {
var statearr_22220_22280 = state_22208__$1;
(statearr_22220_22280[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (15))){
var inst_22155 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22155)){
var statearr_22221_22281 = state_22208__$1;
(statearr_22221_22281[(1)] = (19));

} else {
var statearr_22222_22282 = state_22208__$1;
(statearr_22222_22282[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (21))){
var inst_22160 = (state_22208[(12)]);
var inst_22160__$1 = (state_22208[(2)]);
var inst_22161 = cljs.core.get.call(null,inst_22160__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22162 = cljs.core.get.call(null,inst_22160__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22163 = cljs.core.get.call(null,inst_22160__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_22208__$1 = (function (){var statearr_22223 = state_22208;
(statearr_22223[(12)] = inst_22160__$1);

(statearr_22223[(10)] = inst_22161);

(statearr_22223[(13)] = inst_22162);

return statearr_22223;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_22208__$1,(22),inst_22163);
} else {
if((state_val_22209 === (31))){
var inst_22190 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22190)){
var statearr_22224_22283 = state_22208__$1;
(statearr_22224_22283[(1)] = (32));

} else {
var statearr_22225_22284 = state_22208__$1;
(statearr_22225_22284[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (32))){
var inst_22167 = (state_22208[(14)]);
var state_22208__$1 = state_22208;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22208__$1,(35),out,inst_22167);
} else {
if((state_val_22209 === (33))){
var inst_22160 = (state_22208[(12)]);
var inst_22138 = inst_22160;
var state_22208__$1 = (function (){var statearr_22226 = state_22208;
(statearr_22226[(7)] = inst_22138);

return statearr_22226;
})();
var statearr_22227_22285 = state_22208__$1;
(statearr_22227_22285[(2)] = null);

(statearr_22227_22285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (13))){
var inst_22138 = (state_22208[(7)]);
var inst_22145 = inst_22138.cljs$lang$protocol_mask$partition0$;
var inst_22146 = (inst_22145 & (64));
var inst_22147 = inst_22138.cljs$core$ISeq$;
var inst_22148 = (inst_22146) || (inst_22147);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22148)){
var statearr_22228_22286 = state_22208__$1;
(statearr_22228_22286[(1)] = (16));

} else {
var statearr_22229_22287 = state_22208__$1;
(statearr_22229_22287[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (22))){
var inst_22167 = (state_22208[(14)]);
var inst_22168 = (state_22208[(9)]);
var inst_22166 = (state_22208[(2)]);
var inst_22167__$1 = cljs.core.nth.call(null,inst_22166,(0),null);
var inst_22168__$1 = cljs.core.nth.call(null,inst_22166,(1),null);
var inst_22169 = (inst_22167__$1 == null);
var inst_22170 = cljs.core._EQ_.call(null,inst_22168__$1,change);
var inst_22171 = (inst_22169) || (inst_22170);
var state_22208__$1 = (function (){var statearr_22230 = state_22208;
(statearr_22230[(14)] = inst_22167__$1);

(statearr_22230[(9)] = inst_22168__$1);

return statearr_22230;
})();
if(cljs.core.truth_(inst_22171)){
var statearr_22231_22288 = state_22208__$1;
(statearr_22231_22288[(1)] = (23));

} else {
var statearr_22232_22289 = state_22208__$1;
(statearr_22232_22289[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (36))){
var inst_22160 = (state_22208[(12)]);
var inst_22138 = inst_22160;
var state_22208__$1 = (function (){var statearr_22233 = state_22208;
(statearr_22233[(7)] = inst_22138);

return statearr_22233;
})();
var statearr_22234_22290 = state_22208__$1;
(statearr_22234_22290[(2)] = null);

(statearr_22234_22290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (29))){
var inst_22182 = (state_22208[(11)]);
var state_22208__$1 = state_22208;
var statearr_22235_22291 = state_22208__$1;
(statearr_22235_22291[(2)] = inst_22182);

(statearr_22235_22291[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (6))){
var state_22208__$1 = state_22208;
var statearr_22236_22292 = state_22208__$1;
(statearr_22236_22292[(2)] = false);

(statearr_22236_22292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (28))){
var inst_22178 = (state_22208[(2)]);
var inst_22179 = calc_state.call(null);
var inst_22138 = inst_22179;
var state_22208__$1 = (function (){var statearr_22237 = state_22208;
(statearr_22237[(15)] = inst_22178);

(statearr_22237[(7)] = inst_22138);

return statearr_22237;
})();
var statearr_22238_22293 = state_22208__$1;
(statearr_22238_22293[(2)] = null);

(statearr_22238_22293[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (25))){
var inst_22204 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
var statearr_22239_22294 = state_22208__$1;
(statearr_22239_22294[(2)] = inst_22204);

(statearr_22239_22294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (34))){
var inst_22202 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
var statearr_22240_22295 = state_22208__$1;
(statearr_22240_22295[(2)] = inst_22202);

(statearr_22240_22295[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (17))){
var state_22208__$1 = state_22208;
var statearr_22241_22296 = state_22208__$1;
(statearr_22241_22296[(2)] = false);

(statearr_22241_22296[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (3))){
var state_22208__$1 = state_22208;
var statearr_22242_22297 = state_22208__$1;
(statearr_22242_22297[(2)] = false);

(statearr_22242_22297[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (12))){
var inst_22206 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22208__$1,inst_22206);
} else {
if((state_val_22209 === (2))){
var inst_22114 = (state_22208[(8)]);
var inst_22119 = inst_22114.cljs$lang$protocol_mask$partition0$;
var inst_22120 = (inst_22119 & (64));
var inst_22121 = inst_22114.cljs$core$ISeq$;
var inst_22122 = (inst_22120) || (inst_22121);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22122)){
var statearr_22243_22298 = state_22208__$1;
(statearr_22243_22298[(1)] = (5));

} else {
var statearr_22244_22299 = state_22208__$1;
(statearr_22244_22299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (23))){
var inst_22167 = (state_22208[(14)]);
var inst_22173 = (inst_22167 == null);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22173)){
var statearr_22245_22300 = state_22208__$1;
(statearr_22245_22300[(1)] = (26));

} else {
var statearr_22246_22301 = state_22208__$1;
(statearr_22246_22301[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (35))){
var inst_22193 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
if(cljs.core.truth_(inst_22193)){
var statearr_22247_22302 = state_22208__$1;
(statearr_22247_22302[(1)] = (36));

} else {
var statearr_22248_22303 = state_22208__$1;
(statearr_22248_22303[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (19))){
var inst_22138 = (state_22208[(7)]);
var inst_22157 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22138);
var state_22208__$1 = state_22208;
var statearr_22249_22304 = state_22208__$1;
(statearr_22249_22304[(2)] = inst_22157);

(statearr_22249_22304[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (11))){
var inst_22138 = (state_22208[(7)]);
var inst_22142 = (inst_22138 == null);
var inst_22143 = cljs.core.not.call(null,inst_22142);
var state_22208__$1 = state_22208;
if(inst_22143){
var statearr_22250_22305 = state_22208__$1;
(statearr_22250_22305[(1)] = (13));

} else {
var statearr_22251_22306 = state_22208__$1;
(statearr_22251_22306[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (9))){
var inst_22114 = (state_22208[(8)]);
var state_22208__$1 = state_22208;
var statearr_22252_22307 = state_22208__$1;
(statearr_22252_22307[(2)] = inst_22114);

(statearr_22252_22307[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (5))){
var state_22208__$1 = state_22208;
var statearr_22253_22308 = state_22208__$1;
(statearr_22253_22308[(2)] = true);

(statearr_22253_22308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (14))){
var state_22208__$1 = state_22208;
var statearr_22254_22309 = state_22208__$1;
(statearr_22254_22309[(2)] = false);

(statearr_22254_22309[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (26))){
var inst_22168 = (state_22208[(9)]);
var inst_22175 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_22168);
var state_22208__$1 = state_22208;
var statearr_22255_22310 = state_22208__$1;
(statearr_22255_22310[(2)] = inst_22175);

(statearr_22255_22310[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (16))){
var state_22208__$1 = state_22208;
var statearr_22256_22311 = state_22208__$1;
(statearr_22256_22311[(2)] = true);

(statearr_22256_22311[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (38))){
var inst_22198 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
var statearr_22257_22312 = state_22208__$1;
(statearr_22257_22312[(2)] = inst_22198);

(statearr_22257_22312[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (30))){
var inst_22168 = (state_22208[(9)]);
var inst_22161 = (state_22208[(10)]);
var inst_22162 = (state_22208[(13)]);
var inst_22185 = cljs.core.empty_QMARK_.call(null,inst_22161);
var inst_22186 = inst_22162.call(null,inst_22168);
var inst_22187 = cljs.core.not.call(null,inst_22186);
var inst_22188 = (inst_22185) && (inst_22187);
var state_22208__$1 = state_22208;
var statearr_22258_22313 = state_22208__$1;
(statearr_22258_22313[(2)] = inst_22188);

(statearr_22258_22313[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (10))){
var inst_22114 = (state_22208[(8)]);
var inst_22134 = (state_22208[(2)]);
var inst_22135 = cljs.core.get.call(null,inst_22134,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22136 = cljs.core.get.call(null,inst_22134,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22137 = cljs.core.get.call(null,inst_22134,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_22138 = inst_22114;
var state_22208__$1 = (function (){var statearr_22259 = state_22208;
(statearr_22259[(16)] = inst_22135);

(statearr_22259[(17)] = inst_22136);

(statearr_22259[(7)] = inst_22138);

(statearr_22259[(18)] = inst_22137);

return statearr_22259;
})();
var statearr_22260_22314 = state_22208__$1;
(statearr_22260_22314[(2)] = null);

(statearr_22260_22314[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (18))){
var inst_22152 = (state_22208[(2)]);
var state_22208__$1 = state_22208;
var statearr_22261_22315 = state_22208__$1;
(statearr_22261_22315[(2)] = inst_22152);

(statearr_22261_22315[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (37))){
var state_22208__$1 = state_22208;
var statearr_22262_22316 = state_22208__$1;
(statearr_22262_22316[(2)] = null);

(statearr_22262_22316[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22209 === (8))){
var inst_22114 = (state_22208[(8)]);
var inst_22131 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22114);
var state_22208__$1 = state_22208;
var statearr_22263_22317 = state_22208__$1;
(statearr_22263_22317[(2)] = inst_22131);

(statearr_22263_22317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20446__auto__,c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20447__auto__ = null;
var cljs$core$async$mix_$_state_machine__20447__auto____0 = (function (){
var statearr_22267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22267[(0)] = cljs$core$async$mix_$_state_machine__20447__auto__);

(statearr_22267[(1)] = (1));

return statearr_22267;
});
var cljs$core$async$mix_$_state_machine__20447__auto____1 = (function (state_22208){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22268){if((e22268 instanceof Object)){
var ex__20450__auto__ = e22268;
var statearr_22269_22318 = state_22208;
(statearr_22269_22318[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22208);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22268;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22319 = state_22208;
state_22208 = G__22319;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20447__auto__ = function(state_22208){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20447__auto____1.call(this,state_22208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20447__auto____0;
cljs$core$async$mix_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20447__auto____1;
return cljs$core$async$mix_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20560__auto__ = (function (){var statearr_22270 = f__20559__auto__.call(null);
(statearr_22270[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22271);

return statearr_22270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22271,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19060__auto__ = (((p == null))?null:p);
var m__19061__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19061__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19060__auto__ = (((p == null))?null:p);
var m__19061__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,p,v,ch);
} else {
var m__19061__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args22320 = [];
var len__19463__auto___22323 = arguments.length;
var i__19464__auto___22324 = (0);
while(true){
if((i__19464__auto___22324 < len__19463__auto___22323)){
args22320.push((arguments[i__19464__auto___22324]));

var G__22325 = (i__19464__auto___22324 + (1));
i__19464__auto___22324 = G__22325;
continue;
} else {
}
break;
}

var G__22322 = args22320.length;
switch (G__22322) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22320.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19060__auto__ = (((p == null))?null:p);
var m__19061__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,p);
} else {
var m__19061__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19060__auto__ = (((p == null))?null:p);
var m__19061__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,p,v);
} else {
var m__19061__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args22328 = [];
var len__19463__auto___22453 = arguments.length;
var i__19464__auto___22454 = (0);
while(true){
if((i__19464__auto___22454 < len__19463__auto___22453)){
args22328.push((arguments[i__19464__auto___22454]));

var G__22455 = (i__19464__auto___22454 + (1));
i__19464__auto___22454 = G__22455;
continue;
} else {
}
break;
}

var G__22330 = args22328.length;
switch (G__22330) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22328.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18405__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18405__auto__,mults){
return (function (p1__22327_SHARP_){
if(cljs.core.truth_(p1__22327_SHARP_.call(null,topic))){
return p1__22327_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__22327_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18405__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22331 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22332){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22332 = meta22332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22333,meta22332__$1){
var self__ = this;
var _22333__$1 = this;
return (new cljs.core.async.t_cljs$core$async22331(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22332__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22333){
var self__ = this;
var _22333__$1 = this;
return self__.meta22332;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22332","meta22332",-677181205,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22331";

cljs.core.async.t_cljs$core$async22331.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22331");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22331 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22331(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22332){
return (new cljs.core.async.t_cljs$core$async22331(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22332));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22331(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20558__auto___22457 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22457,mults,ensure_mult,p){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22457,mults,ensure_mult,p){
return (function (state_22405){
var state_val_22406 = (state_22405[(1)]);
if((state_val_22406 === (7))){
var inst_22401 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22407_22458 = state_22405__$1;
(statearr_22407_22458[(2)] = inst_22401);

(statearr_22407_22458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (20))){
var state_22405__$1 = state_22405;
var statearr_22408_22459 = state_22405__$1;
(statearr_22408_22459[(2)] = null);

(statearr_22408_22459[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (1))){
var state_22405__$1 = state_22405;
var statearr_22409_22460 = state_22405__$1;
(statearr_22409_22460[(2)] = null);

(statearr_22409_22460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (24))){
var inst_22384 = (state_22405[(7)]);
var inst_22393 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22384);
var state_22405__$1 = state_22405;
var statearr_22410_22461 = state_22405__$1;
(statearr_22410_22461[(2)] = inst_22393);

(statearr_22410_22461[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (4))){
var inst_22336 = (state_22405[(8)]);
var inst_22336__$1 = (state_22405[(2)]);
var inst_22337 = (inst_22336__$1 == null);
var state_22405__$1 = (function (){var statearr_22411 = state_22405;
(statearr_22411[(8)] = inst_22336__$1);

return statearr_22411;
})();
if(cljs.core.truth_(inst_22337)){
var statearr_22412_22462 = state_22405__$1;
(statearr_22412_22462[(1)] = (5));

} else {
var statearr_22413_22463 = state_22405__$1;
(statearr_22413_22463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (15))){
var inst_22378 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22414_22464 = state_22405__$1;
(statearr_22414_22464[(2)] = inst_22378);

(statearr_22414_22464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (21))){
var inst_22398 = (state_22405[(2)]);
var state_22405__$1 = (function (){var statearr_22415 = state_22405;
(statearr_22415[(9)] = inst_22398);

return statearr_22415;
})();
var statearr_22416_22465 = state_22405__$1;
(statearr_22416_22465[(2)] = null);

(statearr_22416_22465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (13))){
var inst_22360 = (state_22405[(10)]);
var inst_22362 = cljs.core.chunked_seq_QMARK_.call(null,inst_22360);
var state_22405__$1 = state_22405;
if(inst_22362){
var statearr_22417_22466 = state_22405__$1;
(statearr_22417_22466[(1)] = (16));

} else {
var statearr_22418_22467 = state_22405__$1;
(statearr_22418_22467[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (22))){
var inst_22390 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
if(cljs.core.truth_(inst_22390)){
var statearr_22419_22468 = state_22405__$1;
(statearr_22419_22468[(1)] = (23));

} else {
var statearr_22420_22469 = state_22405__$1;
(statearr_22420_22469[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (6))){
var inst_22384 = (state_22405[(7)]);
var inst_22336 = (state_22405[(8)]);
var inst_22386 = (state_22405[(11)]);
var inst_22384__$1 = topic_fn.call(null,inst_22336);
var inst_22385 = cljs.core.deref.call(null,mults);
var inst_22386__$1 = cljs.core.get.call(null,inst_22385,inst_22384__$1);
var state_22405__$1 = (function (){var statearr_22421 = state_22405;
(statearr_22421[(7)] = inst_22384__$1);

(statearr_22421[(11)] = inst_22386__$1);

return statearr_22421;
})();
if(cljs.core.truth_(inst_22386__$1)){
var statearr_22422_22470 = state_22405__$1;
(statearr_22422_22470[(1)] = (19));

} else {
var statearr_22423_22471 = state_22405__$1;
(statearr_22423_22471[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (25))){
var inst_22395 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22424_22472 = state_22405__$1;
(statearr_22424_22472[(2)] = inst_22395);

(statearr_22424_22472[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (17))){
var inst_22360 = (state_22405[(10)]);
var inst_22369 = cljs.core.first.call(null,inst_22360);
var inst_22370 = cljs.core.async.muxch_STAR_.call(null,inst_22369);
var inst_22371 = cljs.core.async.close_BANG_.call(null,inst_22370);
var inst_22372 = cljs.core.next.call(null,inst_22360);
var inst_22346 = inst_22372;
var inst_22347 = null;
var inst_22348 = (0);
var inst_22349 = (0);
var state_22405__$1 = (function (){var statearr_22425 = state_22405;
(statearr_22425[(12)] = inst_22347);

(statearr_22425[(13)] = inst_22348);

(statearr_22425[(14)] = inst_22349);

(statearr_22425[(15)] = inst_22371);

(statearr_22425[(16)] = inst_22346);

return statearr_22425;
})();
var statearr_22426_22473 = state_22405__$1;
(statearr_22426_22473[(2)] = null);

(statearr_22426_22473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (3))){
var inst_22403 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22405__$1,inst_22403);
} else {
if((state_val_22406 === (12))){
var inst_22380 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22427_22474 = state_22405__$1;
(statearr_22427_22474[(2)] = inst_22380);

(statearr_22427_22474[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (2))){
var state_22405__$1 = state_22405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22405__$1,(4),ch);
} else {
if((state_val_22406 === (23))){
var state_22405__$1 = state_22405;
var statearr_22428_22475 = state_22405__$1;
(statearr_22428_22475[(2)] = null);

(statearr_22428_22475[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (19))){
var inst_22336 = (state_22405[(8)]);
var inst_22386 = (state_22405[(11)]);
var inst_22388 = cljs.core.async.muxch_STAR_.call(null,inst_22386);
var state_22405__$1 = state_22405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22405__$1,(22),inst_22388,inst_22336);
} else {
if((state_val_22406 === (11))){
var inst_22346 = (state_22405[(16)]);
var inst_22360 = (state_22405[(10)]);
var inst_22360__$1 = cljs.core.seq.call(null,inst_22346);
var state_22405__$1 = (function (){var statearr_22429 = state_22405;
(statearr_22429[(10)] = inst_22360__$1);

return statearr_22429;
})();
if(inst_22360__$1){
var statearr_22430_22476 = state_22405__$1;
(statearr_22430_22476[(1)] = (13));

} else {
var statearr_22431_22477 = state_22405__$1;
(statearr_22431_22477[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (9))){
var inst_22382 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22432_22478 = state_22405__$1;
(statearr_22432_22478[(2)] = inst_22382);

(statearr_22432_22478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (5))){
var inst_22343 = cljs.core.deref.call(null,mults);
var inst_22344 = cljs.core.vals.call(null,inst_22343);
var inst_22345 = cljs.core.seq.call(null,inst_22344);
var inst_22346 = inst_22345;
var inst_22347 = null;
var inst_22348 = (0);
var inst_22349 = (0);
var state_22405__$1 = (function (){var statearr_22433 = state_22405;
(statearr_22433[(12)] = inst_22347);

(statearr_22433[(13)] = inst_22348);

(statearr_22433[(14)] = inst_22349);

(statearr_22433[(16)] = inst_22346);

return statearr_22433;
})();
var statearr_22434_22479 = state_22405__$1;
(statearr_22434_22479[(2)] = null);

(statearr_22434_22479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (14))){
var state_22405__$1 = state_22405;
var statearr_22438_22480 = state_22405__$1;
(statearr_22438_22480[(2)] = null);

(statearr_22438_22480[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (16))){
var inst_22360 = (state_22405[(10)]);
var inst_22364 = cljs.core.chunk_first.call(null,inst_22360);
var inst_22365 = cljs.core.chunk_rest.call(null,inst_22360);
var inst_22366 = cljs.core.count.call(null,inst_22364);
var inst_22346 = inst_22365;
var inst_22347 = inst_22364;
var inst_22348 = inst_22366;
var inst_22349 = (0);
var state_22405__$1 = (function (){var statearr_22439 = state_22405;
(statearr_22439[(12)] = inst_22347);

(statearr_22439[(13)] = inst_22348);

(statearr_22439[(14)] = inst_22349);

(statearr_22439[(16)] = inst_22346);

return statearr_22439;
})();
var statearr_22440_22481 = state_22405__$1;
(statearr_22440_22481[(2)] = null);

(statearr_22440_22481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (10))){
var inst_22347 = (state_22405[(12)]);
var inst_22348 = (state_22405[(13)]);
var inst_22349 = (state_22405[(14)]);
var inst_22346 = (state_22405[(16)]);
var inst_22354 = cljs.core._nth.call(null,inst_22347,inst_22349);
var inst_22355 = cljs.core.async.muxch_STAR_.call(null,inst_22354);
var inst_22356 = cljs.core.async.close_BANG_.call(null,inst_22355);
var inst_22357 = (inst_22349 + (1));
var tmp22435 = inst_22347;
var tmp22436 = inst_22348;
var tmp22437 = inst_22346;
var inst_22346__$1 = tmp22437;
var inst_22347__$1 = tmp22435;
var inst_22348__$1 = tmp22436;
var inst_22349__$1 = inst_22357;
var state_22405__$1 = (function (){var statearr_22441 = state_22405;
(statearr_22441[(12)] = inst_22347__$1);

(statearr_22441[(13)] = inst_22348__$1);

(statearr_22441[(17)] = inst_22356);

(statearr_22441[(14)] = inst_22349__$1);

(statearr_22441[(16)] = inst_22346__$1);

return statearr_22441;
})();
var statearr_22442_22482 = state_22405__$1;
(statearr_22442_22482[(2)] = null);

(statearr_22442_22482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (18))){
var inst_22375 = (state_22405[(2)]);
var state_22405__$1 = state_22405;
var statearr_22443_22483 = state_22405__$1;
(statearr_22443_22483[(2)] = inst_22375);

(statearr_22443_22483[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22406 === (8))){
var inst_22348 = (state_22405[(13)]);
var inst_22349 = (state_22405[(14)]);
var inst_22351 = (inst_22349 < inst_22348);
var inst_22352 = inst_22351;
var state_22405__$1 = state_22405;
if(cljs.core.truth_(inst_22352)){
var statearr_22444_22484 = state_22405__$1;
(statearr_22444_22484[(1)] = (10));

} else {
var statearr_22445_22485 = state_22405__$1;
(statearr_22445_22485[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22457,mults,ensure_mult,p))
;
return ((function (switch__20446__auto__,c__20558__auto___22457,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_22449 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22449[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_22449[(1)] = (1));

return statearr_22449;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_22405){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22450){if((e22450 instanceof Object)){
var ex__20450__auto__ = e22450;
var statearr_22451_22486 = state_22405;
(statearr_22451_22486[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22450;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22487 = state_22405;
state_22405 = G__22487;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_22405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_22405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22457,mults,ensure_mult,p))
})();
var state__20560__auto__ = (function (){var statearr_22452 = f__20559__auto__.call(null);
(statearr_22452[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22457);

return statearr_22452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22457,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22488 = [];
var len__19463__auto___22491 = arguments.length;
var i__19464__auto___22492 = (0);
while(true){
if((i__19464__auto___22492 < len__19463__auto___22491)){
args22488.push((arguments[i__19464__auto___22492]));

var G__22493 = (i__19464__auto___22492 + (1));
i__19464__auto___22492 = G__22493;
continue;
} else {
}
break;
}

var G__22490 = args22488.length;
switch (G__22490) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22488.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22495 = [];
var len__19463__auto___22498 = arguments.length;
var i__19464__auto___22499 = (0);
while(true){
if((i__19464__auto___22499 < len__19463__auto___22498)){
args22495.push((arguments[i__19464__auto___22499]));

var G__22500 = (i__19464__auto___22499 + (1));
i__19464__auto___22499 = G__22500;
continue;
} else {
}
break;
}

var G__22497 = args22495.length;
switch (G__22497) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22495.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22502 = [];
var len__19463__auto___22573 = arguments.length;
var i__19464__auto___22574 = (0);
while(true){
if((i__19464__auto___22574 < len__19463__auto___22573)){
args22502.push((arguments[i__19464__auto___22574]));

var G__22575 = (i__19464__auto___22574 + (1));
i__19464__auto___22574 = G__22575;
continue;
} else {
}
break;
}

var G__22504 = args22502.length;
switch (G__22504) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22502.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20558__auto___22577 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22543){
var state_val_22544 = (state_22543[(1)]);
if((state_val_22544 === (7))){
var state_22543__$1 = state_22543;
var statearr_22545_22578 = state_22543__$1;
(statearr_22545_22578[(2)] = null);

(statearr_22545_22578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (1))){
var state_22543__$1 = state_22543;
var statearr_22546_22579 = state_22543__$1;
(statearr_22546_22579[(2)] = null);

(statearr_22546_22579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (4))){
var inst_22507 = (state_22543[(7)]);
var inst_22509 = (inst_22507 < cnt);
var state_22543__$1 = state_22543;
if(cljs.core.truth_(inst_22509)){
var statearr_22547_22580 = state_22543__$1;
(statearr_22547_22580[(1)] = (6));

} else {
var statearr_22548_22581 = state_22543__$1;
(statearr_22548_22581[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (15))){
var inst_22539 = (state_22543[(2)]);
var state_22543__$1 = state_22543;
var statearr_22549_22582 = state_22543__$1;
(statearr_22549_22582[(2)] = inst_22539);

(statearr_22549_22582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (13))){
var inst_22532 = cljs.core.async.close_BANG_.call(null,out);
var state_22543__$1 = state_22543;
var statearr_22550_22583 = state_22543__$1;
(statearr_22550_22583[(2)] = inst_22532);

(statearr_22550_22583[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (6))){
var state_22543__$1 = state_22543;
var statearr_22551_22584 = state_22543__$1;
(statearr_22551_22584[(2)] = null);

(statearr_22551_22584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (3))){
var inst_22541 = (state_22543[(2)]);
var state_22543__$1 = state_22543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22543__$1,inst_22541);
} else {
if((state_val_22544 === (12))){
var inst_22529 = (state_22543[(8)]);
var inst_22529__$1 = (state_22543[(2)]);
var inst_22530 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22529__$1);
var state_22543__$1 = (function (){var statearr_22552 = state_22543;
(statearr_22552[(8)] = inst_22529__$1);

return statearr_22552;
})();
if(cljs.core.truth_(inst_22530)){
var statearr_22553_22585 = state_22543__$1;
(statearr_22553_22585[(1)] = (13));

} else {
var statearr_22554_22586 = state_22543__$1;
(statearr_22554_22586[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (2))){
var inst_22506 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22507 = (0);
var state_22543__$1 = (function (){var statearr_22555 = state_22543;
(statearr_22555[(9)] = inst_22506);

(statearr_22555[(7)] = inst_22507);

return statearr_22555;
})();
var statearr_22556_22587 = state_22543__$1;
(statearr_22556_22587[(2)] = null);

(statearr_22556_22587[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (11))){
var inst_22507 = (state_22543[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22543,(10),Object,null,(9));
var inst_22516 = chs__$1.call(null,inst_22507);
var inst_22517 = done.call(null,inst_22507);
var inst_22518 = cljs.core.async.take_BANG_.call(null,inst_22516,inst_22517);
var state_22543__$1 = state_22543;
var statearr_22557_22588 = state_22543__$1;
(statearr_22557_22588[(2)] = inst_22518);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22543__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (9))){
var inst_22507 = (state_22543[(7)]);
var inst_22520 = (state_22543[(2)]);
var inst_22521 = (inst_22507 + (1));
var inst_22507__$1 = inst_22521;
var state_22543__$1 = (function (){var statearr_22558 = state_22543;
(statearr_22558[(10)] = inst_22520);

(statearr_22558[(7)] = inst_22507__$1);

return statearr_22558;
})();
var statearr_22559_22589 = state_22543__$1;
(statearr_22559_22589[(2)] = null);

(statearr_22559_22589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (5))){
var inst_22527 = (state_22543[(2)]);
var state_22543__$1 = (function (){var statearr_22560 = state_22543;
(statearr_22560[(11)] = inst_22527);

return statearr_22560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22543__$1,(12),dchan);
} else {
if((state_val_22544 === (14))){
var inst_22529 = (state_22543[(8)]);
var inst_22534 = cljs.core.apply.call(null,f,inst_22529);
var state_22543__$1 = state_22543;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22543__$1,(16),out,inst_22534);
} else {
if((state_val_22544 === (16))){
var inst_22536 = (state_22543[(2)]);
var state_22543__$1 = (function (){var statearr_22561 = state_22543;
(statearr_22561[(12)] = inst_22536);

return statearr_22561;
})();
var statearr_22562_22590 = state_22543__$1;
(statearr_22562_22590[(2)] = null);

(statearr_22562_22590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (10))){
var inst_22511 = (state_22543[(2)]);
var inst_22512 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22543__$1 = (function (){var statearr_22563 = state_22543;
(statearr_22563[(13)] = inst_22511);

return statearr_22563;
})();
var statearr_22564_22591 = state_22543__$1;
(statearr_22564_22591[(2)] = inst_22512);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22543__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22544 === (8))){
var inst_22525 = (state_22543[(2)]);
var state_22543__$1 = state_22543;
var statearr_22565_22592 = state_22543__$1;
(statearr_22565_22592[(2)] = inst_22525);

(statearr_22565_22592[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20446__auto__,c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_22569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22569[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_22569[(1)] = (1));

return statearr_22569;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_22543){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22570){if((e22570 instanceof Object)){
var ex__20450__auto__ = e22570;
var statearr_22571_22593 = state_22543;
(statearr_22571_22593[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22543);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22570;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22594 = state_22543;
state_22543 = G__22594;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_22543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_22543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20560__auto__ = (function (){var statearr_22572 = f__20559__auto__.call(null);
(statearr_22572[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22577);

return statearr_22572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22577,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22596 = [];
var len__19463__auto___22652 = arguments.length;
var i__19464__auto___22653 = (0);
while(true){
if((i__19464__auto___22653 < len__19463__auto___22652)){
args22596.push((arguments[i__19464__auto___22653]));

var G__22654 = (i__19464__auto___22653 + (1));
i__19464__auto___22653 = G__22654;
continue;
} else {
}
break;
}

var G__22598 = args22596.length;
switch (G__22598) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22596.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___22656 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22656,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22656,out){
return (function (state_22628){
var state_val_22629 = (state_22628[(1)]);
if((state_val_22629 === (7))){
var inst_22608 = (state_22628[(7)]);
var inst_22607 = (state_22628[(8)]);
var inst_22607__$1 = (state_22628[(2)]);
var inst_22608__$1 = cljs.core.nth.call(null,inst_22607__$1,(0),null);
var inst_22609 = cljs.core.nth.call(null,inst_22607__$1,(1),null);
var inst_22610 = (inst_22608__$1 == null);
var state_22628__$1 = (function (){var statearr_22630 = state_22628;
(statearr_22630[(7)] = inst_22608__$1);

(statearr_22630[(9)] = inst_22609);

(statearr_22630[(8)] = inst_22607__$1);

return statearr_22630;
})();
if(cljs.core.truth_(inst_22610)){
var statearr_22631_22657 = state_22628__$1;
(statearr_22631_22657[(1)] = (8));

} else {
var statearr_22632_22658 = state_22628__$1;
(statearr_22632_22658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (1))){
var inst_22599 = cljs.core.vec.call(null,chs);
var inst_22600 = inst_22599;
var state_22628__$1 = (function (){var statearr_22633 = state_22628;
(statearr_22633[(10)] = inst_22600);

return statearr_22633;
})();
var statearr_22634_22659 = state_22628__$1;
(statearr_22634_22659[(2)] = null);

(statearr_22634_22659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (4))){
var inst_22600 = (state_22628[(10)]);
var state_22628__$1 = state_22628;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22628__$1,(7),inst_22600);
} else {
if((state_val_22629 === (6))){
var inst_22624 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22635_22660 = state_22628__$1;
(statearr_22635_22660[(2)] = inst_22624);

(statearr_22635_22660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (3))){
var inst_22626 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22628__$1,inst_22626);
} else {
if((state_val_22629 === (2))){
var inst_22600 = (state_22628[(10)]);
var inst_22602 = cljs.core.count.call(null,inst_22600);
var inst_22603 = (inst_22602 > (0));
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22603)){
var statearr_22637_22661 = state_22628__$1;
(statearr_22637_22661[(1)] = (4));

} else {
var statearr_22638_22662 = state_22628__$1;
(statearr_22638_22662[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (11))){
var inst_22600 = (state_22628[(10)]);
var inst_22617 = (state_22628[(2)]);
var tmp22636 = inst_22600;
var inst_22600__$1 = tmp22636;
var state_22628__$1 = (function (){var statearr_22639 = state_22628;
(statearr_22639[(11)] = inst_22617);

(statearr_22639[(10)] = inst_22600__$1);

return statearr_22639;
})();
var statearr_22640_22663 = state_22628__$1;
(statearr_22640_22663[(2)] = null);

(statearr_22640_22663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (9))){
var inst_22608 = (state_22628[(7)]);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22628__$1,(11),out,inst_22608);
} else {
if((state_val_22629 === (5))){
var inst_22622 = cljs.core.async.close_BANG_.call(null,out);
var state_22628__$1 = state_22628;
var statearr_22641_22664 = state_22628__$1;
(statearr_22641_22664[(2)] = inst_22622);

(statearr_22641_22664[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (10))){
var inst_22620 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22642_22665 = state_22628__$1;
(statearr_22642_22665[(2)] = inst_22620);

(statearr_22642_22665[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (8))){
var inst_22608 = (state_22628[(7)]);
var inst_22609 = (state_22628[(9)]);
var inst_22607 = (state_22628[(8)]);
var inst_22600 = (state_22628[(10)]);
var inst_22612 = (function (){var cs = inst_22600;
var vec__22605 = inst_22607;
var v = inst_22608;
var c = inst_22609;
return ((function (cs,vec__22605,v,c,inst_22608,inst_22609,inst_22607,inst_22600,state_val_22629,c__20558__auto___22656,out){
return (function (p1__22595_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22595_SHARP_);
});
;})(cs,vec__22605,v,c,inst_22608,inst_22609,inst_22607,inst_22600,state_val_22629,c__20558__auto___22656,out))
})();
var inst_22613 = cljs.core.filterv.call(null,inst_22612,inst_22600);
var inst_22600__$1 = inst_22613;
var state_22628__$1 = (function (){var statearr_22643 = state_22628;
(statearr_22643[(10)] = inst_22600__$1);

return statearr_22643;
})();
var statearr_22644_22666 = state_22628__$1;
(statearr_22644_22666[(2)] = null);

(statearr_22644_22666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22656,out))
;
return ((function (switch__20446__auto__,c__20558__auto___22656,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_22648 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22648[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_22648[(1)] = (1));

return statearr_22648;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_22628){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22649){if((e22649 instanceof Object)){
var ex__20450__auto__ = e22649;
var statearr_22650_22667 = state_22628;
(statearr_22650_22667[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22668 = state_22628;
state_22628 = G__22668;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_22628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_22628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22656,out))
})();
var state__20560__auto__ = (function (){var statearr_22651 = f__20559__auto__.call(null);
(statearr_22651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22656);

return statearr_22651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22656,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22669 = [];
var len__19463__auto___22718 = arguments.length;
var i__19464__auto___22719 = (0);
while(true){
if((i__19464__auto___22719 < len__19463__auto___22718)){
args22669.push((arguments[i__19464__auto___22719]));

var G__22720 = (i__19464__auto___22719 + (1));
i__19464__auto___22719 = G__22720;
continue;
} else {
}
break;
}

var G__22671 = args22669.length;
switch (G__22671) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22669.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___22722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22722,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22722,out){
return (function (state_22695){
var state_val_22696 = (state_22695[(1)]);
if((state_val_22696 === (7))){
var inst_22677 = (state_22695[(7)]);
var inst_22677__$1 = (state_22695[(2)]);
var inst_22678 = (inst_22677__$1 == null);
var inst_22679 = cljs.core.not.call(null,inst_22678);
var state_22695__$1 = (function (){var statearr_22697 = state_22695;
(statearr_22697[(7)] = inst_22677__$1);

return statearr_22697;
})();
if(inst_22679){
var statearr_22698_22723 = state_22695__$1;
(statearr_22698_22723[(1)] = (8));

} else {
var statearr_22699_22724 = state_22695__$1;
(statearr_22699_22724[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (1))){
var inst_22672 = (0);
var state_22695__$1 = (function (){var statearr_22700 = state_22695;
(statearr_22700[(8)] = inst_22672);

return statearr_22700;
})();
var statearr_22701_22725 = state_22695__$1;
(statearr_22701_22725[(2)] = null);

(statearr_22701_22725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (4))){
var state_22695__$1 = state_22695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22695__$1,(7),ch);
} else {
if((state_val_22696 === (6))){
var inst_22690 = (state_22695[(2)]);
var state_22695__$1 = state_22695;
var statearr_22702_22726 = state_22695__$1;
(statearr_22702_22726[(2)] = inst_22690);

(statearr_22702_22726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (3))){
var inst_22692 = (state_22695[(2)]);
var inst_22693 = cljs.core.async.close_BANG_.call(null,out);
var state_22695__$1 = (function (){var statearr_22703 = state_22695;
(statearr_22703[(9)] = inst_22692);

return statearr_22703;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22695__$1,inst_22693);
} else {
if((state_val_22696 === (2))){
var inst_22672 = (state_22695[(8)]);
var inst_22674 = (inst_22672 < n);
var state_22695__$1 = state_22695;
if(cljs.core.truth_(inst_22674)){
var statearr_22704_22727 = state_22695__$1;
(statearr_22704_22727[(1)] = (4));

} else {
var statearr_22705_22728 = state_22695__$1;
(statearr_22705_22728[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (11))){
var inst_22672 = (state_22695[(8)]);
var inst_22682 = (state_22695[(2)]);
var inst_22683 = (inst_22672 + (1));
var inst_22672__$1 = inst_22683;
var state_22695__$1 = (function (){var statearr_22706 = state_22695;
(statearr_22706[(8)] = inst_22672__$1);

(statearr_22706[(10)] = inst_22682);

return statearr_22706;
})();
var statearr_22707_22729 = state_22695__$1;
(statearr_22707_22729[(2)] = null);

(statearr_22707_22729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (9))){
var state_22695__$1 = state_22695;
var statearr_22708_22730 = state_22695__$1;
(statearr_22708_22730[(2)] = null);

(statearr_22708_22730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (5))){
var state_22695__$1 = state_22695;
var statearr_22709_22731 = state_22695__$1;
(statearr_22709_22731[(2)] = null);

(statearr_22709_22731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (10))){
var inst_22687 = (state_22695[(2)]);
var state_22695__$1 = state_22695;
var statearr_22710_22732 = state_22695__$1;
(statearr_22710_22732[(2)] = inst_22687);

(statearr_22710_22732[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22696 === (8))){
var inst_22677 = (state_22695[(7)]);
var state_22695__$1 = state_22695;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22695__$1,(11),out,inst_22677);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22722,out))
;
return ((function (switch__20446__auto__,c__20558__auto___22722,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_22714 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22714[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_22714[(1)] = (1));

return statearr_22714;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_22695){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22715){if((e22715 instanceof Object)){
var ex__20450__auto__ = e22715;
var statearr_22716_22733 = state_22695;
(statearr_22716_22733[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22734 = state_22695;
state_22695 = G__22734;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_22695){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_22695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22722,out))
})();
var state__20560__auto__ = (function (){var statearr_22717 = f__20559__auto__.call(null);
(statearr_22717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22722);

return statearr_22717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22722,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22742 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22742 = (function (map_LT_,f,ch,meta22743){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22743 = meta22743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22744,meta22743__$1){
var self__ = this;
var _22744__$1 = this;
return (new cljs.core.async.t_cljs$core$async22742(self__.map_LT_,self__.f,self__.ch,meta22743__$1));
});

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22744){
var self__ = this;
var _22744__$1 = this;
return self__.meta22743;
});

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22745 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22745 = (function (map_LT_,f,ch,meta22743,_,fn1,meta22746){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22743 = meta22743;
this._ = _;
this.fn1 = fn1;
this.meta22746 = meta22746;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22747,meta22746__$1){
var self__ = this;
var _22747__$1 = this;
return (new cljs.core.async.t_cljs$core$async22745(self__.map_LT_,self__.f,self__.ch,self__.meta22743,self__._,self__.fn1,meta22746__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22747){
var self__ = this;
var _22747__$1 = this;
return self__.meta22746;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22735_SHARP_){
return f1.call(null,(((p1__22735_SHARP_ == null))?null:self__.f.call(null,p1__22735_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22743","meta22743",-204130493,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22742","cljs.core.async/t_cljs$core$async22742",1486885234,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22746","meta22746",765308079,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22745.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22745.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22745";

cljs.core.async.t_cljs$core$async22745.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22745");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22745 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22745(map_LT___$1,f__$1,ch__$1,meta22743__$1,___$2,fn1__$1,meta22746){
return (new cljs.core.async.t_cljs$core$async22745(map_LT___$1,f__$1,ch__$1,meta22743__$1,___$2,fn1__$1,meta22746));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22745(self__.map_LT_,self__.f,self__.ch,self__.meta22743,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18393__auto__ = ret;
if(cljs.core.truth_(and__18393__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18393__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22742.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22742.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22743","meta22743",-204130493,null)], null);
});

cljs.core.async.t_cljs$core$async22742.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22742.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22742";

cljs.core.async.t_cljs$core$async22742.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22742");
});

cljs.core.async.__GT_t_cljs$core$async22742 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22742(map_LT___$1,f__$1,ch__$1,meta22743){
return (new cljs.core.async.t_cljs$core$async22742(map_LT___$1,f__$1,ch__$1,meta22743));
});

}

return (new cljs.core.async.t_cljs$core$async22742(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22751 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22751 = (function (map_GT_,f,ch,meta22752){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22752 = meta22752;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22753,meta22752__$1){
var self__ = this;
var _22753__$1 = this;
return (new cljs.core.async.t_cljs$core$async22751(self__.map_GT_,self__.f,self__.ch,meta22752__$1));
});

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22753){
var self__ = this;
var _22753__$1 = this;
return self__.meta22752;
});

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22751.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22751.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22752","meta22752",1204254027,null)], null);
});

cljs.core.async.t_cljs$core$async22751.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22751.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22751";

cljs.core.async.t_cljs$core$async22751.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22751");
});

cljs.core.async.__GT_t_cljs$core$async22751 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22751(map_GT___$1,f__$1,ch__$1,meta22752){
return (new cljs.core.async.t_cljs$core$async22751(map_GT___$1,f__$1,ch__$1,meta22752));
});

}

return (new cljs.core.async.t_cljs$core$async22751(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22757 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22757 = (function (filter_GT_,p,ch,meta22758){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22758 = meta22758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22759,meta22758__$1){
var self__ = this;
var _22759__$1 = this;
return (new cljs.core.async.t_cljs$core$async22757(self__.filter_GT_,self__.p,self__.ch,meta22758__$1));
});

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22759){
var self__ = this;
var _22759__$1 = this;
return self__.meta22758;
});

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22757.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22758","meta22758",-600157529,null)], null);
});

cljs.core.async.t_cljs$core$async22757.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22757";

cljs.core.async.t_cljs$core$async22757.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"cljs.core.async/t_cljs$core$async22757");
});

cljs.core.async.__GT_t_cljs$core$async22757 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22757(filter_GT___$1,p__$1,ch__$1,meta22758){
return (new cljs.core.async.t_cljs$core$async22757(filter_GT___$1,p__$1,ch__$1,meta22758));
});

}

return (new cljs.core.async.t_cljs$core$async22757(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22760 = [];
var len__19463__auto___22804 = arguments.length;
var i__19464__auto___22805 = (0);
while(true){
if((i__19464__auto___22805 < len__19463__auto___22804)){
args22760.push((arguments[i__19464__auto___22805]));

var G__22806 = (i__19464__auto___22805 + (1));
i__19464__auto___22805 = G__22806;
continue;
} else {
}
break;
}

var G__22762 = args22760.length;
switch (G__22762) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22760.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___22808 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___22808,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___22808,out){
return (function (state_22783){
var state_val_22784 = (state_22783[(1)]);
if((state_val_22784 === (7))){
var inst_22779 = (state_22783[(2)]);
var state_22783__$1 = state_22783;
var statearr_22785_22809 = state_22783__$1;
(statearr_22785_22809[(2)] = inst_22779);

(statearr_22785_22809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (1))){
var state_22783__$1 = state_22783;
var statearr_22786_22810 = state_22783__$1;
(statearr_22786_22810[(2)] = null);

(statearr_22786_22810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (4))){
var inst_22765 = (state_22783[(7)]);
var inst_22765__$1 = (state_22783[(2)]);
var inst_22766 = (inst_22765__$1 == null);
var state_22783__$1 = (function (){var statearr_22787 = state_22783;
(statearr_22787[(7)] = inst_22765__$1);

return statearr_22787;
})();
if(cljs.core.truth_(inst_22766)){
var statearr_22788_22811 = state_22783__$1;
(statearr_22788_22811[(1)] = (5));

} else {
var statearr_22789_22812 = state_22783__$1;
(statearr_22789_22812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (6))){
var inst_22765 = (state_22783[(7)]);
var inst_22770 = p.call(null,inst_22765);
var state_22783__$1 = state_22783;
if(cljs.core.truth_(inst_22770)){
var statearr_22790_22813 = state_22783__$1;
(statearr_22790_22813[(1)] = (8));

} else {
var statearr_22791_22814 = state_22783__$1;
(statearr_22791_22814[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (3))){
var inst_22781 = (state_22783[(2)]);
var state_22783__$1 = state_22783;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22783__$1,inst_22781);
} else {
if((state_val_22784 === (2))){
var state_22783__$1 = state_22783;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22783__$1,(4),ch);
} else {
if((state_val_22784 === (11))){
var inst_22773 = (state_22783[(2)]);
var state_22783__$1 = state_22783;
var statearr_22792_22815 = state_22783__$1;
(statearr_22792_22815[(2)] = inst_22773);

(statearr_22792_22815[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (9))){
var state_22783__$1 = state_22783;
var statearr_22793_22816 = state_22783__$1;
(statearr_22793_22816[(2)] = null);

(statearr_22793_22816[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (5))){
var inst_22768 = cljs.core.async.close_BANG_.call(null,out);
var state_22783__$1 = state_22783;
var statearr_22794_22817 = state_22783__$1;
(statearr_22794_22817[(2)] = inst_22768);

(statearr_22794_22817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (10))){
var inst_22776 = (state_22783[(2)]);
var state_22783__$1 = (function (){var statearr_22795 = state_22783;
(statearr_22795[(8)] = inst_22776);

return statearr_22795;
})();
var statearr_22796_22818 = state_22783__$1;
(statearr_22796_22818[(2)] = null);

(statearr_22796_22818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22784 === (8))){
var inst_22765 = (state_22783[(7)]);
var state_22783__$1 = state_22783;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22783__$1,(11),out,inst_22765);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___22808,out))
;
return ((function (switch__20446__auto__,c__20558__auto___22808,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_22800 = [null,null,null,null,null,null,null,null,null];
(statearr_22800[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_22800[(1)] = (1));

return statearr_22800;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_22783){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22783);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e22801){if((e22801 instanceof Object)){
var ex__20450__auto__ = e22801;
var statearr_22802_22819 = state_22783;
(statearr_22802_22819[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22783);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22801;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22820 = state_22783;
state_22783 = G__22820;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_22783){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_22783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___22808,out))
})();
var state__20560__auto__ = (function (){var statearr_22803 = f__20559__auto__.call(null);
(statearr_22803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___22808);

return statearr_22803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___22808,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22821 = [];
var len__19463__auto___22824 = arguments.length;
var i__19464__auto___22825 = (0);
while(true){
if((i__19464__auto___22825 < len__19463__auto___22824)){
args22821.push((arguments[i__19464__auto___22825]));

var G__22826 = (i__19464__auto___22825 + (1));
i__19464__auto___22825 = G__22826;
continue;
} else {
}
break;
}

var G__22823 = args22821.length;
switch (G__22823) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22821.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_22993){
var state_val_22994 = (state_22993[(1)]);
if((state_val_22994 === (7))){
var inst_22989 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_22995_23036 = state_22993__$1;
(statearr_22995_23036[(2)] = inst_22989);

(statearr_22995_23036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (20))){
var inst_22959 = (state_22993[(7)]);
var inst_22970 = (state_22993[(2)]);
var inst_22971 = cljs.core.next.call(null,inst_22959);
var inst_22945 = inst_22971;
var inst_22946 = null;
var inst_22947 = (0);
var inst_22948 = (0);
var state_22993__$1 = (function (){var statearr_22996 = state_22993;
(statearr_22996[(8)] = inst_22945);

(statearr_22996[(9)] = inst_22948);

(statearr_22996[(10)] = inst_22970);

(statearr_22996[(11)] = inst_22947);

(statearr_22996[(12)] = inst_22946);

return statearr_22996;
})();
var statearr_22997_23037 = state_22993__$1;
(statearr_22997_23037[(2)] = null);

(statearr_22997_23037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (1))){
var state_22993__$1 = state_22993;
var statearr_22998_23038 = state_22993__$1;
(statearr_22998_23038[(2)] = null);

(statearr_22998_23038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (4))){
var inst_22934 = (state_22993[(13)]);
var inst_22934__$1 = (state_22993[(2)]);
var inst_22935 = (inst_22934__$1 == null);
var state_22993__$1 = (function (){var statearr_22999 = state_22993;
(statearr_22999[(13)] = inst_22934__$1);

return statearr_22999;
})();
if(cljs.core.truth_(inst_22935)){
var statearr_23000_23039 = state_22993__$1;
(statearr_23000_23039[(1)] = (5));

} else {
var statearr_23001_23040 = state_22993__$1;
(statearr_23001_23040[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (15))){
var state_22993__$1 = state_22993;
var statearr_23005_23041 = state_22993__$1;
(statearr_23005_23041[(2)] = null);

(statearr_23005_23041[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (21))){
var state_22993__$1 = state_22993;
var statearr_23006_23042 = state_22993__$1;
(statearr_23006_23042[(2)] = null);

(statearr_23006_23042[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (13))){
var inst_22945 = (state_22993[(8)]);
var inst_22948 = (state_22993[(9)]);
var inst_22947 = (state_22993[(11)]);
var inst_22946 = (state_22993[(12)]);
var inst_22955 = (state_22993[(2)]);
var inst_22956 = (inst_22948 + (1));
var tmp23002 = inst_22945;
var tmp23003 = inst_22947;
var tmp23004 = inst_22946;
var inst_22945__$1 = tmp23002;
var inst_22946__$1 = tmp23004;
var inst_22947__$1 = tmp23003;
var inst_22948__$1 = inst_22956;
var state_22993__$1 = (function (){var statearr_23007 = state_22993;
(statearr_23007[(8)] = inst_22945__$1);

(statearr_23007[(9)] = inst_22948__$1);

(statearr_23007[(14)] = inst_22955);

(statearr_23007[(11)] = inst_22947__$1);

(statearr_23007[(12)] = inst_22946__$1);

return statearr_23007;
})();
var statearr_23008_23043 = state_22993__$1;
(statearr_23008_23043[(2)] = null);

(statearr_23008_23043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (22))){
var state_22993__$1 = state_22993;
var statearr_23009_23044 = state_22993__$1;
(statearr_23009_23044[(2)] = null);

(statearr_23009_23044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (6))){
var inst_22934 = (state_22993[(13)]);
var inst_22943 = f.call(null,inst_22934);
var inst_22944 = cljs.core.seq.call(null,inst_22943);
var inst_22945 = inst_22944;
var inst_22946 = null;
var inst_22947 = (0);
var inst_22948 = (0);
var state_22993__$1 = (function (){var statearr_23010 = state_22993;
(statearr_23010[(8)] = inst_22945);

(statearr_23010[(9)] = inst_22948);

(statearr_23010[(11)] = inst_22947);

(statearr_23010[(12)] = inst_22946);

return statearr_23010;
})();
var statearr_23011_23045 = state_22993__$1;
(statearr_23011_23045[(2)] = null);

(statearr_23011_23045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (17))){
var inst_22959 = (state_22993[(7)]);
var inst_22963 = cljs.core.chunk_first.call(null,inst_22959);
var inst_22964 = cljs.core.chunk_rest.call(null,inst_22959);
var inst_22965 = cljs.core.count.call(null,inst_22963);
var inst_22945 = inst_22964;
var inst_22946 = inst_22963;
var inst_22947 = inst_22965;
var inst_22948 = (0);
var state_22993__$1 = (function (){var statearr_23012 = state_22993;
(statearr_23012[(8)] = inst_22945);

(statearr_23012[(9)] = inst_22948);

(statearr_23012[(11)] = inst_22947);

(statearr_23012[(12)] = inst_22946);

return statearr_23012;
})();
var statearr_23013_23046 = state_22993__$1;
(statearr_23013_23046[(2)] = null);

(statearr_23013_23046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (3))){
var inst_22991 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22993__$1,inst_22991);
} else {
if((state_val_22994 === (12))){
var inst_22979 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23014_23047 = state_22993__$1;
(statearr_23014_23047[(2)] = inst_22979);

(statearr_23014_23047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (2))){
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22993__$1,(4),in$);
} else {
if((state_val_22994 === (23))){
var inst_22987 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23015_23048 = state_22993__$1;
(statearr_23015_23048[(2)] = inst_22987);

(statearr_23015_23048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (19))){
var inst_22974 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23016_23049 = state_22993__$1;
(statearr_23016_23049[(2)] = inst_22974);

(statearr_23016_23049[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (11))){
var inst_22945 = (state_22993[(8)]);
var inst_22959 = (state_22993[(7)]);
var inst_22959__$1 = cljs.core.seq.call(null,inst_22945);
var state_22993__$1 = (function (){var statearr_23017 = state_22993;
(statearr_23017[(7)] = inst_22959__$1);

return statearr_23017;
})();
if(inst_22959__$1){
var statearr_23018_23050 = state_22993__$1;
(statearr_23018_23050[(1)] = (14));

} else {
var statearr_23019_23051 = state_22993__$1;
(statearr_23019_23051[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (9))){
var inst_22981 = (state_22993[(2)]);
var inst_22982 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22993__$1 = (function (){var statearr_23020 = state_22993;
(statearr_23020[(15)] = inst_22981);

return statearr_23020;
})();
if(cljs.core.truth_(inst_22982)){
var statearr_23021_23052 = state_22993__$1;
(statearr_23021_23052[(1)] = (21));

} else {
var statearr_23022_23053 = state_22993__$1;
(statearr_23022_23053[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (5))){
var inst_22937 = cljs.core.async.close_BANG_.call(null,out);
var state_22993__$1 = state_22993;
var statearr_23023_23054 = state_22993__$1;
(statearr_23023_23054[(2)] = inst_22937);

(statearr_23023_23054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (14))){
var inst_22959 = (state_22993[(7)]);
var inst_22961 = cljs.core.chunked_seq_QMARK_.call(null,inst_22959);
var state_22993__$1 = state_22993;
if(inst_22961){
var statearr_23024_23055 = state_22993__$1;
(statearr_23024_23055[(1)] = (17));

} else {
var statearr_23025_23056 = state_22993__$1;
(statearr_23025_23056[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (16))){
var inst_22977 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23026_23057 = state_22993__$1;
(statearr_23026_23057[(2)] = inst_22977);

(statearr_23026_23057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (10))){
var inst_22948 = (state_22993[(9)]);
var inst_22946 = (state_22993[(12)]);
var inst_22953 = cljs.core._nth.call(null,inst_22946,inst_22948);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22993__$1,(13),out,inst_22953);
} else {
if((state_val_22994 === (18))){
var inst_22959 = (state_22993[(7)]);
var inst_22968 = cljs.core.first.call(null,inst_22959);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22993__$1,(20),out,inst_22968);
} else {
if((state_val_22994 === (8))){
var inst_22948 = (state_22993[(9)]);
var inst_22947 = (state_22993[(11)]);
var inst_22950 = (inst_22948 < inst_22947);
var inst_22951 = inst_22950;
var state_22993__$1 = state_22993;
if(cljs.core.truth_(inst_22951)){
var statearr_23027_23058 = state_22993__$1;
(statearr_23027_23058[(1)] = (10));

} else {
var statearr_23028_23059 = state_22993__$1;
(statearr_23028_23059[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____0 = (function (){
var statearr_23032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23032[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__);

(statearr_23032[(1)] = (1));

return statearr_23032;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____1 = (function (state_22993){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_22993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23033){if((e23033 instanceof Object)){
var ex__20450__auto__ = e23033;
var statearr_23034_23060 = state_22993;
(statearr_23034_23060[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23061 = state_22993;
state_22993 = G__23061;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__ = function(state_22993){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____1.call(this,state_22993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20447__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_23035 = f__20559__auto__.call(null);
(statearr_23035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_23035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args23062 = [];
var len__19463__auto___23065 = arguments.length;
var i__19464__auto___23066 = (0);
while(true){
if((i__19464__auto___23066 < len__19463__auto___23065)){
args23062.push((arguments[i__19464__auto___23066]));

var G__23067 = (i__19464__auto___23066 + (1));
i__19464__auto___23066 = G__23067;
continue;
} else {
}
break;
}

var G__23064 = args23062.length;
switch (G__23064) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23062.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args23069 = [];
var len__19463__auto___23072 = arguments.length;
var i__19464__auto___23073 = (0);
while(true){
if((i__19464__auto___23073 < len__19463__auto___23072)){
args23069.push((arguments[i__19464__auto___23073]));

var G__23074 = (i__19464__auto___23073 + (1));
i__19464__auto___23073 = G__23074;
continue;
} else {
}
break;
}

var G__23071 = args23069.length;
switch (G__23071) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23069.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args23076 = [];
var len__19463__auto___23127 = arguments.length;
var i__19464__auto___23128 = (0);
while(true){
if((i__19464__auto___23128 < len__19463__auto___23127)){
args23076.push((arguments[i__19464__auto___23128]));

var G__23129 = (i__19464__auto___23128 + (1));
i__19464__auto___23128 = G__23129;
continue;
} else {
}
break;
}

var G__23078 = args23076.length;
switch (G__23078) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23076.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___23131 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___23131,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___23131,out){
return (function (state_23102){
var state_val_23103 = (state_23102[(1)]);
if((state_val_23103 === (7))){
var inst_23097 = (state_23102[(2)]);
var state_23102__$1 = state_23102;
var statearr_23104_23132 = state_23102__$1;
(statearr_23104_23132[(2)] = inst_23097);

(statearr_23104_23132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (1))){
var inst_23079 = null;
var state_23102__$1 = (function (){var statearr_23105 = state_23102;
(statearr_23105[(7)] = inst_23079);

return statearr_23105;
})();
var statearr_23106_23133 = state_23102__$1;
(statearr_23106_23133[(2)] = null);

(statearr_23106_23133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (4))){
var inst_23082 = (state_23102[(8)]);
var inst_23082__$1 = (state_23102[(2)]);
var inst_23083 = (inst_23082__$1 == null);
var inst_23084 = cljs.core.not.call(null,inst_23083);
var state_23102__$1 = (function (){var statearr_23107 = state_23102;
(statearr_23107[(8)] = inst_23082__$1);

return statearr_23107;
})();
if(inst_23084){
var statearr_23108_23134 = state_23102__$1;
(statearr_23108_23134[(1)] = (5));

} else {
var statearr_23109_23135 = state_23102__$1;
(statearr_23109_23135[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (6))){
var state_23102__$1 = state_23102;
var statearr_23110_23136 = state_23102__$1;
(statearr_23110_23136[(2)] = null);

(statearr_23110_23136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (3))){
var inst_23099 = (state_23102[(2)]);
var inst_23100 = cljs.core.async.close_BANG_.call(null,out);
var state_23102__$1 = (function (){var statearr_23111 = state_23102;
(statearr_23111[(9)] = inst_23099);

return statearr_23111;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23102__$1,inst_23100);
} else {
if((state_val_23103 === (2))){
var state_23102__$1 = state_23102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23102__$1,(4),ch);
} else {
if((state_val_23103 === (11))){
var inst_23082 = (state_23102[(8)]);
var inst_23091 = (state_23102[(2)]);
var inst_23079 = inst_23082;
var state_23102__$1 = (function (){var statearr_23112 = state_23102;
(statearr_23112[(10)] = inst_23091);

(statearr_23112[(7)] = inst_23079);

return statearr_23112;
})();
var statearr_23113_23137 = state_23102__$1;
(statearr_23113_23137[(2)] = null);

(statearr_23113_23137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (9))){
var inst_23082 = (state_23102[(8)]);
var state_23102__$1 = state_23102;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23102__$1,(11),out,inst_23082);
} else {
if((state_val_23103 === (5))){
var inst_23082 = (state_23102[(8)]);
var inst_23079 = (state_23102[(7)]);
var inst_23086 = cljs.core._EQ_.call(null,inst_23082,inst_23079);
var state_23102__$1 = state_23102;
if(inst_23086){
var statearr_23115_23138 = state_23102__$1;
(statearr_23115_23138[(1)] = (8));

} else {
var statearr_23116_23139 = state_23102__$1;
(statearr_23116_23139[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (10))){
var inst_23094 = (state_23102[(2)]);
var state_23102__$1 = state_23102;
var statearr_23117_23140 = state_23102__$1;
(statearr_23117_23140[(2)] = inst_23094);

(statearr_23117_23140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23103 === (8))){
var inst_23079 = (state_23102[(7)]);
var tmp23114 = inst_23079;
var inst_23079__$1 = tmp23114;
var state_23102__$1 = (function (){var statearr_23118 = state_23102;
(statearr_23118[(7)] = inst_23079__$1);

return statearr_23118;
})();
var statearr_23119_23141 = state_23102__$1;
(statearr_23119_23141[(2)] = null);

(statearr_23119_23141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___23131,out))
;
return ((function (switch__20446__auto__,c__20558__auto___23131,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_23123 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23123[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_23123[(1)] = (1));

return statearr_23123;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_23102){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_23102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23124){if((e23124 instanceof Object)){
var ex__20450__auto__ = e23124;
var statearr_23125_23142 = state_23102;
(statearr_23125_23142[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23102);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23124;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23143 = state_23102;
state_23102 = G__23143;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_23102){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_23102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___23131,out))
})();
var state__20560__auto__ = (function (){var statearr_23126 = f__20559__auto__.call(null);
(statearr_23126[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___23131);

return statearr_23126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___23131,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args23144 = [];
var len__19463__auto___23214 = arguments.length;
var i__19464__auto___23215 = (0);
while(true){
if((i__19464__auto___23215 < len__19463__auto___23214)){
args23144.push((arguments[i__19464__auto___23215]));

var G__23216 = (i__19464__auto___23215 + (1));
i__19464__auto___23215 = G__23216;
continue;
} else {
}
break;
}

var G__23146 = args23144.length;
switch (G__23146) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23144.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___23218 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___23218,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___23218,out){
return (function (state_23184){
var state_val_23185 = (state_23184[(1)]);
if((state_val_23185 === (7))){
var inst_23180 = (state_23184[(2)]);
var state_23184__$1 = state_23184;
var statearr_23186_23219 = state_23184__$1;
(statearr_23186_23219[(2)] = inst_23180);

(statearr_23186_23219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (1))){
var inst_23147 = (new Array(n));
var inst_23148 = inst_23147;
var inst_23149 = (0);
var state_23184__$1 = (function (){var statearr_23187 = state_23184;
(statearr_23187[(7)] = inst_23148);

(statearr_23187[(8)] = inst_23149);

return statearr_23187;
})();
var statearr_23188_23220 = state_23184__$1;
(statearr_23188_23220[(2)] = null);

(statearr_23188_23220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (4))){
var inst_23152 = (state_23184[(9)]);
var inst_23152__$1 = (state_23184[(2)]);
var inst_23153 = (inst_23152__$1 == null);
var inst_23154 = cljs.core.not.call(null,inst_23153);
var state_23184__$1 = (function (){var statearr_23189 = state_23184;
(statearr_23189[(9)] = inst_23152__$1);

return statearr_23189;
})();
if(inst_23154){
var statearr_23190_23221 = state_23184__$1;
(statearr_23190_23221[(1)] = (5));

} else {
var statearr_23191_23222 = state_23184__$1;
(statearr_23191_23222[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (15))){
var inst_23174 = (state_23184[(2)]);
var state_23184__$1 = state_23184;
var statearr_23192_23223 = state_23184__$1;
(statearr_23192_23223[(2)] = inst_23174);

(statearr_23192_23223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (13))){
var state_23184__$1 = state_23184;
var statearr_23193_23224 = state_23184__$1;
(statearr_23193_23224[(2)] = null);

(statearr_23193_23224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (6))){
var inst_23149 = (state_23184[(8)]);
var inst_23170 = (inst_23149 > (0));
var state_23184__$1 = state_23184;
if(cljs.core.truth_(inst_23170)){
var statearr_23194_23225 = state_23184__$1;
(statearr_23194_23225[(1)] = (12));

} else {
var statearr_23195_23226 = state_23184__$1;
(statearr_23195_23226[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (3))){
var inst_23182 = (state_23184[(2)]);
var state_23184__$1 = state_23184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23184__$1,inst_23182);
} else {
if((state_val_23185 === (12))){
var inst_23148 = (state_23184[(7)]);
var inst_23172 = cljs.core.vec.call(null,inst_23148);
var state_23184__$1 = state_23184;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23184__$1,(15),out,inst_23172);
} else {
if((state_val_23185 === (2))){
var state_23184__$1 = state_23184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23184__$1,(4),ch);
} else {
if((state_val_23185 === (11))){
var inst_23164 = (state_23184[(2)]);
var inst_23165 = (new Array(n));
var inst_23148 = inst_23165;
var inst_23149 = (0);
var state_23184__$1 = (function (){var statearr_23196 = state_23184;
(statearr_23196[(7)] = inst_23148);

(statearr_23196[(10)] = inst_23164);

(statearr_23196[(8)] = inst_23149);

return statearr_23196;
})();
var statearr_23197_23227 = state_23184__$1;
(statearr_23197_23227[(2)] = null);

(statearr_23197_23227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (9))){
var inst_23148 = (state_23184[(7)]);
var inst_23162 = cljs.core.vec.call(null,inst_23148);
var state_23184__$1 = state_23184;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23184__$1,(11),out,inst_23162);
} else {
if((state_val_23185 === (5))){
var inst_23148 = (state_23184[(7)]);
var inst_23152 = (state_23184[(9)]);
var inst_23157 = (state_23184[(11)]);
var inst_23149 = (state_23184[(8)]);
var inst_23156 = (inst_23148[inst_23149] = inst_23152);
var inst_23157__$1 = (inst_23149 + (1));
var inst_23158 = (inst_23157__$1 < n);
var state_23184__$1 = (function (){var statearr_23198 = state_23184;
(statearr_23198[(12)] = inst_23156);

(statearr_23198[(11)] = inst_23157__$1);

return statearr_23198;
})();
if(cljs.core.truth_(inst_23158)){
var statearr_23199_23228 = state_23184__$1;
(statearr_23199_23228[(1)] = (8));

} else {
var statearr_23200_23229 = state_23184__$1;
(statearr_23200_23229[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (14))){
var inst_23177 = (state_23184[(2)]);
var inst_23178 = cljs.core.async.close_BANG_.call(null,out);
var state_23184__$1 = (function (){var statearr_23202 = state_23184;
(statearr_23202[(13)] = inst_23177);

return statearr_23202;
})();
var statearr_23203_23230 = state_23184__$1;
(statearr_23203_23230[(2)] = inst_23178);

(statearr_23203_23230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (10))){
var inst_23168 = (state_23184[(2)]);
var state_23184__$1 = state_23184;
var statearr_23204_23231 = state_23184__$1;
(statearr_23204_23231[(2)] = inst_23168);

(statearr_23204_23231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23185 === (8))){
var inst_23148 = (state_23184[(7)]);
var inst_23157 = (state_23184[(11)]);
var tmp23201 = inst_23148;
var inst_23148__$1 = tmp23201;
var inst_23149 = inst_23157;
var state_23184__$1 = (function (){var statearr_23205 = state_23184;
(statearr_23205[(7)] = inst_23148__$1);

(statearr_23205[(8)] = inst_23149);

return statearr_23205;
})();
var statearr_23206_23232 = state_23184__$1;
(statearr_23206_23232[(2)] = null);

(statearr_23206_23232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___23218,out))
;
return ((function (switch__20446__auto__,c__20558__auto___23218,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_23210 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23210[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_23210[(1)] = (1));

return statearr_23210;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_23184){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_23184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23211){if((e23211 instanceof Object)){
var ex__20450__auto__ = e23211;
var statearr_23212_23233 = state_23184;
(statearr_23212_23233[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23184);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23211;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23234 = state_23184;
state_23184 = G__23234;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_23184){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_23184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___23218,out))
})();
var state__20560__auto__ = (function (){var statearr_23213 = f__20559__auto__.call(null);
(statearr_23213[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___23218);

return statearr_23213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___23218,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args23235 = [];
var len__19463__auto___23309 = arguments.length;
var i__19464__auto___23310 = (0);
while(true){
if((i__19464__auto___23310 < len__19463__auto___23309)){
args23235.push((arguments[i__19464__auto___23310]));

var G__23311 = (i__19464__auto___23310 + (1));
i__19464__auto___23310 = G__23311;
continue;
} else {
}
break;
}

var G__23237 = args23235.length;
switch (G__23237) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23235.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20558__auto___23313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___23313,out){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___23313,out){
return (function (state_23279){
var state_val_23280 = (state_23279[(1)]);
if((state_val_23280 === (7))){
var inst_23275 = (state_23279[(2)]);
var state_23279__$1 = state_23279;
var statearr_23281_23314 = state_23279__$1;
(statearr_23281_23314[(2)] = inst_23275);

(statearr_23281_23314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (1))){
var inst_23238 = [];
var inst_23239 = inst_23238;
var inst_23240 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_23279__$1 = (function (){var statearr_23282 = state_23279;
(statearr_23282[(7)] = inst_23240);

(statearr_23282[(8)] = inst_23239);

return statearr_23282;
})();
var statearr_23283_23315 = state_23279__$1;
(statearr_23283_23315[(2)] = null);

(statearr_23283_23315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (4))){
var inst_23243 = (state_23279[(9)]);
var inst_23243__$1 = (state_23279[(2)]);
var inst_23244 = (inst_23243__$1 == null);
var inst_23245 = cljs.core.not.call(null,inst_23244);
var state_23279__$1 = (function (){var statearr_23284 = state_23279;
(statearr_23284[(9)] = inst_23243__$1);

return statearr_23284;
})();
if(inst_23245){
var statearr_23285_23316 = state_23279__$1;
(statearr_23285_23316[(1)] = (5));

} else {
var statearr_23286_23317 = state_23279__$1;
(statearr_23286_23317[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (15))){
var inst_23269 = (state_23279[(2)]);
var state_23279__$1 = state_23279;
var statearr_23287_23318 = state_23279__$1;
(statearr_23287_23318[(2)] = inst_23269);

(statearr_23287_23318[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (13))){
var state_23279__$1 = state_23279;
var statearr_23288_23319 = state_23279__$1;
(statearr_23288_23319[(2)] = null);

(statearr_23288_23319[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (6))){
var inst_23239 = (state_23279[(8)]);
var inst_23264 = inst_23239.length;
var inst_23265 = (inst_23264 > (0));
var state_23279__$1 = state_23279;
if(cljs.core.truth_(inst_23265)){
var statearr_23289_23320 = state_23279__$1;
(statearr_23289_23320[(1)] = (12));

} else {
var statearr_23290_23321 = state_23279__$1;
(statearr_23290_23321[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (3))){
var inst_23277 = (state_23279[(2)]);
var state_23279__$1 = state_23279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23279__$1,inst_23277);
} else {
if((state_val_23280 === (12))){
var inst_23239 = (state_23279[(8)]);
var inst_23267 = cljs.core.vec.call(null,inst_23239);
var state_23279__$1 = state_23279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23279__$1,(15),out,inst_23267);
} else {
if((state_val_23280 === (2))){
var state_23279__$1 = state_23279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23279__$1,(4),ch);
} else {
if((state_val_23280 === (11))){
var inst_23247 = (state_23279[(10)]);
var inst_23243 = (state_23279[(9)]);
var inst_23257 = (state_23279[(2)]);
var inst_23258 = [];
var inst_23259 = inst_23258.push(inst_23243);
var inst_23239 = inst_23258;
var inst_23240 = inst_23247;
var state_23279__$1 = (function (){var statearr_23291 = state_23279;
(statearr_23291[(11)] = inst_23259);

(statearr_23291[(12)] = inst_23257);

(statearr_23291[(7)] = inst_23240);

(statearr_23291[(8)] = inst_23239);

return statearr_23291;
})();
var statearr_23292_23322 = state_23279__$1;
(statearr_23292_23322[(2)] = null);

(statearr_23292_23322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (9))){
var inst_23239 = (state_23279[(8)]);
var inst_23255 = cljs.core.vec.call(null,inst_23239);
var state_23279__$1 = state_23279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23279__$1,(11),out,inst_23255);
} else {
if((state_val_23280 === (5))){
var inst_23247 = (state_23279[(10)]);
var inst_23240 = (state_23279[(7)]);
var inst_23243 = (state_23279[(9)]);
var inst_23247__$1 = f.call(null,inst_23243);
var inst_23248 = cljs.core._EQ_.call(null,inst_23247__$1,inst_23240);
var inst_23249 = cljs.core.keyword_identical_QMARK_.call(null,inst_23240,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_23250 = (inst_23248) || (inst_23249);
var state_23279__$1 = (function (){var statearr_23293 = state_23279;
(statearr_23293[(10)] = inst_23247__$1);

return statearr_23293;
})();
if(cljs.core.truth_(inst_23250)){
var statearr_23294_23323 = state_23279__$1;
(statearr_23294_23323[(1)] = (8));

} else {
var statearr_23295_23324 = state_23279__$1;
(statearr_23295_23324[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (14))){
var inst_23272 = (state_23279[(2)]);
var inst_23273 = cljs.core.async.close_BANG_.call(null,out);
var state_23279__$1 = (function (){var statearr_23297 = state_23279;
(statearr_23297[(13)] = inst_23272);

return statearr_23297;
})();
var statearr_23298_23325 = state_23279__$1;
(statearr_23298_23325[(2)] = inst_23273);

(statearr_23298_23325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (10))){
var inst_23262 = (state_23279[(2)]);
var state_23279__$1 = state_23279;
var statearr_23299_23326 = state_23279__$1;
(statearr_23299_23326[(2)] = inst_23262);

(statearr_23299_23326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23280 === (8))){
var inst_23247 = (state_23279[(10)]);
var inst_23239 = (state_23279[(8)]);
var inst_23243 = (state_23279[(9)]);
var inst_23252 = inst_23239.push(inst_23243);
var tmp23296 = inst_23239;
var inst_23239__$1 = tmp23296;
var inst_23240 = inst_23247;
var state_23279__$1 = (function (){var statearr_23300 = state_23279;
(statearr_23300[(14)] = inst_23252);

(statearr_23300[(7)] = inst_23240);

(statearr_23300[(8)] = inst_23239__$1);

return statearr_23300;
})();
var statearr_23301_23327 = state_23279__$1;
(statearr_23301_23327[(2)] = null);

(statearr_23301_23327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___23313,out))
;
return ((function (switch__20446__auto__,c__20558__auto___23313,out){
return (function() {
var cljs$core$async$state_machine__20447__auto__ = null;
var cljs$core$async$state_machine__20447__auto____0 = (function (){
var statearr_23305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23305[(0)] = cljs$core$async$state_machine__20447__auto__);

(statearr_23305[(1)] = (1));

return statearr_23305;
});
var cljs$core$async$state_machine__20447__auto____1 = (function (state_23279){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_23279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e23306){if((e23306 instanceof Object)){
var ex__20450__auto__ = e23306;
var statearr_23307_23328 = state_23279;
(statearr_23307_23328[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23329 = state_23279;
state_23279 = G__23329;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
cljs$core$async$state_machine__20447__auto__ = function(state_23279){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20447__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20447__auto____1.call(this,state_23279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20447__auto____0;
cljs$core$async$state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20447__auto____1;
return cljs$core$async$state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___23313,out))
})();
var state__20560__auto__ = (function (){var statearr_23308 = f__20559__auto__.call(null);
(statearr_23308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___23313);

return statearr_23308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___23313,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map