// Compiled by ClojureScript 1.7.228 {}
goog.provide('thinktopic.aljabr.core');
goog.require('cljs.core');
goog.require('clojure.core.matrix');
goog.require('clojure.core.matrix.implementations');
goog.require('thi.ng.typedarrays.core');
cljs.core.enable_console_print_BANG_.call(null);
thinktopic.aljabr.core.array_seq_STAR_ = (function thinktopic$aljabr$core$array_seq_STAR_(ary){
if(cljs.core.truth_(ary)){
return (new cljs.core.IndexedSeq(ary,(0)));
} else {
return null;
}
});

/**
 * @interface
 */
thinktopic.aljabr.core.PNDArray = function(){};

/**
 * Returns value at given position in an ndarray view (without bounds check,
 *  assumes position is safe).
 */
thinktopic.aljabr.core.get_at = (function thinktopic$aljabr$core$get_at(var_args){
var args41332 = [];
var len__19463__auto___41368 = arguments.length;
var i__19464__auto___41369 = (0);
while(true){
if((i__19464__auto___41369 < len__19463__auto___41368)){
args41332.push((arguments[i__19464__auto___41369]));

var G__41370 = (i__19464__auto___41369 + (1));
i__19464__auto___41369 = G__41370;
continue;
} else {
}
break;
}

var G__41334 = args41332.length;
switch (G__41334) {
case 2:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41332.length)].join('')));

}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at",_);
}
}
}
});

thinktopic.aljabr.core.get_at.cljs$lang$maxFixedArity = 5;

/**
 * Returns value at given position in an ndarray view (with bounds
 *  check)
 */
thinktopic.aljabr.core.get_at_safe = (function thinktopic$aljabr$core$get_at_safe(var_args){
var args41335 = [];
var len__19463__auto___41372 = arguments.length;
var i__19464__auto___41373 = (0);
while(true){
if((i__19464__auto___41373 < len__19463__auto___41372)){
args41335.push((arguments[i__19464__auto___41373]));

var G__41374 = (i__19464__auto___41373 + (1));
i__19464__auto___41373 = G__41374;
continue;
} else {
}
break;
}

var G__41337 = args41335.length;
switch (G__41337) {
case 2:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41335.length)].join('')));

}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.get_at_safe.cljs$lang$maxFixedArity = 5;

/**
 * Returns value at given global index in an ndarray view's backing
 *  array.
 */
thinktopic.aljabr.core.get_at_index = (function thinktopic$aljabr$core$get_at_index(_,i){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2(_,i);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.get_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.get_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.get-at-index",_);
}
}
}
});

/**
 * Sets backing data array at given position in an ndarray view to
 *  new value v (without bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at = (function thinktopic$aljabr$core$set_at(var_args){
var args41338 = [];
var len__19463__auto___41376 = arguments.length;
var i__19464__auto___41377 = (0);
while(true){
if((i__19464__auto___41377 < len__19463__auto___41376)){
args41338.push((arguments[i__19464__auto___41377]));

var G__41378 = (i__19464__auto___41377 + (1));
i__19464__auto___41377 = G__41378;
continue;
} else {
}
break;
}

var G__41340 = args41338.length;
switch (G__41340) {
case 3:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41338.length)].join('')));

}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$3(_,x,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$4(_,x,y,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$5(_,x,y,z,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at$arity$6(_,x,y,z,w,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at",_);
}
}
}
});

thinktopic.aljabr.core.set_at.cljs$lang$maxFixedArity = 6;

/**
 * Sets backing array at given position in an ndarray view to
 *  new value v (with bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at_safe = (function thinktopic$aljabr$core$set_at_safe(var_args){
var args41341 = [];
var len__19463__auto___41380 = arguments.length;
var i__19464__auto___41381 = (0);
while(true){
if((i__19464__auto___41381 < len__19463__auto___41380)){
args41341.push((arguments[i__19464__auto___41381]));

var G__41382 = (i__19464__auto___41381 + (1));
i__19464__auto___41381 = G__41382;
continue;
} else {
}
break;
}

var G__41343 = args41341.length;
switch (G__41343) {
case 3:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41341.length)].join('')));

}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3(_,x,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4(_,x,y,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5(_,x,y,z,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$6(_,x,y,z,w,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.set_at_safe.cljs$lang$maxFixedArity = 6;

/**
 * Sets backing data array at given global index to new value
 *  v (without bounds check). Returns same NDArray instance.
 */
thinktopic.aljabr.core.set_at_index = (function thinktopic$aljabr$core$set_at_index(_,i,v){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3(_,i,v);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.set_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i,v);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.set_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i,v);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.set-at-index",_);
}
}
}
});

/**
 * Applies function f to given position in an ndarray view and sets
 *  backing array at same position to the return value of f. The
 *  function f itself accepts m args: first the n coordinates of the
 *  position and the value at this position
 */
thinktopic.aljabr.core.update_at = (function thinktopic$aljabr$core$update_at(var_args){
var args41344 = [];
var len__19463__auto___41384 = arguments.length;
var i__19464__auto___41385 = (0);
while(true){
if((i__19464__auto___41385 < len__19463__auto___41384)){
args41344.push((arguments[i__19464__auto___41385]));

var G__41386 = (i__19464__auto___41385 + (1));
i__19464__auto___41385 = G__41386;
continue;
} else {
}
break;
}

var G__41346 = args41344.length;
switch (G__41346) {
case 3:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41344.length)].join('')));

}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$3(_,x,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$4(_,x,y,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$5(_,x,y,z,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at$arity$6(_,x,y,z,w,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at",_);
}
}
}
});

thinktopic.aljabr.core.update_at.cljs$lang$maxFixedArity = 6;

/**
 * Same as `update-at` but with bounds check.
 */
thinktopic.aljabr.core.update_at_safe = (function thinktopic$aljabr$core$update_at_safe(var_args){
var args41347 = [];
var len__19463__auto___41388 = arguments.length;
var i__19464__auto___41389 = (0);
while(true){
if((i__19464__auto___41389 < len__19463__auto___41388)){
args41347.push((arguments[i__19464__auto___41389]));

var G__41390 = (i__19464__auto___41389 + (1));
i__19464__auto___41389 = G__41390;
continue;
} else {
}
break;
}

var G__41349 = args41347.length;
switch (G__41349) {
case 3:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41347.length)].join('')));

}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$3 = (function (_,x,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3(_,x,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4(_,x,y,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5(_,x,y,z,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$core$IFn$_invoke$arity$6 = (function (_,x,y,z,w,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$6 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$6(_,x,y,z,w,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_safe[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_safe["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-safe",_);
}
}
}
});

thinktopic.aljabr.core.update_at_safe.cljs$lang$maxFixedArity = 6;

/**
 * Applies function f to given global index in an ndarray's view
 *  backing array and sets it to the return value of f. The
 *  function f itself accepts 2 args: the supplied array index
 *  and the array's value at this index
 */
thinktopic.aljabr.core.update_at_index = (function thinktopic$aljabr$core$update_at_index(_,i,f){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3(_,i,f);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.update_at_index[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i,f);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.update_at_index["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i,f);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.update-at-index",_);
}
}
}
});

/**
 * Returns a new ndarray view with stride order/axes swapped as per
 *  given vector. Does not mutate backing array.
 */
thinktopic.aljabr.core.transpose = (function thinktopic$aljabr$core$transpose(var_args){
var args41350 = [];
var len__19463__auto___41392 = arguments.length;
var i__19464__auto___41393 = (0);
while(true){
if((i__19464__auto___41393 < len__19463__auto___41392)){
args41350.push((arguments[i__19464__auto___41393]));

var G__41394 = (i__19464__auto___41393 + (1));
i__19464__auto___41393 = G__41394;
continue;
} else {
}
break;
}

var G__41352 = args41350.length;
switch (G__41352) {
case 2:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41350.length)].join('')));

}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$transpose$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$transpose$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.transpose[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.transpose["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.transpose",_);
}
}
}
});

thinktopic.aljabr.core.transpose.cljs$lang$maxFixedArity = 5;

/**
 * Returns the backing data array.
 */
thinktopic.aljabr.core.data = (function thinktopic$aljabr$core$data(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$data$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$data$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.data[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.data["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.data",_);
}
}
}
});

/**
 * Returns the ndarray's type id (keyword).
 */
thinktopic.aljabr.core.data_type = (function thinktopic$aljabr$core$data_type(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$data_type$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$data_type$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.data_type[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.data_type["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.data-type",_);
}
}
}
});

/**
 * Returns a vector of the ndarray's strides in each dimension.
 */
thinktopic.aljabr.core.stride = (function thinktopic$aljabr$core$stride(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$stride$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$stride$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.stride[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.stride["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.stride",_);
}
}
}
});

/**
 * Returns the ndarray view's start index in the backing data array
 */
thinktopic.aljabr.core.offset = (function thinktopic$aljabr$core$offset(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$offset$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$offset$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.offset[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.offset["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.offset",_);
}
}
}
});

/**
 * Returns the element count of an ndarray view
 */
thinktopic.aljabr.core.size = (function thinktopic$aljabr$core$size(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$size$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$size$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.size[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.size["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.size",_);
}
}
}
});

/**
 * Creates a new backing array of only values in given ndarray view
 *  and returns new ndarray of same shape, but with strides reset to
 *  defaults order.
 */
thinktopic.aljabr.core.extract = (function thinktopic$aljabr$core$extract(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$extract$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$extract$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.extract[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.extract["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.extract",_);
}
}
}
});

/**
 * Returns the global index into the backing array for given
 *  position in an ndarray view.
 */
thinktopic.aljabr.core.index_at = (function thinktopic$aljabr$core$index_at(var_args){
var args41353 = [];
var len__19463__auto___41396 = arguments.length;
var i__19464__auto___41397 = (0);
while(true){
if((i__19464__auto___41397 < len__19463__auto___41396)){
args41353.push((arguments[i__19464__auto___41397]));

var G__41398 = (i__19464__auto___41397 + (1));
i__19464__auto___41397 = G__41398;
continue;
} else {
}
break;
}

var G__41355 = args41353.length;
switch (G__41355) {
case 2:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41353.length)].join('')));

}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_at$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_at$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_at[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_at["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-at",_);
}
}
}
});

thinktopic.aljabr.core.index_at.cljs$lang$maxFixedArity = 5;

/**
 * Computes relative position in an ndarray view from given absolute
 *  array index.
 */
thinktopic.aljabr.core.index_pos = (function thinktopic$aljabr$core$index_pos(_,i){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_pos$arity$2(_,i);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_pos[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,i);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_pos["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,i);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-pos",_);
}
}
}
});

/**
 * Returns a lazy seq of all array indices in an ndarray view.
 */
thinktopic.aljabr.core.index_seq = (function thinktopic$aljabr$core$index_seq(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$index_seq$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.index_seq[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.index_seq["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.index-seq",_);
}
}
}
});

/**
 * Returns a lazy seq of all position vectors in an ndarray view.
 */
thinktopic.aljabr.core.position_seq = (function thinktopic$aljabr$core$position_seq(_){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 == null)))){
return _.thinktopic$aljabr$core$PNDArray$position_seq$arity$1(_);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.position_seq[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.position_seq["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.position-seq",_);
}
}
}
});

/**
 * Returns a new ndarray of same type with its shape truncated at
 *  top end. Negative args are considered offsets from current shape.
 *  nil values keep shape in that dimension. Does not mutate backing
 *  array.
 */
thinktopic.aljabr.core.truncate_h = (function thinktopic$aljabr$core$truncate_h(var_args){
var args41356 = [];
var len__19463__auto___41400 = arguments.length;
var i__19464__auto___41401 = (0);
while(true){
if((i__19464__auto___41401 < len__19463__auto___41400)){
args41356.push((arguments[i__19464__auto___41401]));

var G__41402 = (i__19464__auto___41401 + (1));
i__19464__auto___41401 = G__41402;
continue;
} else {
}
break;
}

var G__41358 = args41356.length;
switch (G__41358) {
case 2:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41356.length)].join('')));

}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_h$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_h$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_h[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_h["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-h",_);
}
}
}
});

thinktopic.aljabr.core.truncate_h.cljs$lang$maxFixedArity = 5;

/**
 * Returns a new ndarray of same type with its shape truncated at
 *  lower end, effectively shifting its start index/offset towards the
 *  center of the view. Does not mutate backing array.
 */
thinktopic.aljabr.core.truncate_l = (function thinktopic$aljabr$core$truncate_l(var_args){
var args41359 = [];
var len__19463__auto___41404 = arguments.length;
var i__19464__auto___41405 = (0);
while(true){
if((i__19464__auto___41405 < len__19463__auto___41404)){
args41359.push((arguments[i__19464__auto___41405]));

var G__41406 = (i__19464__auto___41405 + (1));
i__19464__auto___41405 = G__41406;
continue;
} else {
}
break;
}

var G__41361 = args41359.length;
switch (G__41361) {
case 2:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41359.length)].join('')));

}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$truncate_l$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$truncate_l$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.truncate_l[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.truncate_l["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.truncate-l",_);
}
}
}
});

thinktopic.aljabr.core.truncate_l.cljs$lang$maxFixedArity = 5;

/**
 * Returns new ndarray view with stride steps/direction changed as
 *  per given vector. Values >1 result in skipping of items in that
 *  dimension, negative value flip direction, `nil` keeps current
 *  stride for that dimension. Does not mutate backing array.
 */
thinktopic.aljabr.core.step = (function thinktopic$aljabr$core$step(var_args){
var args41362 = [];
var len__19463__auto___41408 = arguments.length;
var i__19464__auto___41409 = (0);
while(true){
if((i__19464__auto___41409 < len__19463__auto___41408)){
args41362.push((arguments[i__19464__auto___41409]));

var G__41410 = (i__19464__auto___41409 + (1));
i__19464__auto___41409 = G__41410;
continue;
} else {
}
break;
}

var G__41364 = args41362.length;
switch (G__41364) {
case 2:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41362.length)].join('')));

}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$step$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$step$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.step[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.step["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.step",_);
}
}
}
});

thinktopic.aljabr.core.step.cljs$lang$maxFixedArity = 5;

/**
 * Generalized getter. Accepts n args (e.g. 3 for a 3D ndarray),
 *  each selecting a dimension slice (nil skips a dimension). Returns
 *  new ndarray view of selection, or if selecting in all dimensions,
 *  returns array value at that point. Does not mutate backing array.
 */
thinktopic.aljabr.core.pick = (function thinktopic$aljabr$core$pick(var_args){
var args41365 = [];
var len__19463__auto___41412 = arguments.length;
var i__19464__auto___41413 = (0);
while(true){
if((i__19464__auto___41413 < len__19463__auto___41412)){
args41365.push((arguments[i__19464__auto___41413]));

var G__41414 = (i__19464__auto___41413 + (1));
i__19464__auto___41413 = G__41414;
continue;
} else {
}
break;
}

var G__41367 = args41365.length;
switch (G__41367) {
case 2:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41365.length)].join('')));

}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$2 = (function (_,x){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$2 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$2(_,x);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$3 = (function (_,x,y){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$3 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$3(_,x,y);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$4 = (function (_,x,y,z){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$4 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$4(_,x,y,z);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$core$IFn$_invoke$arity$5 = (function (_,x,y,z,w){
if((!((_ == null))) && (!((_.thinktopic$aljabr$core$PNDArray$pick$arity$5 == null)))){
return _.thinktopic$aljabr$core$PNDArray$pick$arity$5(_,x,y,z,w);
} else {
var x__19060__auto__ = (((_ == null))?null:_);
var m__19061__auto__ = (thinktopic.aljabr.core.pick[goog.typeOf(x__19060__auto__)]);
if(!((m__19061__auto__ == null))){
return m__19061__auto__.call(null,_,x,y,z,w);
} else {
var m__19061__auto____$1 = (thinktopic.aljabr.core.pick["_"]);
if(!((m__19061__auto____$1 == null))){
return m__19061__auto____$1.call(null,_,x,y,z,w);
} else {
throw cljs.core.missing_protocol.call(null,"PNDArray.pick",_);
}
}
}
});

thinktopic.aljabr.core.pick.cljs$lang$maxFixedArity = 5;

thinktopic.aljabr.core.order = (function thinktopic$aljabr$core$order(coll){
return cljs.core.mapv.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.peek,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),coll)));
});
thinktopic.aljabr.core.shape__GT_stride = (function thinktopic$aljabr$core$shape__GT_stride(shape){
return cljs.core.vec.call(null,cljs.core.drop.call(null,(1),cljs.core.reduce.call(null,(function (p1__41416_SHARP_,p2__41417_SHARP_){
return cljs.core.conj.call(null,p1__41416_SHARP_,(p2__41417_SHARP_ * cljs.core.first.call(null,p1__41416_SHARP_)));
}),cljs.core.list((1)),cljs.core.reverse.call(null,shape))));
});
thinktopic.aljabr.core.ctor_registry = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);

/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1generic = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41425(s__41426){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41426__$1 = s__41426;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41426__$1);
if(temp__4657__auto__){
var s__41426__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41426__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41426__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41428 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41427 = (0);
while(true){
if((i__41427 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41427);
cljs.core.chunk_append.call(null,b__41428,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43118 = (i__41427 + (1));
i__41427 = G__43118;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41428),thinktopic$aljabr$core$iter__41425.call(null,cljs.core.chunk_rest.call(null,s__41426__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41428),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41426__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41425.call(null,cljs.core.rest.call(null,s__41426__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41422 = self__._offset;
var vec__41429 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41422 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41422], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41422], null));
var a0 = cljs.core.nth.call(null,vec__41429,(0),null);
var b0 = cljs.core.nth.call(null,vec__41429,(1),null);
var G__41422__$1 = cljs.core.nth.call(null,vec__41429,(2),null);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,G__41422__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41421){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41421__$1 = (G__41421 | (0));
var G__41418 = (G__41421__$1 - self__._offset);
var a0 = ((G__41418 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41420){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41418_43119 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41418_43119] = G__41420.call(null,p0,(self__._data[G__41418_43119])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41418){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41418);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41418 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41419 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,self__._offset,G__41418.call(null,p0__$1),G__41419.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41422 = self__._offset;
var G__41418 = cljs.core.PersistentVector.EMPTY;
var G__41419 = cljs.core.PersistentVector.EMPTY;
var vec__41430 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41418,G__41419,(G__41422 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41418,self__._shape0),cljs.core.conj.call(null,G__41419,self__._stride0),G__41422], null));
var G__41418__$1 = cljs.core.nth.call(null,vec__41430,(0),null);
var G__41419__$1 = cljs.core.nth.call(null,vec__41430,(1),null);
var G__41422__$1 = cljs.core.nth.call(null,vec__41430,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41418__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41422__$1,G__41419__$1,G__41418__$1);
} else {
return (self__._data[(G__41422__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41431 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41431,(0),null);
var b0 = cljs.core.nth.call(null,vec__41431,(1),null);
var G__41422 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,G__41422,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41420){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41418_43120 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41418_43120] = G__41420.call(null,p0,(self__._data[G__41418_43120])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41418){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41418);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41418){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41418);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1generic(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41418,G__41420){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41418] = G__41420.call(null,G__41418,(self__._data[(G__41418 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41432(s__41433){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41433__$1 = s__41433;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41433__$1);
if(temp__4657__auto__){
var s__41433__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41433__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41433__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41435 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41434 = (0);
while(true){
if((i__41434 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41434);
cljs.core.chunk_append.call(null,b__41435,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43121 = (i__41434 + (1));
i__41434 = G__43121;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41435),thinktopic$aljabr$core$iter__41432.call(null,cljs.core.chunk_rest.call(null,s__41433__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41435),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41433__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41432.call(null,cljs.core.rest.call(null,s__41433__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = cljs.core.to_array.call(null,self__._shape0);
var vec__41436 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41436,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1generic(buf__41278__auto__,(0),a0,self__._shape0));
var G__41418_43122 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41419_43123 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41418_43122)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41419_43123) | (0))] = (self__._data[(cljs.core.first.call(null,G__41418_43122) | (0))]));

var G__43124 = cljs.core.next.call(null,G__41418_43122);
var G__43125 = cljs.core.next.call(null,G__41419_43123);
G__41418_43122 = G__43124;
G__41419_43123 = G__43125;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43126 = length__41284__auto__;
var i__41280__auto___43127 = (0);
while(true){
if((i__41280__auto___43127 < n__19308__auto___43126)){
(r__41285__auto__[i__41280__auto___43127] = 0.0);

var G__43128 = (i__41280__auto___43127 + (1));
i__41280__auto___43127 = G__43128;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43129 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43130 = (0);
while(true){
if((i__41280__auto___43130 < n__19308__auto___43129)){
(r__41285__auto__[i__41280__auto___43130] = 0.0);

var G__43131 = (i__41280__auto___43130 + (1));
i__41280__auto___43130 = G__43131;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41437(s__41438){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41438__$1 = s__41438;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41438__$1);
if(temp__4657__auto__){
var s__41438__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41438__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41438__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41440 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41439 = (0);
while(true){
if((i__41439 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41439);
cljs.core.chunk_append.call(null,b__41440,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43132 = (i__41439 + (1));
i__41439 = G__43132;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41440),thinktopic$aljabr$core$iter__41437.call(null,cljs.core.chunk_rest.call(null,s__41438__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41440),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41438__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41437.call(null,cljs.core.rest.call(null,s__41438__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43133 = length__41284__auto__;
var i__41280__auto___43134 = (0);
while(true){
if((i__41280__auto___43134 < n__19308__auto___43133)){
(cloned_ary__41299__auto__[i__41280__auto___43134] = (self__._data[i__41280__auto___43134]));

var G__43135 = (i__41280__auto___43134 + (1));
i__41280__auto___43134 = G__43135;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1generic";

thinktopic.aljabr.core.NDArray1generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1generic");
});

thinktopic.aljabr.core.__GT_NDArray1generic = (function thinktopic$aljabr$core$__GT_NDArray1generic(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1generic(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_generic = (function thinktopic$aljabr$core$make_raw_ndarray1_generic(data__41282__auto__,o__41302__auto__,p__41441,p__41442){
var vec__41445 = p__41441;
var _stride0 = cljs.core.nth.call(null,vec__41445,(0),null);
var vec__41446 = p__41442;
var _shape0 = cljs.core.nth.call(null,vec__41446,(0),null);
return (new thinktopic.aljabr.core.NDArray1generic(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_generic', thinktopic.aljabr.core.make_raw_ndarray1_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint8 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41454(s__41455){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41455__$1 = s__41455;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41455__$1);
if(temp__4657__auto__){
var s__41455__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41455__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41455__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41457 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41456 = (0);
while(true){
if((i__41456 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41456);
cljs.core.chunk_append.call(null,b__41457,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43136 = (i__41456 + (1));
i__41456 = G__43136;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41457),thinktopic$aljabr$core$iter__41454.call(null,cljs.core.chunk_rest.call(null,s__41455__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41457),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41455__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41454.call(null,cljs.core.rest.call(null,s__41455__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41451 = self__._offset;
var vec__41458 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41451 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41451], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41451], null));
var a0 = cljs.core.nth.call(null,vec__41458,(0),null);
var b0 = cljs.core.nth.call(null,vec__41458,(1),null);
var G__41451__$1 = cljs.core.nth.call(null,vec__41458,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,G__41451__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41450){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41450__$1 = (G__41450 | (0));
var G__41447 = (G__41450__$1 - self__._offset);
var a0 = ((G__41447 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41449){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41447_43137 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41447_43137] = G__41449.call(null,p0,(self__._data[G__41447_43137])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41447){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41447);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41447 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41448 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,self__._offset,G__41447.call(null,p0__$1),G__41448.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41451 = self__._offset;
var G__41447 = cljs.core.PersistentVector.EMPTY;
var G__41448 = cljs.core.PersistentVector.EMPTY;
var vec__41459 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41447,G__41448,(G__41451 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41447,self__._shape0),cljs.core.conj.call(null,G__41448,self__._stride0),G__41451], null));
var G__41447__$1 = cljs.core.nth.call(null,vec__41459,(0),null);
var G__41448__$1 = cljs.core.nth.call(null,vec__41459,(1),null);
var G__41451__$1 = cljs.core.nth.call(null,vec__41459,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41447__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41451__$1,G__41448__$1,G__41447__$1);
} else {
return (self__._data[(G__41451__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41460 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41460,(0),null);
var b0 = cljs.core.nth.call(null,vec__41460,(1),null);
var G__41451 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,G__41451,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41449){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41447_43138 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41447_43138] = G__41449.call(null,p0,(self__._data[G__41447_43138])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41447){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41447);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41447){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41447);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint8(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41447,G__41449){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41447] = G__41449.call(null,G__41447,(self__._data[(G__41447 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41461(s__41462){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41462__$1 = s__41462;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41462__$1);
if(temp__4657__auto__){
var s__41462__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41462__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41462__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41464 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41463 = (0);
while(true){
if((i__41463 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41463);
cljs.core.chunk_append.call(null,b__41464,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43139 = (i__41463 + (1));
i__41463 = G__43139;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41464),thinktopic$aljabr$core$iter__41461.call(null,cljs.core.chunk_rest.call(null,s__41462__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41464),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41462__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41461.call(null,cljs.core.rest.call(null,s__41462__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint8.call(null,self__._shape0);
var vec__41465 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41465,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1uint8(buf__41278__auto__,(0),a0,self__._shape0));
var G__41447_43140 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41448_43141 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41447_43140)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41448_43141) | (0))] = (self__._data[(cljs.core.first.call(null,G__41447_43140) | (0))]));

var G__43142 = cljs.core.next.call(null,G__41447_43140);
var G__43143 = cljs.core.next.call(null,G__41448_43141);
G__41447_43140 = G__43142;
G__41448_43141 = G__43143;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43144 = length__41284__auto__;
var i__41280__auto___43145 = (0);
while(true){
if((i__41280__auto___43145 < n__19308__auto___43144)){
(r__41285__auto__[i__41280__auto___43145] = 0.0);

var G__43146 = (i__41280__auto___43145 + (1));
i__41280__auto___43145 = G__43146;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43147 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43148 = (0);
while(true){
if((i__41280__auto___43148 < n__19308__auto___43147)){
(r__41285__auto__[i__41280__auto___43148] = 0.0);

var G__43149 = (i__41280__auto___43148 + (1));
i__41280__auto___43148 = G__43149;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41466(s__41467){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41467__$1 = s__41467;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41467__$1);
if(temp__4657__auto__){
var s__41467__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41467__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41467__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41469 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41468 = (0);
while(true){
if((i__41468 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41468);
cljs.core.chunk_append.call(null,b__41469,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43150 = (i__41468 + (1));
i__41468 = G__43150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41469),thinktopic$aljabr$core$iter__41466.call(null,cljs.core.chunk_rest.call(null,s__41467__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41469),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41467__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41466.call(null,cljs.core.rest.call(null,s__41467__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43151 = length__41284__auto__;
var i__41280__auto___43152 = (0);
while(true){
if((i__41280__auto___43152 < n__19308__auto___43151)){
(cloned_ary__41299__auto__[i__41280__auto___43152] = (self__._data[i__41280__auto___43152]));

var G__43153 = (i__41280__auto___43152 + (1));
i__41280__auto___43152 = G__43153;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint8";

thinktopic.aljabr.core.NDArray1uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint8");
});

thinktopic.aljabr.core.__GT_NDArray1uint8 = (function thinktopic$aljabr$core$__GT_NDArray1uint8(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint8(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint8(data__41282__auto__,o__41302__auto__,p__41470,p__41471){
var vec__41474 = p__41470;
var _stride0 = cljs.core.nth.call(null,vec__41474,(0),null);
var vec__41475 = p__41471;
var _shape0 = cljs.core.nth.call(null,vec__41475,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint8(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint8', thinktopic.aljabr.core.make_raw_ndarray1_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint8_clamped = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41483(s__41484){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41484__$1 = s__41484;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41484__$1);
if(temp__4657__auto__){
var s__41484__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41484__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41484__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41486 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41485 = (0);
while(true){
if((i__41485 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41485);
cljs.core.chunk_append.call(null,b__41486,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43154 = (i__41485 + (1));
i__41485 = G__43154;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41486),thinktopic$aljabr$core$iter__41483.call(null,cljs.core.chunk_rest.call(null,s__41484__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41486),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41484__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41483.call(null,cljs.core.rest.call(null,s__41484__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41480 = self__._offset;
var vec__41487 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41480 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41480], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41480], null));
var a0 = cljs.core.nth.call(null,vec__41487,(0),null);
var b0 = cljs.core.nth.call(null,vec__41487,(1),null);
var G__41480__$1 = cljs.core.nth.call(null,vec__41487,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,G__41480__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41479){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41479__$1 = (G__41479 | (0));
var G__41476 = (G__41479__$1 - self__._offset);
var a0 = ((G__41476 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41478){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41476_43155 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41476_43155] = G__41478.call(null,p0,(self__._data[G__41476_43155])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41476){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41476);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41476 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41477 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,self__._offset,G__41476.call(null,p0__$1),G__41477.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41480 = self__._offset;
var G__41476 = cljs.core.PersistentVector.EMPTY;
var G__41477 = cljs.core.PersistentVector.EMPTY;
var vec__41488 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41476,G__41477,(G__41480 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41476,self__._shape0),cljs.core.conj.call(null,G__41477,self__._stride0),G__41480], null));
var G__41476__$1 = cljs.core.nth.call(null,vec__41488,(0),null);
var G__41477__$1 = cljs.core.nth.call(null,vec__41488,(1),null);
var G__41480__$1 = cljs.core.nth.call(null,vec__41488,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41476__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41480__$1,G__41477__$1,G__41476__$1);
} else {
return (self__._data[(G__41480__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41489 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41489,(0),null);
var b0 = cljs.core.nth.call(null,vec__41489,(1),null);
var G__41480 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,G__41480,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41478){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41476_43156 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41476_43156] = G__41478.call(null,p0,(self__._data[G__41476_43156])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41476){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41476);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41476){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41476);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41476,G__41478){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41476] = G__41478.call(null,G__41476,(self__._data[(G__41476 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41490(s__41491){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41491__$1 = s__41491;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41491__$1);
if(temp__4657__auto__){
var s__41491__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41491__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41491__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41493 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41492 = (0);
while(true){
if((i__41492 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41492);
cljs.core.chunk_append.call(null,b__41493,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43157 = (i__41492 + (1));
i__41492 = G__43157;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41493),thinktopic$aljabr$core$iter__41490.call(null,cljs.core.chunk_rest.call(null,s__41491__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41493),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41491__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41490.call(null,cljs.core.rest.call(null,s__41491__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint8_clamped.call(null,self__._shape0);
var vec__41494 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41494,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1uint8_clamped(buf__41278__auto__,(0),a0,self__._shape0));
var G__41476_43158 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41477_43159 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41476_43158)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41477_43159) | (0))] = (self__._data[(cljs.core.first.call(null,G__41476_43158) | (0))]));

var G__43160 = cljs.core.next.call(null,G__41476_43158);
var G__43161 = cljs.core.next.call(null,G__41477_43159);
G__41476_43158 = G__43160;
G__41477_43159 = G__43161;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43162 = length__41284__auto__;
var i__41280__auto___43163 = (0);
while(true){
if((i__41280__auto___43163 < n__19308__auto___43162)){
(r__41285__auto__[i__41280__auto___43163] = 0.0);

var G__43164 = (i__41280__auto___43163 + (1));
i__41280__auto___43163 = G__43164;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43165 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43166 = (0);
while(true){
if((i__41280__auto___43166 < n__19308__auto___43165)){
(r__41285__auto__[i__41280__auto___43166] = 0.0);

var G__43167 = (i__41280__auto___43166 + (1));
i__41280__auto___43166 = G__43167;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41495(s__41496){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41496__$1 = s__41496;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41496__$1);
if(temp__4657__auto__){
var s__41496__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41496__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41496__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41498 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41497 = (0);
while(true){
if((i__41497 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41497);
cljs.core.chunk_append.call(null,b__41498,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43168 = (i__41497 + (1));
i__41497 = G__43168;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41498),thinktopic$aljabr$core$iter__41495.call(null,cljs.core.chunk_rest.call(null,s__41496__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41498),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41496__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41495.call(null,cljs.core.rest.call(null,s__41496__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43169 = length__41284__auto__;
var i__41280__auto___43170 = (0);
while(true){
if((i__41280__auto___43170 < n__19308__auto___43169)){
(cloned_ary__41299__auto__[i__41280__auto___43170] = (self__._data[i__41280__auto___43170]));

var G__43171 = (i__41280__auto___43170 + (1));
i__41280__auto___43170 = G__43171;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint8-clamped";

thinktopic.aljabr.core.NDArray1uint8_clamped.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint8-clamped");
});

thinktopic.aljabr.core.__GT_NDArray1uint8_clamped = (function thinktopic$aljabr$core$__GT_NDArray1uint8_clamped(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped = (function thinktopic$aljabr$core$make_raw_ndarray1_uint8_clamped(data__41282__auto__,o__41302__auto__,p__41499,p__41500){
var vec__41503 = p__41499;
var _stride0 = cljs.core.nth.call(null,vec__41503,(0),null);
var vec__41504 = p__41500;
var _shape0 = cljs.core.nth.call(null,vec__41504,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint8_clamped(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped', thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint8_clamped,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8_clamped], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint16 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41512(s__41513){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41513__$1 = s__41513;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41513__$1);
if(temp__4657__auto__){
var s__41513__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41513__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41513__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41515 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41514 = (0);
while(true){
if((i__41514 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41514);
cljs.core.chunk_append.call(null,b__41515,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43172 = (i__41514 + (1));
i__41514 = G__43172;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41515),thinktopic$aljabr$core$iter__41512.call(null,cljs.core.chunk_rest.call(null,s__41513__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41515),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41513__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41512.call(null,cljs.core.rest.call(null,s__41513__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41509 = self__._offset;
var vec__41516 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41509 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41509], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41509], null));
var a0 = cljs.core.nth.call(null,vec__41516,(0),null);
var b0 = cljs.core.nth.call(null,vec__41516,(1),null);
var G__41509__$1 = cljs.core.nth.call(null,vec__41516,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,G__41509__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41508){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41508__$1 = (G__41508 | (0));
var G__41505 = (G__41508__$1 - self__._offset);
var a0 = ((G__41505 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41507){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41505_43173 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41505_43173] = G__41507.call(null,p0,(self__._data[G__41505_43173])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41505){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41505);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41505 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41506 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,self__._offset,G__41505.call(null,p0__$1),G__41506.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41509 = self__._offset;
var G__41505 = cljs.core.PersistentVector.EMPTY;
var G__41506 = cljs.core.PersistentVector.EMPTY;
var vec__41517 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41505,G__41506,(G__41509 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41505,self__._shape0),cljs.core.conj.call(null,G__41506,self__._stride0),G__41509], null));
var G__41505__$1 = cljs.core.nth.call(null,vec__41517,(0),null);
var G__41506__$1 = cljs.core.nth.call(null,vec__41517,(1),null);
var G__41509__$1 = cljs.core.nth.call(null,vec__41517,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41505__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41509__$1,G__41506__$1,G__41505__$1);
} else {
return (self__._data[(G__41509__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41518 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41518,(0),null);
var b0 = cljs.core.nth.call(null,vec__41518,(1),null);
var G__41509 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,G__41509,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41507){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41505_43174 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41505_43174] = G__41507.call(null,p0,(self__._data[G__41505_43174])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41505){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41505);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41505){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41505);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint16(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41505,G__41507){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41505] = G__41507.call(null,G__41505,(self__._data[(G__41505 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41519(s__41520){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41520__$1 = s__41520;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41520__$1);
if(temp__4657__auto__){
var s__41520__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41520__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41520__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41522 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41521 = (0);
while(true){
if((i__41521 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41521);
cljs.core.chunk_append.call(null,b__41522,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43175 = (i__41521 + (1));
i__41521 = G__43175;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41522),thinktopic$aljabr$core$iter__41519.call(null,cljs.core.chunk_rest.call(null,s__41520__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41522),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41520__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41519.call(null,cljs.core.rest.call(null,s__41520__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint16.call(null,self__._shape0);
var vec__41523 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41523,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1uint16(buf__41278__auto__,(0),a0,self__._shape0));
var G__41505_43176 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41506_43177 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41505_43176)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41506_43177) | (0))] = (self__._data[(cljs.core.first.call(null,G__41505_43176) | (0))]));

var G__43178 = cljs.core.next.call(null,G__41505_43176);
var G__43179 = cljs.core.next.call(null,G__41506_43177);
G__41505_43176 = G__43178;
G__41506_43177 = G__43179;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43180 = length__41284__auto__;
var i__41280__auto___43181 = (0);
while(true){
if((i__41280__auto___43181 < n__19308__auto___43180)){
(r__41285__auto__[i__41280__auto___43181] = 0.0);

var G__43182 = (i__41280__auto___43181 + (1));
i__41280__auto___43181 = G__43182;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43183 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43184 = (0);
while(true){
if((i__41280__auto___43184 < n__19308__auto___43183)){
(r__41285__auto__[i__41280__auto___43184] = 0.0);

var G__43185 = (i__41280__auto___43184 + (1));
i__41280__auto___43184 = G__43185;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41524(s__41525){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41525__$1 = s__41525;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41525__$1);
if(temp__4657__auto__){
var s__41525__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41525__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41525__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41527 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41526 = (0);
while(true){
if((i__41526 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41526);
cljs.core.chunk_append.call(null,b__41527,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43186 = (i__41526 + (1));
i__41526 = G__43186;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41527),thinktopic$aljabr$core$iter__41524.call(null,cljs.core.chunk_rest.call(null,s__41525__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41527),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41525__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41524.call(null,cljs.core.rest.call(null,s__41525__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43187 = length__41284__auto__;
var i__41280__auto___43188 = (0);
while(true){
if((i__41280__auto___43188 < n__19308__auto___43187)){
(cloned_ary__41299__auto__[i__41280__auto___43188] = (self__._data[i__41280__auto___43188]));

var G__43189 = (i__41280__auto___43188 + (1));
i__41280__auto___43188 = G__43189;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint16";

thinktopic.aljabr.core.NDArray1uint16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint16");
});

thinktopic.aljabr.core.__GT_NDArray1uint16 = (function thinktopic$aljabr$core$__GT_NDArray1uint16(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint16(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint16 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint16(data__41282__auto__,o__41302__auto__,p__41528,p__41529){
var vec__41532 = p__41528;
var _stride0 = cljs.core.nth.call(null,vec__41532,(0),null);
var vec__41533 = p__41529;
var _shape0 = cljs.core.nth.call(null,vec__41533,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint16(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint16', thinktopic.aljabr.core.make_raw_ndarray1_uint16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint16","uint16",-588869202)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1uint32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41541(s__41542){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41542__$1 = s__41542;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41542__$1);
if(temp__4657__auto__){
var s__41542__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41542__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41542__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41544 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41543 = (0);
while(true){
if((i__41543 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41543);
cljs.core.chunk_append.call(null,b__41544,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43190 = (i__41543 + (1));
i__41543 = G__43190;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41544),thinktopic$aljabr$core$iter__41541.call(null,cljs.core.chunk_rest.call(null,s__41542__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41544),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41542__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41541.call(null,cljs.core.rest.call(null,s__41542__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41538 = self__._offset;
var vec__41545 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41538 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41538], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41538], null));
var a0 = cljs.core.nth.call(null,vec__41545,(0),null);
var b0 = cljs.core.nth.call(null,vec__41545,(1),null);
var G__41538__$1 = cljs.core.nth.call(null,vec__41545,(2),null);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,G__41538__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41537){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41537__$1 = (G__41537 | (0));
var G__41534 = (G__41537__$1 - self__._offset);
var a0 = ((G__41534 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41536){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41534_43191 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41534_43191] = G__41536.call(null,p0,(self__._data[G__41534_43191])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41534){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41534);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41534 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41535 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,self__._offset,G__41534.call(null,p0__$1),G__41535.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41538 = self__._offset;
var G__41534 = cljs.core.PersistentVector.EMPTY;
var G__41535 = cljs.core.PersistentVector.EMPTY;
var vec__41546 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41534,G__41535,(G__41538 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41534,self__._shape0),cljs.core.conj.call(null,G__41535,self__._stride0),G__41538], null));
var G__41534__$1 = cljs.core.nth.call(null,vec__41546,(0),null);
var G__41535__$1 = cljs.core.nth.call(null,vec__41546,(1),null);
var G__41538__$1 = cljs.core.nth.call(null,vec__41546,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41534__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41538__$1,G__41535__$1,G__41534__$1);
} else {
return (self__._data[(G__41538__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41547 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41547,(0),null);
var b0 = cljs.core.nth.call(null,vec__41547,(1),null);
var G__41538 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,G__41538,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41536){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41534_43192 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41534_43192] = G__41536.call(null,p0,(self__._data[G__41534_43192])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41534){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41534);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41534){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41534);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1uint32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41534,G__41536){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41534] = G__41536.call(null,G__41534,(self__._data[(G__41534 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41548(s__41549){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41549__$1 = s__41549;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41549__$1);
if(temp__4657__auto__){
var s__41549__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41549__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41549__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41551 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41550 = (0);
while(true){
if((i__41550 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41550);
cljs.core.chunk_append.call(null,b__41551,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43193 = (i__41550 + (1));
i__41550 = G__43193;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41551),thinktopic$aljabr$core$iter__41548.call(null,cljs.core.chunk_rest.call(null,s__41549__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41551),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41549__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41548.call(null,cljs.core.rest.call(null,s__41549__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint32.call(null,self__._shape0);
var vec__41552 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41552,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1uint32(buf__41278__auto__,(0),a0,self__._shape0));
var G__41534_43194 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41535_43195 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41534_43194)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41535_43195) | (0))] = (self__._data[(cljs.core.first.call(null,G__41534_43194) | (0))]));

var G__43196 = cljs.core.next.call(null,G__41534_43194);
var G__43197 = cljs.core.next.call(null,G__41535_43195);
G__41534_43194 = G__43196;
G__41535_43195 = G__43197;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43198 = length__41284__auto__;
var i__41280__auto___43199 = (0);
while(true){
if((i__41280__auto___43199 < n__19308__auto___43198)){
(r__41285__auto__[i__41280__auto___43199] = 0.0);

var G__43200 = (i__41280__auto___43199 + (1));
i__41280__auto___43199 = G__43200;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43201 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43202 = (0);
while(true){
if((i__41280__auto___43202 < n__19308__auto___43201)){
(r__41285__auto__[i__41280__auto___43202] = 0.0);

var G__43203 = (i__41280__auto___43202 + (1));
i__41280__auto___43202 = G__43203;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41553(s__41554){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41554__$1 = s__41554;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41554__$1);
if(temp__4657__auto__){
var s__41554__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41554__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41554__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41556 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41555 = (0);
while(true){
if((i__41555 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41555);
cljs.core.chunk_append.call(null,b__41556,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43204 = (i__41555 + (1));
i__41555 = G__43204;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41556),thinktopic$aljabr$core$iter__41553.call(null,cljs.core.chunk_rest.call(null,s__41554__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41556),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41554__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41553.call(null,cljs.core.rest.call(null,s__41554__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43205 = length__41284__auto__;
var i__41280__auto___43206 = (0);
while(true){
if((i__41280__auto___43206 < n__19308__auto___43205)){
(cloned_ary__41299__auto__[i__41280__auto___43206] = (self__._data[i__41280__auto___43206]));

var G__43207 = (i__41280__auto___43206 + (1));
i__41280__auto___43206 = G__43207;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1uint32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1uint32";

thinktopic.aljabr.core.NDArray1uint32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1uint32");
});

thinktopic.aljabr.core.__GT_NDArray1uint32 = (function thinktopic$aljabr$core$__GT_NDArray1uint32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1uint32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_uint32 = (function thinktopic$aljabr$core$make_raw_ndarray1_uint32(data__41282__auto__,o__41302__auto__,p__41557,p__41558){
var vec__41561 = p__41557;
var _stride0 = cljs.core.nth.call(null,vec__41561,(0),null);
var vec__41562 = p__41558;
var _shape0 = cljs.core.nth.call(null,vec__41562,(0),null);
return (new thinktopic.aljabr.core.NDArray1uint32(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_uint32', thinktopic.aljabr.core.make_raw_ndarray1_uint32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"uint32","uint32",-418789486)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_uint32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int8 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41570(s__41571){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41571__$1 = s__41571;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41571__$1);
if(temp__4657__auto__){
var s__41571__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41571__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41571__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41573 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41572 = (0);
while(true){
if((i__41572 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41572);
cljs.core.chunk_append.call(null,b__41573,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43208 = (i__41572 + (1));
i__41572 = G__43208;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41573),thinktopic$aljabr$core$iter__41570.call(null,cljs.core.chunk_rest.call(null,s__41571__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41573),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41571__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41570.call(null,cljs.core.rest.call(null,s__41571__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41567 = self__._offset;
var vec__41574 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41567 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41567], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41567], null));
var a0 = cljs.core.nth.call(null,vec__41574,(0),null);
var b0 = cljs.core.nth.call(null,vec__41574,(1),null);
var G__41567__$1 = cljs.core.nth.call(null,vec__41574,(2),null);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,G__41567__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41566){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41566__$1 = (G__41566 | (0));
var G__41563 = (G__41566__$1 - self__._offset);
var a0 = ((G__41563 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41565){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41563_43209 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41563_43209] = G__41565.call(null,p0,(self__._data[G__41563_43209])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41563){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41563);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41563 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41564 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,self__._offset,G__41563.call(null,p0__$1),G__41564.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41567 = self__._offset;
var G__41563 = cljs.core.PersistentVector.EMPTY;
var G__41564 = cljs.core.PersistentVector.EMPTY;
var vec__41575 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41563,G__41564,(G__41567 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41563,self__._shape0),cljs.core.conj.call(null,G__41564,self__._stride0),G__41567], null));
var G__41563__$1 = cljs.core.nth.call(null,vec__41575,(0),null);
var G__41564__$1 = cljs.core.nth.call(null,vec__41575,(1),null);
var G__41567__$1 = cljs.core.nth.call(null,vec__41575,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41563__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41567__$1,G__41564__$1,G__41563__$1);
} else {
return (self__._data[(G__41567__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41576 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41576,(0),null);
var b0 = cljs.core.nth.call(null,vec__41576,(1),null);
var G__41567 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,G__41567,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41565){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41563_43210 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41563_43210] = G__41565.call(null,p0,(self__._data[G__41563_43210])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41563){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41563);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41563){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41563);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int8(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41563,G__41565){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41563] = G__41565.call(null,G__41563,(self__._data[(G__41563 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41577(s__41578){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41578__$1 = s__41578;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41578__$1);
if(temp__4657__auto__){
var s__41578__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41578__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41578__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41580 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41579 = (0);
while(true){
if((i__41579 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41579);
cljs.core.chunk_append.call(null,b__41580,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43211 = (i__41579 + (1));
i__41579 = G__43211;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41580),thinktopic$aljabr$core$iter__41577.call(null,cljs.core.chunk_rest.call(null,s__41578__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41580),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41578__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41577.call(null,cljs.core.rest.call(null,s__41578__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int8.call(null,self__._shape0);
var vec__41581 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41581,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1int8(buf__41278__auto__,(0),a0,self__._shape0));
var G__41563_43212 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41564_43213 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41563_43212)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41564_43213) | (0))] = (self__._data[(cljs.core.first.call(null,G__41563_43212) | (0))]));

var G__43214 = cljs.core.next.call(null,G__41563_43212);
var G__43215 = cljs.core.next.call(null,G__41564_43213);
G__41563_43212 = G__43214;
G__41564_43213 = G__43215;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43216 = length__41284__auto__;
var i__41280__auto___43217 = (0);
while(true){
if((i__41280__auto___43217 < n__19308__auto___43216)){
(r__41285__auto__[i__41280__auto___43217] = 0.0);

var G__43218 = (i__41280__auto___43217 + (1));
i__41280__auto___43217 = G__43218;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43219 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43220 = (0);
while(true){
if((i__41280__auto___43220 < n__19308__auto___43219)){
(r__41285__auto__[i__41280__auto___43220] = 0.0);

var G__43221 = (i__41280__auto___43220 + (1));
i__41280__auto___43220 = G__43221;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41582(s__41583){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41583__$1 = s__41583;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41583__$1);
if(temp__4657__auto__){
var s__41583__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41583__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41583__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41585 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41584 = (0);
while(true){
if((i__41584 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41584);
cljs.core.chunk_append.call(null,b__41585,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43222 = (i__41584 + (1));
i__41584 = G__43222;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41585),thinktopic$aljabr$core$iter__41582.call(null,cljs.core.chunk_rest.call(null,s__41583__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41585),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41583__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41582.call(null,cljs.core.rest.call(null,s__41583__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43223 = length__41284__auto__;
var i__41280__auto___43224 = (0);
while(true){
if((i__41280__auto___43224 < n__19308__auto___43223)){
(cloned_ary__41299__auto__[i__41280__auto___43224] = (self__._data[i__41280__auto___43224]));

var G__43225 = (i__41280__auto___43224 + (1));
i__41280__auto___43224 = G__43225;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int8";

thinktopic.aljabr.core.NDArray1int8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int8");
});

thinktopic.aljabr.core.__GT_NDArray1int8 = (function thinktopic$aljabr$core$__GT_NDArray1int8(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int8(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int8 = (function thinktopic$aljabr$core$make_raw_ndarray1_int8(data__41282__auto__,o__41302__auto__,p__41586,p__41587){
var vec__41590 = p__41586;
var _stride0 = cljs.core.nth.call(null,vec__41590,(0),null);
var vec__41591 = p__41587;
var _shape0 = cljs.core.nth.call(null,vec__41591,(0),null);
return (new thinktopic.aljabr.core.NDArray1int8(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int8', thinktopic.aljabr.core.make_raw_ndarray1_int8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int8","int8",-1834023920)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int16 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41599(s__41600){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41600__$1 = s__41600;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41600__$1);
if(temp__4657__auto__){
var s__41600__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41600__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41600__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41602 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41601 = (0);
while(true){
if((i__41601 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41601);
cljs.core.chunk_append.call(null,b__41602,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43226 = (i__41601 + (1));
i__41601 = G__43226;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41602),thinktopic$aljabr$core$iter__41599.call(null,cljs.core.chunk_rest.call(null,s__41600__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41602),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41600__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41599.call(null,cljs.core.rest.call(null,s__41600__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41596 = self__._offset;
var vec__41603 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41596 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41596], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41596], null));
var a0 = cljs.core.nth.call(null,vec__41603,(0),null);
var b0 = cljs.core.nth.call(null,vec__41603,(1),null);
var G__41596__$1 = cljs.core.nth.call(null,vec__41603,(2),null);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,G__41596__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41595){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41595__$1 = (G__41595 | (0));
var G__41592 = (G__41595__$1 - self__._offset);
var a0 = ((G__41592 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41594){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41592_43227 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41592_43227] = G__41594.call(null,p0,(self__._data[G__41592_43227])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41592){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41592);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41592 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41593 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,self__._offset,G__41592.call(null,p0__$1),G__41593.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41596 = self__._offset;
var G__41592 = cljs.core.PersistentVector.EMPTY;
var G__41593 = cljs.core.PersistentVector.EMPTY;
var vec__41604 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41592,G__41593,(G__41596 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41592,self__._shape0),cljs.core.conj.call(null,G__41593,self__._stride0),G__41596], null));
var G__41592__$1 = cljs.core.nth.call(null,vec__41604,(0),null);
var G__41593__$1 = cljs.core.nth.call(null,vec__41604,(1),null);
var G__41596__$1 = cljs.core.nth.call(null,vec__41604,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41592__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41596__$1,G__41593__$1,G__41592__$1);
} else {
return (self__._data[(G__41596__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41605 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41605,(0),null);
var b0 = cljs.core.nth.call(null,vec__41605,(1),null);
var G__41596 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,G__41596,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41594){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41592_43228 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41592_43228] = G__41594.call(null,p0,(self__._data[G__41592_43228])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41592){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41592);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41592){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41592);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int16(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41592,G__41594){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41592] = G__41594.call(null,G__41592,(self__._data[(G__41592 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41606(s__41607){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41607__$1 = s__41607;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41607__$1);
if(temp__4657__auto__){
var s__41607__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41607__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41607__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41609 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41608 = (0);
while(true){
if((i__41608 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41608);
cljs.core.chunk_append.call(null,b__41609,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43229 = (i__41608 + (1));
i__41608 = G__43229;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41609),thinktopic$aljabr$core$iter__41606.call(null,cljs.core.chunk_rest.call(null,s__41607__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41609),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41607__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41606.call(null,cljs.core.rest.call(null,s__41607__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int16.call(null,self__._shape0);
var vec__41610 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41610,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1int16(buf__41278__auto__,(0),a0,self__._shape0));
var G__41592_43230 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41593_43231 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41592_43230)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41593_43231) | (0))] = (self__._data[(cljs.core.first.call(null,G__41592_43230) | (0))]));

var G__43232 = cljs.core.next.call(null,G__41592_43230);
var G__43233 = cljs.core.next.call(null,G__41593_43231);
G__41592_43230 = G__43232;
G__41593_43231 = G__43233;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43234 = length__41284__auto__;
var i__41280__auto___43235 = (0);
while(true){
if((i__41280__auto___43235 < n__19308__auto___43234)){
(r__41285__auto__[i__41280__auto___43235] = 0.0);

var G__43236 = (i__41280__auto___43235 + (1));
i__41280__auto___43235 = G__43236;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43237 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43238 = (0);
while(true){
if((i__41280__auto___43238 < n__19308__auto___43237)){
(r__41285__auto__[i__41280__auto___43238] = 0.0);

var G__43239 = (i__41280__auto___43238 + (1));
i__41280__auto___43238 = G__43239;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41611(s__41612){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41612__$1 = s__41612;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41612__$1);
if(temp__4657__auto__){
var s__41612__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41612__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41612__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41614 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41613 = (0);
while(true){
if((i__41613 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41613);
cljs.core.chunk_append.call(null,b__41614,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43240 = (i__41613 + (1));
i__41613 = G__43240;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41614),thinktopic$aljabr$core$iter__41611.call(null,cljs.core.chunk_rest.call(null,s__41612__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41614),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41612__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41611.call(null,cljs.core.rest.call(null,s__41612__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43241 = length__41284__auto__;
var i__41280__auto___43242 = (0);
while(true){
if((i__41280__auto___43242 < n__19308__auto___43241)){
(cloned_ary__41299__auto__[i__41280__auto___43242] = (self__._data[i__41280__auto___43242]));

var G__43243 = (i__41280__auto___43242 + (1));
i__41280__auto___43242 = G__43243;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int16";

thinktopic.aljabr.core.NDArray1int16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int16");
});

thinktopic.aljabr.core.__GT_NDArray1int16 = (function thinktopic$aljabr$core$__GT_NDArray1int16(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int16(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int16 = (function thinktopic$aljabr$core$make_raw_ndarray1_int16(data__41282__auto__,o__41302__auto__,p__41615,p__41616){
var vec__41619 = p__41615;
var _stride0 = cljs.core.nth.call(null,vec__41619,(0),null);
var vec__41620 = p__41616;
var _shape0 = cljs.core.nth.call(null,vec__41620,(0),null);
return (new thinktopic.aljabr.core.NDArray1int16(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int16', thinktopic.aljabr.core.make_raw_ndarray1_int16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int16","int16",-188764863)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1int32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41628(s__41629){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41629__$1 = s__41629;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41629__$1);
if(temp__4657__auto__){
var s__41629__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41629__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41629__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41631 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41630 = (0);
while(true){
if((i__41630 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41630);
cljs.core.chunk_append.call(null,b__41631,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43244 = (i__41630 + (1));
i__41630 = G__43244;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41631),thinktopic$aljabr$core$iter__41628.call(null,cljs.core.chunk_rest.call(null,s__41629__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41631),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41629__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41628.call(null,cljs.core.rest.call(null,s__41629__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41625 = self__._offset;
var vec__41632 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41625 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41625], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41625], null));
var a0 = cljs.core.nth.call(null,vec__41632,(0),null);
var b0 = cljs.core.nth.call(null,vec__41632,(1),null);
var G__41625__$1 = cljs.core.nth.call(null,vec__41632,(2),null);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,G__41625__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41624){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41624__$1 = (G__41624 | (0));
var G__41621 = (G__41624__$1 - self__._offset);
var a0 = ((G__41621 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41623){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41621_43245 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41621_43245] = G__41623.call(null,p0,(self__._data[G__41621_43245])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41621){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41621);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41621 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41622 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,self__._offset,G__41621.call(null,p0__$1),G__41622.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41625 = self__._offset;
var G__41621 = cljs.core.PersistentVector.EMPTY;
var G__41622 = cljs.core.PersistentVector.EMPTY;
var vec__41633 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41621,G__41622,(G__41625 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41621,self__._shape0),cljs.core.conj.call(null,G__41622,self__._stride0),G__41625], null));
var G__41621__$1 = cljs.core.nth.call(null,vec__41633,(0),null);
var G__41622__$1 = cljs.core.nth.call(null,vec__41633,(1),null);
var G__41625__$1 = cljs.core.nth.call(null,vec__41633,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41621__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41625__$1,G__41622__$1,G__41621__$1);
} else {
return (self__._data[(G__41625__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41634 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41634,(0),null);
var b0 = cljs.core.nth.call(null,vec__41634,(1),null);
var G__41625 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,G__41625,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41623){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41621_43246 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41621_43246] = G__41623.call(null,p0,(self__._data[G__41621_43246])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41621){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41621);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41621){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41621);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1int32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41621,G__41623){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41621] = G__41623.call(null,G__41621,(self__._data[(G__41621 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41635(s__41636){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41636__$1 = s__41636;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41636__$1);
if(temp__4657__auto__){
var s__41636__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41636__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41636__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41638 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41637 = (0);
while(true){
if((i__41637 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41637);
cljs.core.chunk_append.call(null,b__41638,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43247 = (i__41637 + (1));
i__41637 = G__43247;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41638),thinktopic$aljabr$core$iter__41635.call(null,cljs.core.chunk_rest.call(null,s__41636__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41638),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41636__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41635.call(null,cljs.core.rest.call(null,s__41636__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1int32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int32.call(null,self__._shape0);
var vec__41639 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41639,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1int32(buf__41278__auto__,(0),a0,self__._shape0));
var G__41621_43248 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41622_43249 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41621_43248)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41622_43249) | (0))] = (self__._data[(cljs.core.first.call(null,G__41621_43248) | (0))]));

var G__43250 = cljs.core.next.call(null,G__41621_43248);
var G__43251 = cljs.core.next.call(null,G__41622_43249);
G__41621_43248 = G__43250;
G__41622_43249 = G__43251;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43252 = length__41284__auto__;
var i__41280__auto___43253 = (0);
while(true){
if((i__41280__auto___43253 < n__19308__auto___43252)){
(r__41285__auto__[i__41280__auto___43253] = 0.0);

var G__43254 = (i__41280__auto___43253 + (1));
i__41280__auto___43253 = G__43254;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43255 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43256 = (0);
while(true){
if((i__41280__auto___43256 < n__19308__auto___43255)){
(r__41285__auto__[i__41280__auto___43256] = 0.0);

var G__43257 = (i__41280__auto___43256 + (1));
i__41280__auto___43256 = G__43257;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1int32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41640(s__41641){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41641__$1 = s__41641;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41641__$1);
if(temp__4657__auto__){
var s__41641__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41641__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41641__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41643 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41642 = (0);
while(true){
if((i__41642 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41642);
cljs.core.chunk_append.call(null,b__41643,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43258 = (i__41642 + (1));
i__41642 = G__43258;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41643),thinktopic$aljabr$core$iter__41640.call(null,cljs.core.chunk_rest.call(null,s__41641__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41643),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41641__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41640.call(null,cljs.core.rest.call(null,s__41641__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43259 = length__41284__auto__;
var i__41280__auto___43260 = (0);
while(true){
if((i__41280__auto___43260 < n__19308__auto___43259)){
(cloned_ary__41299__auto__[i__41280__auto___43260] = (self__._data[i__41280__auto___43260]));

var G__43261 = (i__41280__auto___43260 + (1));
i__41280__auto___43260 = G__43261;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1int32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1int32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1int32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1int32";

thinktopic.aljabr.core.NDArray1int32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1int32");
});

thinktopic.aljabr.core.__GT_NDArray1int32 = (function thinktopic$aljabr$core$__GT_NDArray1int32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1int32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_int32 = (function thinktopic$aljabr$core$make_raw_ndarray1_int32(data__41282__auto__,o__41302__auto__,p__41644,p__41645){
var vec__41648 = p__41644;
var _stride0 = cljs.core.nth.call(null,vec__41648,(0),null);
var vec__41649 = p__41645;
var _shape0 = cljs.core.nth.call(null,vec__41649,(0),null);
return (new thinktopic.aljabr.core.NDArray1int32(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_int32', thinktopic.aljabr.core.make_raw_ndarray1_int32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"int32","int32",1718804896)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_int32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1float32 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41657(s__41658){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41658__$1 = s__41658;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41658__$1);
if(temp__4657__auto__){
var s__41658__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41658__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41658__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41660 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41659 = (0);
while(true){
if((i__41659 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41659);
cljs.core.chunk_append.call(null,b__41660,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43262 = (i__41659 + (1));
i__41659 = G__43262;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41660),thinktopic$aljabr$core$iter__41657.call(null,cljs.core.chunk_rest.call(null,s__41658__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41660),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41658__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41657.call(null,cljs.core.rest.call(null,s__41658__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41654 = self__._offset;
var vec__41661 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41654 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41654], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41654], null));
var a0 = cljs.core.nth.call(null,vec__41661,(0),null);
var b0 = cljs.core.nth.call(null,vec__41661,(1),null);
var G__41654__$1 = cljs.core.nth.call(null,vec__41661,(2),null);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,G__41654__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41653){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41653__$1 = (G__41653 | (0));
var G__41650 = (G__41653__$1 - self__._offset);
var a0 = ((G__41650 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41652){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41650_43263 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41650_43263] = G__41652.call(null,p0,(self__._data[G__41650_43263])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41650){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41650);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41650 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41651 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,self__._offset,G__41650.call(null,p0__$1),G__41651.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41654 = self__._offset;
var G__41650 = cljs.core.PersistentVector.EMPTY;
var G__41651 = cljs.core.PersistentVector.EMPTY;
var vec__41662 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41650,G__41651,(G__41654 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41650,self__._shape0),cljs.core.conj.call(null,G__41651,self__._stride0),G__41654], null));
var G__41650__$1 = cljs.core.nth.call(null,vec__41662,(0),null);
var G__41651__$1 = cljs.core.nth.call(null,vec__41662,(1),null);
var G__41654__$1 = cljs.core.nth.call(null,vec__41662,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41650__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41654__$1,G__41651__$1,G__41650__$1);
} else {
return (self__._data[(G__41654__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41663 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41663,(0),null);
var b0 = cljs.core.nth.call(null,vec__41663,(1),null);
var G__41654 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,G__41654,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41652){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41650_43264 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41650_43264] = G__41652.call(null,p0,(self__._data[G__41650_43264])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41650){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41650);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41650){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41650);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1float32(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41650,G__41652){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41650] = G__41652.call(null,G__41650,(self__._data[(G__41650 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41664(s__41665){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41665__$1 = s__41665;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41665__$1);
if(temp__4657__auto__){
var s__41665__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41665__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41665__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41667 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41666 = (0);
while(true){
if((i__41666 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41666);
cljs.core.chunk_append.call(null,b__41667,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43265 = (i__41666 + (1));
i__41666 = G__43265;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41667),thinktopic$aljabr$core$iter__41664.call(null,cljs.core.chunk_rest.call(null,s__41665__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41667),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41665__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41664.call(null,cljs.core.rest.call(null,s__41665__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.float32.call(null,self__._shape0);
var vec__41668 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41668,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1float32(buf__41278__auto__,(0),a0,self__._shape0));
var G__41650_43266 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41651_43267 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41650_43266)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41651_43267) | (0))] = (self__._data[(cljs.core.first.call(null,G__41650_43266) | (0))]));

var G__43268 = cljs.core.next.call(null,G__41650_43266);
var G__43269 = cljs.core.next.call(null,G__41651_43267);
G__41650_43266 = G__43268;
G__41651_43267 = G__43269;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43270 = length__41284__auto__;
var i__41280__auto___43271 = (0);
while(true){
if((i__41280__auto___43271 < n__19308__auto___43270)){
(r__41285__auto__[i__41280__auto___43271] = 0.0);

var G__43272 = (i__41280__auto___43271 + (1));
i__41280__auto___43271 = G__43272;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43273 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43274 = (0);
while(true){
if((i__41280__auto___43274 < n__19308__auto___43273)){
(r__41285__auto__[i__41280__auto___43274] = 0.0);

var G__43275 = (i__41280__auto___43274 + (1));
i__41280__auto___43274 = G__43275;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1float32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41669(s__41670){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41670__$1 = s__41670;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41670__$1);
if(temp__4657__auto__){
var s__41670__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41670__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41670__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41672 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41671 = (0);
while(true){
if((i__41671 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41671);
cljs.core.chunk_append.call(null,b__41672,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43276 = (i__41671 + (1));
i__41671 = G__43276;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41672),thinktopic$aljabr$core$iter__41669.call(null,cljs.core.chunk_rest.call(null,s__41670__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41672),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41670__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41669.call(null,cljs.core.rest.call(null,s__41670__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43277 = length__41284__auto__;
var i__41280__auto___43278 = (0);
while(true){
if((i__41280__auto___43278 < n__19308__auto___43277)){
(cloned_ary__41299__auto__[i__41280__auto___43278] = (self__._data[i__41280__auto___43278]));

var G__43279 = (i__41280__auto___43278 + (1));
i__41280__auto___43278 = G__43279;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1float32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1float32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1float32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1float32";

thinktopic.aljabr.core.NDArray1float32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1float32");
});

thinktopic.aljabr.core.__GT_NDArray1float32 = (function thinktopic$aljabr$core$__GT_NDArray1float32(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1float32(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_float32 = (function thinktopic$aljabr$core$make_raw_ndarray1_float32(data__41282__auto__,o__41302__auto__,p__41673,p__41674){
var vec__41677 = p__41673;
var _stride0 = cljs.core.nth.call(null,vec__41677,(0),null);
var vec__41678 = p__41674;
var _shape0 = cljs.core.nth.call(null,vec__41678,(0),null);
return (new thinktopic.aljabr.core.NDArray1float32(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_float32', thinktopic.aljabr.core.make_raw_ndarray1_float32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"float32","float32",-2119815775)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_float32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray1float64 = (function (_data,_offset,_stride0,_shape0){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._shape0 = _shape0;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(1));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null))], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"size","size",1098693007),self__._shape0,new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41686(s__41687){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41687__$1 = s__41687;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41687__$1);
if(temp__4657__auto__){
var s__41687__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41687__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41687__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41689 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41688 = (0);
while(true){
if((i__41688 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41688);
cljs.core.chunk_append.call(null,b__41689,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)));

var G__43280 = (i__41688 + (1));
i__41688 = G__43280;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41689),thinktopic$aljabr$core$iter__41686.call(null,cljs.core.chunk_rest.call(null,s__41687__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41689),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41687__$2);
return cljs.core.cons.call(null,((self__._offset + (self__._stride0 * (a0 | (0)))) | (0)),thinktopic$aljabr$core$iter__41686.call(null,cljs.core.rest.call(null,s__41687__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$step$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41683 = self__._offset;
var vec__41690 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41683 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41683], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41683], null));
var a0 = cljs.core.nth.call(null,vec__41690,(0),null);
var b0 = cljs.core.nth.call(null,vec__41690,(1),null);
var G__41683__$1 = cljs.core.nth.call(null,vec__41690,(2),null);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,G__41683__$1,b0,a0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41682){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41682__$1 = (G__41682 | (0));
var G__41679 = (G__41682__$1 - self__._offset);
var a0 = ((G__41679 / self__._stride0) | (0));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$3 = (function (___41277__auto__,p0,G__41681){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
var G__41679_43281 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41679_43281] = G__41681.call(null,p0,(self__._data[G__41679_43281])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$3 = (function (___41277__auto__,p0,G__41679){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41679);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var G__41679 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0], null);
var G__41680 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,self__._offset,G__41679.call(null,p0__$1),G__41680.call(null,p0__$1)));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
return (self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41683 = self__._offset;
var G__41679 = cljs.core.PersistentVector.EMPTY;
var G__41680 = cljs.core.PersistentVector.EMPTY;
var vec__41691 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41679,G__41680,(G__41683 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41679,self__._shape0),cljs.core.conj.call(null,G__41680,self__._stride0),G__41683], null));
var G__41679__$1 = cljs.core.nth.call(null,vec__41691,(0),null);
var G__41680__$1 = cljs.core.nth.call(null,vec__41691,(1),null);
var G__41683__$1 = cljs.core.nth.call(null,vec__41691,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41679__$1);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41683__$1,G__41680__$1,G__41679__$1);
} else {
return (self__._data[(G__41683__$1 | (0))]);
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41692 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41692,(0),null);
var b0 = cljs.core.nth.call(null,vec__41692,(1),null);
var G__41683 = (self__._offset + b0);
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,G__41683,self__._stride0,a0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$3 = (function (___41277__auto__,p0,G__41681){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41679_43282 = ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
(self__._data[G__41679_43282] = G__41681.call(null,p0,(self__._data[G__41679_43282])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._offset + (self__._stride0 * (p0 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41679){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41679);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$3 = (function (___41277__auto__,p0,G__41679){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(p0 < self__._shape0):null))){
(self__._data[((self__._offset + (self__._stride0 * (p0 | (0)))) | (0))] = G__41679);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$2 = (function (___41277__auto__,p0){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray1float64(self__._data,self__._offset,self__._stride0,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0)));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41679,G__41681){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41679] = G__41681.call(null,G__41679,(self__._data[(G__41679 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._shape0;
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41693(s__41694){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41694__$1 = s__41694;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41694__$1);
if(temp__4657__auto__){
var s__41694__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41694__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41694__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41696 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41695 = (0);
while(true){
if((i__41695 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41695);
cljs.core.chunk_append.call(null,b__41696,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null));

var G__43283 = (i__41695 + (1));
i__41695 = G__43283;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41696),thinktopic$aljabr$core$iter__41693.call(null,cljs.core.chunk_rest.call(null,s__41694__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41696),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41694__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0], null),thinktopic$aljabr$core$iter__41693.call(null,cljs.core.rest.call(null,s__41694__$2)));
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray1float64.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.float64.call(null,self__._shape0);
var vec__41697 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var a0 = cljs.core.nth.call(null,vec__41697,(0),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray1float64(buf__41278__auto__,(0),a0,self__._shape0));
var G__41679_43284 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41680_43285 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41679_43284)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41680_43285) | (0))] = (self__._data[(cljs.core.first.call(null,G__41679_43284) | (0))]));

var G__43286 = cljs.core.next.call(null,G__41679_43284);
var G__43287 = cljs.core.next.call(null,G__41680_43285);
G__41679_43284 = G__43286;
G__41680_43285 = G__43287;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43288 = length__41284__auto__;
var i__41280__auto___43289 = (0);
while(true){
if((i__41280__auto___43289 < n__19308__auto___43288)){
(r__41285__auto__[i__41280__auto___43289] = 0.0);

var G__43290 = (i__41280__auto___43289 + (1));
i__41280__auto___43289 = G__43290;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43291 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43292 = (0);
while(true){
if((i__41280__auto___43292 < n__19308__auto___43291)){
(r__41285__auto__[i__41280__auto___43292] = 0.0);

var G__43293 = (i__41280__auto___43292 + (1));
i__41280__auto___43292 = G__43293;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray1float64.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(1))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41698(s__41699){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41699__$1 = s__41699;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41699__$1);
if(temp__4657__auto__){
var s__41699__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41699__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41699__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41701 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41700 = (0);
while(true){
if((i__41700 < size__19176__auto__)){
var a0 = cljs.core._nth.call(null,c__19175__auto__,i__41700);
cljs.core.chunk_append.call(null,b__41701,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]));

var G__43294 = (i__41700 + (1));
i__41700 = G__43294;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41701),thinktopic$aljabr$core$iter__41698.call(null,cljs.core.chunk_rest.call(null,s__41699__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41701),null);
}
} else {
var a0 = cljs.core.first.call(null,s__41699__$2);
return cljs.core.cons.call(null,(self__._data[((self__._offset + (self__._stride0 * (a0 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41698.call(null,cljs.core.rest.call(null,s__41699__$2)));
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((1) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43295 = length__41284__auto__;
var i__41280__auto___43296 = (0);
while(true){
if((i__41280__auto___43296 < n__19308__auto___43295)){
(cloned_ary__41299__auto__[i__41280__auto___43296] = (self__._data[i__41280__auto___43296]));

var G__43297 = (i__41280__auto___43296 + (1));
i__41280__auto___43296 = G__43297;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0], null));
});

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray1float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray1float64.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null)], null);
});

thinktopic.aljabr.core.NDArray1float64.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray1float64.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray1float64";

thinktopic.aljabr.core.NDArray1float64.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray1float64");
});

thinktopic.aljabr.core.__GT_NDArray1float64 = (function thinktopic$aljabr$core$__GT_NDArray1float64(_data,_offset,_stride0,_shape0){
return (new thinktopic.aljabr.core.NDArray1float64(_data,_offset,_stride0,_shape0));
});


thinktopic.aljabr.core.make_raw_ndarray1_float64 = (function thinktopic$aljabr$core$make_raw_ndarray1_float64(data__41282__auto__,o__41302__auto__,p__41702,p__41703){
var vec__41706 = p__41702;
var _stride0 = cljs.core.nth.call(null,vec__41706,(0),null);
var vec__41707 = p__41703;
var _shape0 = cljs.core.nth.call(null,vec__41707,(0),null);
return (new thinktopic.aljabr.core.NDArray1float64(data__41282__auto__,o__41302__auto__,_stride0,_shape0));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray1_float64', thinktopic.aljabr.core.make_raw_ndarray1_float64);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),new cljs.core.Keyword(null,"float64","float64",1881838306)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray1_float64,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float64], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2generic = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41715(s__41716){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41716__$1 = s__41716;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41716__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41716__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41715_$_iter__41717(s__41718){
return (new cljs.core.LazySeq(null,((function (s__41716__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41718__$1 = s__41718;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41718__$1);
if(temp__4657__auto____$1){
var s__41718__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41718__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41718__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41720 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41719 = (0);
while(true){
if((i__41719 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41719);
cljs.core.chunk_append.call(null,b__41720,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43298 = (i__41719 + (1));
i__41719 = G__43298;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41720),thinktopic$aljabr$core$iter__41715_$_iter__41717.call(null,cljs.core.chunk_rest.call(null,s__41718__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41720),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41718__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41715_$_iter__41717.call(null,cljs.core.rest.call(null,s__41718__$2)));
}
} else {
return null;
}
break;
}
});})(s__41716__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41716__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41715.call(null,cljs.core.rest.call(null,s__41716__$1)));
} else {
var G__43299 = cljs.core.rest.call(null,s__41716__$1);
s__41716__$1 = G__43299;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41712 = self__._offset;
var vec__41721 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41712 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41712], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41712], null));
var a0 = cljs.core.nth.call(null,vec__41721,(0),null);
var b0 = cljs.core.nth.call(null,vec__41721,(1),null);
var G__41712__$1 = cljs.core.nth.call(null,vec__41721,(2),null);
var vec__41722 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41712__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41712__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41712__$1], null));
var a1 = cljs.core.nth.call(null,vec__41722,(0),null);
var b1 = cljs.core.nth.call(null,vec__41722,(1),null);
var G__41712__$2 = cljs.core.nth.call(null,vec__41722,(2),null);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,G__41712__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41711){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41711__$1 = (G__41711 | (0));
var G__41708 = (G__41711__$1 - self__._offset);
var a0 = ((G__41708 / self__._stride0) | (0));
var G__41708__$1 = (G__41708 - (a0 * self__._stride0));
var a1 = ((G__41708__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41710){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41708_43300 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41708_43300] = G__41710.call(null,p0,p1,(self__._data[G__41708_43300])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41708){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41708);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41708 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41709 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,self__._offset,G__41708.call(null,p0__$1),G__41708.call(null,p1__$1),G__41709.call(null,p0__$1),G__41709.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41712 = self__._offset;
var G__41708 = cljs.core.PersistentVector.EMPTY;
var G__41709 = cljs.core.PersistentVector.EMPTY;
var vec__41723 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41708,G__41709,(G__41712 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41708,self__._shape0),cljs.core.conj.call(null,G__41709,self__._stride0),G__41712], null));
var G__41708__$1 = cljs.core.nth.call(null,vec__41723,(0),null);
var G__41709__$1 = cljs.core.nth.call(null,vec__41723,(1),null);
var G__41712__$1 = cljs.core.nth.call(null,vec__41723,(2),null);
var vec__41724 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41708__$1,G__41709__$1,(G__41712__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41708__$1,self__._shape1),cljs.core.conj.call(null,G__41709__$1,self__._stride1),G__41712__$1], null));
var G__41708__$2 = cljs.core.nth.call(null,vec__41724,(0),null);
var G__41709__$2 = cljs.core.nth.call(null,vec__41724,(1),null);
var G__41712__$2 = cljs.core.nth.call(null,vec__41724,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41708__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41712__$2,G__41709__$2,G__41708__$2);
} else {
return (self__._data[(G__41712__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41725 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41725,(0),null);
var b0 = cljs.core.nth.call(null,vec__41725,(1),null);
var vec__41726 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41726,(0),null);
var b1 = cljs.core.nth.call(null,vec__41726,(1),null);
var G__41712 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,G__41712,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41710){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41708_43301 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41708_43301] = G__41710.call(null,p0,p1,(self__._data[G__41708_43301])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41708){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41708);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41708){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41708);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2generic(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41708,G__41710){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41708] = G__41710.call(null,G__41708,(self__._data[(G__41708 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41727(s__41728){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41728__$1 = s__41728;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41728__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41728__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41727_$_iter__41729(s__41730){
return (new cljs.core.LazySeq(null,((function (s__41728__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41730__$1 = s__41730;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41730__$1);
if(temp__4657__auto____$1){
var s__41730__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41730__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41730__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41732 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41731 = (0);
while(true){
if((i__41731 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41731);
cljs.core.chunk_append.call(null,b__41732,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43302 = (i__41731 + (1));
i__41731 = G__43302;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41732),thinktopic$aljabr$core$iter__41727_$_iter__41729.call(null,cljs.core.chunk_rest.call(null,s__41730__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41732),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41730__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41727_$_iter__41729.call(null,cljs.core.rest.call(null,s__41730__$2)));
}
} else {
return null;
}
break;
}
});})(s__41728__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41728__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41727.call(null,cljs.core.rest.call(null,s__41728__$1)));
} else {
var G__43303 = cljs.core.rest.call(null,s__41728__$1);
s__41728__$1 = G__43303;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = cljs.core.to_array.call(null,(self__._shape0 * self__._shape1));
var vec__41733 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41733,(0),null);
var a1 = cljs.core.nth.call(null,vec__41733,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2generic(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41708_43304 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41709_43305 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41708_43304)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41709_43305) | (0))] = (self__._data[(cljs.core.first.call(null,G__41708_43304) | (0))]));

var G__43306 = cljs.core.next.call(null,G__41708_43304);
var G__43307 = cljs.core.next.call(null,G__41709_43305);
G__41708_43304 = G__43306;
G__41709_43305 = G__43307;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43308 = length__41284__auto__;
var i__41280__auto___43309 = (0);
while(true){
if((i__41280__auto___43309 < n__19308__auto___43308)){
(r__41285__auto__[i__41280__auto___43309] = 0.0);

var G__43310 = (i__41280__auto___43309 + (1));
i__41280__auto___43309 = G__43310;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43311 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43312 = (0);
while(true){
if((i__41280__auto___43312 < n__19308__auto___43311)){
(r__41285__auto__[i__41280__auto___43312] = 0.0);

var G__43313 = (i__41280__auto___43312 + (1));
i__41280__auto___43312 = G__43313;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41734(s__41735){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41735__$1 = s__41735;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41735__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41735__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41734_$_iter__41736(s__41737){
return (new cljs.core.LazySeq(null,((function (s__41735__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41737__$1 = s__41737;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41737__$1);
if(temp__4657__auto____$1){
var s__41737__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41737__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41737__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41739 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41738 = (0);
while(true){
if((i__41738 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41738);
cljs.core.chunk_append.call(null,b__41739,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43314 = (i__41738 + (1));
i__41738 = G__43314;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41739),thinktopic$aljabr$core$iter__41734_$_iter__41736.call(null,cljs.core.chunk_rest.call(null,s__41737__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41739),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41737__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41734_$_iter__41736.call(null,cljs.core.rest.call(null,s__41737__$2)));
}
} else {
return null;
}
break;
}
});})(s__41735__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41735__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41734.call(null,cljs.core.rest.call(null,s__41735__$1)));
} else {
var G__43315 = cljs.core.rest.call(null,s__41735__$1);
s__41735__$1 = G__43315;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43316 = length__41284__auto__;
var i__41280__auto___43317 = (0);
while(true){
if((i__41280__auto___43317 < n__19308__auto___43316)){
(cloned_ary__41299__auto__[i__41280__auto___43317] = (self__._data[i__41280__auto___43317]));

var G__43318 = (i__41280__auto___43317 + (1));
i__41280__auto___43317 = G__43318;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2generic";

thinktopic.aljabr.core.NDArray2generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2generic");
});

thinktopic.aljabr.core.__GT_NDArray2generic = (function thinktopic$aljabr$core$__GT_NDArray2generic(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2generic(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_generic = (function thinktopic$aljabr$core$make_raw_ndarray2_generic(data__41282__auto__,o__41302__auto__,p__41740,p__41741){
var vec__41744 = p__41740;
var _stride0 = cljs.core.nth.call(null,vec__41744,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41744,(1),null);
var vec__41745 = p__41741;
var _shape0 = cljs.core.nth.call(null,vec__41745,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41745,(1),null);
return (new thinktopic.aljabr.core.NDArray2generic(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_generic', thinktopic.aljabr.core.make_raw_ndarray2_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint8 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41753(s__41754){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41754__$1 = s__41754;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41754__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41754__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41753_$_iter__41755(s__41756){
return (new cljs.core.LazySeq(null,((function (s__41754__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41756__$1 = s__41756;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41756__$1);
if(temp__4657__auto____$1){
var s__41756__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41756__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41756__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41758 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41757 = (0);
while(true){
if((i__41757 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41757);
cljs.core.chunk_append.call(null,b__41758,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43319 = (i__41757 + (1));
i__41757 = G__43319;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41758),thinktopic$aljabr$core$iter__41753_$_iter__41755.call(null,cljs.core.chunk_rest.call(null,s__41756__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41758),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41756__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41753_$_iter__41755.call(null,cljs.core.rest.call(null,s__41756__$2)));
}
} else {
return null;
}
break;
}
});})(s__41754__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41754__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41753.call(null,cljs.core.rest.call(null,s__41754__$1)));
} else {
var G__43320 = cljs.core.rest.call(null,s__41754__$1);
s__41754__$1 = G__43320;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41750 = self__._offset;
var vec__41759 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41750 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41750], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41750], null));
var a0 = cljs.core.nth.call(null,vec__41759,(0),null);
var b0 = cljs.core.nth.call(null,vec__41759,(1),null);
var G__41750__$1 = cljs.core.nth.call(null,vec__41759,(2),null);
var vec__41760 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41750__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41750__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41750__$1], null));
var a1 = cljs.core.nth.call(null,vec__41760,(0),null);
var b1 = cljs.core.nth.call(null,vec__41760,(1),null);
var G__41750__$2 = cljs.core.nth.call(null,vec__41760,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,G__41750__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41749){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41749__$1 = (G__41749 | (0));
var G__41746 = (G__41749__$1 - self__._offset);
var a0 = ((G__41746 / self__._stride0) | (0));
var G__41746__$1 = (G__41746 - (a0 * self__._stride0));
var a1 = ((G__41746__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41748){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41746_43321 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41746_43321] = G__41748.call(null,p0,p1,(self__._data[G__41746_43321])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41746){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41746);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41746 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41747 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,self__._offset,G__41746.call(null,p0__$1),G__41746.call(null,p1__$1),G__41747.call(null,p0__$1),G__41747.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41750 = self__._offset;
var G__41746 = cljs.core.PersistentVector.EMPTY;
var G__41747 = cljs.core.PersistentVector.EMPTY;
var vec__41761 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41746,G__41747,(G__41750 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41746,self__._shape0),cljs.core.conj.call(null,G__41747,self__._stride0),G__41750], null));
var G__41746__$1 = cljs.core.nth.call(null,vec__41761,(0),null);
var G__41747__$1 = cljs.core.nth.call(null,vec__41761,(1),null);
var G__41750__$1 = cljs.core.nth.call(null,vec__41761,(2),null);
var vec__41762 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41746__$1,G__41747__$1,(G__41750__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41746__$1,self__._shape1),cljs.core.conj.call(null,G__41747__$1,self__._stride1),G__41750__$1], null));
var G__41746__$2 = cljs.core.nth.call(null,vec__41762,(0),null);
var G__41747__$2 = cljs.core.nth.call(null,vec__41762,(1),null);
var G__41750__$2 = cljs.core.nth.call(null,vec__41762,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41746__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41750__$2,G__41747__$2,G__41746__$2);
} else {
return (self__._data[(G__41750__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41763 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41763,(0),null);
var b0 = cljs.core.nth.call(null,vec__41763,(1),null);
var vec__41764 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41764,(0),null);
var b1 = cljs.core.nth.call(null,vec__41764,(1),null);
var G__41750 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,G__41750,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41748){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41746_43322 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41746_43322] = G__41748.call(null,p0,p1,(self__._data[G__41746_43322])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41746){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41746);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41746){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41746);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint8(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41746,G__41748){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41746] = G__41748.call(null,G__41746,(self__._data[(G__41746 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41765(s__41766){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41766__$1 = s__41766;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41766__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41766__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41765_$_iter__41767(s__41768){
return (new cljs.core.LazySeq(null,((function (s__41766__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41768__$1 = s__41768;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41768__$1);
if(temp__4657__auto____$1){
var s__41768__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41768__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41768__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41770 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41769 = (0);
while(true){
if((i__41769 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41769);
cljs.core.chunk_append.call(null,b__41770,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43323 = (i__41769 + (1));
i__41769 = G__43323;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41770),thinktopic$aljabr$core$iter__41765_$_iter__41767.call(null,cljs.core.chunk_rest.call(null,s__41768__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41770),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41768__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41765_$_iter__41767.call(null,cljs.core.rest.call(null,s__41768__$2)));
}
} else {
return null;
}
break;
}
});})(s__41766__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41766__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41765.call(null,cljs.core.rest.call(null,s__41766__$1)));
} else {
var G__43324 = cljs.core.rest.call(null,s__41766__$1);
s__41766__$1 = G__43324;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint8.call(null,(self__._shape0 * self__._shape1));
var vec__41771 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41771,(0),null);
var a1 = cljs.core.nth.call(null,vec__41771,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2uint8(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41746_43325 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41747_43326 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41746_43325)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41747_43326) | (0))] = (self__._data[(cljs.core.first.call(null,G__41746_43325) | (0))]));

var G__43327 = cljs.core.next.call(null,G__41746_43325);
var G__43328 = cljs.core.next.call(null,G__41747_43326);
G__41746_43325 = G__43327;
G__41747_43326 = G__43328;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43329 = length__41284__auto__;
var i__41280__auto___43330 = (0);
while(true){
if((i__41280__auto___43330 < n__19308__auto___43329)){
(r__41285__auto__[i__41280__auto___43330] = 0.0);

var G__43331 = (i__41280__auto___43330 + (1));
i__41280__auto___43330 = G__43331;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43332 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43333 = (0);
while(true){
if((i__41280__auto___43333 < n__19308__auto___43332)){
(r__41285__auto__[i__41280__auto___43333] = 0.0);

var G__43334 = (i__41280__auto___43333 + (1));
i__41280__auto___43333 = G__43334;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41772(s__41773){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41773__$1 = s__41773;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41773__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41773__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41772_$_iter__41774(s__41775){
return (new cljs.core.LazySeq(null,((function (s__41773__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41775__$1 = s__41775;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41775__$1);
if(temp__4657__auto____$1){
var s__41775__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41775__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41775__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41777 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41776 = (0);
while(true){
if((i__41776 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41776);
cljs.core.chunk_append.call(null,b__41777,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43335 = (i__41776 + (1));
i__41776 = G__43335;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41777),thinktopic$aljabr$core$iter__41772_$_iter__41774.call(null,cljs.core.chunk_rest.call(null,s__41775__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41777),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41775__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41772_$_iter__41774.call(null,cljs.core.rest.call(null,s__41775__$2)));
}
} else {
return null;
}
break;
}
});})(s__41773__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41773__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41772.call(null,cljs.core.rest.call(null,s__41773__$1)));
} else {
var G__43336 = cljs.core.rest.call(null,s__41773__$1);
s__41773__$1 = G__43336;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43337 = length__41284__auto__;
var i__41280__auto___43338 = (0);
while(true){
if((i__41280__auto___43338 < n__19308__auto___43337)){
(cloned_ary__41299__auto__[i__41280__auto___43338] = (self__._data[i__41280__auto___43338]));

var G__43339 = (i__41280__auto___43338 + (1));
i__41280__auto___43338 = G__43339;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint8";

thinktopic.aljabr.core.NDArray2uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint8");
});

thinktopic.aljabr.core.__GT_NDArray2uint8 = (function thinktopic$aljabr$core$__GT_NDArray2uint8(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint8(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint8(data__41282__auto__,o__41302__auto__,p__41778,p__41779){
var vec__41782 = p__41778;
var _stride0 = cljs.core.nth.call(null,vec__41782,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41782,(1),null);
var vec__41783 = p__41779;
var _shape0 = cljs.core.nth.call(null,vec__41783,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41783,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint8(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint8', thinktopic.aljabr.core.make_raw_ndarray2_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint8_clamped = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41791(s__41792){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41792__$1 = s__41792;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41792__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41792__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41791_$_iter__41793(s__41794){
return (new cljs.core.LazySeq(null,((function (s__41792__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41794__$1 = s__41794;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41794__$1);
if(temp__4657__auto____$1){
var s__41794__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41794__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41794__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41796 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41795 = (0);
while(true){
if((i__41795 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41795);
cljs.core.chunk_append.call(null,b__41796,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43340 = (i__41795 + (1));
i__41795 = G__43340;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41796),thinktopic$aljabr$core$iter__41791_$_iter__41793.call(null,cljs.core.chunk_rest.call(null,s__41794__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41796),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41794__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41791_$_iter__41793.call(null,cljs.core.rest.call(null,s__41794__$2)));
}
} else {
return null;
}
break;
}
});})(s__41792__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41792__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41791.call(null,cljs.core.rest.call(null,s__41792__$1)));
} else {
var G__43341 = cljs.core.rest.call(null,s__41792__$1);
s__41792__$1 = G__43341;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41788 = self__._offset;
var vec__41797 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41788 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41788], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41788], null));
var a0 = cljs.core.nth.call(null,vec__41797,(0),null);
var b0 = cljs.core.nth.call(null,vec__41797,(1),null);
var G__41788__$1 = cljs.core.nth.call(null,vec__41797,(2),null);
var vec__41798 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41788__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41788__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41788__$1], null));
var a1 = cljs.core.nth.call(null,vec__41798,(0),null);
var b1 = cljs.core.nth.call(null,vec__41798,(1),null);
var G__41788__$2 = cljs.core.nth.call(null,vec__41798,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,G__41788__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41787){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41787__$1 = (G__41787 | (0));
var G__41784 = (G__41787__$1 - self__._offset);
var a0 = ((G__41784 / self__._stride0) | (0));
var G__41784__$1 = (G__41784 - (a0 * self__._stride0));
var a1 = ((G__41784__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41786){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41784_43342 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41784_43342] = G__41786.call(null,p0,p1,(self__._data[G__41784_43342])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41784){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41784);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41784 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41785 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,self__._offset,G__41784.call(null,p0__$1),G__41784.call(null,p1__$1),G__41785.call(null,p0__$1),G__41785.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41788 = self__._offset;
var G__41784 = cljs.core.PersistentVector.EMPTY;
var G__41785 = cljs.core.PersistentVector.EMPTY;
var vec__41799 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41784,G__41785,(G__41788 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41784,self__._shape0),cljs.core.conj.call(null,G__41785,self__._stride0),G__41788], null));
var G__41784__$1 = cljs.core.nth.call(null,vec__41799,(0),null);
var G__41785__$1 = cljs.core.nth.call(null,vec__41799,(1),null);
var G__41788__$1 = cljs.core.nth.call(null,vec__41799,(2),null);
var vec__41800 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41784__$1,G__41785__$1,(G__41788__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41784__$1,self__._shape1),cljs.core.conj.call(null,G__41785__$1,self__._stride1),G__41788__$1], null));
var G__41784__$2 = cljs.core.nth.call(null,vec__41800,(0),null);
var G__41785__$2 = cljs.core.nth.call(null,vec__41800,(1),null);
var G__41788__$2 = cljs.core.nth.call(null,vec__41800,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41784__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41788__$2,G__41785__$2,G__41784__$2);
} else {
return (self__._data[(G__41788__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41801 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41801,(0),null);
var b0 = cljs.core.nth.call(null,vec__41801,(1),null);
var vec__41802 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41802,(0),null);
var b1 = cljs.core.nth.call(null,vec__41802,(1),null);
var G__41788 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,G__41788,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41786){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41784_43343 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41784_43343] = G__41786.call(null,p0,p1,(self__._data[G__41784_43343])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41784){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41784);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41784){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41784);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41784,G__41786){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41784] = G__41786.call(null,G__41784,(self__._data[(G__41784 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41803(s__41804){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41804__$1 = s__41804;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41804__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41804__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41803_$_iter__41805(s__41806){
return (new cljs.core.LazySeq(null,((function (s__41804__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41806__$1 = s__41806;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41806__$1);
if(temp__4657__auto____$1){
var s__41806__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41806__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41806__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41808 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41807 = (0);
while(true){
if((i__41807 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41807);
cljs.core.chunk_append.call(null,b__41808,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43344 = (i__41807 + (1));
i__41807 = G__43344;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41808),thinktopic$aljabr$core$iter__41803_$_iter__41805.call(null,cljs.core.chunk_rest.call(null,s__41806__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41808),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41806__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41803_$_iter__41805.call(null,cljs.core.rest.call(null,s__41806__$2)));
}
} else {
return null;
}
break;
}
});})(s__41804__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41804__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41803.call(null,cljs.core.rest.call(null,s__41804__$1)));
} else {
var G__43345 = cljs.core.rest.call(null,s__41804__$1);
s__41804__$1 = G__43345;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint8_clamped.call(null,(self__._shape0 * self__._shape1));
var vec__41809 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41809,(0),null);
var a1 = cljs.core.nth.call(null,vec__41809,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2uint8_clamped(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41784_43346 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41785_43347 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41784_43346)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41785_43347) | (0))] = (self__._data[(cljs.core.first.call(null,G__41784_43346) | (0))]));

var G__43348 = cljs.core.next.call(null,G__41784_43346);
var G__43349 = cljs.core.next.call(null,G__41785_43347);
G__41784_43346 = G__43348;
G__41785_43347 = G__43349;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43350 = length__41284__auto__;
var i__41280__auto___43351 = (0);
while(true){
if((i__41280__auto___43351 < n__19308__auto___43350)){
(r__41285__auto__[i__41280__auto___43351] = 0.0);

var G__43352 = (i__41280__auto___43351 + (1));
i__41280__auto___43351 = G__43352;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43353 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43354 = (0);
while(true){
if((i__41280__auto___43354 < n__19308__auto___43353)){
(r__41285__auto__[i__41280__auto___43354] = 0.0);

var G__43355 = (i__41280__auto___43354 + (1));
i__41280__auto___43354 = G__43355;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),thi.ng.typedarrays.core.uint8_clamped.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41810(s__41811){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41811__$1 = s__41811;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41811__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41811__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41810_$_iter__41812(s__41813){
return (new cljs.core.LazySeq(null,((function (s__41811__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41813__$1 = s__41813;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41813__$1);
if(temp__4657__auto____$1){
var s__41813__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41813__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41813__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41815 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41814 = (0);
while(true){
if((i__41814 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41814);
cljs.core.chunk_append.call(null,b__41815,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43356 = (i__41814 + (1));
i__41814 = G__43356;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41815),thinktopic$aljabr$core$iter__41810_$_iter__41812.call(null,cljs.core.chunk_rest.call(null,s__41813__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41815),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41813__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41810_$_iter__41812.call(null,cljs.core.rest.call(null,s__41813__$2)));
}
} else {
return null;
}
break;
}
});})(s__41811__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41811__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41810.call(null,cljs.core.rest.call(null,s__41811__$1)));
} else {
var G__43357 = cljs.core.rest.call(null,s__41811__$1);
s__41811__$1 = G__43357;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43358 = length__41284__auto__;
var i__41280__auto___43359 = (0);
while(true){
if((i__41280__auto___43359 < n__19308__auto___43358)){
(cloned_ary__41299__auto__[i__41280__auto___43359] = (self__._data[i__41280__auto___43359]));

var G__43360 = (i__41280__auto___43359 + (1));
i__41280__auto___43359 = G__43360;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint8-clamped";

thinktopic.aljabr.core.NDArray2uint8_clamped.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint8-clamped");
});

thinktopic.aljabr.core.__GT_NDArray2uint8_clamped = (function thinktopic$aljabr$core$__GT_NDArray2uint8_clamped(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped = (function thinktopic$aljabr$core$make_raw_ndarray2_uint8_clamped(data__41282__auto__,o__41302__auto__,p__41816,p__41817){
var vec__41820 = p__41816;
var _stride0 = cljs.core.nth.call(null,vec__41820,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41820,(1),null);
var vec__41821 = p__41817;
var _shape0 = cljs.core.nth.call(null,vec__41821,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41821,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint8_clamped(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped', thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint8_clamped,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8_clamped], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint16 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41829(s__41830){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41830__$1 = s__41830;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41830__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41830__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41829_$_iter__41831(s__41832){
return (new cljs.core.LazySeq(null,((function (s__41830__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41832__$1 = s__41832;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41832__$1);
if(temp__4657__auto____$1){
var s__41832__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41832__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41832__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41834 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41833 = (0);
while(true){
if((i__41833 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41833);
cljs.core.chunk_append.call(null,b__41834,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43361 = (i__41833 + (1));
i__41833 = G__43361;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41834),thinktopic$aljabr$core$iter__41829_$_iter__41831.call(null,cljs.core.chunk_rest.call(null,s__41832__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41834),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41832__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41829_$_iter__41831.call(null,cljs.core.rest.call(null,s__41832__$2)));
}
} else {
return null;
}
break;
}
});})(s__41830__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41830__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41829.call(null,cljs.core.rest.call(null,s__41830__$1)));
} else {
var G__43362 = cljs.core.rest.call(null,s__41830__$1);
s__41830__$1 = G__43362;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41826 = self__._offset;
var vec__41835 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41826 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41826], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41826], null));
var a0 = cljs.core.nth.call(null,vec__41835,(0),null);
var b0 = cljs.core.nth.call(null,vec__41835,(1),null);
var G__41826__$1 = cljs.core.nth.call(null,vec__41835,(2),null);
var vec__41836 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41826__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41826__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41826__$1], null));
var a1 = cljs.core.nth.call(null,vec__41836,(0),null);
var b1 = cljs.core.nth.call(null,vec__41836,(1),null);
var G__41826__$2 = cljs.core.nth.call(null,vec__41836,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,G__41826__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41825){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41825__$1 = (G__41825 | (0));
var G__41822 = (G__41825__$1 - self__._offset);
var a0 = ((G__41822 / self__._stride0) | (0));
var G__41822__$1 = (G__41822 - (a0 * self__._stride0));
var a1 = ((G__41822__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41824){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41822_43363 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41822_43363] = G__41824.call(null,p0,p1,(self__._data[G__41822_43363])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint16","uint16",-588869202);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41822){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41822);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41822 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41823 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,self__._offset,G__41822.call(null,p0__$1),G__41822.call(null,p1__$1),G__41823.call(null,p0__$1),G__41823.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41826 = self__._offset;
var G__41822 = cljs.core.PersistentVector.EMPTY;
var G__41823 = cljs.core.PersistentVector.EMPTY;
var vec__41837 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41822,G__41823,(G__41826 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41822,self__._shape0),cljs.core.conj.call(null,G__41823,self__._stride0),G__41826], null));
var G__41822__$1 = cljs.core.nth.call(null,vec__41837,(0),null);
var G__41823__$1 = cljs.core.nth.call(null,vec__41837,(1),null);
var G__41826__$1 = cljs.core.nth.call(null,vec__41837,(2),null);
var vec__41838 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41822__$1,G__41823__$1,(G__41826__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41822__$1,self__._shape1),cljs.core.conj.call(null,G__41823__$1,self__._stride1),G__41826__$1], null));
var G__41822__$2 = cljs.core.nth.call(null,vec__41838,(0),null);
var G__41823__$2 = cljs.core.nth.call(null,vec__41838,(1),null);
var G__41826__$2 = cljs.core.nth.call(null,vec__41838,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41822__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41826__$2,G__41823__$2,G__41822__$2);
} else {
return (self__._data[(G__41826__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41839 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41839,(0),null);
var b0 = cljs.core.nth.call(null,vec__41839,(1),null);
var vec__41840 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41840,(0),null);
var b1 = cljs.core.nth.call(null,vec__41840,(1),null);
var G__41826 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,G__41826,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41824){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41822_43364 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41822_43364] = G__41824.call(null,p0,p1,(self__._data[G__41822_43364])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41822){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41822);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41822){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41822);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint16(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41822,G__41824){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41822] = G__41824.call(null,G__41822,(self__._data[(G__41822 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41841(s__41842){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41842__$1 = s__41842;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41842__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41842__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41841_$_iter__41843(s__41844){
return (new cljs.core.LazySeq(null,((function (s__41842__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41844__$1 = s__41844;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41844__$1);
if(temp__4657__auto____$1){
var s__41844__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41844__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41844__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41846 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41845 = (0);
while(true){
if((i__41845 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41845);
cljs.core.chunk_append.call(null,b__41846,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43365 = (i__41845 + (1));
i__41845 = G__43365;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41846),thinktopic$aljabr$core$iter__41841_$_iter__41843.call(null,cljs.core.chunk_rest.call(null,s__41844__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41846),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41844__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41841_$_iter__41843.call(null,cljs.core.rest.call(null,s__41844__$2)));
}
} else {
return null;
}
break;
}
});})(s__41842__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41842__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41841.call(null,cljs.core.rest.call(null,s__41842__$1)));
} else {
var G__43366 = cljs.core.rest.call(null,s__41842__$1);
s__41842__$1 = G__43366;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint16.call(null,(self__._shape0 * self__._shape1));
var vec__41847 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41847,(0),null);
var a1 = cljs.core.nth.call(null,vec__41847,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2uint16(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41822_43367 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41823_43368 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41822_43367)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41823_43368) | (0))] = (self__._data[(cljs.core.first.call(null,G__41822_43367) | (0))]));

var G__43369 = cljs.core.next.call(null,G__41822_43367);
var G__43370 = cljs.core.next.call(null,G__41823_43368);
G__41822_43367 = G__43369;
G__41823_43368 = G__43370;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43371 = length__41284__auto__;
var i__41280__auto___43372 = (0);
while(true){
if((i__41280__auto___43372 < n__19308__auto___43371)){
(r__41285__auto__[i__41280__auto___43372] = 0.0);

var G__43373 = (i__41280__auto___43372 + (1));
i__41280__auto___43372 = G__43373;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43374 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43375 = (0);
while(true){
if((i__41280__auto___43375 < n__19308__auto___43374)){
(r__41285__auto__[i__41280__auto___43375] = 0.0);

var G__43376 = (i__41280__auto___43375 + (1));
i__41280__auto___43375 = G__43376;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),thi.ng.typedarrays.core.uint16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41848(s__41849){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41849__$1 = s__41849;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41849__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41849__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41848_$_iter__41850(s__41851){
return (new cljs.core.LazySeq(null,((function (s__41849__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41851__$1 = s__41851;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41851__$1);
if(temp__4657__auto____$1){
var s__41851__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41851__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41851__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41853 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41852 = (0);
while(true){
if((i__41852 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41852);
cljs.core.chunk_append.call(null,b__41853,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43377 = (i__41852 + (1));
i__41852 = G__43377;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41853),thinktopic$aljabr$core$iter__41848_$_iter__41850.call(null,cljs.core.chunk_rest.call(null,s__41851__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41853),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41851__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41848_$_iter__41850.call(null,cljs.core.rest.call(null,s__41851__$2)));
}
} else {
return null;
}
break;
}
});})(s__41849__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41849__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41848.call(null,cljs.core.rest.call(null,s__41849__$1)));
} else {
var G__43378 = cljs.core.rest.call(null,s__41849__$1);
s__41849__$1 = G__43378;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43379 = length__41284__auto__;
var i__41280__auto___43380 = (0);
while(true){
if((i__41280__auto___43380 < n__19308__auto___43379)){
(cloned_ary__41299__auto__[i__41280__auto___43380] = (self__._data[i__41280__auto___43380]));

var G__43381 = (i__41280__auto___43380 + (1));
i__41280__auto___43380 = G__43381;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint16","uint16",-588869202),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint16";

thinktopic.aljabr.core.NDArray2uint16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint16");
});

thinktopic.aljabr.core.__GT_NDArray2uint16 = (function thinktopic$aljabr$core$__GT_NDArray2uint16(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint16(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint16 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint16(data__41282__auto__,o__41302__auto__,p__41854,p__41855){
var vec__41858 = p__41854;
var _stride0 = cljs.core.nth.call(null,vec__41858,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41858,(1),null);
var vec__41859 = p__41855;
var _shape0 = cljs.core.nth.call(null,vec__41859,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41859,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint16(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint16', thinktopic.aljabr.core.make_raw_ndarray2_uint16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint16","uint16",-588869202)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2uint32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41867(s__41868){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41868__$1 = s__41868;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41868__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41868__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41867_$_iter__41869(s__41870){
return (new cljs.core.LazySeq(null,((function (s__41868__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41870__$1 = s__41870;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41870__$1);
if(temp__4657__auto____$1){
var s__41870__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41870__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41870__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41872 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41871 = (0);
while(true){
if((i__41871 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41871);
cljs.core.chunk_append.call(null,b__41872,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43382 = (i__41871 + (1));
i__41871 = G__43382;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41872),thinktopic$aljabr$core$iter__41867_$_iter__41869.call(null,cljs.core.chunk_rest.call(null,s__41870__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41872),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41870__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41867_$_iter__41869.call(null,cljs.core.rest.call(null,s__41870__$2)));
}
} else {
return null;
}
break;
}
});})(s__41868__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41868__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41867.call(null,cljs.core.rest.call(null,s__41868__$1)));
} else {
var G__43383 = cljs.core.rest.call(null,s__41868__$1);
s__41868__$1 = G__43383;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41864 = self__._offset;
var vec__41873 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41864 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41864], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41864], null));
var a0 = cljs.core.nth.call(null,vec__41873,(0),null);
var b0 = cljs.core.nth.call(null,vec__41873,(1),null);
var G__41864__$1 = cljs.core.nth.call(null,vec__41873,(2),null);
var vec__41874 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41864__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41864__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41864__$1], null));
var a1 = cljs.core.nth.call(null,vec__41874,(0),null);
var b1 = cljs.core.nth.call(null,vec__41874,(1),null);
var G__41864__$2 = cljs.core.nth.call(null,vec__41874,(2),null);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,G__41864__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41863){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41863__$1 = (G__41863 | (0));
var G__41860 = (G__41863__$1 - self__._offset);
var a0 = ((G__41860 / self__._stride0) | (0));
var G__41860__$1 = (G__41860 - (a0 * self__._stride0));
var a1 = ((G__41860__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41862){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41860_43384 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41860_43384] = G__41862.call(null,p0,p1,(self__._data[G__41860_43384])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint32","uint32",-418789486);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41860){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41860);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41860 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41861 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,self__._offset,G__41860.call(null,p0__$1),G__41860.call(null,p1__$1),G__41861.call(null,p0__$1),G__41861.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41864 = self__._offset;
var G__41860 = cljs.core.PersistentVector.EMPTY;
var G__41861 = cljs.core.PersistentVector.EMPTY;
var vec__41875 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41860,G__41861,(G__41864 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41860,self__._shape0),cljs.core.conj.call(null,G__41861,self__._stride0),G__41864], null));
var G__41860__$1 = cljs.core.nth.call(null,vec__41875,(0),null);
var G__41861__$1 = cljs.core.nth.call(null,vec__41875,(1),null);
var G__41864__$1 = cljs.core.nth.call(null,vec__41875,(2),null);
var vec__41876 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41860__$1,G__41861__$1,(G__41864__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41860__$1,self__._shape1),cljs.core.conj.call(null,G__41861__$1,self__._stride1),G__41864__$1], null));
var G__41860__$2 = cljs.core.nth.call(null,vec__41876,(0),null);
var G__41861__$2 = cljs.core.nth.call(null,vec__41876,(1),null);
var G__41864__$2 = cljs.core.nth.call(null,vec__41876,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41860__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41864__$2,G__41861__$2,G__41860__$2);
} else {
return (self__._data[(G__41864__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41877 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41877,(0),null);
var b0 = cljs.core.nth.call(null,vec__41877,(1),null);
var vec__41878 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41878,(0),null);
var b1 = cljs.core.nth.call(null,vec__41878,(1),null);
var G__41864 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,G__41864,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41862){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41860_43385 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41860_43385] = G__41862.call(null,p0,p1,(self__._data[G__41860_43385])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41860){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41860);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41860){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41860);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2uint32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41860,G__41862){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41860] = G__41862.call(null,G__41860,(self__._data[(G__41860 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41879(s__41880){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41880__$1 = s__41880;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41880__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41880__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41879_$_iter__41881(s__41882){
return (new cljs.core.LazySeq(null,((function (s__41880__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41882__$1 = s__41882;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41882__$1);
if(temp__4657__auto____$1){
var s__41882__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41882__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41882__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41884 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41883 = (0);
while(true){
if((i__41883 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41883);
cljs.core.chunk_append.call(null,b__41884,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43386 = (i__41883 + (1));
i__41883 = G__43386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41884),thinktopic$aljabr$core$iter__41879_$_iter__41881.call(null,cljs.core.chunk_rest.call(null,s__41882__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41884),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41882__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41879_$_iter__41881.call(null,cljs.core.rest.call(null,s__41882__$2)));
}
} else {
return null;
}
break;
}
});})(s__41880__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41880__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41879.call(null,cljs.core.rest.call(null,s__41880__$1)));
} else {
var G__43387 = cljs.core.rest.call(null,s__41880__$1);
s__41880__$1 = G__43387;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint32.call(null,(self__._shape0 * self__._shape1));
var vec__41885 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41885,(0),null);
var a1 = cljs.core.nth.call(null,vec__41885,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2uint32(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41860_43388 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41861_43389 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41860_43388)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41861_43389) | (0))] = (self__._data[(cljs.core.first.call(null,G__41860_43388) | (0))]));

var G__43390 = cljs.core.next.call(null,G__41860_43388);
var G__43391 = cljs.core.next.call(null,G__41861_43389);
G__41860_43388 = G__43390;
G__41861_43389 = G__43391;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43392 = length__41284__auto__;
var i__41280__auto___43393 = (0);
while(true){
if((i__41280__auto___43393 < n__19308__auto___43392)){
(r__41285__auto__[i__41280__auto___43393] = 0.0);

var G__43394 = (i__41280__auto___43393 + (1));
i__41280__auto___43393 = G__43394;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43395 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43396 = (0);
while(true){
if((i__41280__auto___43396 < n__19308__auto___43395)){
(r__41285__auto__[i__41280__auto___43396] = 0.0);

var G__43397 = (i__41280__auto___43396 + (1));
i__41280__auto___43396 = G__43397;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),thi.ng.typedarrays.core.uint32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41886(s__41887){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41887__$1 = s__41887;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41887__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41887__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41886_$_iter__41888(s__41889){
return (new cljs.core.LazySeq(null,((function (s__41887__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41889__$1 = s__41889;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41889__$1);
if(temp__4657__auto____$1){
var s__41889__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41889__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41889__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41891 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41890 = (0);
while(true){
if((i__41890 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41890);
cljs.core.chunk_append.call(null,b__41891,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43398 = (i__41890 + (1));
i__41890 = G__43398;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41891),thinktopic$aljabr$core$iter__41886_$_iter__41888.call(null,cljs.core.chunk_rest.call(null,s__41889__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41891),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41889__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41886_$_iter__41888.call(null,cljs.core.rest.call(null,s__41889__$2)));
}
} else {
return null;
}
break;
}
});})(s__41887__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41887__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41886.call(null,cljs.core.rest.call(null,s__41887__$1)));
} else {
var G__43399 = cljs.core.rest.call(null,s__41887__$1);
s__41887__$1 = G__43399;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43400 = length__41284__auto__;
var i__41280__auto___43401 = (0);
while(true){
if((i__41280__auto___43401 < n__19308__auto___43400)){
(cloned_ary__41299__auto__[i__41280__auto___43401] = (self__._data[i__41280__auto___43401]));

var G__43402 = (i__41280__auto___43401 + (1));
i__41280__auto___43401 = G__43402;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint32","uint32",-418789486),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2uint32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2uint32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2uint32";

thinktopic.aljabr.core.NDArray2uint32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2uint32");
});

thinktopic.aljabr.core.__GT_NDArray2uint32 = (function thinktopic$aljabr$core$__GT_NDArray2uint32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2uint32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_uint32 = (function thinktopic$aljabr$core$make_raw_ndarray2_uint32(data__41282__auto__,o__41302__auto__,p__41892,p__41893){
var vec__41896 = p__41892;
var _stride0 = cljs.core.nth.call(null,vec__41896,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41896,(1),null);
var vec__41897 = p__41893;
var _shape0 = cljs.core.nth.call(null,vec__41897,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41897,(1),null);
return (new thinktopic.aljabr.core.NDArray2uint32(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_uint32', thinktopic.aljabr.core.make_raw_ndarray2_uint32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"uint32","uint32",-418789486)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_uint32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int8 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41905(s__41906){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41906__$1 = s__41906;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41906__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41906__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41905_$_iter__41907(s__41908){
return (new cljs.core.LazySeq(null,((function (s__41906__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41908__$1 = s__41908;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41908__$1);
if(temp__4657__auto____$1){
var s__41908__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41908__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41908__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41910 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41909 = (0);
while(true){
if((i__41909 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41909);
cljs.core.chunk_append.call(null,b__41910,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43403 = (i__41909 + (1));
i__41909 = G__43403;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41910),thinktopic$aljabr$core$iter__41905_$_iter__41907.call(null,cljs.core.chunk_rest.call(null,s__41908__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41910),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41908__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41905_$_iter__41907.call(null,cljs.core.rest.call(null,s__41908__$2)));
}
} else {
return null;
}
break;
}
});})(s__41906__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41906__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41905.call(null,cljs.core.rest.call(null,s__41906__$1)));
} else {
var G__43404 = cljs.core.rest.call(null,s__41906__$1);
s__41906__$1 = G__43404;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41902 = self__._offset;
var vec__41911 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41902 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41902], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41902], null));
var a0 = cljs.core.nth.call(null,vec__41911,(0),null);
var b0 = cljs.core.nth.call(null,vec__41911,(1),null);
var G__41902__$1 = cljs.core.nth.call(null,vec__41911,(2),null);
var vec__41912 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41902__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41902__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41902__$1], null));
var a1 = cljs.core.nth.call(null,vec__41912,(0),null);
var b1 = cljs.core.nth.call(null,vec__41912,(1),null);
var G__41902__$2 = cljs.core.nth.call(null,vec__41912,(2),null);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,G__41902__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41901){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41901__$1 = (G__41901 | (0));
var G__41898 = (G__41901__$1 - self__._offset);
var a0 = ((G__41898 / self__._stride0) | (0));
var G__41898__$1 = (G__41898 - (a0 * self__._stride0));
var a1 = ((G__41898__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41900){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41898_43405 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41898_43405] = G__41900.call(null,p0,p1,(self__._data[G__41898_43405])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int8","int8",-1834023920);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41898){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41898);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41898 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41899 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,self__._offset,G__41898.call(null,p0__$1),G__41898.call(null,p1__$1),G__41899.call(null,p0__$1),G__41899.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41902 = self__._offset;
var G__41898 = cljs.core.PersistentVector.EMPTY;
var G__41899 = cljs.core.PersistentVector.EMPTY;
var vec__41913 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41898,G__41899,(G__41902 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41898,self__._shape0),cljs.core.conj.call(null,G__41899,self__._stride0),G__41902], null));
var G__41898__$1 = cljs.core.nth.call(null,vec__41913,(0),null);
var G__41899__$1 = cljs.core.nth.call(null,vec__41913,(1),null);
var G__41902__$1 = cljs.core.nth.call(null,vec__41913,(2),null);
var vec__41914 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41898__$1,G__41899__$1,(G__41902__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41898__$1,self__._shape1),cljs.core.conj.call(null,G__41899__$1,self__._stride1),G__41902__$1], null));
var G__41898__$2 = cljs.core.nth.call(null,vec__41914,(0),null);
var G__41899__$2 = cljs.core.nth.call(null,vec__41914,(1),null);
var G__41902__$2 = cljs.core.nth.call(null,vec__41914,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41898__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41902__$2,G__41899__$2,G__41898__$2);
} else {
return (self__._data[(G__41902__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41915 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41915,(0),null);
var b0 = cljs.core.nth.call(null,vec__41915,(1),null);
var vec__41916 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41916,(0),null);
var b1 = cljs.core.nth.call(null,vec__41916,(1),null);
var G__41902 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,G__41902,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41900){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41898_43406 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41898_43406] = G__41900.call(null,p0,p1,(self__._data[G__41898_43406])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41898){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41898);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41898){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41898);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int8(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41898,G__41900){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41898] = G__41900.call(null,G__41898,(self__._data[(G__41898 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41917(s__41918){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41918__$1 = s__41918;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41918__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41918__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41917_$_iter__41919(s__41920){
return (new cljs.core.LazySeq(null,((function (s__41918__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41920__$1 = s__41920;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41920__$1);
if(temp__4657__auto____$1){
var s__41920__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41920__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41920__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41922 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41921 = (0);
while(true){
if((i__41921 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41921);
cljs.core.chunk_append.call(null,b__41922,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43407 = (i__41921 + (1));
i__41921 = G__43407;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41922),thinktopic$aljabr$core$iter__41917_$_iter__41919.call(null,cljs.core.chunk_rest.call(null,s__41920__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41922),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41920__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41917_$_iter__41919.call(null,cljs.core.rest.call(null,s__41920__$2)));
}
} else {
return null;
}
break;
}
});})(s__41918__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41918__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41917.call(null,cljs.core.rest.call(null,s__41918__$1)));
} else {
var G__43408 = cljs.core.rest.call(null,s__41918__$1);
s__41918__$1 = G__43408;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int8.call(null,(self__._shape0 * self__._shape1));
var vec__41923 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41923,(0),null);
var a1 = cljs.core.nth.call(null,vec__41923,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2int8(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41898_43409 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41899_43410 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41898_43409)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41899_43410) | (0))] = (self__._data[(cljs.core.first.call(null,G__41898_43409) | (0))]));

var G__43411 = cljs.core.next.call(null,G__41898_43409);
var G__43412 = cljs.core.next.call(null,G__41899_43410);
G__41898_43409 = G__43411;
G__41899_43410 = G__43412;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43413 = length__41284__auto__;
var i__41280__auto___43414 = (0);
while(true){
if((i__41280__auto___43414 < n__19308__auto___43413)){
(r__41285__auto__[i__41280__auto___43414] = 0.0);

var G__43415 = (i__41280__auto___43414 + (1));
i__41280__auto___43414 = G__43415;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43416 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43417 = (0);
while(true){
if((i__41280__auto___43417 < n__19308__auto___43416)){
(r__41285__auto__[i__41280__auto___43417] = 0.0);

var G__43418 = (i__41280__auto___43417 + (1));
i__41280__auto___43417 = G__43418;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),thi.ng.typedarrays.core.int8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41924(s__41925){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41925__$1 = s__41925;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41925__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41925__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41924_$_iter__41926(s__41927){
return (new cljs.core.LazySeq(null,((function (s__41925__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41927__$1 = s__41927;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41927__$1);
if(temp__4657__auto____$1){
var s__41927__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41927__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41927__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41929 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41928 = (0);
while(true){
if((i__41928 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41928);
cljs.core.chunk_append.call(null,b__41929,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43419 = (i__41928 + (1));
i__41928 = G__43419;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41929),thinktopic$aljabr$core$iter__41924_$_iter__41926.call(null,cljs.core.chunk_rest.call(null,s__41927__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41929),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41927__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41924_$_iter__41926.call(null,cljs.core.rest.call(null,s__41927__$2)));
}
} else {
return null;
}
break;
}
});})(s__41925__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41925__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41924.call(null,cljs.core.rest.call(null,s__41925__$1)));
} else {
var G__43420 = cljs.core.rest.call(null,s__41925__$1);
s__41925__$1 = G__43420;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43421 = length__41284__auto__;
var i__41280__auto___43422 = (0);
while(true){
if((i__41280__auto___43422 < n__19308__auto___43421)){
(cloned_ary__41299__auto__[i__41280__auto___43422] = (self__._data[i__41280__auto___43422]));

var G__43423 = (i__41280__auto___43422 + (1));
i__41280__auto___43422 = G__43423;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int8","int8",-1834023920),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int8";

thinktopic.aljabr.core.NDArray2int8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int8");
});

thinktopic.aljabr.core.__GT_NDArray2int8 = (function thinktopic$aljabr$core$__GT_NDArray2int8(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int8(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int8 = (function thinktopic$aljabr$core$make_raw_ndarray2_int8(data__41282__auto__,o__41302__auto__,p__41930,p__41931){
var vec__41934 = p__41930;
var _stride0 = cljs.core.nth.call(null,vec__41934,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41934,(1),null);
var vec__41935 = p__41931;
var _shape0 = cljs.core.nth.call(null,vec__41935,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41935,(1),null);
return (new thinktopic.aljabr.core.NDArray2int8(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int8', thinktopic.aljabr.core.make_raw_ndarray2_int8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int8","int8",-1834023920)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int16 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41943(s__41944){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41944__$1 = s__41944;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41944__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41944__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41943_$_iter__41945(s__41946){
return (new cljs.core.LazySeq(null,((function (s__41944__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41946__$1 = s__41946;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41946__$1);
if(temp__4657__auto____$1){
var s__41946__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41946__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41946__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41948 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41947 = (0);
while(true){
if((i__41947 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41947);
cljs.core.chunk_append.call(null,b__41948,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43424 = (i__41947 + (1));
i__41947 = G__43424;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41948),thinktopic$aljabr$core$iter__41943_$_iter__41945.call(null,cljs.core.chunk_rest.call(null,s__41946__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41948),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41946__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41943_$_iter__41945.call(null,cljs.core.rest.call(null,s__41946__$2)));
}
} else {
return null;
}
break;
}
});})(s__41944__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41944__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41943.call(null,cljs.core.rest.call(null,s__41944__$1)));
} else {
var G__43425 = cljs.core.rest.call(null,s__41944__$1);
s__41944__$1 = G__43425;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41940 = self__._offset;
var vec__41949 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41940 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41940], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41940], null));
var a0 = cljs.core.nth.call(null,vec__41949,(0),null);
var b0 = cljs.core.nth.call(null,vec__41949,(1),null);
var G__41940__$1 = cljs.core.nth.call(null,vec__41949,(2),null);
var vec__41950 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41940__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41940__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41940__$1], null));
var a1 = cljs.core.nth.call(null,vec__41950,(0),null);
var b1 = cljs.core.nth.call(null,vec__41950,(1),null);
var G__41940__$2 = cljs.core.nth.call(null,vec__41950,(2),null);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,G__41940__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41939){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41939__$1 = (G__41939 | (0));
var G__41936 = (G__41939__$1 - self__._offset);
var a0 = ((G__41936 / self__._stride0) | (0));
var G__41936__$1 = (G__41936 - (a0 * self__._stride0));
var a1 = ((G__41936__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41938){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41936_43426 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41936_43426] = G__41938.call(null,p0,p1,(self__._data[G__41936_43426])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int16","int16",-188764863);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41936){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41936);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41936 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41937 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,self__._offset,G__41936.call(null,p0__$1),G__41936.call(null,p1__$1),G__41937.call(null,p0__$1),G__41937.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41940 = self__._offset;
var G__41936 = cljs.core.PersistentVector.EMPTY;
var G__41937 = cljs.core.PersistentVector.EMPTY;
var vec__41951 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41936,G__41937,(G__41940 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41936,self__._shape0),cljs.core.conj.call(null,G__41937,self__._stride0),G__41940], null));
var G__41936__$1 = cljs.core.nth.call(null,vec__41951,(0),null);
var G__41937__$1 = cljs.core.nth.call(null,vec__41951,(1),null);
var G__41940__$1 = cljs.core.nth.call(null,vec__41951,(2),null);
var vec__41952 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41936__$1,G__41937__$1,(G__41940__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41936__$1,self__._shape1),cljs.core.conj.call(null,G__41937__$1,self__._stride1),G__41940__$1], null));
var G__41936__$2 = cljs.core.nth.call(null,vec__41952,(0),null);
var G__41937__$2 = cljs.core.nth.call(null,vec__41952,(1),null);
var G__41940__$2 = cljs.core.nth.call(null,vec__41952,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41936__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41940__$2,G__41937__$2,G__41936__$2);
} else {
return (self__._data[(G__41940__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41953 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41953,(0),null);
var b0 = cljs.core.nth.call(null,vec__41953,(1),null);
var vec__41954 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41954,(0),null);
var b1 = cljs.core.nth.call(null,vec__41954,(1),null);
var G__41940 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,G__41940,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41938){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41936_43427 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41936_43427] = G__41938.call(null,p0,p1,(self__._data[G__41936_43427])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41936){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41936);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41936){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41936);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int16(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41936,G__41938){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41936] = G__41938.call(null,G__41936,(self__._data[(G__41936 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41955(s__41956){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41956__$1 = s__41956;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41956__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41956__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41955_$_iter__41957(s__41958){
return (new cljs.core.LazySeq(null,((function (s__41956__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41958__$1 = s__41958;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41958__$1);
if(temp__4657__auto____$1){
var s__41958__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41958__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41958__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41960 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41959 = (0);
while(true){
if((i__41959 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41959);
cljs.core.chunk_append.call(null,b__41960,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43428 = (i__41959 + (1));
i__41959 = G__43428;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41960),thinktopic$aljabr$core$iter__41955_$_iter__41957.call(null,cljs.core.chunk_rest.call(null,s__41958__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41960),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41958__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41955_$_iter__41957.call(null,cljs.core.rest.call(null,s__41958__$2)));
}
} else {
return null;
}
break;
}
});})(s__41956__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41956__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41955.call(null,cljs.core.rest.call(null,s__41956__$1)));
} else {
var G__43429 = cljs.core.rest.call(null,s__41956__$1);
s__41956__$1 = G__43429;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int16.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int16.call(null,(self__._shape0 * self__._shape1));
var vec__41961 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41961,(0),null);
var a1 = cljs.core.nth.call(null,vec__41961,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2int16(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41936_43430 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41937_43431 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41936_43430)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41937_43431) | (0))] = (self__._data[(cljs.core.first.call(null,G__41936_43430) | (0))]));

var G__43432 = cljs.core.next.call(null,G__41936_43430);
var G__43433 = cljs.core.next.call(null,G__41937_43431);
G__41936_43430 = G__43432;
G__41937_43431 = G__43433;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43434 = length__41284__auto__;
var i__41280__auto___43435 = (0);
while(true){
if((i__41280__auto___43435 < n__19308__auto___43434)){
(r__41285__auto__[i__41280__auto___43435] = 0.0);

var G__43436 = (i__41280__auto___43435 + (1));
i__41280__auto___43435 = G__43436;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43437 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43438 = (0);
while(true){
if((i__41280__auto___43438 < n__19308__auto___43437)){
(r__41285__auto__[i__41280__auto___43438] = 0.0);

var G__43439 = (i__41280__auto___43438 + (1));
i__41280__auto___43438 = G__43439;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),thi.ng.typedarrays.core.int16.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int16.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41962(s__41963){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__41963__$1 = s__41963;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41963__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41963__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__41962_$_iter__41964(s__41965){
return (new cljs.core.LazySeq(null,((function (s__41963__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__41965__$1 = s__41965;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41965__$1);
if(temp__4657__auto____$1){
var s__41965__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41965__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41965__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41967 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41966 = (0);
while(true){
if((i__41966 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41966);
cljs.core.chunk_append.call(null,b__41967,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43440 = (i__41966 + (1));
i__41966 = G__43440;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41967),thinktopic$aljabr$core$iter__41962_$_iter__41964.call(null,cljs.core.chunk_rest.call(null,s__41965__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41967),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41965__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__41962_$_iter__41964.call(null,cljs.core.rest.call(null,s__41965__$2)));
}
} else {
return null;
}
break;
}
});})(s__41963__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__41963__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41962.call(null,cljs.core.rest.call(null,s__41963__$1)));
} else {
var G__43441 = cljs.core.rest.call(null,s__41963__$1);
s__41963__$1 = G__43441;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43442 = length__41284__auto__;
var i__41280__auto___43443 = (0);
while(true){
if((i__41280__auto___43443 < n__19308__auto___43442)){
(cloned_ary__41299__auto__[i__41280__auto___43443] = (self__._data[i__41280__auto___43443]));

var G__43444 = (i__41280__auto___43443 + (1));
i__41280__auto___43443 = G__43444;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int16","int16",-188764863),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int16.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int16.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int16.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int16.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int16";

thinktopic.aljabr.core.NDArray2int16.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int16");
});

thinktopic.aljabr.core.__GT_NDArray2int16 = (function thinktopic$aljabr$core$__GT_NDArray2int16(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int16(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int16 = (function thinktopic$aljabr$core$make_raw_ndarray2_int16(data__41282__auto__,o__41302__auto__,p__41968,p__41969){
var vec__41972 = p__41968;
var _stride0 = cljs.core.nth.call(null,vec__41972,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__41972,(1),null);
var vec__41973 = p__41969;
var _shape0 = cljs.core.nth.call(null,vec__41973,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__41973,(1),null);
return (new thinktopic.aljabr.core.NDArray2int16(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int16', thinktopic.aljabr.core.make_raw_ndarray2_int16);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int16","int16",-188764863)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int16,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int16], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2int32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41981(s__41982){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41982__$1 = s__41982;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41982__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41982__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41981_$_iter__41983(s__41984){
return (new cljs.core.LazySeq(null,((function (s__41982__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41984__$1 = s__41984;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41984__$1);
if(temp__4657__auto____$1){
var s__41984__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41984__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41984__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41986 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41985 = (0);
while(true){
if((i__41985 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41985);
cljs.core.chunk_append.call(null,b__41986,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43445 = (i__41985 + (1));
i__41985 = G__43445;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41986),thinktopic$aljabr$core$iter__41981_$_iter__41983.call(null,cljs.core.chunk_rest.call(null,s__41984__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41986),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41984__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__41981_$_iter__41983.call(null,cljs.core.rest.call(null,s__41984__$2)));
}
} else {
return null;
}
break;
}
});})(s__41982__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41982__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41981.call(null,cljs.core.rest.call(null,s__41982__$1)));
} else {
var G__43446 = cljs.core.rest.call(null,s__41982__$1);
s__41982__$1 = G__43446;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41978 = self__._offset;
var vec__41987 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__41978 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__41978], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__41978], null));
var a0 = cljs.core.nth.call(null,vec__41987,(0),null);
var b0 = cljs.core.nth.call(null,vec__41987,(1),null);
var G__41978__$1 = cljs.core.nth.call(null,vec__41987,(2),null);
var vec__41988 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__41978__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__41978__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__41978__$1], null));
var a1 = cljs.core.nth.call(null,vec__41988,(0),null);
var b1 = cljs.core.nth.call(null,vec__41988,(1),null);
var G__41978__$2 = cljs.core.nth.call(null,vec__41988,(2),null);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,G__41978__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__41977){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41977__$1 = (G__41977 | (0));
var G__41974 = (G__41977__$1 - self__._offset);
var a0 = ((G__41974 / self__._stride0) | (0));
var G__41974__$1 = (G__41974 - (a0 * self__._stride0));
var a1 = ((G__41974__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41976){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__41974_43447 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41974_43447] = G__41976.call(null,p0,p1,(self__._data[G__41974_43447])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"int32","int32",1718804896);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__41974){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41974);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__41974 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__41975 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,self__._offset,G__41974.call(null,p0__$1),G__41974.call(null,p1__$1),G__41975.call(null,p0__$1),G__41975.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41978 = self__._offset;
var G__41974 = cljs.core.PersistentVector.EMPTY;
var G__41975 = cljs.core.PersistentVector.EMPTY;
var vec__41989 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41974,G__41975,(G__41978 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41974,self__._shape0),cljs.core.conj.call(null,G__41975,self__._stride0),G__41978], null));
var G__41974__$1 = cljs.core.nth.call(null,vec__41989,(0),null);
var G__41975__$1 = cljs.core.nth.call(null,vec__41989,(1),null);
var G__41978__$1 = cljs.core.nth.call(null,vec__41989,(2),null);
var vec__41990 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41974__$1,G__41975__$1,(G__41978__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__41974__$1,self__._shape1),cljs.core.conj.call(null,G__41975__$1,self__._stride1),G__41978__$1], null));
var G__41974__$2 = cljs.core.nth.call(null,vec__41990,(0),null);
var G__41975__$2 = cljs.core.nth.call(null,vec__41990,(1),null);
var G__41978__$2 = cljs.core.nth.call(null,vec__41990,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__41974__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"int32","int32",1718804896),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__41978__$2,G__41975__$2,G__41974__$2);
} else {
return (self__._data[(G__41978__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__41991 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__41991,(0),null);
var b0 = cljs.core.nth.call(null,vec__41991,(1),null);
var vec__41992 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__41992,(0),null);
var b1 = cljs.core.nth.call(null,vec__41992,(1),null);
var G__41978 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,G__41978,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__41976){
var self__ = this;
var ___41277__auto____$1 = this;
var G__41974_43448 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__41974_43448] = G__41976.call(null,p0,p1,(self__._data[G__41974_43448])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__41974){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__41974);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__41974){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__41974);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2int32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__41974,G__41976){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__41974] = G__41976.call(null,G__41974,(self__._data[(G__41974 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41993(s__41994){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__41994__$1 = s__41994;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__41994__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__41994__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__41993_$_iter__41995(s__41996){
return (new cljs.core.LazySeq(null,((function (s__41994__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__41996__$1 = s__41996;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__41996__$1);
if(temp__4657__auto____$1){
var s__41996__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__41996__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__41996__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__41998 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__41997 = (0);
while(true){
if((i__41997 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__41997);
cljs.core.chunk_append.call(null,b__41998,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43449 = (i__41997 + (1));
i__41997 = G__43449;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41998),thinktopic$aljabr$core$iter__41993_$_iter__41995.call(null,cljs.core.chunk_rest.call(null,s__41996__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__41998),null);
}
} else {
var a1 = cljs.core.first.call(null,s__41996__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__41993_$_iter__41995.call(null,cljs.core.rest.call(null,s__41996__$2)));
}
} else {
return null;
}
break;
}
});})(s__41994__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__41994__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__41993.call(null,cljs.core.rest.call(null,s__41994__$1)));
} else {
var G__43450 = cljs.core.rest.call(null,s__41994__$1);
s__41994__$1 = G__43450;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2int32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.int32.call(null,(self__._shape0 * self__._shape1));
var vec__41999 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__41999,(0),null);
var a1 = cljs.core.nth.call(null,vec__41999,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2int32(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__41974_43451 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__41975_43452 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__41974_43451)){
(buf__41278__auto__[(cljs.core.first.call(null,G__41975_43452) | (0))] = (self__._data[(cljs.core.first.call(null,G__41974_43451) | (0))]));

var G__43453 = cljs.core.next.call(null,G__41974_43451);
var G__43454 = cljs.core.next.call(null,G__41975_43452);
G__41974_43451 = G__43453;
G__41975_43452 = G__43454;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43455 = length__41284__auto__;
var i__41280__auto___43456 = (0);
while(true){
if((i__41280__auto___43456 < n__19308__auto___43455)){
(r__41285__auto__[i__41280__auto___43456] = 0.0);

var G__43457 = (i__41280__auto___43456 + (1));
i__41280__auto___43456 = G__43457;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43458 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43459 = (0);
while(true){
if((i__41280__auto___43459 < n__19308__auto___43458)){
(r__41285__auto__[i__41280__auto___43459] = 0.0);

var G__43460 = (i__41280__auto___43459 + (1));
i__41280__auto___43459 = G__43460;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),thi.ng.typedarrays.core.int32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2int32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42000(s__42001){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__42001__$1 = s__42001;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42001__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42001__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42000_$_iter__42002(s__42003){
return (new cljs.core.LazySeq(null,((function (s__42001__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42003__$1 = s__42003;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42003__$1);
if(temp__4657__auto____$1){
var s__42003__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42003__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42003__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42005 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42004 = (0);
while(true){
if((i__42004 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42004);
cljs.core.chunk_append.call(null,b__42005,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43461 = (i__42004 + (1));
i__42004 = G__43461;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42005),thinktopic$aljabr$core$iter__42000_$_iter__42002.call(null,cljs.core.chunk_rest.call(null,s__42003__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42005),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42003__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__42000_$_iter__42002.call(null,cljs.core.rest.call(null,s__42003__$2)));
}
} else {
return null;
}
break;
}
});})(s__42001__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42001__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42000.call(null,cljs.core.rest.call(null,s__42001__$1)));
} else {
var G__43462 = cljs.core.rest.call(null,s__42001__$1);
s__42001__$1 = G__43462;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43463 = length__41284__auto__;
var i__41280__auto___43464 = (0);
while(true){
if((i__41280__auto___43464 < n__19308__auto___43463)){
(cloned_ary__41299__auto__[i__41280__auto___43464] = (self__._data[i__41280__auto___43464]));

var G__43465 = (i__41280__auto___43464 + (1));
i__41280__auto___43464 = G__43465;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"int32","int32",1718804896),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2int32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2int32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2int32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2int32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2int32";

thinktopic.aljabr.core.NDArray2int32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2int32");
});

thinktopic.aljabr.core.__GT_NDArray2int32 = (function thinktopic$aljabr$core$__GT_NDArray2int32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2int32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_int32 = (function thinktopic$aljabr$core$make_raw_ndarray2_int32(data__41282__auto__,o__41302__auto__,p__42006,p__42007){
var vec__42010 = p__42006;
var _stride0 = cljs.core.nth.call(null,vec__42010,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__42010,(1),null);
var vec__42011 = p__42007;
var _shape0 = cljs.core.nth.call(null,vec__42011,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__42011,(1),null);
return (new thinktopic.aljabr.core.NDArray2int32(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_int32', thinktopic.aljabr.core.make_raw_ndarray2_int32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"int32","int32",1718804896)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_int32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.int32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2float32 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42019(s__42020){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42020__$1 = s__42020;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42020__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42020__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42019_$_iter__42021(s__42022){
return (new cljs.core.LazySeq(null,((function (s__42020__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42022__$1 = s__42022;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42022__$1);
if(temp__4657__auto____$1){
var s__42022__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42022__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42022__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42024 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42023 = (0);
while(true){
if((i__42023 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42023);
cljs.core.chunk_append.call(null,b__42024,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43466 = (i__42023 + (1));
i__42023 = G__43466;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42024),thinktopic$aljabr$core$iter__42019_$_iter__42021.call(null,cljs.core.chunk_rest.call(null,s__42022__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42024),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42022__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__42019_$_iter__42021.call(null,cljs.core.rest.call(null,s__42022__$2)));
}
} else {
return null;
}
break;
}
});})(s__42020__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42020__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42019.call(null,cljs.core.rest.call(null,s__42020__$1)));
} else {
var G__43467 = cljs.core.rest.call(null,s__42020__$1);
s__42020__$1 = G__43467;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42016 = self__._offset;
var vec__42025 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__42016 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__42016], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__42016], null));
var a0 = cljs.core.nth.call(null,vec__42025,(0),null);
var b0 = cljs.core.nth.call(null,vec__42025,(1),null);
var G__42016__$1 = cljs.core.nth.call(null,vec__42025,(2),null);
var vec__42026 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__42016__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__42016__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__42016__$1], null));
var a1 = cljs.core.nth.call(null,vec__42026,(0),null);
var b1 = cljs.core.nth.call(null,vec__42026,(1),null);
var G__42016__$2 = cljs.core.nth.call(null,vec__42026,(2),null);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,G__42016__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__42015){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42015__$1 = (G__42015 | (0));
var G__42012 = (G__42015__$1 - self__._offset);
var a0 = ((G__42012 / self__._stride0) | (0));
var G__42012__$1 = (G__42012 - (a0 * self__._stride0));
var a1 = ((G__42012__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__42014){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__42012_43468 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__42012_43468] = G__42014.call(null,p0,p1,(self__._data[G__42012_43468])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float32","float32",-2119815775);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__42012){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__42012);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__42012 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__42013 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,self__._offset,G__42012.call(null,p0__$1),G__42012.call(null,p1__$1),G__42013.call(null,p0__$1),G__42013.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42016 = self__._offset;
var G__42012 = cljs.core.PersistentVector.EMPTY;
var G__42013 = cljs.core.PersistentVector.EMPTY;
var vec__42027 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42012,G__42013,(G__42016 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42012,self__._shape0),cljs.core.conj.call(null,G__42013,self__._stride0),G__42016], null));
var G__42012__$1 = cljs.core.nth.call(null,vec__42027,(0),null);
var G__42013__$1 = cljs.core.nth.call(null,vec__42027,(1),null);
var G__42016__$1 = cljs.core.nth.call(null,vec__42027,(2),null);
var vec__42028 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42012__$1,G__42013__$1,(G__42016__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42012__$1,self__._shape1),cljs.core.conj.call(null,G__42013__$1,self__._stride1),G__42016__$1], null));
var G__42012__$2 = cljs.core.nth.call(null,vec__42028,(0),null);
var G__42013__$2 = cljs.core.nth.call(null,vec__42028,(1),null);
var G__42016__$2 = cljs.core.nth.call(null,vec__42028,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__42012__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__42016__$2,G__42013__$2,G__42012__$2);
} else {
return (self__._data[(G__42016__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__42029 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__42029,(0),null);
var b0 = cljs.core.nth.call(null,vec__42029,(1),null);
var vec__42030 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__42030,(0),null);
var b1 = cljs.core.nth.call(null,vec__42030,(1),null);
var G__42016 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,G__42016,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__42014){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42012_43469 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__42012_43469] = G__42014.call(null,p0,p1,(self__._data[G__42012_43469])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__42012){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__42012);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__42012){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__42012);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2float32(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__42012,G__42014){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__42012] = G__42014.call(null,G__42012,(self__._data[(G__42012 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42031(s__42032){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42032__$1 = s__42032;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42032__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42032__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42031_$_iter__42033(s__42034){
return (new cljs.core.LazySeq(null,((function (s__42032__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42034__$1 = s__42034;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42034__$1);
if(temp__4657__auto____$1){
var s__42034__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42034__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42034__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42036 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42035 = (0);
while(true){
if((i__42035 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42035);
cljs.core.chunk_append.call(null,b__42036,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43470 = (i__42035 + (1));
i__42035 = G__43470;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42036),thinktopic$aljabr$core$iter__42031_$_iter__42033.call(null,cljs.core.chunk_rest.call(null,s__42034__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42036),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42034__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__42031_$_iter__42033.call(null,cljs.core.rest.call(null,s__42034__$2)));
}
} else {
return null;
}
break;
}
});})(s__42032__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42032__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42031.call(null,cljs.core.rest.call(null,s__42032__$1)));
} else {
var G__43471 = cljs.core.rest.call(null,s__42032__$1);
s__42032__$1 = G__43471;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float32.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.float32.call(null,(self__._shape0 * self__._shape1));
var vec__42037 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__42037,(0),null);
var a1 = cljs.core.nth.call(null,vec__42037,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2float32(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__42012_43472 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__42013_43473 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__42012_43472)){
(buf__41278__auto__[(cljs.core.first.call(null,G__42013_43473) | (0))] = (self__._data[(cljs.core.first.call(null,G__42012_43472) | (0))]));

var G__43474 = cljs.core.next.call(null,G__42012_43472);
var G__43475 = cljs.core.next.call(null,G__42013_43473);
G__42012_43472 = G__43474;
G__42013_43473 = G__43475;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43476 = length__41284__auto__;
var i__41280__auto___43477 = (0);
while(true){
if((i__41280__auto___43477 < n__19308__auto___43476)){
(r__41285__auto__[i__41280__auto___43477] = 0.0);

var G__43478 = (i__41280__auto___43477 + (1));
i__41280__auto___43477 = G__43478;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43479 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43480 = (0);
while(true){
if((i__41280__auto___43480 < n__19308__auto___43479)){
(r__41285__auto__[i__41280__auto___43480] = 0.0);

var G__43481 = (i__41280__auto___43480 + (1));
i__41280__auto___43480 = G__43481;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),thi.ng.typedarrays.core.float32.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2float32.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42038(s__42039){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__42039__$1 = s__42039;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42039__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42039__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42038_$_iter__42040(s__42041){
return (new cljs.core.LazySeq(null,((function (s__42039__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42041__$1 = s__42041;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42041__$1);
if(temp__4657__auto____$1){
var s__42041__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42041__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42041__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42043 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42042 = (0);
while(true){
if((i__42042 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42042);
cljs.core.chunk_append.call(null,b__42043,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43482 = (i__42042 + (1));
i__42042 = G__43482;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42043),thinktopic$aljabr$core$iter__42038_$_iter__42040.call(null,cljs.core.chunk_rest.call(null,s__42041__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42043),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42041__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__42038_$_iter__42040.call(null,cljs.core.rest.call(null,s__42041__$2)));
}
} else {
return null;
}
break;
}
});})(s__42039__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42039__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42038.call(null,cljs.core.rest.call(null,s__42039__$1)));
} else {
var G__43483 = cljs.core.rest.call(null,s__42039__$1);
s__42039__$1 = G__43483;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43484 = length__41284__auto__;
var i__41280__auto___43485 = (0);
while(true){
if((i__41280__auto___43485 < n__19308__auto___43484)){
(cloned_ary__41299__auto__[i__41280__auto___43485] = (self__._data[i__41280__auto___43485]));

var G__43486 = (i__41280__auto___43485 + (1));
i__41280__auto___43485 = G__43486;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float32","float32",-2119815775),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2float32.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2float32.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2float32.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2float32.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2float32";

thinktopic.aljabr.core.NDArray2float32.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2float32");
});

thinktopic.aljabr.core.__GT_NDArray2float32 = (function thinktopic$aljabr$core$__GT_NDArray2float32(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2float32(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_float32 = (function thinktopic$aljabr$core$make_raw_ndarray2_float32(data__41282__auto__,o__41302__auto__,p__42044,p__42045){
var vec__42048 = p__42044;
var _stride0 = cljs.core.nth.call(null,vec__42048,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__42048,(1),null);
var vec__42049 = p__42045;
var _shape0 = cljs.core.nth.call(null,vec__42049,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__42049,(1),null);
return (new thinktopic.aljabr.core.NDArray2float32(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_float32', thinktopic.aljabr.core.make_raw_ndarray2_float32);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"float32","float32",-2119815775)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_float32,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float32], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray2float64 = (function (_data,_offset,_stride0,_stride1,_shape0,_shape1){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._shape0 = _shape0;
this._shape1 = _shape1;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(2));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null))], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"size","size",1098693007),(self__._shape0 * self__._shape1),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42057(s__42058){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42058__$1 = s__42058;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42058__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42058__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42057_$_iter__42059(s__42060){
return (new cljs.core.LazySeq(null,((function (s__42058__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42060__$1 = s__42060;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42060__$1);
if(temp__4657__auto____$1){
var s__42060__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42060__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42060__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42062 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42061 = (0);
while(true){
if((i__42061 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42061);
cljs.core.chunk_append.call(null,b__42062,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)));

var G__43487 = (i__42061 + (1));
i__42061 = G__43487;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42062),thinktopic$aljabr$core$iter__42057_$_iter__42059.call(null,cljs.core.chunk_rest.call(null,s__42060__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42062),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42060__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0)),thinktopic$aljabr$core$iter__42057_$_iter__42059.call(null,cljs.core.rest.call(null,s__42060__$2)));
}
} else {
return null;
}
break;
}
});})(s__42058__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42058__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42057.call(null,cljs.core.rest.call(null,s__42058__$1)));
} else {
var G__43488 = cljs.core.rest.call(null,s__42058__$1);
s__42058__$1 = G__43488;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$step$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42054 = self__._offset;
var vec__42063 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__42054 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__42054], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__42054], null));
var a0 = cljs.core.nth.call(null,vec__42063,(0),null);
var b0 = cljs.core.nth.call(null,vec__42063,(1),null);
var G__42054__$1 = cljs.core.nth.call(null,vec__42063,(2),null);
var vec__42064 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__42054__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__42054__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__42054__$1], null));
var a1 = cljs.core.nth.call(null,vec__42064,(0),null);
var b1 = cljs.core.nth.call(null,vec__42064,(1),null);
var G__42054__$2 = cljs.core.nth.call(null,vec__42064,(2),null);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,G__42054__$2,b0,b1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__42053){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42053__$1 = (G__42053 | (0));
var G__42050 = (G__42053__$1 - self__._offset);
var a0 = ((G__42050 / self__._stride0) | (0));
var G__42050__$1 = (G__42050 - (a0 * self__._stride0));
var a1 = ((G__42050__$1 / self__._stride1) | (0));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__42052){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
var G__42050_43489 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__42050_43489] = G__42052.call(null,p0,p1,(self__._data[G__42050_43489])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"float64","float64",1881838306);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$4 = (function (___41277__auto__,p0,p1,G__42050){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__42050);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var G__42050 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1], null);
var G__42051 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,self__._offset,G__42050.call(null,p0__$1),G__42050.call(null,p1__$1),G__42051.call(null,p0__$1),G__42051.call(null,p1__$1)));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42054 = self__._offset;
var G__42050 = cljs.core.PersistentVector.EMPTY;
var G__42051 = cljs.core.PersistentVector.EMPTY;
var vec__42065 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42050,G__42051,(G__42054 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42050,self__._shape0),cljs.core.conj.call(null,G__42051,self__._stride0),G__42054], null));
var G__42050__$1 = cljs.core.nth.call(null,vec__42065,(0),null);
var G__42051__$1 = cljs.core.nth.call(null,vec__42065,(1),null);
var G__42054__$1 = cljs.core.nth.call(null,vec__42065,(2),null);
var vec__42066 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42050__$1,G__42051__$1,(G__42054__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42050__$1,self__._shape1),cljs.core.conj.call(null,G__42051__$1,self__._stride1),G__42054__$1], null));
var G__42050__$2 = cljs.core.nth.call(null,vec__42066,(0),null);
var G__42051__$2 = cljs.core.nth.call(null,vec__42066,(1),null);
var G__42054__$2 = cljs.core.nth.call(null,vec__42066,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__42050__$2);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__42054__$2,G__42051__$2,G__42050__$2);
} else {
return (self__._data[(G__42054__$2 | (0))]);
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__42067 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__42067,(0),null);
var b0 = cljs.core.nth.call(null,vec__42067,(1),null);
var vec__42068 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__42068,(0),null);
var b1 = cljs.core.nth.call(null,vec__42068,(1),null);
var G__42054 = ((self__._offset + b0) + b1);
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,G__42054,self__._stride0,self__._stride1,a0,a1));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$4 = (function (___41277__auto__,p0,p1,G__42052){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42050_43490 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
(self__._data[G__42050_43490] = G__42052.call(null,p0,p1,(self__._data[G__42050_43490])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__42050){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__42050);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$4 = (function (___41277__auto__,p0,p1,G__42050){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(p1 < self__._shape1):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + (self__._stride1 * (p1 | (0)))) | (0))] = G__42050);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$3 = (function (___41277__auto__,p0,p1){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray2float64(self__._data,self__._offset,self__._stride0,self__._stride1,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1)));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__42050,G__42052){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__42050] = G__42052.call(null,G__42050,(self__._data[(G__42050 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._shape0 * self__._shape1);
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42069(s__42070){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42070__$1 = s__42070;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42070__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42070__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42069_$_iter__42071(s__42072){
return (new cljs.core.LazySeq(null,((function (s__42070__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42072__$1 = s__42072;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42072__$1);
if(temp__4657__auto____$1){
var s__42072__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42072__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42072__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42074 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42073 = (0);
while(true){
if((i__42073 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42073);
cljs.core.chunk_append.call(null,b__42074,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null));

var G__43491 = (i__42073 + (1));
i__42073 = G__43491;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42074),thinktopic$aljabr$core$iter__42069_$_iter__42071.call(null,cljs.core.chunk_rest.call(null,s__42072__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42074),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42072__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1], null),thinktopic$aljabr$core$iter__42069_$_iter__42071.call(null,cljs.core.rest.call(null,s__42072__$2)));
}
} else {
return null;
}
break;
}
});})(s__42070__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42070__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42069.call(null,cljs.core.rest.call(null,s__42070__$1)));
} else {
var G__43492 = cljs.core.rest.call(null,s__42070__$1);
s__42070__$1 = G__43492;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray2float64.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.float64.call(null,(self__._shape0 * self__._shape1));
var vec__42075 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var a0 = cljs.core.nth.call(null,vec__42075,(0),null);
var a1 = cljs.core.nth.call(null,vec__42075,(1),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray2float64(buf__41278__auto__,(0),a0,a1,self__._shape0,self__._shape1));
var G__42050_43493 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__42051_43494 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__42050_43493)){
(buf__41278__auto__[(cljs.core.first.call(null,G__42051_43494) | (0))] = (self__._data[(cljs.core.first.call(null,G__42050_43493) | (0))]));

var G__43495 = cljs.core.next.call(null,G__42050_43493);
var G__43496 = cljs.core.next.call(null,G__42051_43494);
G__42050_43493 = G__43495;
G__42051_43494 = G__43496;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43497 = length__41284__auto__;
var i__41280__auto___43498 = (0);
while(true){
if((i__41280__auto___43498 < n__19308__auto___43497)){
(r__41285__auto__[i__41280__auto___43498] = 0.0);

var G__43499 = (i__41280__auto___43498 + (1));
i__41280__auto___43498 = G__43499;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43500 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43501 = (0);
while(true){
if((i__41280__auto___43501 < n__19308__auto___43500)){
(r__41285__auto__[i__41280__auto___43501] = 0.0);

var G__43502 = (i__41280__auto___43501 + (1));
i__41280__auto___43501 = G__43502;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),thi.ng.typedarrays.core.float64.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray2float64.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(2))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42076(s__42077){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__42077__$1 = s__42077;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42077__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42077__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42076_$_iter__42078(s__42079){
return (new cljs.core.LazySeq(null,((function (s__42077__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42079__$1 = s__42079;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42079__$1);
if(temp__4657__auto____$1){
var s__42079__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42079__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42079__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42081 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42080 = (0);
while(true){
if((i__42080 < size__19176__auto__)){
var a1 = cljs.core._nth.call(null,c__19175__auto__,i__42080);
cljs.core.chunk_append.call(null,b__42081,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]));

var G__43503 = (i__42080 + (1));
i__42080 = G__43503;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42081),thinktopic$aljabr$core$iter__42076_$_iter__42078.call(null,cljs.core.chunk_rest.call(null,s__42079__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42081),null);
}
} else {
var a1 = cljs.core.first.call(null,s__42079__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + (self__._stride1 * (a1 | (0)))) | (0))]),thinktopic$aljabr$core$iter__42076_$_iter__42078.call(null,cljs.core.rest.call(null,s__42079__$2)));
}
} else {
return null;
}
break;
}
});})(s__42077__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42077__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42076.call(null,cljs.core.rest.call(null,s__42077__$1)));
} else {
var G__43504 = cljs.core.rest.call(null,s__42077__$1);
s__42077__$1 = G__43504;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((2) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43505 = length__41284__auto__;
var i__41280__auto___43506 = (0);
while(true){
if((i__41280__auto___43506 < n__19308__auto___43505)){
(cloned_ary__41299__auto__[i__41280__auto___43506] = (self__._data[i__41280__auto___43506]));

var G__43507 = (i__41280__auto___43506 + (1));
i__41280__auto___43506 = G__43507;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"float64","float64",1881838306),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1], null));
});

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray2float64.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray2float64.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null)], null);
});

thinktopic.aljabr.core.NDArray2float64.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray2float64.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray2float64";

thinktopic.aljabr.core.NDArray2float64.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray2float64");
});

thinktopic.aljabr.core.__GT_NDArray2float64 = (function thinktopic$aljabr$core$__GT_NDArray2float64(_data,_offset,_stride0,_stride1,_shape0,_shape1){
return (new thinktopic.aljabr.core.NDArray2float64(_data,_offset,_stride0,_stride1,_shape0,_shape1));
});


thinktopic.aljabr.core.make_raw_ndarray2_float64 = (function thinktopic$aljabr$core$make_raw_ndarray2_float64(data__41282__auto__,o__41302__auto__,p__42082,p__42083){
var vec__42086 = p__42082;
var _stride0 = cljs.core.nth.call(null,vec__42086,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__42086,(1),null);
var vec__42087 = p__42083;
var _shape0 = cljs.core.nth.call(null,vec__42087,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__42087,(1),null);
return (new thinktopic.aljabr.core.NDArray2float64(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_shape0,_shape1));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray2_float64', thinktopic.aljabr.core.make_raw_ndarray2_float64);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),new cljs.core.Keyword(null,"float64","float64",1881838306)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray2_float64,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.float64], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3generic = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42095(s__42096){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42096__$1 = s__42096;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42096__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42096__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42095_$_iter__42097(s__42098){
return (new cljs.core.LazySeq(null,((function (s__42096__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42098__$1 = s__42098;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42098__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42098__$1,s__42096__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42095_$_iter__42097_$_iter__42099(s__42100){
return (new cljs.core.LazySeq(null,((function (s__42098__$1,s__42096__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42100__$1 = s__42100;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42100__$1);
if(temp__4657__auto____$2){
var s__42100__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42100__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42100__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42102 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42101 = (0);
while(true){
if((i__42101 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42101);
cljs.core.chunk_append.call(null,b__42102,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__43508 = (i__42101 + (1));
i__42101 = G__43508;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42102),thinktopic$aljabr$core$iter__42095_$_iter__42097_$_iter__42099.call(null,cljs.core.chunk_rest.call(null,s__42100__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42102),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42100__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__42095_$_iter__42097_$_iter__42099.call(null,cljs.core.rest.call(null,s__42100__$2)));
}
} else {
return null;
}
break;
}
});})(s__42098__$1,s__42096__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42098__$1,s__42096__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42095_$_iter__42097.call(null,cljs.core.rest.call(null,s__42098__$1)));
} else {
var G__43509 = cljs.core.rest.call(null,s__42098__$1);
s__42098__$1 = G__43509;
continue;
}
} else {
return null;
}
break;
}
});})(s__42096__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42096__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42095.call(null,cljs.core.rest.call(null,s__42096__$1)));
} else {
var G__43510 = cljs.core.rest.call(null,s__42096__$1);
s__42096__$1 = G__43510;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42092 = self__._offset;
var vec__42103 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__42092 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__42092], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__42092], null));
var a0 = cljs.core.nth.call(null,vec__42103,(0),null);
var b0 = cljs.core.nth.call(null,vec__42103,(1),null);
var G__42092__$1 = cljs.core.nth.call(null,vec__42103,(2),null);
var vec__42104 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__42092__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__42092__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__42092__$1], null));
var a1 = cljs.core.nth.call(null,vec__42104,(0),null);
var b1 = cljs.core.nth.call(null,vec__42104,(1),null);
var G__42092__$2 = cljs.core.nth.call(null,vec__42104,(2),null);
var vec__42105 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__42092__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__42092__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__42092__$2], null));
var a2 = cljs.core.nth.call(null,vec__42105,(0),null);
var b2 = cljs.core.nth.call(null,vec__42105,(1),null);
var G__42092__$3 = cljs.core.nth.call(null,vec__42105,(2),null);
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,G__42092__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__42091){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42091__$1 = (G__42091 | (0));
var G__42088 = (G__42091__$1 - self__._offset);
var a0 = ((G__42088 / self__._stride0) | (0));
var G__42088__$1 = (G__42088 - (a0 * self__._stride0));
var a1 = ((G__42088__$1 / self__._stride1) | (0));
var G__42088__$2 = (G__42088__$1 - (a1 * self__._stride1));
var a2 = ((G__42088__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42090){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__42088_43511 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__42088_43511] = G__42090.call(null,p0,p1,p2,(self__._data[G__42088_43511])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"generic","generic",-1245036524);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42088){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__42088);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__42088 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__42089 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,self__._offset,G__42088.call(null,p0__$1),G__42088.call(null,p1__$1),G__42088.call(null,p2__$1),G__42089.call(null,p0__$1),G__42089.call(null,p1__$1),G__42089.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42092 = self__._offset;
var G__42088 = cljs.core.PersistentVector.EMPTY;
var G__42089 = cljs.core.PersistentVector.EMPTY;
var vec__42106 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42088,G__42089,(G__42092 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42088,self__._shape0),cljs.core.conj.call(null,G__42089,self__._stride0),G__42092], null));
var G__42088__$1 = cljs.core.nth.call(null,vec__42106,(0),null);
var G__42089__$1 = cljs.core.nth.call(null,vec__42106,(1),null);
var G__42092__$1 = cljs.core.nth.call(null,vec__42106,(2),null);
var vec__42107 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42088__$1,G__42089__$1,(G__42092__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42088__$1,self__._shape1),cljs.core.conj.call(null,G__42089__$1,self__._stride1),G__42092__$1], null));
var G__42088__$2 = cljs.core.nth.call(null,vec__42107,(0),null);
var G__42089__$2 = cljs.core.nth.call(null,vec__42107,(1),null);
var G__42092__$2 = cljs.core.nth.call(null,vec__42107,(2),null);
var vec__42108 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42088__$2,G__42089__$2,(G__42092__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42088__$2,self__._shape2),cljs.core.conj.call(null,G__42089__$2,self__._stride2),G__42092__$2], null));
var G__42088__$3 = cljs.core.nth.call(null,vec__42108,(0),null);
var G__42089__$3 = cljs.core.nth.call(null,vec__42108,(1),null);
var G__42092__$3 = cljs.core.nth.call(null,vec__42108,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__42088__$3);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__42092__$3,G__42089__$3,G__42088__$3);
} else {
return (self__._data[(G__42092__$3 | (0))]);
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__42109 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__42109,(0),null);
var b0 = cljs.core.nth.call(null,vec__42109,(1),null);
var vec__42110 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__42110,(0),null);
var b1 = cljs.core.nth.call(null,vec__42110,(1),null);
var vec__42111 = (((p2 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape2 - (p2 | (0))),(self__._stride2 * (p2 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,(0)], null));
var a2 = cljs.core.nth.call(null,vec__42111,(0),null);
var b2 = cljs.core.nth.call(null,vec__42111,(1),null);
var G__42092 = ((self__._offset + b0) + (b1 + b2));
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,G__42092,self__._stride0,self__._stride1,self__._stride2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42090){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42088_43512 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__42088_43512] = G__42090.call(null,p0,p1,p2,(self__._data[G__42088_43512])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__42088){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__42088);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42088){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__42088);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray3generic(self__._data,self__._offset,self__._stride0,self__._stride1,self__._stride2,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1),((typeof p2 === 'number')?(((p2 < (0)))?(self__._shape2 + (p2 | (0))):(p2 | (0))):self__._shape2)));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__42088,G__42090){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__42088] = G__42090.call(null,G__42088,(self__._data[(G__42088 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._shape0 * self__._shape1) * self__._shape2);
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42112(s__42113){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42113__$1 = s__42113;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42113__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42113__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42112_$_iter__42114(s__42115){
return (new cljs.core.LazySeq(null,((function (s__42113__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42115__$1 = s__42115;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42115__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42115__$1,s__42113__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42112_$_iter__42114_$_iter__42116(s__42117){
return (new cljs.core.LazySeq(null,((function (s__42115__$1,s__42113__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42117__$1 = s__42117;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42117__$1);
if(temp__4657__auto____$2){
var s__42117__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42117__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42117__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42119 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42118 = (0);
while(true){
if((i__42118 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42118);
cljs.core.chunk_append.call(null,b__42119,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null));

var G__43513 = (i__42118 + (1));
i__42118 = G__43513;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42119),thinktopic$aljabr$core$iter__42112_$_iter__42114_$_iter__42116.call(null,cljs.core.chunk_rest.call(null,s__42117__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42119),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42117__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null),thinktopic$aljabr$core$iter__42112_$_iter__42114_$_iter__42116.call(null,cljs.core.rest.call(null,s__42117__$2)));
}
} else {
return null;
}
break;
}
});})(s__42115__$1,s__42113__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42115__$1,s__42113__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42112_$_iter__42114.call(null,cljs.core.rest.call(null,s__42115__$1)));
} else {
var G__43514 = cljs.core.rest.call(null,s__42115__$1);
s__42115__$1 = G__43514;
continue;
}
} else {
return null;
}
break;
}
});})(s__42113__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42113__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42112.call(null,cljs.core.rest.call(null,s__42113__$1)));
} else {
var G__43515 = cljs.core.rest.call(null,s__42113__$1);
s__42113__$1 = G__43515;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3generic.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = cljs.core.to_array.call(null,((self__._shape0 * self__._shape1) * self__._shape2));
var vec__42120 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var a0 = cljs.core.nth.call(null,vec__42120,(0),null);
var a1 = cljs.core.nth.call(null,vec__42120,(1),null);
var a2 = cljs.core.nth.call(null,vec__42120,(2),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray3generic(buf__41278__auto__,(0),a0,a1,a2,self__._shape0,self__._shape1,self__._shape2));
var G__42088_43516 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__42089_43517 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__42088_43516)){
(buf__41278__auto__[(cljs.core.first.call(null,G__42089_43517) | (0))] = (self__._data[(cljs.core.first.call(null,G__42088_43516) | (0))]));

var G__43518 = cljs.core.next.call(null,G__42088_43516);
var G__43519 = cljs.core.next.call(null,G__42089_43517);
G__42088_43516 = G__43518;
G__42089_43517 = G__43519;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43520 = length__41284__auto__;
var i__41280__auto___43521 = (0);
while(true){
if((i__41280__auto___43521 < n__19308__auto___43520)){
(r__41285__auto__[i__41280__auto___43521] = 0.0);

var G__43522 = (i__41280__auto___43521 + (1));
i__41280__auto___43521 = G__43522;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43523 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43524 = (0);
while(true){
if((i__41280__auto___43524 < n__19308__auto___43523)){
(r__41285__auto__[i__41280__auto___43524] = 0.0);

var G__43525 = (i__41280__auto___43524 + (1));
i__41280__auto___43524 = G__43525;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cljs.core.to_array.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray3generic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(3))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42121(s__42122){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__42122__$1 = s__42122;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42122__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42122__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42121_$_iter__42123(s__42124){
return (new cljs.core.LazySeq(null,((function (s__42122__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42124__$1 = s__42124;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42124__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42124__$1,s__42122__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42121_$_iter__42123_$_iter__42125(s__42126){
return (new cljs.core.LazySeq(null,((function (s__42124__$1,s__42122__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42126__$1 = s__42126;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42126__$1);
if(temp__4657__auto____$2){
var s__42126__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42126__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42126__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42128 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42127 = (0);
while(true){
if((i__42127 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42127);
cljs.core.chunk_append.call(null,b__42128,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]));

var G__43526 = (i__42127 + (1));
i__42127 = G__43526;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42128),thinktopic$aljabr$core$iter__42121_$_iter__42123_$_iter__42125.call(null,cljs.core.chunk_rest.call(null,s__42126__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42128),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42126__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]),thinktopic$aljabr$core$iter__42121_$_iter__42123_$_iter__42125.call(null,cljs.core.rest.call(null,s__42126__$2)));
}
} else {
return null;
}
break;
}
});})(s__42124__$1,s__42122__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42124__$1,s__42122__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42121_$_iter__42123.call(null,cljs.core.rest.call(null,s__42124__$1)));
} else {
var G__43527 = cljs.core.rest.call(null,s__42124__$1);
s__42124__$1 = G__43527;
continue;
}
} else {
return null;
}
break;
}
});})(s__42122__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42122__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42121.call(null,cljs.core.rest.call(null,s__42122__$1)));
} else {
var G__43528 = cljs.core.rest.call(null,s__42122__$1);
s__42122__$1 = G__43528;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((3) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43529 = length__41284__auto__;
var i__41280__auto___43530 = (0);
while(true){
if((i__41280__auto___43530 < n__19308__auto___43529)){
(cloned_ary__41299__auto__[i__41280__auto___43530] = (self__._data[i__41280__auto___43530]));

var G__43531 = (i__41280__auto___43530 + (1));
i__41280__auto___43530 = G__43531;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"generic","generic",-1245036524),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray3generic.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray3generic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_stride2","_stride2",-1119345708,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null),new cljs.core.Symbol(null,"_shape2","_shape2",-126153333,null)], null);
});

thinktopic.aljabr.core.NDArray3generic.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray3generic.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray3generic";

thinktopic.aljabr.core.NDArray3generic.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray3generic");
});

thinktopic.aljabr.core.__GT_NDArray3generic = (function thinktopic$aljabr$core$__GT_NDArray3generic(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
return (new thinktopic.aljabr.core.NDArray3generic(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});


thinktopic.aljabr.core.make_raw_ndarray3_generic = (function thinktopic$aljabr$core$make_raw_ndarray3_generic(data__41282__auto__,o__41302__auto__,p__42129,p__42130){
var vec__42133 = p__42129;
var _stride0 = cljs.core.nth.call(null,vec__42133,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__42133,(1),null);
var _stride2 = cljs.core.nth.call(null,vec__42133,(2),null);
var vec__42134 = p__42130;
var _shape0 = cljs.core.nth.call(null,vec__42134,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__42134,(1),null);
var _shape2 = cljs.core.nth.call(null,vec__42134,(2),null);
return (new thinktopic.aljabr.core.NDArray3generic(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray3_generic', thinktopic.aljabr.core.make_raw_ndarray3_generic);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),new cljs.core.Keyword(null,"generic","generic",-1245036524)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray3_generic,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),cljs.core.to_array], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3uint8 = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42142(s__42143){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42143__$1 = s__42143;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42143__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42143__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42142_$_iter__42144(s__42145){
return (new cljs.core.LazySeq(null,((function (s__42143__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42145__$1 = s__42145;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42145__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42145__$1,s__42143__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42142_$_iter__42144_$_iter__42146(s__42147){
return (new cljs.core.LazySeq(null,((function (s__42145__$1,s__42143__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42147__$1 = s__42147;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42147__$1);
if(temp__4657__auto____$2){
var s__42147__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42147__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42147__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42149 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42148 = (0);
while(true){
if((i__42148 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42148);
cljs.core.chunk_append.call(null,b__42149,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__43532 = (i__42148 + (1));
i__42148 = G__43532;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42149),thinktopic$aljabr$core$iter__42142_$_iter__42144_$_iter__42146.call(null,cljs.core.chunk_rest.call(null,s__42147__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42149),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42147__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__42142_$_iter__42144_$_iter__42146.call(null,cljs.core.rest.call(null,s__42147__$2)));
}
} else {
return null;
}
break;
}
});})(s__42145__$1,s__42143__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42145__$1,s__42143__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42142_$_iter__42144.call(null,cljs.core.rest.call(null,s__42145__$1)));
} else {
var G__43533 = cljs.core.rest.call(null,s__42145__$1);
s__42145__$1 = G__43533;
continue;
}
} else {
return null;
}
break;
}
});})(s__42143__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42143__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42142.call(null,cljs.core.rest.call(null,s__42143__$1)));
} else {
var G__43534 = cljs.core.rest.call(null,s__42143__$1);
s__42143__$1 = G__43534;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42139 = self__._offset;
var vec__42150 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__42139 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__42139], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__42139], null));
var a0 = cljs.core.nth.call(null,vec__42150,(0),null);
var b0 = cljs.core.nth.call(null,vec__42150,(1),null);
var G__42139__$1 = cljs.core.nth.call(null,vec__42150,(2),null);
var vec__42151 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__42139__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__42139__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__42139__$1], null));
var a1 = cljs.core.nth.call(null,vec__42151,(0),null);
var b1 = cljs.core.nth.call(null,vec__42151,(1),null);
var G__42139__$2 = cljs.core.nth.call(null,vec__42151,(2),null);
var vec__42152 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__42139__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__42139__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__42139__$2], null));
var a2 = cljs.core.nth.call(null,vec__42152,(0),null);
var b2 = cljs.core.nth.call(null,vec__42152,(1),null);
var G__42139__$3 = cljs.core.nth.call(null,vec__42152,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,G__42139__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__42138){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42138__$1 = (G__42138 | (0));
var G__42135 = (G__42138__$1 - self__._offset);
var a0 = ((G__42135 / self__._stride0) | (0));
var G__42135__$1 = (G__42135 - (a0 * self__._stride0));
var a1 = ((G__42135__$1 / self__._stride1) | (0));
var G__42135__$2 = (G__42135__$1 - (a1 * self__._stride1));
var a2 = ((G__42135__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42137){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__42135_43535 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__42135_43535] = G__42137.call(null,p0,p1,p2,(self__._data[G__42135_43535])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8","uint8",956521151);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42135){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__42135);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__42135 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__42136 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,self__._offset,G__42135.call(null,p0__$1),G__42135.call(null,p1__$1),G__42135.call(null,p2__$1),G__42136.call(null,p0__$1),G__42136.call(null,p1__$1),G__42136.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42139 = self__._offset;
var G__42135 = cljs.core.PersistentVector.EMPTY;
var G__42136 = cljs.core.PersistentVector.EMPTY;
var vec__42153 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42135,G__42136,(G__42139 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42135,self__._shape0),cljs.core.conj.call(null,G__42136,self__._stride0),G__42139], null));
var G__42135__$1 = cljs.core.nth.call(null,vec__42153,(0),null);
var G__42136__$1 = cljs.core.nth.call(null,vec__42153,(1),null);
var G__42139__$1 = cljs.core.nth.call(null,vec__42153,(2),null);
var vec__42154 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42135__$1,G__42136__$1,(G__42139__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42135__$1,self__._shape1),cljs.core.conj.call(null,G__42136__$1,self__._stride1),G__42139__$1], null));
var G__42135__$2 = cljs.core.nth.call(null,vec__42154,(0),null);
var G__42136__$2 = cljs.core.nth.call(null,vec__42154,(1),null);
var G__42139__$2 = cljs.core.nth.call(null,vec__42154,(2),null);
var vec__42155 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42135__$2,G__42136__$2,(G__42139__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42135__$2,self__._shape2),cljs.core.conj.call(null,G__42136__$2,self__._stride2),G__42139__$2], null));
var G__42135__$3 = cljs.core.nth.call(null,vec__42155,(0),null);
var G__42136__$3 = cljs.core.nth.call(null,vec__42155,(1),null);
var G__42139__$3 = cljs.core.nth.call(null,vec__42155,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__42135__$3);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"ctor","ctor",1750864802)], null)).call(null,self__._data,G__42139__$3,G__42136__$3,G__42135__$3);
} else {
return (self__._data[(G__42139__$3 | (0))]);
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_l$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var vec__42156 = (((p0 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape0 - (p0 | (0))),(self__._stride0 * (p0 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,(0)], null));
var a0 = cljs.core.nth.call(null,vec__42156,(0),null);
var b0 = cljs.core.nth.call(null,vec__42156,(1),null);
var vec__42157 = (((p1 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape1 - (p1 | (0))),(self__._stride1 * (p1 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,(0)], null));
var a1 = cljs.core.nth.call(null,vec__42157,(0),null);
var b1 = cljs.core.nth.call(null,vec__42157,(1),null);
var vec__42158 = (((p2 > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__._shape2 - (p2 | (0))),(self__._stride2 * (p2 | (0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,(0)], null));
var a2 = cljs.core.nth.call(null,vec__42158,(0),null);
var b2 = cljs.core.nth.call(null,vec__42158,(1),null);
var G__42139 = ((self__._offset + b0) + (b1 + b2));
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,G__42139,self__._stride0,self__._stride1,self__._stride2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42137){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42135_43536 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__42135_43536] = G__42137.call(null,p0,p1,p2,(self__._data[G__42135_43536])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$index_at$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_index$arity$3 = (function (___41277__auto__,i__41280__auto__,G__42135){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(i__41280__auto__ | (0))] = G__42135);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$set_at_safe$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42135){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__42135);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$truncate_h$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (new thinktopic.aljabr.core.NDArray3uint8(self__._data,self__._offset,self__._stride0,self__._stride1,self__._stride2,((typeof p0 === 'number')?(((p0 < (0)))?(self__._shape0 + (p0 | (0))):(p0 | (0))):self__._shape0),((typeof p1 === 'number')?(((p1 < (0)))?(self__._shape1 + (p1 | (0))):(p1 | (0))):self__._shape1),((typeof p2 === 'number')?(((p2 < (0)))?(self__._shape2 + (p2 | (0))):(p2 | (0))):self__._shape2)));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$update_at_index$arity$3 = (function (___41277__auto__,G__42135,G__42137){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[G__42135] = G__42137.call(null,G__42135,(self__._data[(G__42135 | (0))])));

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$size$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return ((self__._shape0 * self__._shape1) * self__._shape2);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$position_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42159(s__42160){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42160__$1 = s__42160;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42160__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42160__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42159_$_iter__42161(s__42162){
return (new cljs.core.LazySeq(null,((function (s__42160__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42162__$1 = s__42162;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42162__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42162__$1,s__42160__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42159_$_iter__42161_$_iter__42163(s__42164){
return (new cljs.core.LazySeq(null,((function (s__42162__$1,s__42160__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42164__$1 = s__42164;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42164__$1);
if(temp__4657__auto____$2){
var s__42164__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42164__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42164__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42166 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42165 = (0);
while(true){
if((i__42165 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42165);
cljs.core.chunk_append.call(null,b__42166,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null));

var G__43537 = (i__42165 + (1));
i__42165 = G__43537;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42166),thinktopic$aljabr$core$iter__42159_$_iter__42161_$_iter__42163.call(null,cljs.core.chunk_rest.call(null,s__42164__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42166),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42164__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null),thinktopic$aljabr$core$iter__42159_$_iter__42161_$_iter__42163.call(null,cljs.core.rest.call(null,s__42164__$2)));
}
} else {
return null;
}
break;
}
});})(s__42162__$1,s__42160__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42162__$1,s__42160__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42159_$_iter__42161.call(null,cljs.core.rest.call(null,s__42162__$1)));
} else {
var G__43538 = cljs.core.rest.call(null,s__42162__$1);
s__42162__$1 = G__43538;
continue;
}
} else {
return null;
}
break;
}
});})(s__42160__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42160__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42159.call(null,cljs.core.rest.call(null,s__42160__$1)));
} else {
var G__43539 = cljs.core.rest.call(null,s__42160__$1);
s__42160__$1 = G__43539;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.thinktopic$aljabr$core$PNDArray$extract$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var buf__41278__auto__ = thi.ng.typedarrays.core.uint8.call(null,((self__._shape0 * self__._shape1) * self__._shape2));
var vec__42167 = thinktopic.aljabr.core.shape__GT_stride.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var a0 = cljs.core.nth.call(null,vec__42167,(0),null);
var a1 = cljs.core.nth.call(null,vec__42167,(1),null);
var a2 = cljs.core.nth.call(null,vec__42167,(2),null);
var arr__41279__auto__ = (new thinktopic.aljabr.core.NDArray3uint8(buf__41278__auto__,(0),a0,a1,a2,self__._shape0,self__._shape1,self__._shape2));
var G__42135_43540 = thinktopic.aljabr.core.index_seq.call(null,___41277__auto____$1);
var G__42136_43541 = thinktopic.aljabr.core.index_seq.call(null,arr__41279__auto__);
while(true){
if(cljs.core.truth_(G__42135_43540)){
(buf__41278__auto__[(cljs.core.first.call(null,G__42136_43541) | (0))] = (self__._data[(cljs.core.first.call(null,G__42135_43540) | (0))]));

var G__43542 = cljs.core.next.call(null,G__42135_43540);
var G__43543 = cljs.core.next.call(null,G__42136_43541);
G__42135_43540 = G__43542;
G__42136_43541 = G__43543;
continue;
} else {
}
break;
}

return arr__41279__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"thing-ndarray","thing-ndarray",1493660876);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Aljabr Matrix"], null);
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (___41277__auto__,data__41282__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var dims__41283__auto__ = cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,data__41282__auto__));
if((dims__41283__auto__ === (0))){
return clojure.core.matrix.protocols.get_0d.call(null,data__41282__auto__);
} else {
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),clojure.core.matrix.eseq.call(null,data__41282__auto__),clojure.core.matrix.shape.call(null,data__41282__auto__));

}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (___41277__auto__,length__41284__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,length__41284__auto__),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [length__41284__auto__], null));
var n__19308__auto___43544 = length__41284__auto__;
var i__41280__auto___43545 = (0);
while(true){
if((i__41280__auto___43545 < n__19308__auto___43544)){
(r__41285__auto__[i__41280__auto___43545] = 0.0);

var G__43546 = (i__41280__auto___43545 + (1));
i__41280__auto___43545 = G__43546;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (___41277__auto__,rows__41286__auto__,columns__41287__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var r__41285__auto__ = thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,(rows__41286__auto__ * columns__41287__auto__)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows__41286__auto__,columns__41287__auto__], null));
var n__19308__auto___43547 = (rows__41286__auto__ * columns__41287__auto__);
var i__41280__auto___43548 = (0);
while(true){
if((i__41280__auto___43548 < n__19308__auto___43547)){
(r__41285__auto__[i__41280__auto___43548] = 0.0);

var G__43549 = (i__41280__auto___43548 + (1));
i__41280__auto___43548 = G__43549;
continue;
} else {
}
break;
}

return r__41285__auto__;
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (___41277__auto__,shape__41288__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var temp__4655__auto__ = cljs.core.seq.call(null,shape__41288__auto__);
if(temp__4655__auto__){
var shape__41288__auto____$1 = temp__4655__auto__;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),thi.ng.typedarrays.core.uint8.call(null,cljs.core.apply.call(null,cljs.core._STAR_,shape__41288__auto____$1)),shape__41288__auto____$1);
} else {
return 0.0;
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (___41277__auto__,dimensions__41289__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (dimensions__41289__auto__ <= (4));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (m__41263__auto__){
var self__ = this;
var m__41263__auto____$1 = this;
if(((self__._data == null)) || (cljs.core._EQ_.call(null,(0),self__._data.length))){
return null;
} else {
if(cljs.core._EQ_.call(null,(1),(3))){
var iter__19177__auto__ = ((function (m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42168(s__42169){
return (new cljs.core.LazySeq(null,((function (m__41263__auto____$1){
return (function (){
var s__42169__$1 = s__42169;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42169__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42169__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42168_$_iter__42170(s__42171){
return (new cljs.core.LazySeq(null,((function (s__42169__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42171__$1 = s__42171;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42171__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42171__$1,s__42169__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function thinktopic$aljabr$core$iter__42168_$_iter__42170_$_iter__42172(s__42173){
return (new cljs.core.LazySeq(null,((function (s__42171__$1,s__42169__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1){
return (function (){
var s__42173__$1 = s__42173;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42173__$1);
if(temp__4657__auto____$2){
var s__42173__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42173__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42173__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42175 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42174 = (0);
while(true){
if((i__42174 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42174);
cljs.core.chunk_append.call(null,b__42175,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]));

var G__43550 = (i__42174 + (1));
i__42174 = G__43550;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42175),thinktopic$aljabr$core$iter__42168_$_iter__42170_$_iter__42172.call(null,cljs.core.chunk_rest.call(null,s__42173__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42175),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42173__$2);
return cljs.core.cons.call(null,(self__._data[(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0))]),thinktopic$aljabr$core$iter__42168_$_iter__42170_$_iter__42172.call(null,cljs.core.rest.call(null,s__42173__$2)));
}
} else {
return null;
}
break;
}
});})(s__42171__$1,s__42169__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42171__$1,s__42169__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42168_$_iter__42170.call(null,cljs.core.rest.call(null,s__42171__$1)));
} else {
var G__43551 = cljs.core.rest.call(null,s__42171__$1);
s__42171__$1 = G__43551;
continue;
}
} else {
return null;
}
break;
}
});})(s__42169__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
,null,null));
});})(s__42169__$1,a0,xs__5205__auto__,temp__4657__auto__,m__41263__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42168.call(null,cljs.core.rest.call(null,s__42169__$1)));
} else {
var G__43552 = cljs.core.rest.call(null,s__42169__$1);
s__42169__$1 = G__43552;
continue;
}
} else {
return null;
}
break;
}
});})(m__41263__auto____$1))
,null,null));
});})(m__41263__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
} else {
var shape__41264__auto__ = clojure.core.matrix.shape.call(null,m__41263__auto____$1);
return cljs.core.map.call(null,((function (shape__41264__auto__,m__41263__auto____$1){
return (function (p1__41262__41265__auto__){
return cljs.core.apply.call(null,thinktopic.aljabr.core.pick,m__41263__auto____$1,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41262__41265__auto__], null),cljs.core.repeat.call(null,((3) - (1)),null)));
});})(shape__41264__auto__,m__41263__auto____$1))
,cljs.core.range.call(null,cljs.core.first.call(null,shape__41264__auto__)));

}
}
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PMatrixCloning$clone$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var length__41284__auto__ = cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
var cloned_ary__41299__auto__ = cljs.core.double_array.call(null,length__41284__auto__);
var n__19308__auto___43553 = length__41284__auto__;
var i__41280__auto___43554 = (0);
while(true){
if((i__41280__auto___43554 < n__19308__auto___43553)){
(cloned_ary__41299__auto__[i__41280__auto___43554] = (self__._data[i__41280__auto___43554]));

var G__43555 = (i__41280__auto___43554 + (1));
i__41280__auto___43554 = G__43555;
continue;
} else {
}
break;
}

return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8","uint8",956521151),cloned_ary__41299__auto__,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = true;

thinktopic.aljabr.core.NDArray3uint8.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.array_seq_STAR_.call(null,self__._data);
});

thinktopic.aljabr.core.NDArray3uint8.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_data","_data",246266088,null),new cljs.core.Symbol(null,"_offset","_offset",1914826382,null),new cljs.core.Symbol(null,"_stride0","_stride0",1015451040,null),new cljs.core.Symbol(null,"_stride1","_stride1",1839580896,null),new cljs.core.Symbol(null,"_stride2","_stride2",-1119345708,null),new cljs.core.Symbol(null,"_shape0","_shape0",864663649,null),new cljs.core.Symbol(null,"_shape1","_shape1",-1811213663,null),new cljs.core.Symbol(null,"_shape2","_shape2",-126153333,null)], null);
});

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$type = true;

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$ctorStr = "thinktopic.aljabr.core/NDArray3uint8";

thinktopic.aljabr.core.NDArray3uint8.cljs$lang$ctorPrWriter = (function (this__19003__auto__,writer__19004__auto__,opt__19005__auto__){
return cljs.core._write.call(null,writer__19004__auto__,"thinktopic.aljabr.core/NDArray3uint8");
});

thinktopic.aljabr.core.__GT_NDArray3uint8 = (function thinktopic$aljabr$core$__GT_NDArray3uint8(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
return (new thinktopic.aljabr.core.NDArray3uint8(_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});


thinktopic.aljabr.core.make_raw_ndarray3_uint8 = (function thinktopic$aljabr$core$make_raw_ndarray3_uint8(data__41282__auto__,o__41302__auto__,p__42176,p__42177){
var vec__42180 = p__42176;
var _stride0 = cljs.core.nth.call(null,vec__42180,(0),null);
var _stride1 = cljs.core.nth.call(null,vec__42180,(1),null);
var _stride2 = cljs.core.nth.call(null,vec__42180,(2),null);
var vec__42181 = p__42177;
var _shape0 = cljs.core.nth.call(null,vec__42181,(0),null);
var _shape1 = cljs.core.nth.call(null,vec__42181,(1),null);
var _shape2 = cljs.core.nth.call(null,vec__42181,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8(data__41282__auto__,o__41302__auto__,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2));
});
goog.exportSymbol('thinktopic.aljabr.core.make_raw_ndarray3_uint8', thinktopic.aljabr.core.make_raw_ndarray3_uint8);

cljs.core.swap_BANG_.call(null,thinktopic.aljabr.core.ctor_registry,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),new cljs.core.Keyword(null,"uint8","uint8",956521151)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ctor","ctor",1750864802),thinktopic.aljabr.core.make_raw_ndarray3_uint8,new cljs.core.Keyword(null,"data-ctor","data-ctor",1202821358),thi.ng.typedarrays.core.uint8], null));


/**
* @constructor
 * @implements {clojure.core.matrix.protocols.PMatrixEquality}
 * @implements {clojure.core.matrix.protocols.PDimensionInfo}
 * @implements {clojure.core.matrix.protocols.PVectorView}
 * @implements {clojure.core.matrix.protocols.PIndexedSettingMutable}
 * @implements {clojure.core.matrix.protocols.PIndexedAccess}
 * @implements {clojure.core.matrix.protocols.PNumerical}
 * @implements {clojure.core.matrix.protocols.PIndexedSetting}
 * @implements {clojure.core.matrix.protocols.PTypeInfo}
 * @implements {clojure.core.matrix.protocols.PValueEquality}
 * @implements {thinktopic.aljabr.core.PNDArray}
 * @implements {clojure.core.matrix.protocols.PImplementation}
 * @implements {cljs.core.ISeqable}
 * @implements {clojure.core.matrix.protocols.PMatrixCloning}
 * @implements {thinktopic.aljabr.core.Object}
 * @implements {clojure.core.matrix.protocols.PFunctionalOperations}
*/
thinktopic.aljabr.core.NDArray3uint8_clamped = (function (_data,_offset,_stride0,_stride1,_stride2,_shape0,_shape1,_shape2){
this._data = _data;
this._offset = _offset;
this._stride0 = _stride0;
this._stride1 = _stride1;
this._stride2 = _stride2;
this._shape0 = _shape0;
this._shape1 = _shape1;
this._shape2 = _shape2;
this.cljs$lang$protocol_mask$partition0$ = 8388608;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
if((a__41300__auto____$1 === b__41301__auto__)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__))){
if(((0) === cljs.core.long$.call(null,clojure.core.matrix.protocols.dimensionality.call(null,a__41300__auto____$1)))){
return (clojure.core.matrix.protocols.get_0d.call(null,a__41300__auto____$1) === (function (){var x__24690__auto__ = b__41301__auto__;
if(typeof x__24690__auto__ === 'number'){
return x__24690__auto__;
} else {
return clojure.core.matrix.protocols.get_0d.call(null,x__24690__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
}
} else {
return false;

}
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.count.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return false;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core._EQ_.call(null,(1),(3));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (___41277__auto__,dimension_number__41290__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return cljs.core.nth.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),dimension_number__41290__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PVectorView$as_vector$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return thinktopic.aljabr.core.ndarray.call(null,new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),self__._data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core._STAR_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null))], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_1d_BANG_$arity$3 = (function (m__41291__auto__,x__41295__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_2d_BANG_$arity$4 = (function (m__41291__auto__,x__41295__auto__,y__41298__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,m__41291__auto____$1,x__41295__auto__,y__41298__auto__,v__41296__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSettingMutable$set_nd_BANG_$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,m__41291__auto____$1,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return m__41291__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.toString = (function (){
var self__ = this;
var ___41277__auto__ = this;
return cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"offset","offset",296498311),self__._offset,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"size","size",1098693007),((self__._shape0 * self__._shape1) * self__._shape2),new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count.call(null,cljs.core.seq.call(null,___41277__auto__)),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null),new cljs.core.Keyword(null,"stride","stride",-1172818435),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null),new cljs.core.Keyword(null,"data","data",-232669377),self__._data], null));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m__41291__auto__,i__41280__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,i__41280__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.get_at.call(null,m__41291__auto____$1,row__41292__auto__,column__41293__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m__41291__auto__,indexes__41294__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return cljs.core.apply.call(null,thinktopic.aljabr.core.get_at,m__41291__auto____$1,indexes__41294__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PNumerical$numerical_QMARK_$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m__41291__auto__,i__41280__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),i__41280__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m__41291__auto__,row__41292__auto__,column__41293__auto__,x__41295__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return thinktopic.aljabr.core.set_at.call(null,clojure.core.matrix.clone.call(null,m__41291__auto____$1),row__41292__auto__,column__41293__auto__,x__41295__auto__);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m__41291__auto__,indexes__41294__auto__,v__41296__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
var new_m__41297__auto__ = clojure.core.matrix.clone.call(null,m__41291__auto____$1);
cljs.core.apply.call(null,thinktopic.aljabr.core.set_at,new_m__41297__auto__,cljs.core.concat.call(null,indexes__41294__auto__,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v__41296__auto__], null)));

return new_m__41297__auto__;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m__41291__auto__){
var self__ = this;
var m__41291__auto____$1 = this;
return true;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PTypeInfo$element_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.clojure$core$matrix$protocols$PValueEquality$value_equals$arity$2 = (function (a__41300__auto__,b__41301__auto__){
var self__ = this;
var a__41300__auto____$1 = this;
var and__18393__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_.call(null,a__41300__auto____$1,b__41301__auto__);
if(cljs.core.truth_(and__18393__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,clojure.core.matrix.protocols.element_seq.call(null,a__41300__auto____$1),clojure.core.matrix.protocols.element_seq.call(null,b__41301__auto__)));
} else {
return and__18393__auto__;
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$ = true;

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_seq$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
var iter__19177__auto__ = ((function (___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42189(s__42190){
return (new cljs.core.LazySeq(null,((function (___41277__auto____$1){
return (function (){
var s__42190__$1 = s__42190;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42190__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var a0 = cljs.core.first.call(null,xs__5205__auto__);
var iterys__19173__auto__ = ((function (s__42190__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42189_$_iter__42191(s__42192){
return (new cljs.core.LazySeq(null,((function (s__42190__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42192__$1 = s__42192;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__42192__$1);
if(temp__4657__auto____$1){
var xs__5205__auto____$1 = temp__4657__auto____$1;
var a1 = cljs.core.first.call(null,xs__5205__auto____$1);
var iterys__19173__auto__ = ((function (s__42192__$1,s__42190__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function thinktopic$aljabr$core$iter__42189_$_iter__42191_$_iter__42193(s__42194){
return (new cljs.core.LazySeq(null,((function (s__42192__$1,s__42190__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1){
return (function (){
var s__42194__$1 = s__42194;
while(true){
var temp__4657__auto____$2 = cljs.core.seq.call(null,s__42194__$1);
if(temp__4657__auto____$2){
var s__42194__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42194__$2)){
var c__19175__auto__ = cljs.core.chunk_first.call(null,s__42194__$2);
var size__19176__auto__ = cljs.core.count.call(null,c__19175__auto__);
var b__42196 = cljs.core.chunk_buffer.call(null,size__19176__auto__);
if((function (){var i__42195 = (0);
while(true){
if((i__42195 < size__19176__auto__)){
var a2 = cljs.core._nth.call(null,c__19175__auto__,i__42195);
cljs.core.chunk_append.call(null,b__42196,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)));

var G__43556 = (i__42195 + (1));
i__42195 = G__43556;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42196),thinktopic$aljabr$core$iter__42189_$_iter__42191_$_iter__42193.call(null,cljs.core.chunk_rest.call(null,s__42194__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42196),null);
}
} else {
var a2 = cljs.core.first.call(null,s__42194__$2);
return cljs.core.cons.call(null,(((self__._offset + (self__._stride0 * (a0 | (0)))) + ((self__._stride1 * (a1 | (0))) + (self__._stride2 * (a2 | (0))))) | (0)),thinktopic$aljabr$core$iter__42189_$_iter__42191_$_iter__42193.call(null,cljs.core.rest.call(null,s__42194__$2)));
}
} else {
return null;
}
break;
}
});})(s__42192__$1,s__42190__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42192__$1,s__42190__$1,a1,xs__5205__auto____$1,temp__4657__auto____$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape2)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42189_$_iter__42191.call(null,cljs.core.rest.call(null,s__42192__$1)));
} else {
var G__43557 = cljs.core.rest.call(null,s__42192__$1);
s__42192__$1 = G__43557;
continue;
}
} else {
return null;
}
break;
}
});})(s__42190__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
,null,null));
});})(s__42190__$1,a0,xs__5205__auto__,temp__4657__auto__,___41277__auto____$1))
;
var fs__19174__auto__ = cljs.core.seq.call(null,iterys__19173__auto__.call(null,cljs.core.range.call(null,self__._shape1)));
if(fs__19174__auto__){
return cljs.core.concat.call(null,fs__19174__auto__,thinktopic$aljabr$core$iter__42189.call(null,cljs.core.rest.call(null,s__42190__$1)));
} else {
var G__43558 = cljs.core.rest.call(null,s__42190__$1);
s__42190__$1 = G__43558;
continue;
}
} else {
return null;
}
break;
}
});})(___41277__auto____$1))
,null,null));
});})(___41277__auto____$1))
;
return iter__19177__auto__.call(null,cljs.core.range.call(null,self__._shape0));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$step$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42186 = self__._offset;
var vec__42197 = ((typeof p0 === 'number')?(((p0 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape0) / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),(G__42186 + (self__._stride0 * (self__._shape0 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape0 / (p0 | (0)))) | (0)),(self__._stride0 * (p0 | (0))),G__42186], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._stride0,G__42186], null));
var a0 = cljs.core.nth.call(null,vec__42197,(0),null);
var b0 = cljs.core.nth.call(null,vec__42197,(1),null);
var G__42186__$1 = cljs.core.nth.call(null,vec__42197,(2),null);
var vec__42198 = ((typeof p1 === 'number')?(((p1 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape1) / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),(G__42186__$1 + (self__._stride1 * (self__._shape1 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape1 / (p1 | (0)))) | (0)),(self__._stride1 * (p1 | (0))),G__42186__$1], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape1,self__._stride1,G__42186__$1], null));
var a1 = cljs.core.nth.call(null,vec__42198,(0),null);
var b1 = cljs.core.nth.call(null,vec__42198,(1),null);
var G__42186__$2 = cljs.core.nth.call(null,vec__42198,(2),null);
var vec__42199 = ((typeof p2 === 'number')?(((p2 < (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil(((- self__._shape2) / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),(G__42186__$2 + (self__._stride2 * (self__._shape2 - (1))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(Math.ceil((self__._shape2 / (p2 | (0)))) | (0)),(self__._stride2 * (p2 | (0))),G__42186__$2], null)):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape2,self__._stride2,G__42186__$2], null));
var a2 = cljs.core.nth.call(null,vec__42199,(0),null);
var b2 = cljs.core.nth.call(null,vec__42199,(1),null);
var G__42186__$3 = cljs.core.nth.call(null,vec__42199,(2),null);
return (new thinktopic.aljabr.core.NDArray3uint8_clamped(self__._data,G__42186__$3,b0,b1,b2,a0,a1,a2));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$stride$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$index_pos$arity$2 = (function (___41277__auto__,G__42185){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42185__$1 = (G__42185 | (0));
var G__42182 = (G__42185__$1 - self__._offset);
var a0 = ((G__42182 / self__._stride0) | (0));
var G__42182__$1 = (G__42182 - (a0 * self__._stride0));
var a1 = ((G__42182__$1 / self__._stride1) | (0));
var G__42182__$2 = (G__42182__$1 - (a1 * self__._stride1));
var a2 = ((G__42182__$2 / self__._stride2) | (0));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a0,a1,a2], null);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._data;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_index$arity$2 = (function (___41277__auto__,i__41280__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return (self__._data[(i__41280__auto__ | (0))]);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$update_at_safe$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42184){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
var G__42182_43559 = (((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0));
(self__._data[G__42182_43559] = G__42184.call(null,p0,p1,p2,(self__._data[G__42182_43559])));
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$data_type$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936);
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$offset$arity$1 = (function (___41277__auto__){
var self__ = this;
var ___41277__auto____$1 = this;
return self__._offset;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$set_at$arity$5 = (function (___41277__auto__,p0,p1,p2,G__42182){
var self__ = this;
var ___41277__auto____$1 = this;
(self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))] = G__42182);

return ___41277__auto____$1;
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$transpose$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var p0__$1 = (cljs.core.truth_(p0)?(p0 | (0)):(0));
var p1__$1 = (cljs.core.truth_(p1)?(p1 | (0)):(1));
var p2__$1 = (cljs.core.truth_(p2)?(p2 | (0)):(2));
var G__42182 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._stride0,self__._stride1,self__._stride2], null);
var G__42183 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__._shape0,self__._shape1,self__._shape2], null);
return (new thinktopic.aljabr.core.NDArray3uint8_clamped(self__._data,self__._offset,G__42182.call(null,p0__$1),G__42182.call(null,p1__$1),G__42182.call(null,p2__$1),G__42183.call(null,p0__$1),G__42183.call(null,p1__$1),G__42183.call(null,p2__$1)));
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$get_at_safe$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
if(cljs.core.truth_((((p0 >= (0)))?(((p0 < self__._shape0))?(((p1 >= (0)))?(((p1 < self__._shape1))?(((p2 >= (0)))?(p2 < self__._shape2):null):null):null):null):null))){
return (self__._data[(((self__._offset + (self__._stride0 * (p0 | (0)))) + ((self__._stride1 * (p1 | (0))) + (self__._stride2 * (p2 | (0))))) | (0))]);
} else {
throw (new Error([cljs.core.str("Invalid index: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p0,p1,p2], null)))].join('')));
}
});

thinktopic.aljabr.core.NDArray3uint8_clamped.prototype.thinktopic$aljabr$core$PNDArray$pick$arity$4 = (function (___41277__auto__,p0,p1,p2){
var self__ = this;
var ___41277__auto____$1 = this;
var G__42186 = self__._offset;
var G__42182 = cljs.core.PersistentVector.EMPTY;
var G__42183 = cljs.core.PersistentVector.EMPTY;
var vec__42200 = (((typeof p0 === 'number') && ((p0 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42182,G__42183,(G__42186 + (self__._stride0 * (p0 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42182,self__._shape0),cljs.core.conj.call(null,G__42183,self__._stride0),G__42186], null));
var G__42182__$1 = cljs.core.nth.call(null,vec__42200,(0),null);
var G__42183__$1 = cljs.core.nth.call(null,vec__42200,(1),null);
var G__42186__$1 = cljs.core.nth.call(null,vec__42200,(2),null);
var vec__42201 = (((typeof p1 === 'number') && ((p1 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42182__$1,G__42183__$1,(G__42186__$1 + (self__._stride1 * (p1 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42182__$1,self__._shape1),cljs.core.conj.call(null,G__42183__$1,self__._stride1),G__42186__$1], null));
var G__42182__$2 = cljs.core.nth.call(null,vec__42201,(0),null);
var G__42183__$2 = cljs.core.nth.call(null,vec__42201,(1),null);
var G__42186__$2 = cljs.core.nth.call(null,vec__42201,(2),null);
var vec__42202 = (((typeof p2 === 'number') && ((p2 >= (0))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__42182__$2,G__42183__$2,(G__42186__$2 + (self__._stride2 * (p2 | (0))))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,G__42182__$2,self__._shape2),cljs.core.conj.call(null,G__42183__$2,self__._stride2),G__42186__$2], null));
var G__42182__$3 = cljs.core.nth.call(null,vec__42202,(0),null);
var G__42183__$3 = cljs.core.nth.call(null,vec__42202,(1),null);
var G__42186__$3 = cljs.core.nth.call(null,vec__42202,(2),null);
var cnt__41281__auto__ = cljs.core.count.call(null,G__42182__$3);
if((cnt__41281__auto__ > (0))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,thinktopic.aljabr.core.ctor_registry),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cnt__41281__auto__,new cljs.core.Keyword(null,"uint8-clamp