(ns thi.ng.ndarray.core
  #?(:clj
     (:require [thi.ng.ndarray.macros :refer [def-ndarray]])
     :cljs
     (:require-macros [thi.ng.ndarray.macros :refer [def-ndarray]])))

(defprotocol PNDArray
  (data [_])
  (data-seq [_])
  (dimension [_])
  (shape [_])
  (stride [_])
  (offset [_])
  (index-at [_ p])
  (get-at [_ p])
  (get-at-unsafe [_ p])
  (set-at [_ p v])
  (set-at-unsafe [_ p v])
  (hi [_ p])
  (lo [_ p])
  (transpose [_ p])
  (step [_ p])
  (pick [_ p]))

(defn order
  [coll] (->> coll (map vector (range)) (sort-by peek) (mapv first)))

(defn shape->stride
  [shape]
  (->> shape
       reverse
       (reduce #(conj % (* %2 (first %))) '(1))
       (drop 1)
       (vec)))

(def ctor-registry (atom {}))

(def-ndarray 1 #?(:clj IndexOutOfBoundsException :cljs js/Error))
(def-ndarray 2 #?(:clj IndexOutOfBoundsException :cljs js/Error))
(def-ndarray 3 #?(:clj IndexOutOfBoundsException :cljs js/Error))
(def-ndarray 4 #?(:clj IndexOutOfBoundsException :cljs js/Error))

(defn nd-array
  [data shape]
  (let [stride (shape->stride shape)]
    ((@ctor-registry (count shape)) aget aset data 0 stride shape)))
