(ns thi.ng.trio.entities.utils
  (:require
   [thi.ng.trio.core :as api]
   [thi.ng.validate.core :as v]))

(defn filtered-triple-seq
  [xs] (->> xs (api/triple-seq) (filter #(-> % last nil? not))))

(defn triple-map
  [props rec]
  (->> props
       (map
        (fn [[k f]]
          [(:prop f)
           (if-let [ser (:values f)]
             (ser (k rec))
             (k rec))]))
       (into {})
       (merge (->> props keys (apply dissoc rec :id) keys (select-keys rec)))))

(defn pick-id
  [id] (fn [x] (let [k (id x)] (if (map? k) (:id k) k))))

(defn pick-id-coll
  [id]
  (fn [x]
    (let [k (id x)
          k (if (or (string? k) (number? k) (map? k)) [k] k)]
      (mapv #(if (map? %) (:id %) %) k))))

(defn wrap-optional [vals] (mapv #(v/optional %) vals))

(defn build-validators
  [props]
  (reduce-kv
   (fn [acc k {:keys [validate optional card]}]
     (if validate
       (let [v (if (and optional (not (map? validate)))
                 (wrap-optional validate)
                 validate)]
         (assoc acc k (if (and (= card :*) (not (map? v))) {:* v} v)))
       acc))
   {} props))

(defn build-sorter
  [id dir]
  (fn [props]
    (let [p (props id)]
      (if (coll? p)
        (vec (if (= :asc dir) (sort p) (reverse (sort p))))
        p))))

(defn build-initializers
  [props]
  (reduce-kv
   (fn [acc k {:keys [init card order]}]
     (let [ordered (if order (build-sorter k order))]
       (cond
        init        (assoc acc k (if order (fn [_] (-> _ order init)) init))
        ordered     (assoc acc k ordered)
        (= :* card) (assoc acc k (pick-id-coll k))
        :else       acc)))
   {} props))

(defn apply-initializers
  [props inits]
  (reduce-kv
   (fn [acc k v] (if (acc k) (assoc acc k (v acc)) acc))
   props inits))

(defn build-defaults
  [props]
  (reduce-kv
   (fn [acc k {:keys [card default]}]
     (cond
      default     (assoc acc k default)
      (= :* card) (assoc acc k (fn [_] []))
      :else       acc))
   {} props))

(defn inject-defaults
  [props defaults]
  (reduce-kv
   (fn [acc k v] (if (nil? (acc k)) (assoc acc k (if (fn? v) (v acc) v)) acc))
   props defaults))

(defn entity-map-from-triples
  [triples props id]
  (let [iprop (reduce-kv (fn [acc k v] (assoc acc (:prop v) k)) {} props)
        conj* (fnil conj [])]
    (->> triples
         (filter #(= id (:s %)))
         (reduce
          (fn [acc [_ p o]]
            (let [p' (iprop p p)
                  op (props p')]
              (if (and op (-> op :card (not= :*)))
                (assoc acc p' o)
                (update-in acc [p'] conj* o))))
          {:id id}))))
