(ns thi.ng.trio.utils
  (:require
   [clojure.string :as str]))

(defn ->kebab-case
  [x] (-> x (str/replace #"([a-z\d])([A-Z])" "$1-$2") str/lower-case))

#+clj
(defn new-uuid [] (str (java.util.UUID/randomUUID)))

#+cljs
(defn- rand-bits [pow]
  (rand-int (bit-shift-left 1 pow)))

#+cljs
(defn new-uuid
  []
  (str
   (-> (js/Date.) (.getTime) (/ 1000) (Math/round) (.toString 16))
   "-" (-> (rand-bits 16) (.toString 16))
   "-" (-> (rand-bits 16) (bit-and 0x0fff) (bit-or 0x4000) (.toString 16))
   "-" (-> (rand-bits 16) (bit-and 0x3fff) (bit-or 0x8000) (.toString 16))
   "-" (-> (rand-bits 16) (.toString 16))
   (-> (rand-bits 16) (.toString 16))
   (-> (rand-bits 16) (.toString 16))))
