(ns thi.ng.glsl.grid
  (:require-macros
   [thi.ng.glsl.core :refer [defglsl]]))

(defglsl grid-1d
  nil "
float grid1D(float coord, float gridSize, float width) {
  return smoothstep(2.0 * width, width, abs(0.5 - (0.5 + fract(coord / gridSize))));
}")

(defglsl grid-2d
  nil "
float grid2D(vec2 coord, vec2 gridSize, vec2 width) {
  const vec2 c = vec2(0.5);
  vec2 g = smoothstep(2.0 * width, width, abs(c - (c + fract(coord / gridSize))));
  return max(g.x, g.y);
}")

(defglsl grid-3d
  nil "
float grid3D(vec3 coord, vec3 gridSize, vec3 width) {
  const vec3 c = vec3(0.5);
  vec3 g = smoothstep(2.0 * width, width, abs(c - (c + fract(coord / gridSize))));
  return max(max(g.x, g.y), g.z);
}")
