(ns thi.ng.glsl.color
  (:require-macros
   [thi.ng.glsl.core :refer [defglsl]]))

(defglsl hsv2rgb
  nil "
const vec4 HSV_K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);

vec3 hsv2rgb(vec3 col) {
  vec3 p = abs(fract(col.xxx + HSV_K.xyz) * 6.0 - HSV_K.www);
  return col.z * mix(HSV_K.xxx, clamp(p - HSV_K.xxx, 0.0, 1.0), col.y);
}")

(defglsl rgb2hsv
  nil "
const vec4 RGB_K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);

vec3 rgb2hsv(vec3 c) {
  vec4 p = mix(vec4(c.bg, RGB_K.wz), vec4(c.gb, RGB_K.xy), step(c.b, c.g));
  vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));
  float d = q.x - min(q.w, q.y);
  float e = 1.0e-10;
  return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}")

(defglsl luminance
  nil "
float luminance(vec3 rgb) {
  vec3 l = rgb * vec3(0.299, 0.587, 0.114);
  return l.x + l.y + l.z;
}")

(defglsl rotate-hue-hsv
  nil "
vec3 rotateHueHSV(vec3 hsv, float theta) {
  float h = mod(hsv.x + mod(theta, TWO_PI) / TWO_PI, 1.0);
  if (h < 0.0) { h += 1.0; }
  return vec3(h, hsv.yz);
}")

(defglsl rotate-hue-rgb
  [rgb2hsv hsv2rgb rotate-hue-hsv]
  "
vec3 rotateHueRGB(vec3 rgb, float theta) {
  return hsv2rgb(rotateHueHSV(rgb2hsv(rgb), theta));
}")
