(ns thi.ng.glsl.fog
  (:require
   [thi.ng.glsl.core :as glsl :include-macros true]))

(glsl/defglsl fog-linear
  nil "
float fogLinear(float dist, float start, float end) {
  return 1.0 - clamp((end - dist) / (end - start), 0.0, 1.0);
}")

(glsl/defglsl fog-exp
  nil "
float fogExp(float dist, float density) {
  return 1.0 - clamp(exp(-density * dist), 0.0, 1.0);
}")

(glsl/defglsl fog-exp2
  nil "
float FOG_LOG2 = -1.442695;

float fogExp2(float dist, float density) {
  float d = density * dist;
  return 1.0 - clamp(exp2(d * d * FOG_LOG2), 0.0, 1.0);
}")
