(defproject thi.ng/shadergraph "0.3.0"
  :description  "WebGL/GLSL shader library & dependency graph for ClojureScript"
  :url          "https://github.com/thi-ng/shadergraph"
  :license      {:name "Apache Software License"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/shadergraph"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.10.238"]
                 [com.postspectacular/dependency "0.1.2"]]

  :profiles {:dev {:plugins [[lein-cljsbuild "1.1.7"]
                             [com.cemerick/clojurescript.test "0.3.3"]]
                   :aliases {"cleantest" ["do" "clean," "cljsbuild" "test"]}}}

  :cljsbuild {:builds [{:source-paths ["src" "test"]
                        :id "simple"
                        :compiler {:output-to "target/shadergraph-0.3.0.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}
                       {:source-paths ["src" "test"]
                        :id "prod"
                        :compiler {:output-to "target/shadergraph-0.3.0.js"
                                   :optimizations :advanced
                                   :pretty-print false}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/shadergraph-0.3.0.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
