(ns thi.ng.glsl.texture
  (:require
   [thi.ng.glsl.core :as glsl :include-macros true]
   [thi.ng.glsl.color :as col]))

(glsl/defglsl blur5-weights
    nil "
  const float blurWeights[5] = float[] (0.2270270270, 0.1945945946, 0.1216216216, 0.0540540541, 0.0162162162);")

(glsl/defglsl blur5-h
  [blur5-weights] "
#if __VERSION__ >= 300
vec3 blur5H(sampler2D tex, vec2 uv) {
  vec2 off = 1.0 / textureSize(tex, 0); // size of single texel @ level 0
  vec3 sum = texture(tex, uv).rgb * blurWeights[0];
  for(int i = 1; i < 5; i++) {
    sum += texture(tex, uv + vec2(off.x * i, 0.0)).rgb * blurWeights[i];
    sum += texture(tex, uv - vec2(off.x * i, 0.0)).rgb * blurWeights[i];
  }
  return sum;
}
#else
vec3 blur5H(sampler2D tex, vec2 uv) {
  vec2 off = 1.0 / textureSize(tex, 0); // size of single texel @ level 0
  vec3 sum = texture2D(tex, uv).rgb * blurWeights[0];
  for(int i = 1; i < 5; i++) {
    sum += texture2D(tex, uv + vec2(off.x * i, 0.0)).rgb * blurWeights[i];
    sum += texture2D(tex, uv - vec2(off.x * i, 0.0)).rgb * blurWeights[i];
  }
  return sum;
}
#endif")

(glsl/defglsl blur5-v
  [blur5-weights] "
#if __VERSION__ >= 300
vec3 blur5V(sampler2D tex, vec2 uv) {
  vec2 off = 1.0 / textureSize(tex, 0); // size of single texel @ level 0
  vec3 sum = texture(tex, uv).rgb * blurWeights[0];
  for(int i = 1; i < 5; i++) {
    sum += texture(tex, uv + vec2(0.0, off.y * i)).rgb * blurWeights[i];
    sum += texture(tex, uv - vec2(0.0, off.y * i)).rgb * blurWeights[i];
  }
  return sum;
}
#else
vec3 blur5V(sampler2D tex, vec2 uv) {
  vec2 off = 1.0 / textureSize(tex, 0); // size of single texel @ level 0
  vec3 sum = texture2D(tex, uv).rgb * blurWeights[0];
  for(int i = 1; i < 5; i++) {
    sum += texture2D(tex, uv + vec2(0.0, off.y * i)).rgb * blurWeights[i];
    sum += texture2D(tex, uv - vec2(0.0, off.y * i)).rgb * blurWeights[i];
  }
  return sum;
}
#endif")
