(ns thi.ng.glsl.distancefields
  (:require-macros
   [thi.ng.glsl.core :refer [defglsl]]))

(defglsl sd-plane
  nil "
  float sdPlane(vec3 p, vec3 n, float w) {
    return dot(n, p) + w;
  }
  
  float sdPlane(vec3 p, vec3 pp, vec3 n) {
    return dot(n, p) - dot(n, pp);
  }")

(defglsl sd-sphere
  nil "
  float sdSphere(vec3 p, float radius) {
    return length(p) - radius;
  }")

(defglsl sd-aabb
  nil "
  ")

(defglsl sd-torus
  nil "
  float sdTorus(vec3 p, float r1, float r2) {
    return length(vec2(length(p.xz) - r2, p.y)) - r1;
  }")

(defglsl sd-cylinder
  nil "
  float sdCylinder(vec3 p, float h, float r) {
    vec2 d = abs(vec2(length(p.xz), p.y)) - vec2(h, r);
    return min(max(d.x, d.y), 0.0) + length(max(d, 0.0));
  }")

(defglsl sd-capsule
  nil "
  float sdCapsule(vec3 p, vec3 a, vec3 b, float r) {
    vec3 pa = p - a, ba = b - a;
    float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);
    return length(pa - ba * h) - r;
  }")

(defglsl sd-op-sub
  nil "
  float sdOpSub(float d1, float d2) {
    return max(-d2, d1);
  }")

(defglsl sd-op-union
  nil "
  float sdOpUnion(float d1, float d2) {
    return min(d1, d2);
  }")

(defglsl sd-op-blend
  nil "
  float sdOpBlend(float a, float b, float f) {
    float h = clamp(0.5 + 0.5 * (b - a) / f, 0.0, 1.0);
    return mix(b, a, h) - f * h * (1.0 - h);
  }")
