(ns thi.ng.luxor.config)

;; References:
;; http://www.luxrender.net/wiki/Scene_file_format_dev

(def mesh-types            {:inline :trimesh :ply :plymesh :stl :stlmesh})
(def volume-types          #{:clear :homogenous :heterogenous})
(def volume-integrators    #{:none :single :emission :multi})
(def sppm-accelerators     #{:hashgrid :hybridhashgrid :kdtree :parallelhashgrid})
(def pixel-samplers        #{:hilbert :liner :tile :vegas})
(def photon-samplers       #{:halton :amc})
(def light-strategies      #{:auto :one :all :importance :powerimp :allpowerimp :logpowerimp})
(def light-path-strategies #{:auto :one :all :importance :powerimp :allpowerimp :logpowerimp})
(def rr-strategies         #{:none :efficiency :probability})
(def render-modes          #{:directlighting})

(def ^:dynamic *indent*         2)
(def ^:dynamic *degrees*        true)
(def ^:dynamic *float-format*   "%1.10f")
