(ns thi.ng.luxor.presets)

(comment
  (->> (clojure.string/split crd-ids #"\n")
       (map (fn [x] [(keyword (-> x (.toLowerCase) (.replaceAll "_" "-") (.replaceAll "ii" "2"))) x]))
       (into (sorted-map))
       (clojure.pprint/pprint))
  )

;; See lux/core/cameraresponse.cpp or luxrender/properties/camera.py
;; to keep this up to date...
(def ^:const film-response-presets
  {:advantix-100cd "Advantix_100CD"
   :advantix-200cd "Advantix_200CD"
   :advantix-400cd "Advantix_400CD"
   :agfachrome-ctpecisa-200cd "Agfachrome_ctpecisa_200CD"
   :agfachrome-ctprecisa-100cd "Agfachrome_ctprecisa_100CD"
   :agfachrome-rsx2-050cd "Agfachrome_rsx2_050CD"
   :agfachrome-rsx2-100cd "Agfachrome_rsx2_100CD"
   :agfachrome-rsx2-200cd "Agfachrome_rsx2_200CD"
   :agfacolor-futura-100cd "Agfacolor_futura_100CD"
   :agfacolor-futura-200cd "Agfacolor_futura_200CD"
   :agfacolor-futura-400cd "Agfacolor_futura_400CD"
   :agfacolor-futura2-100cd "Agfacolor_futuraII_100CD"
   :agfacolor-futura2-200cd "Agfacolor_futuraII_200CD"
   :agfacolor-futura2-400cd "Agfacolor_futuraII_400CD"
   :agfacolor-hdc-100-pluscd "Agfacolor_hdc_100_plusCD"
   :agfacolor-hdc-200-pluscd "Agfacolor_hdc_200_plusCD"
   :agfacolor-hdc-400-pluscd "Agfacolor_hdc_400_plusCD"
   :agfacolor-optima2-100cd "Agfacolor_optimaII_100CD"
   :agfacolor-optima2-200cd "Agfacolor_optimaII_200CD"
   :agfacolor-ultra-050-cd "Agfacolor_ultra_050_CD"
   :agfacolor-vista-100cd "Agfacolor_vista_100CD"
   :agfacolor-vista-200cd "Agfacolor_vista_200CD"
   :agfacolor-vista-400cd "Agfacolor_vista_400CD"
   :agfacolor-vista-800cd "Agfacolor_vista_800CD"
   :ektachrome-100-pluscd "Ektachrome_100_plusCD"
   :ektachrome-100cd "Ektachrome_100CD"
   :ektachrome-320tcd "Ektachrome_320TCD"
   :ektachrome-400xcd "Ektachrome_400XCD"
   :ektachrome-64cd "Ektachrome_64CD"
   :ektachrome-64tcd "Ektachrome_64TCD"
   :ektachrome-e100scd "Ektachrome_E100SCD"
   :f125cd "F125CD"
   :f250cd "F250CD"
   :f400cd "F400CD"
   :fcicd "FCICD"
   :gold-100cd "Gold_100CD"
   :gold-200cd "Gold_200CD"
   :kodachrome-200cd "Kodachrome_200CD"
   :kodachrome-25cd "Kodachrome_25CD"
   :kodachrome-64cd "Kodachrome_64CD"
   :max-zoom-800cd "Max_Zoom_800CD"
   :portra-100tcd "Portra_100TCD"
   :portra-160nccd "Portra_160NCCD"
   :portra-160vccd "Portra_160VCCD"
   :portra-400nccd "Portra_400NCCD"
   :portra-400vccd "Portra_400VCCD"
   :portra-800cd "Portra_800CD"})

(def ^:const ior-categories
  {:gases       {:air 1.000293
                 :air-stp 1.0002926
                 :carbon-dioxide 1.00045
                 :helium 1.000036
                 :hydrogen 1.000132
                 :vacuum 1.0}

   :gemstones   {:agate 1.544
                 :alexandrite 1.746
                 :almandine 1.75
                 :amber 1.539
                 :amethyst 1.532
                 :ammolite 1.52
                 :andalusite 1.629
                 :apatite 1.632
                 :aquamarine 1.567
                 :axenite 1.674
                 :beryl 1.57
                 :beryl-red 1.57
                 :chalcedony 1.544
                 :chrome-tourmaline 1.61
                 :citrine 1.532
                 :clinohumite 1.625
                 :coral 1.486
                 :crysoberyl-catseye 1.746
                 :crystal 2.0
                 :danburite 1.627
                 :diamond 2.417
                 :emerald 1.56
                 :emerald-catseye 1.56
                 :flourite 1.434
                 :garnet-andradite 1.88
                 :garnet-demantiod 1.88
                 :garnet-grossular 1.72
                 :garnet-mandarin 1.79
                 :garnet-pyrope 1.73
                 :garnet-rhodolite 1.74
                 :garnet-tsavorite 1.739
                 :garnet-uvarovite 1.74
                 :hauyn 1.49
                 :iolite 1.522
                 :jade-jadeite 1.64
                 :jade-nephrite 1.6
                 :jet 1.66
                 :kunzite 1.66
                 :labradorite 1.56
                 :lapis-lazuli 1.5
                 :moonstone 1.518
                 :morganite 1.585
                 :obsidian 1.5
                 :opal-black 1.44
                 :opal-fire 1.43
                 :opal-white 1.44
                 :oregon-sunstone 1.56
                 :padparadja 1.76
                 :pearl 1.53
                 :peridot 1.635
                 :quartz 1.544
                 :ruby 1.757
                 :sapphire 1.757
                 :sapphire-star 1.76
                 :spessarite 1.79
                 :spinel 1.712
                 :spinel-blue 1.712
                 :spinel-red 1.708
                 :star-ruby 1.76
                 :tanzanite 1.69
                 :topaz 1.607
                 :topaz-imperial 1.605
                 :tourmaline 1.603
                 :tourmaline-blue 1.61
                 :tourmaline-catseye 1.61
                 :tourmaline-green 1.61
                 :tourmaline-paraiba 1.61
                 :tourmaline-red 1.61
                 :zircon 1.777
                 :zirconia-cubic 2.173}

   :liquids     {:acetone 1.36
                 :alcohol-ethyl 1.36
                 :alcohol-methyl 1.329
                 :beer 1.345
                 :benzene 1.501
                 :carbon-disulfide 1.00045
                 :carbon-tetrachloride 1.000132
                 :carbonated-beverages 1.34
                 :chlorine 1.385
                 :cranberry-juice-25pc 1.351
                 :glycerin 1.473
                 :honey-13pc-water 1.504
                 :honey-17pc-water 1.494
                 :honey-21pc-water 1.484
                 :ice 1.309
                 :milk 1.35
                 :oil-clove 1.535
                 :oil-lemon 1.481
                 :oil-neroli 1.482
                 :oil-of-wintergreen 1.536
                 :oil-orange 1.473
                 :oil-safflower 1.466
                 :oil-vegetable-50c 1.47
                 :rum-white 1.361
                 :shampoo 1.362
                 :sugar-solution-30pc 1.38
                 :sugar-solution-80pc 1.49
                 :turpentine 1.472
                 :vodka 1.363
                 :water-0c 1.33346
                 :water-100c 1.31766
                 :water-20c 1.33283
                 :whisky 1.356}

   :other       {:acetone 1.36
                 :acrylic-glass 1.49
                 :bromine 1.661
                 :crown-glass-impure 1.485
                 :crown-glass-pure 1.5
                 :cryolite 1.388
                 :cubic-zirconia 2.15
                 :ethanol 1.36
                 :flint-glass-impure 1.523
                 :flint-glass-pure 1.6
                 :fused-quartz 1.46
                 :gallium-arsenide 3.5
                 :gallium-prosphide 3.02
                 :glycerol 1.4729
                 :mercury-sulfide 2.65
                 :moissanite 2.419
                 :pet 1.575
                 :petg 1.57
                 :pmma 1.4893
                 :polycarbonate 1.584
                 :pyrex 1.47
                 :rock-salt 1.516
                 :ruby 1.76
                 :salt 1.544
                 :silicon 3.927
                 :teflon 1.35
                 :water-ice 1.31}

   :transparent {:eye-aqueous-humor 1.33
                 :eye-cornea 1.38
                 :eye-lens 1.41
                 :eye-vitreous-humor 1.34
                 :glass-arsenic-trisulfide 2.04
                 :glass-crown 1.52
                 :glass-flint-29pc-lead 1.569
                 :glass-flint-55pc-lead 1.669
                 :glass-flint-71pc-lead 1.805
                 :glass-fused-silica 1.459
                 :glass-pyrex 1.474
                 :lucite 1.495
                 :nylon 1.53
                 :obsidian 1.5
                 :plastic 1.46
                 :plexiglas 1.488
                 :salt 1.516}})

(def ior-presets (apply merge (vals ior-categories)))
