(ns thi.ng.geom.webgl.shaders.xray
  (:require
   [thi.ng.geom.webgl.core :as gl]))

(def shader-spec
  {:vs "void main() {
  vec4 worldPos = view * model * vec4(position, 1.0);
  vNormal = (normalMat * vec4(normal, 0.0)).xyz;
  vIncident = worldPos.xyz;
  gl_Position = proj * worldPos;
}"
   :fs "void main() {
  float opac = abs(dot(normalize(-vNormal), normalize(-vIncident)));
  opac = 1.0-pow(opac, alpha);
  gl_FragColor = vec4(lightCol * opac, opac);
}"
   :uniforms {:model      :mat4
              :view       :mat4
              :normalMat  :mat4
              :proj       :mat4
              :lightCol   :vec3
              :alpha      :float}
   :attribs  {:position   :vec3
              :normal     :vec3}
   :varying  {:vIncident  :vec3
              :vNormal    :vec3}
   :state    {:depth-test false
              :blend true
              :blend-func [gl/src-alpha gl/one]}})
