(defproject thi.ng/geom-webgl "0.0-725"
  :description  "thi.ng geometry kit - WebGL module"
  :url          "https://github.com/thi-ng/geom"
  :license      {:name "Apache Software License"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/geom"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.6.0"]
                 [thi.ng/geom-core "0.0-725"]
                 [thi.ng/geom-types "0.0-725"]
                 [thi.ng/geom-meshops "0.0-725"]
                 [thi.ng/color "0.1.2"]
                 [thi.ng/shadergraph "0.1.0"]]

  :profiles {:dev {:dependencies [[org.clojure/clojurescript "0.0-2913"]
                                  [criterium "0.4.3"]]
                   :plugins      [[lein-cljsbuild "1.0.4"]
                                  [com.cemerick/clojurescript.test "0.3.3"]]
                   :aliases {"cleantest" ["do" "clean," "cljsbuild" "test"]}}}

  :cljsbuild {:builds [{:source-paths ["src" "test"]
                        :id "simple"
                        :compiler {:output-to "target/geom-webgl-0.0-725.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}
                       {:source-paths ["src" "test"]
                        :id "prod"
                        :compiler {:output-to "target/geom-webgl-0.0-725.js"
                                   :optimizations :advanced
                                   :pretty-print false}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/geom-webgl-0.0-725.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
