(ns thi.ng.geom.webgl.shaders.lambert
  (:require
   [thi.ng.geom.webgl.buffers :as buf]
   [thi.ng.geom.webgl.shaders :as sh]
   [thi.ng.glsl.core :as glsl :include-macros true]
   [thi.ng.glsl.vertex :as vertex]
   [thi.ng.glsl.lighting :as light]))

(def shader-spec
  {:vs (glsl/assemble
        (glsl/glsl-spec
         [vertex/mvp vertex/normal light/lambert-abs]
         "
void main() {
  float lambert = lambertAbs(surfaceNormal(normal, normalMat), lightDir);
  vCol = vec4(ambientCol + diffuseCol * lightCol * lambert, alpha);
  gl_Position = mvp(position, model, view, proj);
}"))
   :fs "void main(){gl_FragColor=vCol;}"
   :uniforms {:model      :mat4
              :view       :mat4
              :proj       :mat4
              :normalMat  :mat4
              :ambientCol :vec3
              :diffuseCol :vec3
              :lightCol   :vec3
              :lightDir   :vec3
              :alpha      :float}
   :attribs  {:position   :vec3
              :normal     :vec3}
   :varying  {:vCol       :vec4}
   :state    {:depth-test true}})

(defn draw
  [^WebGLRenderingContext gl spec]
  (buf/draw-arrays gl (sh/inject-normal-matrix spec :model :view :normalMat)))
