(ns thi.ng.geom.core.vectorseq
  (:require
   [thi.ng.common.error :as err]
   [thi.ng.common.math.core :as m]
                         ))

(defn lookup
  ([v idx start end]
     (if (< -1 idx (- end start))
                                    
              (-nth v (+ start idx))
       (err/key-error! idx)))
  ([v idx start end default]
     (if (< -1 idx (- end start))
                                    
              (-nth v (+ start idx))
       default)))

(deftype VectorSeq
                                 
                                            
                  
           [start end v _meta]
                        
       IMeta
       IWithMeta
(                   -meta [_] _meta)
(                       -with-meta [_ m] (VectorSeq. start end v m))

                                    
                                               

                         
                                              

                           
       ILookup
(                    -lookup [_ k] (lookup v (int k) start end))
(                    -lookup [_ k nf] (lookup v (int k) start end nf))

                       
       IFn
(                     -invoke [_ idx] (lookup v (int idx) start end))
(                     -invoke [_ idx default] (lookup v (int idx) start end default))

     
                 
                         
                 
                                             
                    
                                                             
                                  

                                      
                      
                               
                         
                          
             
                                                       

                               
                                     
       ICounted
(                    -count [_] (- end start))
                                 

       IAssociative
       IVector
(                          -contains-key? [_ k] (< -1 k (- end start)))
                                                                                               
                                            
       (-assoc [_ k v] (-assoc-n _ (int k) v))
                       
                    
                                            
                                                                          
                 
       (-assoc-n [_ k v']
         (VectorSeq.
          start (if (= k end) (inc end) end)
          (-assoc v (int (+ start k)) v')
          _meta))

                          
                                        
                   
                                                                                    
                         
                  
              
                
                         
                                 
                       
                               

                                         
                           
                              
                        
                           
                     
       IEmptyableCollection
       INext
       ISeq
       ICollection
       IStack
       IIndexed
(                  -seq [_] _)
(                    -empty [_] (with-meta [] _meta))
(                    -first [_]
  (when (< 0 (- end start))
                         
           (-nth v start)))
(                   -next [_]
  (let [cnt (- end start)]
    (when (< 1 cnt)
      (VectorSeq. (inc start) end v _meta))))
                                                 
(                  -conj [_ k]
  (VectorSeq.
   start (inc end)
                                                           
          (-assoc v end k)
   _meta))
(                  -peek [_]
  (when (< 0 (- end start))
                             
           (-nth v (dec end))))
(                 -pop [_]
  (let [cnt (- end start)]
    (if (< 0 cnt)
      (VectorSeq. start (dec end) v _meta)
      (err/throw! "Cannot pop from an empty vector."))))

(                 -nth [_ idx nf] (lookup v idx start end nf))
(                 -nth [_ idx] (lookup v idx start end))
                                             

       IEquiv
(                   -equiv [_ x]
  (and
   (sequential? x)
   (== (count _) (count x))
   (loop [idx start, x x]
     (if (== end idx)
       true
       (if (and x
                                                                      
                       (= (-nth v idx) (first x)))
         (recur (inc idx) (rest x))
         false)))))

     
             
      
                  
                           
                         
                     
           
                                                                    
                                   
                   

                 
       IComparable
(                       -compare [_ x]
  (let [cnt (count x)]
    (if (== (- end start) cnt)
      (- (compare x _))
      (- (- end start) cnt))))

     
             
                
                         
                     
        
             
                 
                          
                                      
                                                    

                          
                 
                            
                       
                                
                            
               
                    
                        
                                 
                                             
                                                            
                        

       IHash
       (-hash [_]
         (mix-collection-hash
          (loop [idx start, h 1]
            (if (== end idx)
              h
              (recur
               (inc idx)
               (bit-or (+ (imul 31 h) (hash (-nth v idx))) 0))))
          (- end start)))
m/PDeltaEquals
(delta=
 [_ o]
 (and (sequential? o)
      (== (count _) (count o))
      (loop [_ _, o o]
        (if _
          (if (m/delta= (first _) (first o))
            (recur (next _) (next o))
            false)
          true))))
(delta=
 [_ o eps]
 (and (sequential? o)
      (== (count _) (count o))
      (loop [_ _, o o]
        (if _
          (if (m/delta= (first _) (first o) eps)
            (recur (next _) (next o))
            false)
          true))))
)

     
                                                   
                                                                                                      

     
                                                                  
                              

(defn vecseq
  ([x] (VectorSeq. 0 (count x) (vec x) nil))
  ([x start end] (VectorSeq. start end (vec x) nil)))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/geom/core/vectorseq.cljx
