(defproject thi.ng/geom-core "0.0.737"
  :description  "thi.ng geometry kit - core module"
  :url          "https://github.com/thi-ng/geom"
  :license      {:name "Apache Software License"
                 :url  "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/geom"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.7.0-alpha5"]
                 [thi.ng/common "0.3.1"]
                 [thi.ng/macromath "0.3.0"]]

  :source-paths ["src/cljx"]
  :test-paths   ["target/test-classes"]

  :perforate {:environments [{:namespaces [thi.ng.geom.bench.core.vector]}]}

  :profiles     {:dev {:dependencies [[org.clojure/clojurescript "0.0-3117"]
                                      [perforate-x "0.1.0"]]
                       :plugins      [[com.keminglabs/cljx "0.6.0"]
                                      [lein-cljsbuild "1.0.5"]
                                      [com.cemerick/clojurescript.test "0.3.3"]
                                      [perforate "0.3.4"]
                                      [lein-npm "0.5.0"]]
                       :node-dependencies [[benchmark "1.0.0"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :auto-clean false
                       :prep-tasks [["cljx" "once"]]
                       :aliases {"cleantest" ["do" "clean," "cljx" "once," "test," "cljsbuild" "test"]}}}

  :cljx         {:builds [{:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :clj}
                          {:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :cljs}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :clj}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :cljs}]}

  :cljsbuild    {:builds [{:id "simple"
                           :source-paths ["target/classes" "target/test-classes"]
                           :compiler {:output-to "target/geom-core-0.0.737.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}
                          {:id "bench"
                           :source-paths ["target/classes" "target/test-classes" "benchmarks"]
                           :notify-command ["node" "target/cljs/benchmark.js"]
                           :compiler {:target :nodejs
                                      :output-to "target/cljs/benchmark.js"
                                      :optimizations :simple
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/geom-core-0.0.737.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
