
(ns thi.ng.fabric.facts.packed
  (:require
   [thi.ng.fabric.facts.core :as ff]
   [clojure.data.int-map :as imap]))

(defn- new-sub-index
  [bits]
  {:max  (dec (bit-shift-left 1 bits))
   :next 0
   :fwd  (hash-map)
   :rev  (imap/int-map)})

(defn- sub-index-item
  [idx x]
  (if-let [id (find (:fwd idx) x)]
    [(val id) idx]
    (let [id (:next idx)]
      [id (-> idx
              (update :fwd assoc x id)
              (update :rev assoc id x)
              (assoc  :next (inc id)))])))

(defn packed-fact-index
  ([]
   (packed-fact-index 24 16 24))
  ([nsubj npred nobj]
   (let [idx (atom
              {:s       (new-sub-index nsubj)
               :p       (new-sub-index npred)
               :o       (new-sub-index nobj)
               :s-mask  (dec (bit-shift-left 1 nsubj))
               :p-mask  (dec (bit-shift-left 1 npred))
               :o-mask  (dec (bit-shift-left 1 nobj))
               :s-shift (+ nobj npred)
               :p-shift nobj})]
     (reify
       ff/ITwoWayTransform
       (transform
         [_ [s p o]]
         (let [id (volatile! 0)]
           (swap! idx
                  (fn [idx]
                    (let [[sid sidx] (sub-index-item (get idx :s) s)
                          [pid pidx] (sub-index-item (get idx :p) p)
                          [oid oidx] (sub-index-item (get idx :o) o)]
                      (vreset! id
                               (bit-or
                                (bit-or
                                 (bit-shift-left sid (get idx :s-shift))
                                 (bit-shift-left pid (get idx :p-shift)))
                                oid))
                      (-> idx (assoc :s sidx) (assoc :p pidx) (assoc :o oidx)))))
           @id))
       (untransform
         [_ id]
         (let [idx @idx]
           (let [s (-> idx
                       (get :s)
                       (get :rev)
                       (get (unsigned-bit-shift-right id (get idx :s-shift))))]
             (if s
               (let [p (-> idx
                           (get :p)
                           (get :rev)
                           (get (bit-and
                                 (unsigned-bit-shift-right id (get idx :p-shift))
                                 (get idx :p-mask))))]
                 (if p
                   (let [o (-> idx
                               (get :o)
                               (get :rev)
                               (get (bit-and id (:o-mask idx))))]
                     (if o [s p o]))))))))))))
