(defproject thi.ng/dstruct "0.1.1"
  :description  "Data structures & utilities for CLJ/CLJS"
  :url          "http://thi.ng/dstruct"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "git@github.com:thi-ng/dstruct.git"}

  :min-lein-vesion "2.4.0"
  
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.122"]
                 [thi.ng/math "0.1.4"]]

  :source-paths ["src"]
  :test-paths   ["test"]

  :profiles     {:dev {:dependencies [[criterium "0.4.3"]]
                       :plugins [[lein-cljsbuild "1.1.0"]
                                 [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean," "test," "cljsbuild" "test"]}
                }}

  :cljsbuild    {:builds [{:id "simple"
                           :source-paths ["src" "test"]
                           :compiler {:output-to "target/dstruct-0.1.1.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/dstruct-0.1.1.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
