(ns thi.ng.common.error)

(defn throw!
  [^String msg]
  (throw
          (IllegalArgumentException. msg)
                         ))

(defn key-error!
  [k] (throw! (str "Illegal lookup key: " k)))

(defn type-error!
  [t x] (throw! (str "Can't create " t " from " (pr-str x))))

(defn arity-error!
  [n] (throw! (str "Wrong number of args: " n)))

(defn illegal-arg!
  ([x] (illegal-arg! "Illegal argument" x))
  ([msg x] (throw! (str msg ": " x))))

(defn unsupported!
  ([] (unsupported! "Unsupported operation"))
  ([^String msg]
     (throw
             (UnsupportedOperationException. msg)
                            )))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/common/error.cljx
