(ns thi.ng.common.data.intervaltree)

(defprotocol PIntervalTree
  (add-interval [_ i x])
  (query-point [_ x ifn acc]))

(deftype IntervalNode
    [median
     ^:unsynchronized-mutable left
     ^:unsynchronized-mutable right
     ^:unsynchronized-mutable center]
  PIntervalTree
  (add-interval [_ [il ih :as i] val]
    (cond
     (< ih median)
     (if left
       (add-interval left i val)
       (set! left (IntervalNode. (* (+ il ih) 0.5) nil nil {i #{val}})))

     (> il median)
     (if right
       (add-interval right i val)
       (set! right (IntervalNode. (* (+ il ih) 0.5) nil nil {i #{val}})))

     :else (set! center (update-in center [i] (fnil conj #{}) val)))
    _)
  (query-point
    [_ x ifn acc]
    (let [acc (if (== x median)
                (into acc (mapcat val center))
                (->> center (filter (ifn x)) (mapcat val) (into acc)))
          acc (if (and left (< x median))
                (query-point left x ifn acc)
                acc)
          acc (if (and right (> x median))
                (query-point right x ifn acc)
                acc)]
      acc))
  Object
  (toString
    [_]
    (str ":median " median
         ", :left " (pr-str left)
         ", :right " (pr-str right)
         ", :center " (pr-str center))))

(defn interval-fn
  [min-incl? max-incl?]
  (let [f1 (if min-incl? >= >)
        f2 (if max-incl? <= <)]
    (fn [x]
      (fn [kv] (let [k (first kv)] (and (f1 x (k 0)) (f2 x (k 1))))))))

(def closed (interval-fn true true))
(def open (interval-fn false false))
(def <open (interval-fn false true))
(def open> (interval-fn true false))

(defn interval-tree
  [x]
  (IntervalNode. x nil nil {}))
