(ns thi.ng.color.presets
  (:require
   [thi.ng.color.core :as col]
   [thi.ng.strf.core :as f]))

(def colors
  {:alice-blue 0xf0f8ff
   :antique-white 0xfaebd7
   :aqua 0x00ffff
   :aquamarine 0x7fffd4
   :azure 0xf0ffff
   :beige 0xf5f5dc
   :bisque 0xffe4c4
   :black 0x000000
   :blanched-almond 0xffebcd
   :blue 0x0000ff
   :blue-violet 0x8a2be2
   :brown 0xa52a2a
   :burly-wood 0xdeb887
   :cadet-blue 0x5f9ea0
   :chartreuse 0x7fff00
   :chocolate 0xd2691e
   :coral 0xff7f50
   :cornflower-blue 0x6495ed
   :cornsilk 0xfff8dc
   :crimson 0xdc143c
   :cyan 0x00ffff
   :dark-blue 0x00008b
   :dark-cyan 0x008b8b
   :dark-goldenrod 0xb8860b
   :dark-gray 0xa9a9a9
   :dark-green 0x006400
   :dark-khaki 0xbdb76b
   :dark-magenta 0x8b008b
   :dark-olivegreen 0x556b2f
   :dark-orange 0xff8c00
   :dark-orchid 0x9932cc
   :dark-red 0x8b0000
   :dark-salmon 0xe9967a
   :dark-seagreen 0x8fbc8f
   :dark-slateblue 0x483d8b
   :dark-slategray 0x2f4f4f
   :dark-turquoise 0x00ced1
   :dark-violet 0x9400d3
   :deep-pink 0xff1493
   :deep-skyblue 0x00bfff
   :dim-gray 0x696969
   :dodger-blue 0x1e90ff
   :fire-brick 0xb22222
   :floral-white 0xfffaf0
   :forest-green 0x228b22
   :fuchsia 0xff00ff
   :gainsboro 0xdcdcdc
   :ghost-white 0xf8f8ff
   :gold 0xffd700
   :goldenrod 0xdaa520
   :gray 0x808080
   :green 0x008000
   :green-yellow 0xadff2f
   :honeydew 0xf0fff0
   :hot-pink 0xff69b4
   :indian-red 0xcd5c5c
   :indigo 0x4b0082
   :ivory 0xfffff0
   :khaki 0xf0e68c
   :lavender 0xe6e6fa
   :lavender-blush 0xfff0f5
   :lawn-green 0x7cfc00
   :lemon-chiffon 0xfffacd
   :light-blue 0xadd8e6
   :light-coral 0xf08080
   :light-cyan 0xe0ffff
   :light-goldenrodyellow 0xfafad2
   :light-green 0x90ee90
   :light-grey 0xd3d3d3
   :light-pink 0xffb6c1
   :light-salmon 0xffa07a
   :light-seagreen 0x20b2aa
   :light-skyblue 0x87cefa
   :light-slategray 0x778899
   :light-steelblue 0xb0c4de
   :light-yellow 0xffffe0
   :lime 0x00ff00
   :limegreen 0x32cd32
   :linen 0xfaf0e6
   :magenta 0xff00ff
   :maroon 0x800000
   :medium-aquamarine 0x66cdaa
   :medium-blue 0x0000cd
   :medium-orchid 0xba55d3
   :medium-purple 0x9370db
   :medium-seagreen 0x3cb371
   :medium-slateblue 0x7b68ee
   :medium-springgreen 0x00fa9a
   :medium-turquoise 0x48d1cc
   :medium-violetred 0xc71585
   :midnight-blue 0x191970
   :mint-cream 0xf5fffa
   :misty-rose 0xffe4e1
   :moccasin 0xffe4b5
   :navajo-white 0xffdead
   :navy 0x000080
   :old-lace 0xfdf5e6
   :olive 0x808000
   :olive-drab 0x6b8e23
   :orange 0xffa500
   :orange-red 0xff4500
   :orchid 0xda70d6
   :pale-goldenrod 0xeee8aa
   :pale-green 0x98fb98
   :pale-violetred 0xdb7093
   :papaya-whip 0xffefd5
   :peach-puff 0xffdab9
   :peru 0xcd853f
   :pink 0xffc0cb
   :plum 0xdda0dd
   :powder-blue 0xb0e0e6
   :purple 0x800080
   :red 0xff0000
   :rosy-brown 0xbc8f8f
   :royal-blue 0x4169e1
   :saddle-brown 0x8b4513
   :salmon 0xfa8072
   :sandy-brown 0xfaa460
   :sea-green 0x2e8b57
   :seashell 0xfff5ee
   :sienna 0xa0522d
   :silver 0xc0c0c0
   :skyblue 0x87ceeb
   :slate-blue 0x6a5acd
   :slate-gray 0x708090
   :snow 0xfffafa
   :spring-green 0x00ff7f
   :steel-blue 0x4682b4
   :tan 0xd2b48c
   :teal 0x008080
   :thistle 0xd8bfd8
   :tomato 0xff6347
   :turquoise 0x40e0d0
   :violet 0xee82ee
   :wheat 0xf5deb3
   :white 0xffffff
   :white-smoke 0xf5f5f5
   :yellow 0xffff00
   :yellow-green 0x9acd32
   })

(defn preset-rgb [id] (-> id colors col/int->rgba (subvec 0 3)))

(defn preset-hsv [id] (->> id preset-rgb (apply col/rgb->hsv)))

(defn preset-cmyk [id] (->> id preset-rgb (apply col/rgb->cmyk)))

(defn preset-css [id] (->> id colors col/int->hex))
