(ns silvur.http
  (:gen-class)  
  (:refer-clojure :exclude [get])
  (:require [silvur.util :refer :all]
            [org.httpkit.client :as http])
  (:import [java.net URI]
           [javax.net.ssl SNIHostName SNIServerName SSLEngine SSLParameters X509TrustManager]))

;; SSL


(defn sni-configure [^SSLEngine ssl-engine ^URI uri]
  (let [^SSLParameters ssl-params (.getSSLParameters ssl-engine)]
    (.setServerNames ssl-params [(SNIHostName. (.getHost uri))])
    (.setUseClientMode ssl-engine true)
    (.setSSLParameters ssl-engine ssl-params)))

;; When using SNI, it should make a client as below for httpkit
;; (defonce sni-client
;;   ;; SNI (Server Name Indication) is a TLS extension to multiplex multiple SSL termination on a single IP  
;;   (http/make-client {:ssl-configurer ssl/sni-configure}))

(defn engine []
  (let [tm (reify javax.net.ssl.X509TrustManager
             (getAcceptedIssuers [this] (make-array  java.security.cert.X509Certificate 0))
             (checkClientTrusted [this chain auth-type])
             (checkServerTrusted [this chain auth-type]))
        client-context (javax.net.ssl.SSLContext/getInstance "TLSv1.2")]
    (.init client-context nil
           (into-array javax.net.ssl.TrustManager [tm])
           nil)
    (doto (.createSSLEngine client-context)
        (.setUseClientMode true))))

(defn get
  ([uri]
   (http/get uri))
  ([uri opts]
   (http/get uri (merge opts {:client (http/make-client {:ssl-configurer sni-configure})})))
  ([uri opts callback]
   (http/get uri (merge opts {:client (http/make-client {:ssl-configurer sni-configure})}) callback)))

(defn post
  ([uri]
   (http/post uri))
  ([uri opts]
   (http/post uri (merge opts {:client (http/make-client {:ssl-configurer sni-configure})})))
  ([uri opts callback]
   (http/post uri (merge opts {:client (http/make-client {:ssl-configurer sni-configure})}) callback)))



