(ns silvur.net
  (:require [clojure.string :as str]))

(defn hex<-text [text-bytes]
  ;; text-bytes [0x38 0x36 0x3e 0x30]
  ;; => 0x86e0
  (str/join "" (map #(format "%x" (- % 0x30)) text-bytes)))

(defn digit<-text [text-bytes]
  ;; text-bytes [0x38 0x36 0x3e 0x30]
  ;; => 34528
  (str (Long/parseLong (hex<-text text-bytes) 16)))

(defn parse [format-coll data-coll]
  ;; format-coll: [1 3 3 4 4 4 4 4 4]
  ;;              [[1 text<-bytes] [3 text<-bytes] ....]
  (loop [sf format-coll
         pdata []
         zs data-coll]
    (let [v (first sf)
          [s cf] (cond
                   (number? v) [v]
                   (sequential? v) v
                   :else [])]
      (if-not (seq sf)
        pdata
        (recur (rest sf) (conj pdata ((or cf identity) (take s zs))) (drop s zs))))))
