(ns silvur.nrepl
  (:require [nrepl.server :as nrepl]
            [nrepl.transport :as transport]))

(defn start [& {:keys [ip port cider] :or {ip "0.0.0.0" port 7888}}]
  (letfn [(nrepl-handler []
            (require 'cider.nrepl)
            (ns-resolve 'cider.nrepl 'cider-nrepl-handler))]

    (if cider
      (nrepl/start-server :port port :bind ip :handler (nrepl-handler))
      (nrepl/start-server :port port :bind ip
                          :transport-fn transport/tty
                          :greeting-fn (fn [transport]
                                         (transport/send transport
                                                         {:out (str "\nWelcome to  nREPL !\n\n"
                                                                    "user=> ")}))))
    (println (str "Booted nREPL server on " ip  ":" port (when cider (str " with cider option"))))))
