;; *   Silvur
;; *
;; *   Copyright (c) Tsutomu Miyashita. All rights reserved.
;; *
;; *   The use and distribution terms for this software are covered by the
;; *   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; *   which can be found in the file epl-v10.html at the root of this distribution.
;; *   By using this software in any fashion, you are agreeing to be bound by
;; * 	 the terms of this license.
;; *   You must not remove this notice, or any other, from this software.

(ns silvur.util
  (:require [clojure.string :refer [upper-case lower-case]]))

(defn uuid [] (str (java.util.UUID/randomUUID)))

(defmacro uk [s]
  `(try (keyword (upper-case (name ~s))) (catch Exception e# nil)))

(defmacro us [s]
  `(try (upper-case (name ~s)) (catch Exception e# nil)))

(defmacro lk [s]
  `(try (keyword (lower-case (name ~s))) (catch Exception e# nil)))

(defmacro ls [s]
  `(try (lower-case (name ~s)) (catch Exception e# nil)))
