;; *   Silvur
;; *
;; *   Copyright (c) Tsutomu Miyashita. All rights reserved.
;; *
;; *   The use and distribution terms for this software are covered by the
;; *   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; *   which can be found in the file epl-v10.html at the root of this distribution.
;; *   By using this software in any fashion, you are agreeing to be bound by
;; * 	 the terms of this license.
;; *   You must not remove this notice, or any other, from this software.

(ns silvur.smtp
  (:gen-class)
  (:require [postal.core :as postal])   )


(defn mail [& {:keys [from to subject host port contents] :or {host "localhost" port 25}}]
  ;; Ex. (mail :host "lebesgue" :from "analysis@theorems.co" :to ["myst3m@gmail.com"] :subject "Test" :contents {:text/plain "Hello"})
  (postal/send-message {:host host}
                       {:from from :to to :subject subject
                        :body (reduce conj [] (map (fn [[type content]]
                                                     (hash-map :type (condp = type
                                                                       :attachment type
                                                                       :inline type
                                                                       (clojure.string/replace (str type "; charset=utf-8") #":" ""))
                                                               :content content))
                                                   contents))}))
